/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.awt.image.BufferedImage;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.codec.ImageEncodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFEncodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFField;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFImageEncoder;
import org.apache.batik.ext.awt.image.rendered.FormatRed;
import org.apache.commons.logging.Log;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.java2d.Java2DRenderer;

public class TIFFRenderer
extends Java2DRenderer {
    public static final String MIME_TYPE = "image/tiff";
    private TIFFEncodeParam renderParams = new TIFFEncodeParam();
    private OutputStream outputStream;

    public String getMimeType() {
        return MIME_TYPE;
    }

    public TIFFRenderer() {
        this.renderParams.setCompression(32773);
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        int comp = cfg.getChild("compression").getAttributeAsInteger("value", 1);
        String name = null;
        switch (comp) {
            case 1: {
                name = "COMPRESSION_NONE";
                break;
            }
            case 7: {
                name = "COMPRESSION_JPEG_TTN2";
                break;
            }
            case 32773: {
                name = "COMPRESSION_PACKBITS";
                break;
            }
            case 32946: {
                name = "COMPRESSION_DEFLATE";
                break;
            }
            default: {
                log.info("TIFF compression not supported: " + comp);
                return;
            }
        }
        log.info("TIFF compression set to " + name);
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.outputStream = outputStream;
        super.startRenderer(outputStream);
    }

    public void stopRenderer() throws IOException {
        super.stopRenderer();
        log.debug("Starting Tiff encoding ...");
        float pixSzMM = this.userAgent.getPixelUnitToMillimeter();
        int numPix = (int)((double)(100000.0f / pixSzMM) + 0.5);
        int denom = 10000;
        long[] rational = new long[]{numPix, denom};
        TIFFField[] fields = new TIFFField[]{new TIFFField(296, 3, 1, (Object)new char[]{'\u0003'}), new TIFFField(282, 5, 1, (Object)new long[][]{rational}), new TIFFField(283, 5, 1, (Object)new long[][]{rational})};
        this.renderParams.setExtraFields(fields);
        TIFFImageEncoder enc = new TIFFImageEncoder(this.outputStream, (ImageEncodeParam)this.renderParams);
        LazyPageImagesIterator pageImagesItr = new LazyPageImagesIterator(this.getNumberOfPages(), log);
        RenderedImage first = (RenderedImage)pageImagesItr.next();
        this.renderParams.setExtraImages((Iterator)pageImagesItr);
        enc.encode(first);
        this.outputStream.flush();
        this.clearViewportList();
        log.debug("Tiff encoding done.");
    }

    private class LazyPageImagesIterator
    implements Iterator {
        private Log log;
        private int count;
        private int current = 0;

        public LazyPageImagesIterator(int c, Log log) {
            this.count = c;
            this.log = log;
        }

        public boolean hasNext() {
            return this.current < this.count;
        }

        public Object next() {
            this.log.debug("[" + (this.current + 1) + "]");
            BufferedImage pageImage = null;
            try {
                pageImage = TIFFRenderer.this.getPageImage(this.current++);
            }
            catch (FOPException e) {
                e.printStackTrace();
            }
            switch (TIFFRenderer.this.renderParams.getCompression()) {
                default: 
            }
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)pageImage.getSampleModel();
            int bands = sppsm.getNumBands();
            int[] off = new int[bands];
            int w = pageImage.getWidth();
            int h = pageImage.getHeight();
            for (int i = 0; i < bands; ++i) {
                off[i] = i;
            }
            PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(0, w, h, bands, w * bands, off);
            FormatRed rimg = new FormatRed(GraphicsUtil.wrap((RenderedImage)pageImage), (SampleModel)sm);
            return rimg;
        }

        public void remove() {
            throw new UnsupportedOperationException("Method 'remove' is not supported.");
        }
    }
}

