/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import java.util.Calendar;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.model.ProfileElement;
import org.eclipse.equinox.internal.provisional.p2.ui.query.ElementQueryDescriptor;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateChecker;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateListener;
import org.eclipse.ui.IStartup;
import org.osgi.framework.BundleContext;

public class AutomaticUpdateScheduler
implements IStartup {
    public static final String P_DAY = "day";
    public static final String P_HOUR = "hour";
    public static final String[] DAYS = new String[]{ProvSDKMessages.SchedulerStartup_day, ProvSDKMessages.SchedulerStartup_Monday, ProvSDKMessages.SchedulerStartup_Tuesday, ProvSDKMessages.SchedulerStartup_Wednesday, ProvSDKMessages.SchedulerStartup_Thursday, ProvSDKMessages.SchedulerStartup_Friday, ProvSDKMessages.SchedulerStartup_Saturday, ProvSDKMessages.SchedulerStartup_Sunday};
    public static final String[] HOURS = new String[]{ProvSDKMessages.SchedulerStartup_1AM, ProvSDKMessages.SchedulerStartup_2AM, ProvSDKMessages.SchedulerStartup_3AM, ProvSDKMessages.SchedulerStartup_4AM, ProvSDKMessages.SchedulerStartup_5AM, ProvSDKMessages.SchedulerStartup_6AM, ProvSDKMessages.SchedulerStartup_7AM, ProvSDKMessages.SchedulerStartup_8AM, ProvSDKMessages.SchedulerStartup_9AM, ProvSDKMessages.SchedulerStartup_10AM, ProvSDKMessages.SchedulerStartup_11AM, ProvSDKMessages.SchedulerStartup_12PM, ProvSDKMessages.SchedulerStartup_1PM, ProvSDKMessages.SchedulerStartup_2PM, ProvSDKMessages.SchedulerStartup_3PM, ProvSDKMessages.SchedulerStartup_4PM, ProvSDKMessages.SchedulerStartup_5PM, ProvSDKMessages.SchedulerStartup_6PM, ProvSDKMessages.SchedulerStartup_7PM, ProvSDKMessages.SchedulerStartup_8PM, ProvSDKMessages.SchedulerStartup_9PM, ProvSDKMessages.SchedulerStartup_10PM, ProvSDKMessages.SchedulerStartup_11PM, ProvSDKMessages.SchedulerStartup_12AM};
    private IUpdateListener listener = null;
    private IUpdateChecker checker = null;
    private String profileId;

    public AutomaticUpdateScheduler() {
        ProvSDKUIActivator.getDefault().setScheduler(this);
        this.checker = (IUpdateChecker)ServiceHelper.getService((BundleContext)ProvSDKUIActivator.getContext(), (String)IUpdateChecker.SERVICE_NAME);
        if (this.checker == null) {
            Status status = new Status(4, "org.eclipse.equinox.p2.ui.sdk", ProvSDKMessages.AutomaticUpdateScheduler_UpdateNotInitialized);
            ProvUI.reportStatus((IStatus)status, (int)1);
            return;
        }
        try {
            this.profileId = ProvSDKUIActivator.getSelfProfileId();
        }
        catch (ProvisionException e) {
            this.profileId = null;
            if (e.getStatus() != null) {
                ProvUI.reportStatus((IStatus)e.getStatus(), (int)1);
            } else {
                ProvUI.handleException((Throwable)e, null, (int)1);
            }
            return;
        }
    }

    public void earlyStartup() {
        this.scheduleUpdate();
    }

    public void shutdown() {
        this.removeUpdateListener();
    }

    public void rescheduleUpdate() {
        this.removeUpdateListener();
        Preferences pref = ProvSDKUIActivator.getDefault().getPluginPreferences();
        String schedule = pref.getString("schedule");
        if (schedule.equals("on-startup")) {
            return;
        }
        this.scheduleUpdate();
    }

    private void scheduleUpdate() {
        if (this.profileId == null) {
            return;
        }
        Preferences pref = ProvSDKUIActivator.getDefault().getPluginPreferences();
        if (!pref.getBoolean("enabled")) {
            return;
        }
        String schedule = pref.getString("schedule");
        long delay = -1L;
        long poll = -1L;
        if (!schedule.equals("on-startup")) {
            delay = this.computeDelay(pref);
            poll = this.computePoll(pref);
        }
        this.listener = ProvSDKUIActivator.getDefault().getAutomaticUpdater();
        ElementQueryDescriptor descriptor = ProvSDKUIActivator.getDefault().getQueryProvider().getQueryDescriptor((Object)new ProfileElement(this.profileId), 6);
        this.checker.addUpdateCheck(this.profileId, descriptor.query, delay, poll, this.listener);
    }

    private int getDay(Preferences pref) {
        String day = pref.getString(P_DAY);
        int d = 0;
        while (d < DAYS.length) {
            if (DAYS[d].equals(day)) {
                switch (d) {
                    case 0: {
                        return -1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 5;
                    }
                    case 5: {
                        return 6;
                    }
                    case 6: {
                        return 7;
                    }
                    case 7: {
                        return 1;
                    }
                }
            }
            ++d;
        }
        return -1;
    }

    private int getHour(Preferences pref) {
        String hour = pref.getString(P_HOUR);
        int h = 0;
        while (h < HOURS.length) {
            if (HOURS[h].equals(hour)) {
                return h + 1;
            }
            ++h;
        }
        return 1;
    }

    private long computeDelay(Preferences pref) {
        int target_d = this.getDay(pref);
        int target_h = this.getHour(pref);
        Calendar calendar = Calendar.getInstance();
        int current_d = calendar.get(7);
        int current_h = calendar.get(11);
        int current_m = calendar.get(12);
        int current_s = calendar.get(13);
        int current_ms = calendar.get(14);
        long delay = 0L;
        if (target_d == -1) {
            if (target_h == current_h && current_m == 0 && current_s == 0) {
                return delay;
            }
            int delta_h = target_h - current_h;
            if (target_h <= current_h) {
                delta_h += 24;
            }
            delay = ((delta_h * 60 - current_m) * 60 - current_s) * 1000 - current_ms;
            return delay;
        }
        if (target_d == current_d && target_h == current_h && current_m == 0 && current_s == 0) {
            return delay;
        }
        int delta_d = target_d - current_d;
        if (target_d < current_d || target_d == current_d && (target_h < current_h || target_h == current_h && current_m > 0)) {
            delta_d += 7;
        }
        delay = (((delta_d * 24 + target_h - current_h) * 60 - current_m) * 60 - current_s) * 1000 - current_ms;
        return delay;
    }

    private long computePoll(Preferences pref) {
        int target_d = this.getDay(pref);
        if (target_d == -1) {
            return 86400000L;
        }
        return 604800000L;
    }

    private void removeUpdateListener() {
        if (this.listener != null && this.checker != null) {
            this.checker.removeUpdateCheck(this.listener);
            this.listener = null;
        }
    }
}

