/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.XML;
import com.insightful.gdevice.XMLElement;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;

public class ColorScheme
implements Serializable {
    private static final int NUMBER_PALETTE_COLORS = 16;
    public static final int NUMBER_IMAGE_COLORS = 256;
    protected String m_name;
    private Color m_backgroundColor;
    private Color[] m_paletteColors;
    private Color[] m_imageColors;
    private static Color[] m_defaultPaletteColors = null;
    private static String g_getPaletteCmd = "c(paste(ifelse1(length(dev.list())==0, \"#FFFFFF\", par(\"bg\")), \"FF\", sep=\"\"), palette())";

    public ColorScheme() {
        this(true);
    }

    public ColorScheme(boolean bl) {
        this.m_name = "default color scheme";
        this.m_backgroundColor = Color.white;
        this.m_paletteColors = bl ? null : this.getDefaultPaletteColors();
        this.m_imageColors = new Color[256];
        double d = 221.0;
        double d2 = 230.0;
        double d3 = 245.0;
        double d4 = 10.0;
        double d5 = 65.0;
        double d6 = 128.0;
        double d7 = (d - d4) / 256.0;
        double d8 = (d2 - d5) / 256.0;
        double d9 = (d3 - d6) / 256.0;
        for (int i = 0; i < 256; ++i) {
            this.m_imageColors[i] = new Color((int)d, (int)d2, (int)d3);
            d -= d7;
            d2 -= d8;
            d3 -= d9;
        }
    }

    public ColorScheme(String string, Color color, Color[] colorArray, Color[] colorArray2) {
        int n;
        this.m_name = string;
        this.m_backgroundColor = color != null ? color : Color.white;
        this.m_paletteColors = new Color[colorArray.length];
        for (n = 0; n < colorArray.length; ++n) {
            this.m_paletteColors[n] = colorArray != null && n < colorArray.length ? colorArray[n] : Color.black;
        }
        this.m_imageColors = new Color[256];
        for (n = 0; n < 256; ++n) {
            this.m_imageColors[n] = colorArray2 != null && n < colorArray2.length ? colorArray2[n] : new Color(n, n, n);
        }
    }

    public ColorScheme(String string, int[] nArray) {
        int n;
        this.m_name = string;
        this.m_backgroundColor = this.getColorFromColorInts(nArray, 0);
        this.m_paletteColors = new Color[16];
        for (n = 0; n < 16; ++n) {
            this.m_paletteColors[n] = this.getColorFromColorInts(nArray, 1 + n);
        }
        this.m_imageColors = new Color[256];
        for (n = 0; n < 256; ++n) {
            this.m_imageColors[n] = this.getColorFromColorInts(nArray, 17 + n);
        }
    }

    private Color[] getDefaultPaletteColors() {
        if (m_defaultPaletteColors == null) {
            m_defaultPaletteColors = new Color[]{Color.black, new Color(0, 95, 190), new Color(190, 0, 95), new Color(0, 190, 0), new Color(255, 128, 0), new Color(0, 128, 255), new Color(128, 64, 0), new Color(192, 0, 0), new Color(184, 255, 255), new Color(255, 195, 255), new Color(200, 255, 200), new Color(255, 209, 143), new Color(169, 226, 255), new Color(255, 255, 195), new Color(255, 140, 138), new Color(110, 110, 100)};
        }
        return m_defaultPaletteColors;
    }

    protected Color[] getPalette() {
        if (this.m_paletteColors == null) {
            try {
                Class<?> clazz = Class.forName("com.insightful.splus.SplusSystem");
                Method method = clazz.getMethod("getEngineQueryHandler", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                Class<?> clazz2 = Class.forName("com.insightful.splus.SplusEngineQueryHandler");
                Method method2 = clazz2.getMethod("processDataQuery", String.class);
                Object object2 = method2.invoke(object, g_getPaletteCmd);
                Class<?> clazz3 = Class.forName("com.insightful.splus.SplusDataResult");
                Method method3 = clazz3.getMethod("getStringData", new Class[0]);
                String[] stringArray = (String[])method3.invoke(object2, new Object[0]);
                this.m_paletteColors = new Color[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    int n = stringArray[i].substring(1).length();
                    int n2 = Integer.parseInt(stringArray[i].substring(1, 3), 16);
                    int n3 = Integer.parseInt(stringArray[i].substring(3, 5), 16);
                    int n4 = Integer.parseInt(stringArray[i].substring(5, 7), 16);
                    int n5 = n == 8 ? Integer.parseInt(stringArray[i].substring(7, 9), 16) : 255;
                    this.m_paletteColors[i] = new Color(n2, n3, n4, n5);
                }
            }
            catch (Throwable throwable) {
                this.m_paletteColors = this.getDefaultPaletteColors();
            }
        }
        return this.m_paletteColors;
    }

    private Color getColorFromColorInts(int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 3 * n;
        if (nArray != null && n5 >= 0 && nArray.length > n5 + 2) {
            n2 = Math.max(0, Math.min(255, nArray[n5]));
            n3 = Math.max(0, Math.min(255, nArray[n5 + 1]));
            n4 = Math.max(0, Math.min(255, nArray[n5 + 2]));
        }
        return new Color(n2, n3, n4);
    }

    private void setColorIntsFromColor(int[] nArray, int n, Color color) {
        int n2 = 3 * n;
        if (nArray != null && n2 >= 0 && nArray.length > n2 + 2) {
            nArray[n2] = color.getRed();
            nArray[n2 + 1] = color.getGreen();
            nArray[n2 + 2] = color.getBlue();
        }
    }

    public String getName() {
        return this.m_name;
    }

    public int[] getInts() {
        int n;
        Color[] colorArray = this.getPalette();
        int[] nArray = new int[3 * (1 + colorArray.length + 256)];
        this.setColorIntsFromColor(nArray, 0, this.m_backgroundColor);
        for (n = 0; n < colorArray.length; ++n) {
            this.setColorIntsFromColor(nArray, 1 + n, colorArray[n]);
        }
        for (n = 0; n < 256; ++n) {
            this.setColorIntsFromColor(nArray, 1 + colorArray.length + n, this.m_imageColors[n]);
        }
        return nArray;
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor;
    }

    public boolean isPDF() {
        return false;
    }

    public Color getLineColor(int n) {
        return this.getPaletteColor(n);
    }

    public Color getTextColor(int n) {
        return this.getPaletteColor(n);
    }

    public Color getPolygonColor(int n) {
        return this.getPaletteColor(n);
    }

    public Color getPaletteColor(int n) {
        if (n < 1) {
            return this.getBackgroundColor();
        }
        Color[] colorArray = this.getPalette();
        n = (n - 1) % colorArray.length;
        return colorArray[n];
    }

    public Color[] getPaletteColors() {
        Color[] colorArray = this.getPalette();
        Color[] colorArray2 = new Color[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray2[i] = colorArray[i];
        }
        return colorArray2;
    }

    public Color getImageColor(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 256) {
            n = 256;
        }
        return this.m_imageColors[n - 1];
    }

    public Color[] getImageColors() {
        Color[] colorArray = new Color[256];
        for (int i = 0; i < 256; ++i) {
            colorArray[i] = this.m_imageColors[i];
        }
        return colorArray;
    }

    public IndexColorModel getImageIndexColorModel() {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            Color color = this.getImageColor(i + 1);
            byArray[i] = (byte)color.getRed();
            byArray2[i] = (byte)color.getGreen();
            byArray3[i] = (byte)color.getBlue();
        }
        IndexColorModel indexColorModel = null;
        try {
            indexColorModel = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return indexColorModel;
    }

    public void writeXML(PrintWriter printWriter, String string) {
        printWriter.print("<COLORSCHEME");
        XML.writeProperty(printWriter, "ID", string);
        XML.writeProperty(printWriter, "NAME", this.getName());
        printWriter.print(">\n");
        XML.writeData(printWriter, "BACKGROUND", this.m_backgroundColor);
        XML.writeData(printWriter, "PALETTE", this.getPalette());
        XML.writeData(printWriter, "IMAGE", this.m_imageColors);
        printWriter.print("</COLORSCHEME>\n");
    }

    public static ColorScheme createFromXML(XMLElement xMLElement) {
        String string = XML.getStringProperty(xMLElement, "NAME");
        Color[] colorArray = XML.getColorData(xMLElement, "BACKGROUND", 1);
        Color[] colorArray2 = XML.getColorData(xMLElement, "PALETTE");
        Color[] colorArray3 = XML.getColorData(xMLElement, "IMAGE", 256);
        return new ColorScheme(string, colorArray[0], colorArray2, colorArray3);
    }

    public String[] getPaletteColorLabels() {
        Color[] colorArray = this.getPalette();
        String[] stringArray = new String[colorArray.length];
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray[i] = "Color " + Integer.toString(i);
        }
        stringArray[0] = "Background";
        return stringArray;
    }

    public static class PDFColorScheme
    extends ColorScheme {
        private Color[] m_pdfLineColors = null;
        private Color[] m_pdfTextColors = null;
        private Color[] m_pdfPolygonColors = null;
        private Color[] m_pdfImageColors = null;
        private Color m_pdfBackgroundColor = null;

        public PDFColorScheme(Color[] colorArray, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n) {
            super(false);
            this.m_name = "pdf color scheme";
            this.m_pdfLineColors = this.createColorsFromIndex(nArray, colorArray);
            this.m_pdfTextColors = this.createColorsFromIndex(nArray2, colorArray);
            this.m_pdfPolygonColors = this.createColorsFromIndex(nArray3, colorArray);
            this.m_pdfImageColors = this.createColorsFromIndex(nArray4, colorArray);
            this.m_pdfBackgroundColor = this.createColorsFromIndex(new int[]{n}, colorArray)[0];
        }

        public PDFColorScheme(boolean bl, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int n) {
            this(PDFColorScheme.getColormapColors(bl, nArray), nArray2, nArray3, nArray4, nArray5, n);
        }

        private static Color[] getColormapColors(boolean bl, int[] nArray) {
            int n = bl ? nArray.length : nArray.length / 3;
            Color[] colorArray = new Color[n];
            for (int i = 0; i < n; ++i) {
                int n2 = PDFColorScheme.getColormapInt(nArray, i, bl, 0);
                int n3 = PDFColorScheme.getColormapInt(nArray, i, bl, 1);
                int n4 = PDFColorScheme.getColormapInt(nArray, i, bl, 2);
                colorArray[i] = new Color(n2, n3, n4);
            }
            return colorArray;
        }

        private static int getColormapInt(int[] nArray, int n, boolean bl, int n2) {
            int n3 = bl ? n : n * 3 + n2;
            int n4 = nArray[n3];
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 > 255) {
                n4 = 255;
            }
            return n4;
        }

        private Color[] createColorsFromIndex(int[] nArray, Color[] colorArray) {
            Color[] colorArray2 = new Color[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n < 1) {
                    n = 1;
                }
                if (n > colorArray.length) {
                    n = colorArray.length;
                }
                colorArray2[i] = colorArray[n - 1];
            }
            return colorArray2;
        }

        public Color getBackgroundColor() {
            return this.m_pdfBackgroundColor;
        }

        public boolean isPDF() {
            return true;
        }

        public Color getLineColor(int n) {
            return this.getColor(this.m_pdfLineColors, n);
        }

        public Color getTextColor(int n) {
            return this.getColor(this.m_pdfTextColors, n);
        }

        public Color getPolygonColor(int n) {
            return this.getColor(this.m_pdfPolygonColors, n);
        }

        public Color getPaletteColor(int n) {
            return this.getColor(this.m_pdfLineColors, n);
        }

        public Color getImageColor(int n) {
            return this.getColor(this.m_pdfImageColors, n);
        }

        private Color getColor(Color[] colorArray, int n) {
            if (n < 1) {
                return this.getBackgroundColor();
            }
            n = (n - 1) % colorArray.length;
            return colorArray[n];
        }

        public IndexColorModel getImageIndexColorModel() {
            byte[] byArray = new byte[256];
            byte[] byArray2 = new byte[256];
            byte[] byArray3 = new byte[256];
            for (int i = 0; i < 256; ++i) {
                int n = (int)Math.rint((double)i * 0.00392156862745098 * (double)(this.m_pdfImageColors.length - 1));
                Color color = this.getImageColor(n + 1);
                byArray[i] = (byte)color.getRed();
                byArray2[i] = (byte)color.getGreen();
                byArray3[i] = (byte)color.getBlue();
            }
            IndexColorModel indexColorModel = null;
            try {
                indexColorModel = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
            return indexColorModel;
        }
    }
}

