/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusTextField;
import com.insightful.splus.SplusDistributionComboBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class SplusDistributionParameterGroup
extends SplusGroupPanel {
    SplusDistributionComboBox distributionControl;
    ArrayList parameterControlList = new ArrayList();
    static final String[] distNames = new String[]{"beta", "binomial", "cauchy", "chisquare", "exponential", "f", "gamma", "geometric", "hypergeometric", "lognormal", "logistic", "negbinomial", "normal", "poisson", "t", "uniform", "weibull"};
    static HashMap enableMap = new HashMap();
    static final int[][] enableIndices = new int[][]{{6, 7}, {11, 12}, {4, 5}, {8}, {2}, {8, 9}, {6}, {11}, {12, 13, 14}, {2, 3}, {4, 5}, {10, 11}, {2, 3}, {2}, {8}, {0, 1}, {5, 6}};
    static final String[] prompts = new String[]{"Minimum", "Maximum", "Mean", "Std. Deviation", "Location", "Scale", "Shape 1", "Shape 2", "Deg of Freedom 1", "Deg of Freedom 2", "No. of Successes", "Probability", "Sample Size", "Total Successes", "Total Failures"};
    static final char[] mnemonics = new char[]{'N', 'X', 'M', 'O', 'L', 'C', 'H', 'P', '1', '2', '.', 'B', 'S', 'T', 'F'};
    static final String[] argNames = new String[]{"min", "max", "mean", "sd", "location", "scale", "shape1", "shape2", "df1", "df2", "k", "prob", "size", "m", "nhyper"};

    public SplusDistributionParameterGroup(SplusDistributionComboBox splusDistributionComboBox) {
        super("Distribution Parameters");
        if (enableMap.isEmpty()) {
            for (int i = 0; i < distNames.length; ++i) {
                enableMap.put(distNames[i], enableIndices[i]);
            }
        }
        this.distributionControl = splusDistributionComboBox;
        this.distributionControl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SplusDistributionParameterGroup.this.refreshEnabledStatus();
            }
        });
        for (int i = 0; i < prompts.length; ++i) {
            SplusTextField splusTextField = new SplusTextField(prompts[i], mnemonics[i]);
            this.add(splusTextField);
            this.parameterControlList.add(splusTextField);
        }
        this.refreshEnabledStatus();
    }

    private void refreshEnabledStatus() {
        String string = this.distributionControl.getValue();
        int[] nArray = (int[])enableMap.get(string);
        for (int i = 0; i < prompts.length; ++i) {
            SplusTextField splusTextField = (SplusTextField)this.parameterControlList.get(i);
            boolean bl = false;
            for (int j = 0; j < nArray.length; ++j) {
                bl |= nArray[j] == i;
            }
            splusTextField.setEnabled(bl);
        }
    }

    public void registerControls(SplusFunctionInfo splusFunctionInfo) {
        for (int i = 1; i < prompts.length; ++i) {
            splusFunctionInfo.add((SplusTextField)this.parameterControlList.get(i), argNames[i]);
        }
    }

    public static String[] getDistributionNames() {
        return distNames;
    }

    public void setValues(String[] stringArray) {
        int n = this.parameterControlList.size();
        if (n == stringArray.length) {
            for (int i = 0; i < n; ++i) {
                ((SplusTextField)this.parameterControlList.get(i)).setValue(stringArray[i]);
            }
        }
    }

    public String[] getValues() {
        int n = this.parameterControlList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SplusTextField)this.parameterControlList.get(i)).getValue();
        }
        return stringArray;
    }

    public boolean warnIfEmpty() {
        String string = this.distributionControl.getValue();
        int[] nArray = (int[])enableMap.get(string);
        boolean bl = true;
        for (int i = 0; bl && i < nArray.length; ++i) {
            SplusTextField splusTextField = (SplusTextField)this.parameterControlList.get(nArray[i]);
            if (!splusTextField.getValue().equals("")) continue;
            JOptionPane.showMessageDialog(this, splusTextField.getText() + " field requires a value.", "Required Field Empty", 2);
            bl = false;
        }
        return bl;
    }
}

