/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.client;

import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusControlMetrics;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusRadioButtonGroup;
import com.insightful.controls.SplusWideTextField;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.client.ServerFile;
import com.insightful.splus.util.FileUtilities;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileSystemView;

public class TransferFileDialog
extends SplusDialog {
    SplusRadioButtonGroup directionButtons;
    SplusWideTextField serverFileName;
    SplusWideTextField clientFileName;
    SplusButton serverFileButton;
    SplusButton clientFileButton;
    JFileChooser serverFileChooser;
    JFileChooser clientFileChooser;
    private static File clientFrameCwd = new File(System.getProperty("user.home"));
    private Cursor savedCursor;
    private static final Cursor waitCursor = new Cursor(3);

    public TransferFileDialog() {
        super("Transfer File");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("");
        jPanel.add(splusGroupPanel);
        this.directionButtons = new SplusRadioButtonGroup("Direction", 'D', new String[]{"Server to Client", "Client to Server"});
        this.directionButtons.setValue("Server to Client");
        splusGroupPanel.add(this.directionButtons);
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Server");
        jPanel.add(splusGroupPanel2);
        this.serverFileName = new SplusWideTextField("Server File Name", 'S');
        splusGroupPanel2.add(this.serverFileName);
        this.serverFileButton = new SplusButton("Browse", 'B');
        this.serverFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (TransferFileDialog.this.serverFileChooser == null) {
                    TransferFileDialog.this.serverFileChooser = new JFileChooser(SplusSystem.getCwd(), SplusSystem.getServerFileHandler().getServerFileSystemView());
                    TransferFileDialog.this.serverFileChooser.setDialogTitle("Select Server File");
                    TransferFileDialog.this.serverFileChooser.setFileFilter(TransferFileDialog.this.serverFileChooser.getAcceptAllFileFilter());
                }
                if ((n = TransferFileDialog.this.serverFileChooser.showDialog(SplusSystem.getDefaultFrame(), "OK")) == 0) {
                    String string = ServerFile.convertServerFilePath(TransferFileDialog.this.serverFileChooser.getSelectedFile().getAbsolutePath());
                    TransferFileDialog.this.serverFileName.setValue(string);
                    SplusSystem.setCwd(TransferFileDialog.this.serverFileChooser.getCurrentDirectory());
                }
            }
        });
        Box box = new Box(0);
        box.add(Box.createHorizontalGlue());
        box.add(this.serverFileButton);
        box.add(Box.createHorizontalStrut(10));
        splusGroupPanel2.add(Box.createVerticalStrut(5));
        splusGroupPanel2.add(box);
        splusGroupPanel2.add(Box.createVerticalStrut(5));
        splusGroupPanel2.add(Box.createVerticalStrut(SplusControlMetrics.getFullDimension().height));
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Client");
        jPanel.add(splusGroupPanel3);
        this.clientFileName = new SplusWideTextField("Client File Name", 'C');
        splusGroupPanel3.add(this.clientFileName);
        this.clientFileButton = new SplusButton("Browse", 'R');
        this.clientFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (TransferFileDialog.this.clientFileChooser == null) {
                    TransferFileDialog.this.clientFileChooser = new JFileChooser(clientFrameCwd);
                    TransferFileDialog.this.clientFileChooser.setDialogTitle("Select Client File");
                    TransferFileDialog.this.clientFileChooser.setFileFilter(TransferFileDialog.this.clientFileChooser.getAcceptAllFileFilter());
                }
                if ((n = TransferFileDialog.this.clientFileChooser.showDialog(SplusSystem.getDefaultFrame(), "OK")) == 0) {
                    TransferFileDialog.this.clientFileName.setValue(TransferFileDialog.this.clientFileChooser.getSelectedFile().getAbsolutePath());
                    clientFrameCwd = TransferFileDialog.this.clientFileChooser.getCurrentDirectory();
                }
            }
        });
        Box box2 = new Box(0);
        box2.add(Box.createHorizontalGlue());
        box2.add(this.clientFileButton);
        box2.add(Box.createHorizontalStrut(10));
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        splusGroupPanel3.add(box2);
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        splusGroupPanel3.add(Box.createVerticalStrut(SplusControlMetrics.getFullDimension().height));
        Dimension dimension = SplusControlMetrics.getLabelDimension();
        Dimension dimension2 = new Dimension(4 * dimension.width + 40, dimension.height);
        jPanel.add(new Box.Filler(dimension2, dimension2, dimension2));
        this.setCenterPanel(jPanel);
    }

    public void sendCommand() {
        this.savedCursor = this.getCursor();
        this.setCursor(waitCursor);
        try {
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            if (this.directionButtons.getValue().equals("Server to Client")) {
                String string = this.serverFileName.getValue();
                String string2 = this.clientFileName.getValue();
                fileInputStream = SplusSystem.getServerFileHandler().getServerFileInputStream(string);
                fileOutputStream = new FileOutputStream(string2);
            } else {
                String string = this.clientFileName.getValue();
                String string3 = this.serverFileName.getValue();
                fileInputStream = new FileInputStream(string);
                fileOutputStream = SplusSystem.getServerFileHandler().getServerFileOutputStream(string3);
            }
            FileUtilities.transferBytes(fileInputStream, fileOutputStream);
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error transferring file:\n\n" + exception.toString(), "File Transfer Error", 2);
        }
        this.setCursor(this.savedCursor);
    }

    public boolean isComplete() {
        Object object;
        boolean bl;
        String string;
        boolean bl2;
        boolean bl3 = bl2 = this.warnIfEmpty(this.directionButtons) && this.warnIfEmpty(this.serverFileName) && this.warnIfEmpty(this.clientFileName);
        if (bl2) {
            string = "";
            bl = false;
            if (this.directionButtons.getValue().equals("Server to Client")) {
                string = this.serverFileName.getValue();
                FileSystemView fileSystemView = SplusSystem.getServerFileHandler().getServerFileSystemView();
                object = fileSystemView.createFileObject(string);
                bl = object == null ? false : object.canRead();
            } else {
                string = this.clientFileName.getValue();
                bl = new File(string).exists();
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this, "File to transer does not exist or is not readable:\n" + string + "\n\nMake sure that the correct path and filename are given.", "File Not Found", 2);
                bl2 = false;
            }
        }
        if (bl2) {
            string = "";
            bl = false;
            boolean bl4 = false;
            if (this.directionButtons.getValue().equals("Server to Client")) {
                string = this.clientFileName.getValue();
                object = new File(string);
                bl = object.exists();
                bl4 = object.canWrite();
            } else {
                string = this.serverFileName.getValue();
                object = SplusSystem.getServerFileHandler().getServerFileSystemView();
                File file = object.createFileObject(string);
                if (file == null) {
                    bl = false;
                    bl4 = true;
                } else {
                    bl = file.exists();
                    bl4 = file.canWrite();
                }
            }
            if (bl && bl4) {
                object = new Object[]{"Yes", "No"};
                int n = JOptionPane.showOptionDialog(this, "File already exists:\n" + string + "\n\nReplace existing file?", "Replace File", -1, 3, null, object, object[1]);
                if (n != 0) {
                    bl2 = false;
                }
            } else if (bl && !bl4) {
                JOptionPane.showMessageDialog(this, "File is not writable:\n" + string, "File Not Writable", 2);
                bl2 = false;
            }
        }
        return bl2;
    }

    public static void main(String[] stringArray) {
        new TransferFileDialog().show();
    }
}

