/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.graph;

import com.insightful.controls.SplusButton;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.client.ServerFile;
import com.insightful.splus.graph.ExportGraphCommand;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ExportGraphDialog
extends JDialog {
    protected ExportGraphCommand m_cmd;
    protected JFileChooser m_fileChooser;
    protected AccessoryPanel m_accessory;
    public boolean m_ok = false;

    public ExportGraphDialog(ExportGraphCommand exportGraphCommand, Frame frame) {
        super(frame, true);
        this.m_cmd = exportGraphCommand;
        this.m_accessory = new AccessoryPanel();
        this.m_fileChooser = new JFileChooser(SplusSystem.getCwd(), SplusSystem.getServerFileHandler().getServerFileSystemView());
        this.m_fileChooser.setAccessory(this.m_accessory);
        this.m_fileChooser.setDialogType(1);
        this.m_fileChooser.removeChoosableFileFilter(this.m_fileChooser.getAcceptAllFileFilter());
        this.m_fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("ApproveSelection")) {
                    ExportGraphDialog.this.m_ok = true;
                    ExportGraphDialog.this.m_cmd.setImageType(ExportGraphDialog.this.getChosenFilterType());
                    ExportGraphDialog.this.setImageFilename();
                    SplusSystem.setCwd(ExportGraphDialog.this.m_fileChooser.getCurrentDirectory());
                } else {
                    ExportGraphDialog.this.m_ok = false;
                }
                ExportGraphDialog.this.dispose();
            }
        });
        this.getContentPane().add(this.m_fileChooser);
        this.pack();
        FileFilter fileFilter = null;
        for (int i = this.m_cmd.getFirstImageType(); i <= this.m_cmd.getLastImageType(); ++i) {
            if (!exportGraphCommand.canEncodeType(i)) continue;
            FileFilter fileFilter2 = new FileFilter(i, ExportGraphCommand.getImageTypeDescription(i));
            this.m_fileChooser.addChoosableFileFilter(fileFilter2);
            if (i != this.m_cmd.getImageType()) continue;
            fileFilter = fileFilter2;
        }
        if (fileFilter != null) {
            this.m_fileChooser.setFileFilter(fileFilter);
        }
    }

    protected void setImageFilename() {
        this.m_cmd.setImageFilename(ServerFile.convertServerFilePath(this.m_fileChooser.getSelectedFile().getPath()));
    }

    int getChosenFilterType() {
        FileFilter fileFilter = (FileFilter)this.m_fileChooser.getFileFilter();
        return fileFilter.getImageType();
    }

    class OptionsDialog
    extends JDialog
    implements ActionListener {
        ExportGraphCommand m_cmd;
        int m_type;
        private final int SPACE_BETWEEN_BUTTONS = 8;
        private final String sm_strOK = "OK";
        private final String sm_strCancel = "Cancel";
        private String AUTO_SIZE;
        private String UNITS_INCHES;
        private String UNITS_CM;
        private String UNITS_PIXELS;
        private final double PIXELS_PER_INCH = 96.0;
        private final double PIXELS_PER_CM = 37.79527559055118;
        private JComboBox m_cbColorDepth;
        private JTextField m_tfQuality;
        private JComboBox m_cbHeight;
        private JComboBox m_cbWidth;
        private JComboBox m_cbUnits;
        private JRadioButton m_jai;
        private JRadioButton m_batik;
        private JRadioButton m_freeHEP;
        String[] m_PNGColorDepthStrings;
        int[] m_PNGColorDepthValues;
        boolean[] m_PNGColorDepthIsColor;

        OptionsDialog(ExportGraphCommand exportGraphCommand, int n, JDialog jDialog) {
            super(jDialog, "Export Options", true);
            this.SPACE_BETWEEN_BUTTONS = 8;
            this.sm_strOK = "OK";
            this.sm_strCancel = "Cancel";
            this.AUTO_SIZE = "Auto";
            this.UNITS_INCHES = "inches";
            this.UNITS_CM = "centimeters";
            this.UNITS_PIXELS = "pixels";
            this.PIXELS_PER_INCH = 96.0;
            this.PIXELS_PER_CM = 37.79527559055118;
            this.m_PNGColorDepthStrings = new String[]{"Black and White", "Grayscale 4 shades", "Grayscale 16 shades", "Grayscale 256 shades", "Color"};
            this.m_PNGColorDepthValues = new int[]{1, 2, 4, 8, 8};
            this.m_PNGColorDepthIsColor = new boolean[]{false, false, false, false, true};
            this.m_cmd = exportGraphCommand;
            this.m_type = n;
            this.m_cmd.setImageType(this.m_type);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JPanel jPanel2 = new JPanel();
            if (this.m_cmd.getImageType() == 2) {
                this.m_cbColorDepth = new JComboBox<String>(this.m_PNGColorDepthStrings);
                for (int i = 0; i < this.m_PNGColorDepthStrings.length; ++i) {
                    if (this.m_PNGColorDepthValues[i] != this.m_cmd.getImageBitDepth() || this.m_PNGColorDepthIsColor[i] != this.m_cmd.getImageIsColor()) continue;
                    this.m_cbColorDepth.setSelectedIndex(i);
                    break;
                }
                jPanel2.add(new JLabel("Colors: "));
                jPanel2.add(Box.createHorizontalStrut(10));
                jPanel2.add(this.m_cbColorDepth);
            }
            if (this.m_cmd.getImageType() == 0) {
                this.m_tfQuality = new JTextField(8);
                this.m_tfQuality.setText(Double.toString(exportGraphCommand.getImageQuality()));
                jPanel2.add(new JLabel("Q Factor:"));
                jPanel2.add(Box.createHorizontalStrut(10));
                jPanel2.add(this.m_tfQuality);
            }
            jPanel.add(jPanel2);
            jPanel.add(Box.createVerticalStrut(5));
            this.m_cbHeight = new JComboBox();
            this.m_cbWidth = new JComboBox();
            this.m_cbUnits = new JComboBox();
            this.m_cbUnits.addItem(this.UNITS_PIXELS);
            this.m_cbUnits.addItem(this.UNITS_INCHES);
            this.m_cbUnits.addItem(this.UNITS_CM);
            this.m_cbUnits.setSelectedIndex(0);
            this.m_cbUnits.setEditable(false);
            this.m_cbHeight.addItem(this.AUTO_SIZE);
            this.m_cbWidth.addItem(this.AUTO_SIZE);
            this.m_cbHeight.setEditable(true);
            this.m_cbWidth.setEditable(true);
            Dimension dimension = this.m_cmd.getImageSize();
            if (dimension.width >= 0) {
                this.m_cbWidth.setSelectedItem(Integer.toString(dimension.width));
            }
            if (dimension.height >= 0) {
                this.m_cbHeight.setSelectedItem(Integer.toString(dimension.height));
            }
            JPanel jPanel3 = new JPanel();
            if (this.m_cmd.getImageType() == 5) {
                jPanel3.add(new JLabel("There are no export options for this file type"));
            } else {
                jPanel3.add(new JLabel("Height"));
                jPanel3.add(this.m_cbHeight);
                jPanel3.add(new JLabel("Width"));
                jPanel3.add(this.m_cbWidth);
                jPanel3.add(new JLabel("Units"));
                jPanel3.add(this.m_cbUnits);
            }
            jPanel.add(jPanel3);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)jPanel, "North");
            Box box = Box.createHorizontalBox();
            JButton jButton = new JButton("OK");
            jButton.setActionCommand("OK");
            jButton.addActionListener(this);
            JButton jButton2 = new JButton("Cancel");
            jButton2.setActionCommand("Cancel");
            jButton2.addActionListener(this);
            box.add(jButton);
            box.add(Box.createHorizontalStrut(8));
            box.add(jButton2);
            this.getContentPane().add((Component)box, "South");
            this.pack();
        }

        int getDimension(JComboBox jComboBox) {
            String string = (String)jComboBox.getSelectedItem();
            if (0 == string.compareTo(this.AUTO_SIZE)) {
                return -1;
            }
            String string2 = (String)this.m_cbUnits.getSelectedItem();
            double d = string2.compareTo(this.UNITS_INCHES) == 0 ? 96.0 : (string2.compareTo(this.UNITS_CM) == 0 ? 37.79527559055118 : 1.0);
            try {
                return (int)(Double.parseDouble(string) * d);
            }
            catch (Exception exception) {
                return -1;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("OK".equals(actionEvent.getActionCommand())) {
                this.m_cmd.setImageSize(this.getDimension(this.m_cbWidth), this.getDimension(this.m_cbHeight));
                if (this.m_cmd.getImageType() == 2) {
                    int n = this.m_cbColorDepth.getSelectedIndex();
                    this.m_cmd.setImageBitDepth(this.m_PNGColorDepthValues[n]);
                    this.m_cmd.setImageIsColor(this.m_PNGColorDepthIsColor[n]);
                }
                if (this.m_cmd.getImageType() == 0) {
                    double d = 1.0;
                    try {
                        d = Double.parseDouble(this.m_tfQuality.getText());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.m_cmd.setImageQuality(d);
                }
            }
            this.dispose();
        }
    }

    class FileFilter
    extends javax.swing.filechooser.FileFilter {
        int m_type;
        String m_description;

        FileFilter(int n, String string) {
            this.m_type = n;
            this.m_description = string;
        }

        public String getDescription() {
            return this.m_description;
        }

        public int getImageType() {
            return this.m_type;
        }

        public boolean accept(File file) {
            return true;
        }
    }

    class AccessoryPanel
    extends JPanel {
        public AccessoryPanel() {
            SplusButton splusButton = new SplusButton("Options...");
            this.setPreferredSize(splusButton.getPreferredSize());
            this.add(splusButton);
            splusButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsDialog optionsDialog = new OptionsDialog(ExportGraphDialog.this.m_cmd, ExportGraphDialog.this.getChosenFilterType(), ExportGraphDialog.this);
                    optionsDialog.show();
                }
            });
        }
    }
}

