/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusRadioButtonGroup;
import com.insightful.controls.SplusTextField;
import com.insightful.controls.SplusWideBoxFiller;
import com.insightful.splus.SplusDataColumnComboBox;
import com.insightful.splus.SplusDataColumnListBox;
import com.insightful.splus.SplusDataColumnListProvider;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusSubsetField;
import com.insightful.splus.SplusWideFormulaField;
import com.insightful.splus.statdlg.RegressionFormulaDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LocalRegressionDialog
extends SplusDialog {
    SplusDataSetComboBox dataSet;
    SplusDataColumnComboBox dependentColumn;
    SplusDataColumnComboBox weightsColumn;
    SplusDataColumnListBox independentColumnList;
    SplusDataColumnListBox dropQuadList;
    SplusDataColumnListBox condParamList;
    SplusWideFormulaField formulaField;
    SplusButton formulaButton;
    SplusRadioButtonGroup familyType;
    SplusRadioButtonGroup surfaceType;
    SplusTextField numIter;
    SplusTextField cellSize;
    SplusCheckBox addQuadratic;

    public LocalRegressionDialog() {
        super("Local (Loess) Regression");
        JTabbedPane jTabbedPane = new JTabbedPane();
        SplusFunctionInfo splusFunctionInfo = new SplusFunctionInfo("menuLoess");
        this.setFunctionInfo(splusFunctionInfo);
        JPanel jPanel = new JPanel();
        jTabbedPane.addTab("Model", jPanel);
        Box box = new Box(0);
        Box box2 = new Box(0);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        box.add(box3);
        box.add(box4);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(box);
        jPanel.add(box2);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Data");
        box3.add(splusGroupPanel);
        this.dataSet = new SplusDataSetComboBox();
        splusGroupPanel.add(this.dataSet);
        splusFunctionInfo.add(this.dataSet, "data");
        this.weightsColumn = new SplusDataColumnComboBox("Weights", 'W', (SplusDataColumnListProvider)this.dataSet);
        this.weightsColumn.setValue("");
        splusGroupPanel.add(this.weightsColumn);
        splusFunctionInfo.add(this.weightsColumn, "weights");
        SplusSubsetField splusSubsetField = new SplusSubsetField();
        splusGroupPanel.add(splusSubsetField);
        splusFunctionInfo.add(splusSubsetField, "subset");
        SplusCheckBox splusCheckBox = new SplusCheckBox("Omit Rows with Missing Values", 'M');
        splusCheckBox.setValue("T");
        splusGroupPanel.add(splusCheckBox);
        splusFunctionInfo.add(splusCheckBox, "na.omit.p");
        box4.add(new SplusBoxFiller(5));
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Save Model Object");
        box4.add(splusGroupPanel2);
        SplusTextField splusTextField = new SplusTextField("Save As", 'S');
        splusGroupPanel2.add(splusTextField);
        splusFunctionInfo.setResultControl(splusTextField);
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Variables");
        box2.add(splusGroupPanel3);
        this.dependentColumn = new SplusDataColumnComboBox("Dependent", 'E', (SplusDataColumnListProvider)this.dataSet);
        this.dependentColumn.setValue("");
        splusGroupPanel3.add(this.dependentColumn);
        splusFunctionInfo.add(this.dependentColumn, "");
        this.independentColumnList = new SplusDataColumnListBox("Independent", 'I', (SplusDataColumnListProvider)this.dataSet);
        this.independentColumnList.setPrepend(new String[]{"<ALL>"});
        splusGroupPanel3.add(this.independentColumnList);
        splusFunctionInfo.add(this.independentColumnList, "");
        this.formulaField = new SplusWideFormulaField();
        splusGroupPanel3.add(this.formulaField);
        splusFunctionInfo.add(this.formulaField, "formula");
        this.dependentColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LocalRegressionDialog.this.formulaField.setDependentValue(LocalRegressionDialog.this.dependentColumn.getValue());
            }
        });
        this.independentColumnList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LocalRegressionDialog.this.formulaField.setIndependentValue(LocalRegressionDialog.this.independentColumnList.getValue());
            }
        });
        this.formulaButton = new SplusButton("Create Formula", 'C');
        this.formulaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new RegressionFormulaDialog(LocalRegressionDialog.this.formulaField, LocalRegressionDialog.this.dataSet, 1).show();
            }
        });
        Box box5 = new Box(0);
        box5.add(Box.createHorizontalStrut(5));
        box5.add(this.formulaButton);
        box5.add(Box.createHorizontalGlue());
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        splusGroupPanel3.add(box5);
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        jPanel.add(new SplusWideBoxFiller());
        JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab("Options", jPanel2);
        Box box6 = new Box(1);
        Box box7 = new Box(1);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(box6);
        jPanel2.add(box7);
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("Model");
        box6.add(splusGroupPanel4);
        this.familyType = new SplusRadioButtonGroup("Family", 'Y', new String[]{"gaussian", "symmetric"});
        this.familyType.setValue("gaussian");
        splusGroupPanel4.add(this.familyType);
        splusFunctionInfo.add(this.familyType, "family", true);
        SplusCheckBox splusCheckBox2 = new SplusCheckBox("Normalize Numeric Predictors", 'N');
        splusCheckBox2.setValue("T");
        splusGroupPanel4.add(splusCheckBox2);
        splusFunctionInfo.add(splusCheckBox2, "normalize");
        this.addQuadratic = new SplusCheckBox("Add Quadratic Term in Local Fitting", 'L');
        this.addQuadratic.setValue("T");
        splusGroupPanel4.add(this.addQuadratic);
        splusFunctionInfo.add(this.addQuadratic);
        this.dropQuadList = new SplusDataColumnListBox("Drop Quadratic Terms in:", 'T', (SplusDataColumnListProvider)this.dataSet);
        this.dropQuadList.setPrepend(new String[]{"<NONE>"});
        this.dropQuadList.setValue("<NONE>");
        splusGroupPanel4.add(this.dropQuadList);
        splusFunctionInfo.add(this.dropQuadList, "drop.quad", true, true);
        this.addQuadratic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LocalRegressionDialog.this.dropQuadList.setEnabled(LocalRegressionDialog.this.addQuadratic.getValue().equals("T"));
            }
        });
        this.condParamList = new SplusDataColumnListBox("Conditionally Parametric in:", 'O', (SplusDataColumnListProvider)this.dataSet);
        this.condParamList.setPrepend(new String[]{"<NONE>"});
        this.condParamList.setValue("<NONE>");
        splusGroupPanel4.add(this.condParamList);
        splusFunctionInfo.add(this.condParamList, "cond.parametric", true, true);
        box6.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel5 = new SplusGroupPanel("Local Smoothness");
        box7.add(splusGroupPanel5);
        SplusComboBox splusComboBox = new SplusComboBox("Span", 'P', new String[]{"0", "0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.75", "0.8", "0.9", "1.0"});
        splusComboBox.setValue("0.75");
        splusGroupPanel5.add(splusComboBox);
        splusFunctionInfo.add(splusComboBox, "span");
        SplusTextField splusTextField2 = new SplusTextField("Equivalent Number of Parameters", 'Q');
        splusGroupPanel5.add(splusTextField2);
        splusFunctionInfo.add(splusTextField2, "enp.target");
        SplusGroupPanel splusGroupPanel6 = new SplusGroupPanel("Control Parameters");
        box7.add(splusGroupPanel6);
        this.surfaceType = new SplusRadioButtonGroup("Surface Fitting", 'S', new String[]{"direct", "interpolate"});
        this.surfaceType.setValue("interpolate");
        splusGroupPanel6.add(this.surfaceType);
        splusFunctionInfo.add(this.surfaceType, "surface", true);
        this.cellSize = new SplusTextField("Cell Size", 'C');
        this.cellSize.setValue("0.2");
        splusGroupPanel6.add(this.cellSize);
        splusFunctionInfo.add(this.cellSize, "cell");
        this.surfaceType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LocalRegressionDialog.this.cellSize.setEnabled(LocalRegressionDialog.this.surfaceType.getValue().equals("interpolate"));
            }
        });
        this.numIter = new SplusTextField("Number of Iterations", 'I');
        this.numIter.setValue("4");
        this.numIter.setEnabled(false);
        splusGroupPanel6.add(this.numIter);
        splusFunctionInfo.add(this.numIter, "iterations");
        this.familyType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LocalRegressionDialog.this.numIter.setEnabled(LocalRegressionDialog.this.familyType.getValue().equals("symmetric"));
            }
        });
        box7.add(new SplusBoxFiller());
        JPanel jPanel3 = new JPanel();
        jTabbedPane.addTab("Results", jPanel3);
        Box box8 = new Box(1);
        Box box9 = new Box(1);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(box8);
        jPanel3.add(box9);
        SplusGroupPanel splusGroupPanel7 = new SplusGroupPanel("Printed Results");
        box8.add(splusGroupPanel7);
        SplusCheckBox splusCheckBox3 = new SplusCheckBox("Short Output", 'S');
        splusCheckBox3.setValue("T");
        splusGroupPanel7.add(splusCheckBox3);
        splusFunctionInfo.add(splusCheckBox3, "print.object.p");
        box8.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel8 = new SplusGroupPanel("Saved Results");
        box9.add(splusGroupPanel8);
        SplusDataSetComboBox splusDataSetComboBox = new SplusDataSetComboBox("Save In", 'I');
        splusDataSetComboBox.setValue("");
        splusGroupPanel8.add(splusDataSetComboBox);
        splusFunctionInfo.add(splusDataSetComboBox, "save.results", true);
        SplusCheckBox splusCheckBox4 = new SplusCheckBox("Fitted Values", 'F');
        splusGroupPanel8.add(splusCheckBox4);
        splusFunctionInfo.add(splusCheckBox4, "save.fitted.p");
        SplusCheckBox splusCheckBox5 = new SplusCheckBox("Residuals", 'R');
        splusGroupPanel8.add(splusCheckBox5);
        splusFunctionInfo.add(splusCheckBox5, "save.resid.p");
        box9.add(new SplusBoxFiller());
        JPanel jPanel4 = new JPanel();
        jTabbedPane.addTab("Plot", jPanel4);
        Box box10 = new Box(1);
        Box box11 = new Box(1);
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(box10);
        jPanel4.add(box11);
        SplusGroupPanel splusGroupPanel9 = new SplusGroupPanel("Plots");
        box10.add(splusGroupPanel9);
        SplusCheckBox splusCheckBox6 = new SplusCheckBox("Residuals vs Fit", 'R');
        splusGroupPanel9.add(splusCheckBox6);
        splusFunctionInfo.add(splusCheckBox6, "plotResidVsFit.p");
        SplusCheckBox splusCheckBox7 = new SplusCheckBox("Sqrt Abs Residuals vs Fit", 'Q');
        splusGroupPanel9.add(splusCheckBox7);
        splusFunctionInfo.add(splusCheckBox7, "plotSqrtAbsResid.p");
        SplusCheckBox splusCheckBox8 = new SplusCheckBox("Response vs Fit", 'P');
        splusGroupPanel9.add(splusCheckBox8);
        splusFunctionInfo.add(splusCheckBox8, "plotResponseVsFit.p");
        SplusCheckBox splusCheckBox9 = new SplusCheckBox("Residuals Normal QQ", 'Q');
        splusGroupPanel9.add(splusCheckBox9);
        splusFunctionInfo.add(splusCheckBox9, "plotQQ.p");
        SplusCheckBox splusCheckBox10 = new SplusCheckBox("Residual-Fit Spread", 'S');
        splusGroupPanel9.add(splusCheckBox10);
        splusFunctionInfo.add(splusCheckBox10, "plotRFSpread.p");
        SplusCheckBox splusCheckBox11 = new SplusCheckBox("Cond. Plots of Fitted vs Predictors", 'C');
        splusGroupPanel9.add(splusCheckBox11);
        splusFunctionInfo.add(splusCheckBox11, "plotCoplot.p");
        box10.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel10 = new SplusGroupPanel("Options");
        box11.add(splusGroupPanel10);
        SplusCheckBox splusCheckBox12 = new SplusCheckBox("Include Smooth", 'M');
        splusCheckBox12.setValue("T");
        splusGroupPanel10.add(splusCheckBox12);
        splusFunctionInfo.add(splusCheckBox12, "smooth");
        SplusCheckBox splusCheckBox13 = new SplusCheckBox("Include Rugplot", 'G');
        splusGroupPanel10.add(splusCheckBox13);
        splusFunctionInfo.add(splusCheckBox13, "rugplot");
        SplusTextField splusTextField3 = new SplusTextField("Number of Extreme Points to Identify:", 'X');
        splusTextField3.setValue("3");
        splusGroupPanel10.add(splusTextField3);
        splusFunctionInfo.add(splusTextField3, "id.n");
        box11.add(new SplusBoxFiller());
        JPanel jPanel5 = new JPanel();
        jTabbedPane.addTab("Predict", jPanel5);
        Box box12 = new Box(1);
        Box box13 = new Box(1);
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(box12);
        jPanel5.add(box13);
        SplusGroupPanel splusGroupPanel11 = new SplusGroupPanel("");
        box12.add(splusGroupPanel11);
        SplusDataSetComboBox splusDataSetComboBox2 = new SplusDataSetComboBox("New Data", 'N');
        splusDataSetComboBox2.setValue("");
        splusGroupPanel11.add(splusDataSetComboBox2);
        splusFunctionInfo.add(splusDataSetComboBox2, "newdata");
        SplusGroupPanel splusGroupPanel12 = new SplusGroupPanel("Save");
        box12.add(splusGroupPanel12);
        SplusDataSetComboBox splusDataSetComboBox3 = new SplusDataSetComboBox("Save In", 'I');
        splusDataSetComboBox3.setValue("");
        splusGroupPanel12.add(splusDataSetComboBox3);
        splusFunctionInfo.add(splusDataSetComboBox3, "predobj.name", true);
        SplusCheckBox splusCheckBox14 = new SplusCheckBox("Predictions", 'P');
        splusGroupPanel12.add(splusCheckBox14);
        splusFunctionInfo.add(splusCheckBox14, "predict.p");
        SplusCheckBox splusCheckBox15 = new SplusCheckBox("Standard Errors", 'S');
        splusGroupPanel12.add(splusCheckBox15);
        splusFunctionInfo.add(splusCheckBox15, "se.p");
        box12.add(new SplusBoxFiller());
        box13.add(new SplusBoxFiller());
        this.setCenterPanel(jTabbedPane);
    }

    public boolean isComplete() {
        return this.warnIfEmpty(this.dataSet) && this.warnIfEmpty(this.formulaField);
    }
}

