/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusControlMethods;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusTextField;
import com.insightful.controls.SplusWideTextField;
import com.insightful.splus.SplusDataColumnListBox;
import com.insightful.splus.SplusDataColumnListProvider;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.statdlg.TransformationBuilderDialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SurvivalFormulaDialog
extends SplusDialog {
    SplusControlMethods incomingFormulaField;
    SplusDataSetComboBox dataSet;
    int dialogType;
    SplusWideTextField formulaField;
    SplusDataColumnListBox varList;
    SplusButton transformButton;
    SplusButton mainButton;
    SplusButton intButton;
    SplusButton bothButton;
    SplusButton offsetButton;
    SplusButton strataButton;
    SplusButton clusterButton;
    SplusButton frailtyButton;
    SplusButton gammaButton;
    SplusButton splineButton;
    SplusButton ridgeButton;
    SplusButton timeOneButton;
    SplusButton codesButton;
    SplusButton timeTwoButton;
    SplusButton addResponseButton;
    SplusButton removeAllButton;
    SplusButton removeLastButton;
    SplusComboBox censorType;
    SplusTextField timeOneField;
    SplusTextField codesField;
    SplusTextField timeTwoField;
    public static final int TYPE_SURVFIT = 1;
    public static final int TYPE_COXPH = 2;
    public static final int TYPE_SURVREG = 3;
    public static final int TYPE_CENSORREG = 4;

    public SurvivalFormulaDialog(SplusControlMethods splusControlMethods, SplusDataSetComboBox splusDataSetComboBox, int n) {
        super("Survival Formula");
        this.incomingFormulaField = splusControlMethods;
        this.dataSet = splusDataSetComboBox;
        this.dialogType = n;
        this.setApplyVisible(false);
        JPanel jPanel = new JPanel();
        Box box = new Box(0);
        Box box2 = new Box(0);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        box.add(box3);
        box.add(box4);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(box);
        jPanel.add(box2);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Variables");
        box3.add(splusGroupPanel);
        this.varList = new SplusDataColumnListBox("Choose Variables", 'V', (SplusDataColumnListProvider)this.dataSet);
        splusGroupPanel.add(this.varList);
        this.transformButton = new SplusButton("Transformation", 'T');
        this.transformButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new TransformationBuilderDialog(SurvivalFormulaDialog.this.varList).show();
            }
        });
        Box box5 = new Box(0);
        box5.add(Box.createHorizontalStrut(5));
        box5.add(this.transformButton);
        box5.add(Box.createHorizontalGlue());
        splusGroupPanel.add(Box.createVerticalStrut(5));
        splusGroupPanel.add(box5);
        splusGroupPanel.add(Box.createVerticalStrut(5));
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Add Terms");
        box3.add(splusGroupPanel2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(5, 2, 5, 5));
        this.mainButton = new SplusButton("Main Effect: (+)", 'M');
        jPanel2.add(this.mainButton);
        this.mainButton.addActionListener(new AddTermActionListener("+", true));
        this.intButton = new SplusButton("Interaction: (:)", 'I');
        jPanel2.add(this.intButton);
        this.intButton.addActionListener(new AddTermActionListener(":", true));
        this.bothButton = new SplusButton("Main+Interact: (*)", 'N');
        jPanel2.add(this.bothButton);
        this.bothButton.addActionListener(new AddTermActionListener("*", true));
        this.offsetButton = new SplusButton("Offset", 'O');
        jPanel2.add(this.offsetButton);
        this.offsetButton.addActionListener(new AddTermActionListener("offset", false));
        this.strataButton = new SplusButton("Strata", 'S');
        jPanel2.add(this.strataButton);
        this.strataButton.addActionListener(new AddTermActionListener("strata", false));
        this.clusterButton = new SplusButton("Cluster", 'L');
        jPanel2.add(this.clusterButton);
        this.clusterButton.addActionListener(new AddTermActionListener("cluster", false));
        this.frailtyButton = new SplusButton("Frailty", 'A');
        jPanel2.add(this.frailtyButton);
        this.frailtyButton.addActionListener(new AddTermActionListener("frailty", false));
        this.gammaButton = new SplusButton("Gamma Frailty", 'Y');
        jPanel2.add(this.gammaButton);
        this.gammaButton.addActionListener(new AddTermActionListener("frailty.gamma", false));
        this.splineButton = new SplusButton("Spline", 'P');
        jPanel2.add(this.splineButton);
        this.splineButton.addActionListener(new AddTermActionListener("pspline", false));
        this.ridgeButton = new SplusButton("Ridge", 'D');
        jPanel2.add(this.ridgeButton);
        this.ridgeButton.addActionListener(new AddTermActionListener("ridge", false));
        splusGroupPanel2.add(jPanel2);
        splusGroupPanel2.add(Box.createVerticalStrut(5));
        if (this.dialogType == 4) {
            this.clusterButton.setEnabled(false);
            this.frailtyButton.setEnabled(false);
            this.gammaButton.setEnabled(false);
            this.splineButton.setEnabled(false);
            this.ridgeButton.setEnabled(false);
        } else if (this.dialogType == 3) {
            this.offsetButton.setEnabled(false);
            this.strataButton.setEnabled(false);
            this.clusterButton.setEnabled(false);
            this.frailtyButton.setEnabled(false);
            this.gammaButton.setEnabled(false);
        } else if (this.dialogType == 1) {
            this.intButton.setEnabled(false);
            this.bothButton.setEnabled(false);
            this.offsetButton.setEnabled(false);
            this.strataButton.setEnabled(false);
            this.clusterButton.setEnabled(false);
            this.frailtyButton.setEnabled(false);
            this.gammaButton.setEnabled(false);
            this.splineButton.setEnabled(false);
            this.ridgeButton.setEnabled(false);
        }
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Survival Response");
        box4.add(splusGroupPanel3);
        this.censorType = new SplusComboBox("Censoring Type", 'T', new String[]{"right", "left", "counting"});
        this.censorType.setValue("right");
        this.censorType.setEditable(false);
        splusGroupPanel3.add(this.censorType);
        if (this.dialogType == 4) {
            this.censorType.setOptionList(new String[]{"right", "left", "counting", "interval"});
        } else if (this.dialogType == 3) {
            this.censorType.setOptionList(new String[]{"right", "left", "counting", "interval", "interval2"});
        }
        this.censorType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = SurvivalFormulaDialog.this.censorType.getValue();
                boolean bl = string.equals("counting") || string.equals("interval") || string.equals("interval2");
                SurvivalFormulaDialog.this.timeTwoButton.setEnabled(bl);
                SurvivalFormulaDialog.this.timeTwoField.setEnabled(bl);
                if (!bl) {
                    SurvivalFormulaDialog.this.timeTwoField.setValue("");
                }
                SurvivalFormulaDialog.this.formulaField.setValue("");
            }
        });
        this.timeOneButton = new SplusButton("Time 1", '1');
        this.timeOneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = SurvivalFormulaDialog.this.varList.getValues();
                if (stringArray.length == 1) {
                    SurvivalFormulaDialog.this.timeOneField.setValue(stringArray[0]);
                    SurvivalFormulaDialog.this.formulaField.setValue("");
                } else if (stringArray.length == 0) {
                    JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Select a variable for Time 1.");
                } else {
                    JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Select only one variable for Time 1.");
                }
            }
        });
        Box box6 = new Box(0);
        box6.add(Box.createHorizontalStrut(5));
        box6.add(this.timeOneButton);
        box6.add(Box.createHorizontalGlue());
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        splusGroupPanel3.add(box6);
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        this.timeOneField = new SplusTextField("          -->");
        splusGroupPanel3.add(this.timeOneField);
        this.codesButton = new SplusButton("Censor Codes", 'C');
        this.codesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = SurvivalFormulaDialog.this.varList.getValues();
                if (stringArray.length == 1) {
                    SurvivalFormulaDialog.this.codesField.setValue(stringArray[0]);
                    SurvivalFormulaDialog.this.formulaField.setValue("");
                } else if (stringArray.length == 0) {
                    JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Select a variable for Censor Codes.");
                } else {
                    JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Select only one variable for Censor Codes.");
                }
            }
        });
        Box box7 = new Box(0);
        box7.add(Box.createHorizontalStrut(5));
        box7.add(this.codesButton);
        box7.add(Box.createHorizontalGlue());
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        splusGroupPanel3.add(box7);
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        this.codesField = new SplusTextField("          -->");
        splusGroupPanel3.add(this.codesField);
        this.timeTwoButton = new SplusButton("Time 2", '2');
        this.timeTwoButton.setEnabled(false);
        this.timeTwoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = SurvivalFormulaDialog.this.varList.getValues();
                if (stringArray.length == 1) {
                    SurvivalFormulaDialog.this.timeTwoField.setValue(stringArray[0]);
                    SurvivalFormulaDialog.this.formulaField.setValue("");
                } else if (stringArray.length == 0) {
                    JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Select a variable for Time 2.");
                } else {
                    JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Select only one variable for Time 2.");
                }
            }
        });
        Box box8 = new Box(0);
        box8.add(Box.createHorizontalStrut(5));
        box8.add(this.timeTwoButton);
        box8.add(Box.createHorizontalGlue());
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        splusGroupPanel3.add(box8);
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        this.timeTwoField = new SplusTextField("          -->");
        this.timeTwoField.setEnabled(false);
        splusGroupPanel3.add(this.timeTwoField);
        this.addResponseButton = new SplusButton("Add Response", 'R');
        this.addResponseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = SurvivalFormulaDialog.this.censorType.getValue();
                String string2 = SurvivalFormulaDialog.this.dialogType == 4 ? "censor" : "Surv";
                string2 = string.equals("left") || string.equals("right") ? string2 + "(" + SurvivalFormulaDialog.this.timeOneField.getValue() + ", " + SurvivalFormulaDialog.this.codesField.getValue() + ", type='" + string + "') ~ 1" : string2 + "(" + SurvivalFormulaDialog.this.timeOneField.getValue() + ", " + SurvivalFormulaDialog.this.timeTwoField.getValue() + ", " + SurvivalFormulaDialog.this.codesField.getValue() + ", type='" + string + "') ~ 1";
                SurvivalFormulaDialog.this.formulaField.setValue(string2);
            }
        });
        Box box9 = new Box(0);
        box9.add(Box.createHorizontalStrut(5));
        box9.add(this.addResponseButton);
        box9.add(Box.createHorizontalGlue());
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        splusGroupPanel3.add(box9);
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("Remove");
        box4.add(splusGroupPanel4);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2, 5, 5));
        splusGroupPanel4.add(jPanel3);
        splusGroupPanel4.add(Box.createVerticalStrut(5));
        this.removeAllButton = new SplusButton("Remove All", 'R');
        jPanel3.add(this.removeAllButton);
        this.removeAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SurvivalFormulaDialog.this.formulaField.setValue("");
            }
        });
        this.removeLastButton = new SplusButton("Remove Last", 'L');
        jPanel3.add(this.removeLastButton);
        this.removeLastButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = SurvivalFormulaDialog.this.formulaField.getValue();
                if (string.length() > 0) {
                    int n = string.lastIndexOf("+");
                    if (n > 0) {
                        SurvivalFormulaDialog.this.formulaField.setValue(string.substring(0, n));
                    } else {
                        SurvivalFormulaDialog.this.formulaField.setValue("");
                    }
                }
            }
        });
        SplusGroupPanel splusGroupPanel5 = new SplusGroupPanel("");
        box2.add(splusGroupPanel5);
        this.formulaField = new SplusWideTextField("Formula", 'F');
        splusGroupPanel5.add(this.formulaField);
        this.formulaField.setValue(this.incomingFormulaField.getValue());
        this.setCenterPanel(jPanel);
    }

    public void sendCommand() {
        this.incomingFormulaField.setValue(this.formulaField.getValue());
    }

    private void addTerm(String string, boolean bl) {
        String string2 = this.formulaField.getValue().trim();
        int n = string2.indexOf(126);
        String[] stringArray = this.varList.getValues();
        if (n < 0) {
            JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Add response before adding other terms.");
            return;
        }
        if (string2.substring(n + 1).trim().equals("1")) {
            string2 = string2.substring(0, n + 1);
        }
        if (stringArray.length == 0) {
            JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Select variables to add terms.");
            return;
        }
        if (bl) {
            string2 = string2.endsWith("~") ? string2 + stringArray[0] : string2 + "+" + stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string2 = string2 + string + stringArray[i];
            }
        } else {
            string2 = string2.endsWith("~") ? string2 + string + "(" + stringArray[0] + ")" : string2 + "+" + string + "(" + stringArray[0] + ")";
            for (int i = 1; i < stringArray.length; ++i) {
                string2 = string2 + "+" + string + "(" + stringArray[i] + ")";
            }
        }
        this.formulaField.setValue(string2);
    }

    public void show() {
        if (this.dataSet.getValue().trim().length() == 0) {
            JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Enter Data Set before building formula.");
        } else {
            super.show();
        }
    }

    private class AddTermActionListener
    implements ActionListener {
        String operator;
        boolean isBinary;

        AddTermActionListener(String string, boolean bl) {
            this.operator = string;
            this.isBinary = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SurvivalFormulaDialog.this.addTerm(this.operator, this.isBinary);
        }
    }
}

