/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusListBox;
import com.insightful.controls.SplusRadioButtonGroup;
import com.insightful.controls.SplusTextField;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusGui;
import com.insightful.splus.SplusObjectComboBox;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.util.StringUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class TreeToolsDialog
extends SplusDialog {
    SplusTextField nameStringMatch;
    SplusComboBox modelObject;
    SplusComboBox rugVariable;
    SplusListBox histVariables;
    SplusRadioButtonGroup toolType;
    SplusFunctionInfo funcInfo;
    String[] fullNameList;

    public TreeToolsDialog() {
        super("Tree Tools");
        JPanel jPanel = new JPanel();
        Box box = new Box(1);
        Box box2 = new Box(1);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(box);
        jPanel.add(box2);
        this.funcInfo = new SplusFunctionInfo("menuTreeTools");
        this.setFunctionInfo(this.funcInfo);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Model Selection");
        box.add(splusGroupPanel);
        this.fullNameList = SplusObjectComboBox.getObjectsOfClass("tree", true);
        this.modelObject = new SplusComboBox("Model Object", 'O', new String[]{""});
        this.modelObject.setOptionList(this.fullNameList);
        this.modelObject.setValue("");
        splusGroupPanel.add(this.modelObject);
        this.funcInfo.add(this.modelObject, "tree");
        this.modelObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = TreeToolsDialog.this.modelObject.getValue().trim();
                if (string.length() > 0) {
                    String[] stringArray;
                    String string2 = "if (exists(\"" + string + "\") && inherits(" + string + ", \"tree\")) as.character(attr(" + string + "$terms, \"variables\")) else NULL";
                    try {
                        SplusDataResult splusDataResult = SplusSystem.getEngineQueryHandler().processDataQuery(string2);
                        stringArray = splusDataResult.getStringData();
                    }
                    catch (Exception exception) {
                        stringArray = new String[]{};
                    }
                    TreeToolsDialog.this.histVariables.setOptionList(stringArray);
                    TreeToolsDialog.this.rugVariable.setOptionList(stringArray);
                }
            }
        });
        this.nameStringMatch = new SplusTextField("Name String Match", 'N');
        splusGroupPanel.add(this.nameStringMatch);
        this.funcInfo.add(this.nameStringMatch, "");
        this.nameStringMatch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeToolsDialog.this.modelObject.setOptionList(StringUtilities.getElementsContainingPattern(TreeToolsDialog.this.fullNameList, TreeToolsDialog.this.nameStringMatch.getValue().trim()));
            }
        });
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Variables to Plot");
        box.add(splusGroupPanel2);
        this.histVariables = new SplusListBox("Hist Variables", 'H');
        this.histVariables.setEnabled(false);
        splusGroupPanel2.add(this.histVariables);
        this.funcInfo.add(this.histVariables, "hist.vars", true, true);
        this.rugVariable = new SplusComboBox("Rug/Tile Variable", 'R', new String[0]);
        this.rugVariable.setEnabled(false);
        splusGroupPanel2.add(this.rugVariable);
        this.funcInfo.add(this.rugVariable, "rug.var", true);
        box.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Tree Tool");
        box2.add(splusGroupPanel3);
        this.toolType = new SplusRadioButtonGroup("Tool Type", 'T', new String[]{"Browse", "Burl", "Histogram", "Identify", "Rug", "Snip", "Tile"});
        this.toolType.setValue("Browse");
        splusGroupPanel3.add(this.toolType);
        this.funcInfo.add(this.toolType, "type", true);
        this.toolType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = TreeToolsDialog.this.toolType.getValue();
                TreeToolsDialog.this.histVariables.setEnabled(string.equals("Histogram"));
                TreeToolsDialog.this.rugVariable.setEnabled(string.equals("Rug") || string.equals("Tile"));
            }
        });
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("Save Results");
        box2.add(splusGroupPanel4);
        SplusTextField splusTextField = new SplusTextField("Save As", 'S');
        splusGroupPanel4.add(splusTextField);
        this.funcInfo.add(splusTextField, "ret.value", true);
        box2.add(new SplusBoxFiller());
        this.setCenterPanel(jPanel);
    }

    public void sendCommand() {
        SplusGui splusGui = (SplusGui)SplusSystem.getEngineQueryHandler();
        splusGui.evaluateCommand(this.funcInfo.getFunctionCall());
    }

    public boolean isComplete() {
        boolean bl = this.warnIfEmpty(this.modelObject);
        String string = this.toolType.getValue();
        if (bl && string.equals("Histogram")) {
            bl = this.warnIfEmpty(this.histVariables);
        } else if (bl && (string.equals("Rug") || string.equals("Tile"))) {
            bl = this.warnIfEmpty(this.rugVariable);
        }
        return bl;
    }
}

