/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;

final class BandSelectOpImage
extends PointOpImage {
    private int[] bandIndices;

    public BandSelectOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, int[] nArray) {
        super(renderedImage, tileCache, imageLayout, true);
        this.bandIndices = nArray;
        int n = nArray.length;
        if (this.getSampleModel().getNumBands() != n) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, this.sampleModel.getDataType(), this.tileWidth, this.tileHeight, n);
            this.colorModel = PlanarImage.createColorModel(this.sampleModel);
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: 
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2);
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n3 = rasterAccessor2.getWidth();
        int n4 = rasterAccessor2.getHeight();
        int n5 = rasterAccessor2.getNumBands();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n8 = 0;
        while (n8 < n5) {
            int n9 = this.bandIndices[n8];
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n8];
            int n10 = nArray[n9];
            int n11 = nArray2[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n10;
                int n14 = n11;
                n10 += n;
                n11 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    byte by = byArray3[n13];
                    byte by2 = byArray4[n14];
                    byArray4[n14] = byArray3[n13];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n3 = rasterAccessor2.getWidth();
        int n4 = rasterAccessor2.getHeight();
        int n5 = rasterAccessor2.getNumBands();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n8 = 0;
        while (n8 < n5) {
            int n9 = this.bandIndices[n8];
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n8];
            int n10 = nArray[n9];
            int n11 = nArray2[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n10;
                int n14 = n11;
                n10 += n;
                n11 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    dArray4[n14] = dArray3[n13];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n3 = rasterAccessor2.getWidth();
        int n4 = rasterAccessor2.getHeight();
        int n5 = rasterAccessor2.getNumBands();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n8 = 0;
        while (n8 < n5) {
            int n9 = this.bandIndices[n8];
            float[] fArray3 = fArray[n9];
            float[] fArray4 = fArray2[n8];
            int n10 = nArray[n9];
            int n11 = nArray2[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n10;
                int n14 = n11;
                n10 += n;
                n11 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    fArray4[n14] = fArray3[n13];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n3 = rasterAccessor2.getWidth();
        int n4 = rasterAccessor2.getHeight();
        int n5 = rasterAccessor2.getNumBands();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        int n8 = 0;
        while (n8 < n5) {
            int n9 = this.bandIndices[n8];
            int[] nArray5 = nArray2[n9];
            int[] nArray6 = nArray4[n8];
            int n10 = nArray[n9];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n10;
                int n14 = n11;
                n10 += n;
                n11 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    nArray6[n14] = nArray5[n13];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getWidth();
        int n4 = rasterAccessor2.getHeight();
        int n5 = rasterAccessor2.getNumBands();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n8 = 0;
        while (n8 < n5) {
            int n9 = this.bandIndices[n8];
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n8];
            int n10 = nArray[n9];
            int n11 = nArray2[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n10;
                int n14 = n11;
                n10 += n;
                n11 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    sArray4[n14] = sArray3[n13];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }
}

