/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.revisions.IRevisionRulerColumn;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IChangeRulerColumn;
import org.eclipse.jface.text.source.ILineDifferExtension;
import org.eclipse.jface.text.source.ILineDifferExtension2;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.text.source.LineNumberChangeRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.PropertyEventDispatcher;
import org.eclipse.ui.internal.texteditor.RulerMessages;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.quickdiff.QuickDiff;
import org.eclipse.ui.texteditor.rulers.AbstractContributedRulerColumn;

public class LineNumberColumn
extends AbstractContributedRulerColumn
implements IVerticalRulerInfo,
IVerticalRulerInfoExtension {
    public static final String ID = "org.eclipse.ui.editors.columns.linenumbers";
    private static final String FG_COLOR_KEY = "lineNumberColor";
    private static final String BG_COLOR_KEY = "AbstractTextEditor.Color.Background";
    private static final String USE_DEFAULT_BG_KEY = "AbstractTextEditor.Color.Background.SystemDefault";
    private static final String LINE_NUMBER_KEY = "lineNumberRuler";
    private static final String REVISION_ASK_BEFORE_QUICKDIFF_SWITCH_KEY = "quickdiff.nowarn.before.switch";
    private IVerticalRulerColumn fDelegate;
    private final MarkerAnnotationPreferences fAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
    private PropertyEventDispatcher fDispatcher;
    private ISourceViewer fViewer;
    private ICompatibilityForwarder fForwarder;

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        Assert.isTrue((this.fDelegate != null ? 1 : 0) != 0);
        ITextViewer viewer = parentRuler.getTextViewer();
        Assert.isLegal((boolean)(viewer instanceof ISourceViewer));
        this.fViewer = (ISourceViewer)viewer;
        this.initialize();
        Control control = this.fDelegate.createControl(parentRuler, parentControl);
        return control;
    }

    public Control getControl() {
        return this.fDelegate.getControl();
    }

    public int getWidth() {
        return this.fDelegate.getWidth();
    }

    public void redraw() {
        this.fDelegate.redraw();
    }

    public void setFont(Font font) {
        this.fDelegate.setFont(font);
    }

    public void setModel(IAnnotationModel model) {
        if (this.getQuickDiffPreference()) {
            this.fDelegate.setModel(model);
        }
    }

    public int getLineOfLastMouseButtonActivity() {
        if (this.fDelegate instanceof IVerticalRulerInfo) {
            return ((IVerticalRulerInfo)this.fDelegate).getLineOfLastMouseButtonActivity();
        }
        return -1;
    }

    public int toDocumentLineNumber(int y_coordinate) {
        if (this.fDelegate instanceof IVerticalRulerInfo) {
            return ((IVerticalRulerInfo)this.fDelegate).toDocumentLineNumber(y_coordinate);
        }
        return -1;
    }

    public void addVerticalRulerListener(IVerticalRulerListener listener) {
        if (this.fDelegate instanceof IVerticalRulerInfoExtension) {
            ((IVerticalRulerInfoExtension)this.fDelegate).addVerticalRulerListener(listener);
        }
    }

    public IAnnotationHover getHover() {
        if (this.fDelegate instanceof IVerticalRulerInfoExtension) {
            return ((IVerticalRulerInfoExtension)this.fDelegate).getHover();
        }
        return null;
    }

    public IAnnotationModel getModel() {
        if (this.fDelegate instanceof IVerticalRulerInfoExtension) {
            return ((IVerticalRulerInfoExtension)this.fDelegate).getModel();
        }
        return null;
    }

    public void removeVerticalRulerListener(IVerticalRulerListener listener) {
        if (this.fDelegate instanceof IVerticalRulerInfoExtension) {
            ((IVerticalRulerInfoExtension)this.fDelegate).removeVerticalRulerListener(listener);
        }
    }

    public void columnRemoved() {
        if (this.fDispatcher != null) {
            this.fDispatcher.dispose();
            this.fDispatcher = null;
        }
    }

    private IPreferenceStore getPreferenceStore() {
        return EditorsUI.getPreferenceStore();
    }

    private ISharedTextColors getSharedColors() {
        return EditorsUI.getSharedTextColors();
    }

    private void initialize() {
        final IPreferenceStore store = this.getPreferenceStore();
        if (store == null) {
            return;
        }
        this.updateForegroundColor(store, this.fDelegate);
        this.updateBackgroundColor(store, this.fDelegate);
        this.updateLineNumbersVisibility(this.fDelegate);
        this.updateQuickDiffVisibility(this.fDelegate);
        this.updateCharacterMode(store, this.fDelegate);
        this.updateRevisionRenderingMode(store, this.fDelegate);
        this.updateRevisionAuthorVisibility(store, this.fDelegate);
        this.updateRevisionIdVisibility(store, this.fDelegate);
        Map annotationPrefs = this.getAnnotationPreferenceMap();
        final AnnotationPreference changedPref = (AnnotationPreference)annotationPrefs.get("org.eclipse.ui.workbench.texteditor.quickdiffChange");
        final AnnotationPreference addedPref = (AnnotationPreference)annotationPrefs.get("org.eclipse.ui.workbench.texteditor.quickdiffAddition");
        final AnnotationPreference deletedPref = (AnnotationPreference)annotationPrefs.get("org.eclipse.ui.workbench.texteditor.quickdiffDeletion");
        this.updateChangedColor(changedPref, store, this.fDelegate);
        this.updateAddedColor(addedPref, store, this.fDelegate);
        this.updateDeletedColor(deletedPref, store, this.fDelegate);
        this.fDelegate.redraw();
        this.fDispatcher = new PropertyEventDispatcher(store);
        this.fDispatcher.addPropertyChangeListener(FG_COLOR_KEY, new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LineNumberColumn.this.updateForegroundColor(store, LineNumberColumn.this.fDelegate);
                LineNumberColumn.this.fDelegate.redraw();
            }
        });
        IPropertyChangeListener backgroundHandler = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LineNumberColumn.this.updateBackgroundColor(store, LineNumberColumn.this.fDelegate);
                LineNumberColumn.this.fDelegate.redraw();
            }
        };
        this.fDispatcher.addPropertyChangeListener(BG_COLOR_KEY, backgroundHandler);
        this.fDispatcher.addPropertyChangeListener(USE_DEFAULT_BG_KEY, backgroundHandler);
        this.fDispatcher.addPropertyChangeListener(LINE_NUMBER_KEY, new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LineNumberColumn.this.updateLineNumbersVisibility(LineNumberColumn.this.fDelegate);
            }
        });
        this.fDispatcher.addPropertyChangeListener("quickdiff.characterMode", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LineNumberColumn.this.updateCharacterMode(store, LineNumberColumn.this.fDelegate);
            }
        });
        this.fDispatcher.addPropertyChangeListener("revisionRulerRenderingMode", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LineNumberColumn.this.updateRevisionRenderingMode(store, LineNumberColumn.this.fDelegate);
            }
        });
        this.fDispatcher.addPropertyChangeListener("revisionRulerShowAuthor", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LineNumberColumn.this.updateRevisionAuthorVisibility(store, LineNumberColumn.this.fDelegate);
            }
        });
        this.fDispatcher.addPropertyChangeListener("revisionRulerShowRevision", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LineNumberColumn.this.updateRevisionIdVisibility(store, LineNumberColumn.this.fDelegate);
            }
        });
        this.fDispatcher.addPropertyChangeListener("quickdiff.quickDiff", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LineNumberColumn.this.updateQuickDiffVisibility(LineNumberColumn.this.fDelegate);
            }
        });
        if (changedPref != null) {
            this.fDispatcher.addPropertyChangeListener(changedPref.getColorPreferenceKey(), new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    LineNumberColumn.this.updateChangedColor(changedPref, store, LineNumberColumn.this.fDelegate);
                    LineNumberColumn.this.fDelegate.redraw();
                }
            });
        }
        if (addedPref != null) {
            this.fDispatcher.addPropertyChangeListener(addedPref.getColorPreferenceKey(), new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    LineNumberColumn.this.updateAddedColor(addedPref, store, LineNumberColumn.this.fDelegate);
                    LineNumberColumn.this.fDelegate.redraw();
                }
            });
        }
        if (deletedPref != null) {
            this.fDispatcher.addPropertyChangeListener(deletedPref.getColorPreferenceKey(), new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    LineNumberColumn.this.updateDeletedColor(deletedPref, store, LineNumberColumn.this.fDelegate);
                    LineNumberColumn.this.fDelegate.redraw();
                }
            });
        }
    }

    private Map getAnnotationPreferenceMap() {
        HashMap<Object, AnnotationPreference> annotationPrefs = new HashMap<Object, AnnotationPreference>();
        Iterator iter = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (iter.hasNext()) {
            AnnotationPreference pref = (AnnotationPreference)iter.next();
            Object type = pref.getAnnotationType();
            annotationPrefs.put(type, pref);
        }
        return annotationPrefs;
    }

    private void updateForegroundColor(IPreferenceStore store, IVerticalRulerColumn column) {
        RGB rgb = LineNumberColumn.getColorFromStore(store, FG_COLOR_KEY);
        if (rgb == null) {
            rgb = new RGB(0, 0, 0);
        }
        ISharedTextColors sharedColors = this.getSharedColors();
        if (column instanceof LineNumberRulerColumn) {
            ((LineNumberRulerColumn)column).setForeground(sharedColors.getColor(rgb));
        }
    }

    private void updateBackgroundColor(IPreferenceStore store, IVerticalRulerColumn column) {
        RGB rgb = store.getBoolean(USE_DEFAULT_BG_KEY) ? null : LineNumberColumn.getColorFromStore(store, BG_COLOR_KEY);
        ISharedTextColors sharedColors = this.getSharedColors();
        if (column instanceof LineNumberRulerColumn) {
            ((LineNumberRulerColumn)column).setBackground(sharedColors.getColor(rgb));
        }
    }

    private void updateChangedColor(AnnotationPreference pref, IPreferenceStore store, IVerticalRulerColumn column) {
        if (pref != null && column instanceof IChangeRulerColumn) {
            RGB rgb = LineNumberColumn.getColorFromAnnotationPreference(store, pref);
            ((IChangeRulerColumn)column).setChangedColor(this.getSharedColors().getColor(rgb));
        }
    }

    private void updateAddedColor(AnnotationPreference pref, IPreferenceStore store, IVerticalRulerColumn column) {
        if (pref != null && column instanceof IChangeRulerColumn) {
            RGB rgb = LineNumberColumn.getColorFromAnnotationPreference(store, pref);
            ((IChangeRulerColumn)column).setAddedColor(this.getSharedColors().getColor(rgb));
        }
    }

    private void updateDeletedColor(AnnotationPreference pref, IPreferenceStore store, IVerticalRulerColumn column) {
        if (pref != null && column instanceof IChangeRulerColumn) {
            RGB rgb = LineNumberColumn.getColorFromAnnotationPreference(store, pref);
            ((IChangeRulerColumn)column).setDeletedColor(this.getSharedColors().getColor(rgb));
        }
    }

    private void updateCharacterMode(IPreferenceStore store, IVerticalRulerColumn column) {
        if (column instanceof LineNumberChangeRulerColumn) {
            LineNumberChangeRulerColumn lncrc = (LineNumberChangeRulerColumn)column;
            lncrc.setDisplayMode(store.getBoolean("quickdiff.characterMode"));
        }
    }

    private void updateLineNumbersVisibility(IVerticalRulerColumn column) {
        if (column instanceof LineNumberChangeRulerColumn) {
            ((LineNumberChangeRulerColumn)column).showLineNumbers(this.getLineNumberPreference());
        }
    }

    private void updateRevisionRenderingMode(IPreferenceStore store, IVerticalRulerColumn column) {
        if (column instanceof IRevisionRulerColumnExtension) {
            String option = store.getString("revisionRulerRenderingMode");
            IRevisionRulerColumnExtension.RenderingMode[] modes = new IRevisionRulerColumnExtension.RenderingMode[]{IRevisionRulerColumnExtension.AUTHOR, IRevisionRulerColumnExtension.AGE, IRevisionRulerColumnExtension.AUTHOR_SHADED_BY_AGE};
            int i = 0;
            while (i < modes.length) {
                if (modes[i].name().equals(option)) {
                    ((IRevisionRulerColumnExtension)column).setRevisionRenderingMode(modes[i]);
                    return;
                }
                ++i;
            }
        }
    }

    private void updateRevisionAuthorVisibility(IPreferenceStore store, IVerticalRulerColumn column) {
        if (column instanceof IRevisionRulerColumnExtension) {
            boolean show = store.getBoolean("revisionRulerShowAuthor");
            ((IRevisionRulerColumnExtension)column).showRevisionAuthor(show);
        }
    }

    private void updateRevisionIdVisibility(IPreferenceStore store, IVerticalRulerColumn column) {
        if (column instanceof IRevisionRulerColumnExtension) {
            boolean show = store.getBoolean("revisionRulerShowRevision");
            ((IRevisionRulerColumnExtension)column).showRevisionId(show);
        }
    }

    private void updateQuickDiffVisibility(IVerticalRulerColumn column) {
        boolean show = this.getQuickDiffPreference();
        if (show == this.isShowingChangeInformation()) {
            return;
        }
        if (show) {
            this.installChangeRulerModel(column);
        } else {
            this.uninstallChangeRulerModel(column);
        }
    }

    private boolean getLineNumberPreference() {
        if (this.fForwarder != null) {
            return this.fForwarder.isLineNumberRulerVisible();
        }
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean(LINE_NUMBER_KEY) : false;
    }

    private boolean getQuickDiffPreference() {
        boolean modifiable;
        boolean setting;
        if (this.fForwarder != null) {
            return this.fForwarder.isQuickDiffEnabled();
        }
        IPreferenceStore store = this.getPreferenceStore();
        boolean bl = setting = store != null ? store.getBoolean("quickdiff.quickDiff") : false;
        if (!setting) {
            return false;
        }
        ITextEditor editor = this.getEditor();
        if (editor instanceof ITextEditorExtension2) {
            ITextEditorExtension2 ext = (ITextEditorExtension2)editor;
            modifiable = ext.isEditorInputModifiable();
        } else if (editor instanceof ITextEditorExtension) {
            ITextEditorExtension ext = (ITextEditorExtension)editor;
            modifiable = ext.isEditorInputReadOnly();
        } else {
            modifiable = editor != null ? editor.isEditable() : true;
        }
        return modifiable;
    }

    private static RGB getColorFromAnnotationPreference(IPreferenceStore store, AnnotationPreference pref) {
        String key = pref.getColorPreferenceKey();
        RGB rgb = null;
        if (store.contains(key)) {
            rgb = store.isDefault(key) ? pref.getColorPreferenceValue() : PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        }
        if (rgb == null) {
            rgb = pref.getColorPreferenceValue();
        }
        return rgb;
    }

    private static RGB getColorFromStore(IPreferenceStore store, String key) {
        RGB rgb = null;
        if (store.contains(key)) {
            rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        }
        return rgb;
    }

    private boolean ensureQuickDiffProvider(String diffProviderId) {
        MessageDialogWithToggle toggleDialog;
        if (!this.isShowingChangeInformation()) {
            this.installChangeRulerModel(this.fDelegate);
        }
        IAnnotationModel annotationModel = this.fViewer.getAnnotationModel();
        IAnnotationModel oldDiffer = this.getDiffer();
        if (oldDiffer == null && annotationModel != null) {
            return false;
        }
        if (annotationModel == null) {
            annotationModel = new AnnotationModel();
        }
        if (!(annotationModel instanceof IAnnotationModelExtension)) {
            return false;
        }
        QuickDiff util = new QuickDiff();
        Object oldDifferId = util.getConfiguredQuickDiffProvider(oldDiffer);
        if (oldDifferId.equals(diffProviderId)) {
            if (oldDiffer instanceof ILineDifferExtension) {
                ((ILineDifferExtension)oldDiffer).resume();
            }
            return true;
        }
        IAnnotationModel newDiffer = util.createQuickDiffAnnotationModel(this.getEditor(), diffProviderId);
        if (util.getConfiguredQuickDiffProvider(newDiffer).equals(oldDifferId)) {
            if (oldDiffer instanceof ILineDifferExtension) {
                ((ILineDifferExtension)oldDiffer).resume();
            }
            return true;
        }
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        if (oldDiffer != null && !store.getString(REVISION_ASK_BEFORE_QUICKDIFF_SWITCH_KEY).equals("always") && (toggleDialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.fViewer.getTextWidget().getShell(), (String)RulerMessages.AbstractDecoratedTextEditor_revision_quickdiff_switch_title, (String)RulerMessages.AbstractDecoratedTextEditor_revision_quickdiff_switch_message, (String)RulerMessages.AbstractDecoratedTextEditor_revision_quickdiff_switch_rememberquestion, (boolean)true, (IPreferenceStore)store, (String)REVISION_ASK_BEFORE_QUICKDIFF_SWITCH_KEY)).getReturnCode() != 0) {
            return false;
        }
        IAnnotationModelExtension modelExtension = (IAnnotationModelExtension)annotationModel;
        modelExtension.removeAnnotationModel((Object)"diff");
        modelExtension.addAnnotationModel((Object)"diff", newDiffer);
        if (this.fDelegate instanceof IChangeRulerColumn) {
            ((IChangeRulerColumn)this.fDelegate).setModel(annotationModel);
        }
        return true;
    }

    private void installChangeRulerModel(IVerticalRulerColumn column) {
        if (column instanceof IChangeRulerColumn) {
            ISourceViewer viewer;
            IAnnotationModel model = this.getAnnotationModelWithDiffer();
            ((IChangeRulerColumn)column).setModel(model);
            if (model != null && (viewer = this.fViewer) != null && viewer.getAnnotationModel() == null) {
                viewer.showAnnotations(true);
            }
        }
    }

    private void uninstallChangeRulerModel(IVerticalRulerColumn column) {
        ISourceViewer viewer;
        IAnnotationModel model;
        if (column instanceof IChangeRulerColumn) {
            ((IChangeRulerColumn)column).setModel(null);
        }
        if ((model = this.getDiffer()) instanceof ILineDifferExtension) {
            ((ILineDifferExtension)model).suspend();
        }
        if ((viewer = this.fViewer) != null && viewer.getAnnotationModel() == null) {
            viewer.showAnnotations(false);
        }
    }

    private IAnnotationModel getAnnotationModelWithDiffer() {
        IAnnotationModel differ;
        ISourceViewer viewer = this.fViewer;
        if (viewer == null) {
            return null;
        }
        IAnnotationModel m = viewer.getAnnotationModel();
        IAnnotationModelExtension model = null;
        if (m instanceof IAnnotationModelExtension) {
            model = (IAnnotationModelExtension)m;
        }
        if ((differ = this.getDiffer()) == null) {
            IPreferenceStore store = this.getPreferenceStore();
            if (store != null) {
                String defaultId = store.getString("quickdiff.defaultProvider");
                differ = new QuickDiff().createQuickDiffAnnotationModel(this.getEditor(), defaultId);
                if (differ != null) {
                    if (model == null) {
                        model = new AnnotationModel();
                    }
                    model.addAnnotationModel((Object)"diff", differ);
                }
            }
        } else if (differ instanceof ILineDifferExtension2) {
            if (((ILineDifferExtension2)differ).isSuspended()) {
                ((ILineDifferExtension)differ).resume();
            }
        } else if (differ instanceof ILineDifferExtension) {
            ((ILineDifferExtension)differ).resume();
        }
        return (IAnnotationModel)model;
    }

    private IAnnotationModel getDiffer() {
        ISourceViewer viewer = this.fViewer;
        if (viewer == null) {
            return null;
        }
        IAnnotationModel m = viewer.getAnnotationModel();
        if (m == null && this.fDelegate instanceof IChangeRulerColumn) {
            m = ((IChangeRulerColumn)this.fDelegate).getModel();
        }
        if (!(m instanceof IAnnotationModelExtension)) {
            return null;
        }
        IAnnotationModelExtension model = (IAnnotationModelExtension)m;
        return model.getAnnotationModel((Object)"diff");
    }

    public void setForwarder(ICompatibilityForwarder forwarder) {
        this.fForwarder = forwarder;
        this.fDelegate = forwarder.createLineNumberRulerColumn();
    }

    public void initializeLineNumberRulerColumn(LineNumberRulerColumn rulerColumn) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            this.updateForegroundColor(store, (IVerticalRulerColumn)rulerColumn);
            this.updateBackgroundColor(store, (IVerticalRulerColumn)rulerColumn);
            this.updateLineNumbersVisibility((IVerticalRulerColumn)rulerColumn);
            rulerColumn.redraw();
        }
    }

    public boolean isShowingLineNumbers() {
        return this.fDelegate instanceof LineNumberChangeRulerColumn && ((LineNumberChangeRulerColumn)this.fDelegate).isShowingLineNumbers();
    }

    public boolean isShowingChangeInformation() {
        return this.fDelegate instanceof LineNumberChangeRulerColumn && ((LineNumberChangeRulerColumn)this.fDelegate).isShowingChangeInformation();
    }

    public void showRevisionInformation(RevisionInformation info, String quickDiffProviderId) {
        if (!this.ensureQuickDiffProvider(quickDiffProviderId)) {
            return;
        }
        if (this.fDelegate instanceof IRevisionRulerColumn) {
            ((IRevisionRulerColumn)this.fDelegate).setRevisionInformation(info);
        }
    }

    public void hideRevisionInformation() {
        if (this.fDelegate instanceof IRevisionRulerColumn) {
            ((IRevisionRulerColumn)this.fDelegate).setRevisionInformation(null);
        }
    }

    public boolean isShowingRevisionInformation() {
        if (this.fDelegate instanceof LineNumberChangeRulerColumn) {
            return ((LineNumberChangeRulerColumn)this.fDelegate).isShowingRevisionInformation();
        }
        return false;
    }

    public ISelectionProvider getRevisionSelectionProvider() {
        if (this.fDelegate instanceof IRevisionRulerColumnExtension) {
            return ((IRevisionRulerColumnExtension)this.fDelegate).getRevisionSelectionProvider();
        }
        return null;
    }

    public static interface ICompatibilityForwarder {
        public IVerticalRulerColumn createLineNumberRulerColumn();

        public boolean isQuickDiffEnabled();

        public boolean isLineNumberRulerVisible();
    }
}

