/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.sdk.AutomaticUpdateScheduler;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKQueryProvider;
import org.eclipse.equinox.internal.p2.ui.sdk.updates.AutomaticUpdater;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.SimpleLicenseManager;
import org.eclipse.equinox.internal.provisional.p2.ui.UpdateManagerCompatibility;
import org.eclipse.equinox.internal.provisional.p2.ui.ValidationDialogServiceUI;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IPlanValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IQueryProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ProvSDKUIActivator
extends AbstractUIPlugin {
    public static final boolean ANY_PROFILE = false;
    private static final String DEFAULT_PROFILE_ID = "DefaultProfile";
    private static final String LICENSE_STORAGE = "licenses.xml";
    private static ProvSDKUIActivator plugin;
    private static BundleContext context;
    private AutomaticUpdateScheduler scheduler;
    private AutomaticUpdater updater;
    private IQueryProvider queryProvider;
    private SimpleLicenseManager licenseManager;
    private IPlanValidator planValidator;
    private ServiceRegistration certificateUIRegistration;
    public static final String PLUGIN_ID = "org.eclipse.equinox.p2.ui.sdk";
    static /* synthetic */ Class class$0;

    public static BundleContext getContext() {
        return context;
    }

    public static ProvSDKUIActivator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return ProvSDKUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        context = bundleContext;
        this.readLicenseRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.IServiceUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.certificateUIRegistration = context.registerService(clazz.getName(), (Object)new ValidationDialogServiceUI(), null);
    }

    private void readLicenseRegistry() {
        IPath location = this.getStateLocation().append(LICENSE_STORAGE);
        File f = location.toFile();
        BufferedInputStream stream = null;
        if (f.exists()) {
            try {
                stream = new BufferedInputStream(new FileInputStream(f));
                this.getLicenseManager().read((InputStream)stream);
                stream.close();
            }
            catch (IOException e) {
                ProvUI.reportStatus((IStatus)new Status(4, PLUGIN_ID, 0, ProvSDKMessages.ProvSDKUIActivator_LicenseManagerReadError, (Throwable)e), (int)1);
            }
        }
    }

    private void writeLicenseRegistry() {
        if (!this.getLicenseManager().hasAcceptedLicenses()) {
            return;
        }
        IPath location = this.getStateLocation().append(LICENSE_STORAGE);
        File f = location.toFile();
        BufferedOutputStream stream = null;
        try {
            stream = new BufferedOutputStream(new FileOutputStream(f, false));
            this.getLicenseManager().write((OutputStream)stream);
            stream.close();
        }
        catch (IOException e) {
            ProvUI.reportStatus((IStatus)new Status(4, PLUGIN_ID, 0, ProvSDKMessages.ProvSDKUIActivator_ErrorWritingLicenseRegistry, (Throwable)e), (int)1);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.writeLicenseRegistry();
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
        if (this.updater != null) {
            this.updater.shutdown();
            this.updater = null;
        }
        plugin = null;
        this.certificateUIRegistration.unregister();
        super.stop(bundleContext);
    }

    public AutomaticUpdateScheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = new AutomaticUpdateScheduler();
        }
        return this.scheduler;
    }

    public IProvisioningEventBus getProvisioningEventBus() {
        ServiceReference busReference = context.getServiceReference(IProvisioningEventBus.SERVICE_NAME);
        if (busReference == null) {
            return null;
        }
        return (IProvisioningEventBus)context.getService(busReference);
    }

    public AutomaticUpdater getAutomaticUpdater() {
        if (this.updater == null) {
            this.updater = new AutomaticUpdater();
        }
        return this.updater;
    }

    public static String getSelfProfileId() throws ProvisionException {
        IProfile profile = ProvisioningUtil.getProfile((String)"_SELF_");
        if (profile == null) {
            throw new ProvisionException(ProvSDKUIActivator.getNoSelfProfileStatus());
        }
        return profile.getProfileId();
    }

    void setScheduler(AutomaticUpdateScheduler scheduler) {
        this.scheduler = scheduler;
    }

    static IStatus getNoSelfProfileStatus() {
        return new Status(2, PLUGIN_ID, ProvSDKMessages.ProvSDKUIActivator_NoSelfProfile);
    }

    public IQueryProvider getQueryProvider() {
        if (this.queryProvider == null) {
            this.queryProvider = new ProvSDKQueryProvider();
        }
        return this.queryProvider;
    }

    public SimpleLicenseManager getLicenseManager() {
        if (this.licenseManager == null) {
            this.licenseManager = new SimpleLicenseManager();
        }
        return this.licenseManager;
    }

    public IPlanValidator getPlanValidator() {
        if (this.planValidator == null) {
            this.planValidator = new IPlanValidator(){

                public boolean continueWorkingWithPlan(ProvisioningPlan plan, Shell shell) {
                    if (plan == null) {
                        return false;
                    }
                    if (UpdateManagerCompatibility.requiresInstallHandlerSupport((ProvisioningPlan)plan)) {
                        MessageDialog dialog = new MessageDialog(shell, ProvSDKMessages.ProvSDKUIActivator_UnsupportedFeatureTitle, null, ProvSDKMessages.ProvSDKUIActivator_UnsupportedFeatureMessage, 4, new String[]{ProvSDKMessages.ProvSDKUIActivator_LaunchUpdateManager, IDialogConstants.CANCEL_LABEL}, 0);
                        if (dialog.open() == 0) {
                            BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(this){
                                final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    UpdateManagerCompatibility.openInstaller();
                                }
                            });
                        }
                        return false;
                    }
                    if (plan.getStatus().getCode() == 10000) {
                        ProvUI.reportStatus((IStatus)plan.getStatus(), (int)4);
                        return false;
                    }
                    if (plan.getStatus().getSeverity() != 4) {
                        return true;
                    }
                    String openPlan = ProvSDKUIActivator.this.getPreferenceStore().getString("allowNonOKPlan");
                    if ("always".equals(openPlan)) {
                        return true;
                    }
                    if ("never".equals(openPlan)) {
                        ProvUI.reportStatus((IStatus)plan.getStatus(), (int)3);
                        return false;
                    }
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)shell, (String)ProvSDKMessages.ProvSDKUIActivator_Question, (String)ProvSDKMessages.ProvSDKUIActivator_OpenWizardAnyway, null, (boolean)false, (IPreferenceStore)ProvSDKUIActivator.this.getPreferenceStore(), (String)"allowNonOKPlan");
                    if (dialog.getReturnCode() == 3) {
                        ProvUI.reportStatus((IStatus)plan.getStatus(), (int)3);
                    }
                    return dialog.getReturnCode() == 2;
                }
            };
        }
        return this.planValidator;
    }
}

