/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splusserver.api.java;

import com.insightful.splusserver.api.CommonApi;
import com.insightful.splusserver.api.bridge.FunctionServiceBridgeUrl;
import com.insightful.splusserver.api.bridge.IFunctionServiceBridge;
import com.insightful.splusserver.domain.SplusDataResult;
import com.insightful.splusserver.exception.IException;
import com.insightful.splusserver.exception.NotAuthenticatedException;
import com.insightful.splusserver.exception.ServerNotRespondingException;
import com.insightful.splusserver.exception.api.ApiException;
import com.insightful.splusserver.exception.api.BridgeException;
import com.insightful.splusserver.util.XmlUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionService
extends CommonApi
implements Serializable {
    private static final long serialVersionUID = 5102L;
    private IFunctionServiceBridge mFunctionServiceBridge = null;

    public FunctionService(String serviceUrl) throws ApiException, ServerNotRespondingException {
        try {
            this.mFunctionServiceBridge = new FunctionServiceBridgeUrl(serviceUrl);
            this.setServerBridge(this.mFunctionServiceBridge);
        }
        catch (BridgeException e) {
            throw new ApiException("Creation of ServerBridge failed", (Throwable)e);
        }
    }

    public FunctionService(String userName, String password, String serviceUrl) throws ApiException, NotAuthenticatedException, ServerNotRespondingException {
        try {
            this.mFunctionServiceBridge = new FunctionServiceBridgeUrl(userName, password, serviceUrl);
            this.setServerBridge(this.mFunctionServiceBridge);
        }
        catch (BridgeException e) {
            throw new ApiException("Creation of ServerBridge failed", (Throwable)e);
        }
    }

    IFunctionServiceBridge getFunctionServiceBridge() {
        return this.mFunctionServiceBridge;
    }

    void setFunctionServiceBridge(IFunctionServiceBridge serviceBridge) {
        this.mFunctionServiceBridge = serviceBridge;
        this.setServerBridge(serviceBridge);
    }

    protected Log getLogger() {
        return LogFactory.getLog(FunctionService.class);
    }

    public SplusDataResult eval(String functionName, String packageName, Map<String, String[]> args, String dataSet, Boolean async) throws IException, ApiException {
        SplusDataResult splus = null;
        String xml = null;
        try {
            Object unmarshalledObj;
            if (!async.booleanValue()) {
                this.getFunctionServiceBridge().resetTimeouts();
            }
            splus = SplusDataResult.class.isInstance(unmarshalledObj = XmlUtil.unmarshal(SplusDataResult.class, (String)(xml = this.getFunctionServiceBridge().eval(functionName, packageName, args, dataSet, async)))) ? XmlUtil.unmarshalSplusDataResult((String)xml) : (SplusDataResult)XmlUtil.unmarshal(SplusDataResult.class, (String)xml);
            if (!async.booleanValue()) {
                this.getFunctionServiceBridge().setTimeouts();
            }
        }
        catch (BridgeException e) {
        }
        catch (MarshalException e) {
            if (xml != null) {
                this.checkException(xml);
            }
        }
        catch (MappingException e) {
        }
        catch (ValidationException e) {
            // empty catch block
        }
        return splus;
    }

    public SplusDataResult eval(String functionName, String packageName, Map<String, String[]> args, String dataSet, Date date) throws IException, ApiException {
        SplusDataResult splus = null;
        String xml = null;
        try {
            xml = this.getFunctionServiceBridge().eval(functionName, packageName, args, dataSet, date.getTime());
            Object unmarshalledObj = XmlUtil.unmarshal(SplusDataResult.class, (String)xml);
            splus = SplusDataResult.class.isInstance(unmarshalledObj) ? XmlUtil.unmarshalSplusDataResult((String)xml) : (SplusDataResult)XmlUtil.unmarshal(SplusDataResult.class, (String)xml);
        }
        catch (BridgeException e) {
        }
        catch (MarshalException e) {
            if (xml != null) {
                this.checkException(xml);
            }
        }
        catch (MappingException e) {
        }
        catch (ValidationException e) {
            // empty catch block
        }
        return splus;
    }

    public SplusDataResult getJob(String jobId) throws IException {
        SplusDataResult splus = null;
        String xml = null;
        try {
            xml = this.getFunctionServiceBridge().getJob(jobId);
            Object unmarshalledObj = XmlUtil.unmarshal(SplusDataResult.class, (String)xml);
            splus = SplusDataResult.class.isInstance(unmarshalledObj) ? XmlUtil.unmarshalSplusDataResult((String)xml) : (SplusDataResult)XmlUtil.unmarshal(SplusDataResult.class, (String)xml);
        }
        catch (BridgeException e) {
        }
        catch (MarshalException e) {
            if (xml != null) {
                this.checkException(xml);
            }
        }
        catch (MappingException e) {
        }
        catch (ValidationException e) {
            // empty catch block
        }
        return splus;
    }
}

