/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.debug.core.model;

import com.insightful.splus.SplusDebugHandlerInterface;
import com.insightful.splus.SplusDebugListener;
import com.insightful.splus.eclipse.SplusEclipseSession;
import com.insightful.splus.eclipse.debug.core.SplusDebugPlugin;
import java.rmi.RemoteException;
import java.util.HashMap;

public class SplusDebugManager
implements SplusDebugHandlerInterface {
    private static HashMap m_debugListeners = new HashMap();
    private SplusEclipseSession m_session;

    public SplusDebugManager(SplusEclipseSession splusEclipseSession) {
        this.m_session = splusEclipseSession;
    }

    public void start() {
        try {
            this.m_session.start();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void addSplusDebugListener(SplusDebugListener splusDebugListener) {
        try {
            if (!this.m_session.isRemote()) {
                this.m_session.addSplusDebugListener(splusDebugListener);
            } else if (m_debugListeners.get(splusDebugListener) == null) {
                m_debugListeners.put(splusDebugListener, splusDebugListener);
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void removeSplusDebugListener(SplusDebugListener splusDebugListener) {
        try {
            if (!this.m_session.isRemote()) {
                this.m_session.removeSplusDebugListener(splusDebugListener);
            } else {
                m_debugListeners.remove(splusDebugListener);
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void addBreakpoint(String string, String string2, long[] lArray) {
        try {
            this.m_session.addBreakpoint(string, string2, lArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void doCallStack(long l) {
        try {
            this.m_session.doCallStack(l);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void doEvaluate(long l, String string) {
        try {
            this.m_session.doEvaluate(l, string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void doFrameDown(long l) {
        try {
            this.m_session.doFrameDown(l);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void doFrameUp(long l) {
        try {
            this.m_session.doFrameUp(l);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void doInvisibleEvaluate(long l, String string) {
        try {
            this.m_session.doInvisibleEvaluate(l, string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void doObjects(long l) {
        try {
            this.m_session.doObjects(l);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public boolean doParse(String string) {
        try {
            return this.m_session.doParse(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return false;
        }
    }

    public void doPause(long l) {
        try {
            this.m_session.doPause(l);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void doResume(long l) {
        try {
            this.m_session.doResume(l);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void doSetCommandLine(boolean bl) {
        try {
            this.m_session.doSetCommandLine(bl);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public long doStart(String string) {
        try {
            return this.m_session.doStart(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return -1L;
        }
    }

    public void doStep(long l) {
        try {
            this.m_session.doStep(l);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void doStepIn(long l) {
        try {
            this.m_session.doStepIn(l);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void doStepOut(long l) {
        try {
            this.m_session.doStepOut(l);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void doStop(long l) {
        try {
            this.m_session.doStop(l);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public long[] getBreakAddress() {
        try {
            return this.m_session.getBreakAddress();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return new long[0];
        }
    }

    public String getBreakInfo() {
        try {
            return this.m_session.getBreakInfo();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return "";
        }
    }

    public String getCall(int n) {
        try {
            return this.m_session.getCall(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return "";
        }
    }

    public String getCallName(int n) {
        try {
            return this.m_session.getCallName(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return "";
        }
    }

    public String getContainerCallName(int n) {
        try {
            return this.m_session.getContainerCallName(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return "";
        }
    }

    public String getEval(String string, int n) {
        try {
            return this.m_session.getEval(string, n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return "";
        }
    }

    public int getNumCalls() {
        try {
            return this.m_session.getNumCalls();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return 0;
        }
    }

    public int getNumEvals(String string) {
        try {
            return this.m_session.getNumEvals(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return 0;
        }
    }

    public int getNumObjects() {
        try {
            return this.m_session.getNumObjects();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return 0;
        }
    }

    public String[] getObjectData(int n) {
        try {
            return this.m_session.getObjectData(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return new String[0];
        }
    }

    public String getObjectName(int n) {
        try {
            return this.m_session.getObjectName(n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return "";
        }
    }

    public void removeBreakpoint(String string, String string2, long[] lArray) {
        try {
            this.m_session.removeBreakpoint(string, string2, lArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void setDebugMode(boolean bl) {
        try {
            this.m_session.setDebugMode(bl);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void setErrorBreakpoint(boolean bl) {
        try {
            this.m_session.setErrorBreakpoint(bl);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void setWarningBreakpoint(boolean bl) {
        try {
            this.m_session.setWarningBreakpoint(bl);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public static void breakpointHit(SplusDebugHandlerInterface splusDebugHandlerInterface) {
        for (SplusDebugListener splusDebugListener : m_debugListeners.keySet()) {
            splusDebugListener.breakpointHit((SplusDebugHandlerInterface)SplusDebugPlugin.getDefault().getDebugManager());
        }
    }

    public static void callStackRetrieved(SplusDebugHandlerInterface splusDebugHandlerInterface) {
        for (SplusDebugListener splusDebugListener : m_debugListeners.keySet()) {
            splusDebugListener.callStackRetrieved((SplusDebugHandlerInterface)SplusDebugPlugin.getDefault().getDebugManager());
        }
    }

    public static void evalInfoRetrieved(String string, SplusDebugHandlerInterface splusDebugHandlerInterface) {
        for (SplusDebugListener splusDebugListener : m_debugListeners.keySet()) {
            splusDebugListener.evalInfoRetrieved(string, (SplusDebugHandlerInterface)SplusDebugPlugin.getDefault().getDebugManager());
        }
    }

    public static void objectsRetrieved(SplusDebugHandlerInterface splusDebugHandlerInterface) {
        for (SplusDebugListener splusDebugListener : m_debugListeners.keySet()) {
            splusDebugListener.objectsRetrieved((SplusDebugHandlerInterface)SplusDebugPlugin.getDefault().getDebugManager());
        }
    }
}

