/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusContentProvider;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusPluginImages;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import com.insightful.splus.parser.PObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class SplusContentOutlinePage
extends ContentOutlinePage {
    public Action m_hideVarAction;
    public Action m_hideAllFunsAction;
    public Action m_hideAnonFunsAction;
    public Action m_hideWatchFunsAction;
    public Action m_hideScopeAction;
    public Action m_sortAction;
    public Action m_prefAction;
    public boolean m_hideVariables = false;
    public boolean m_hideFunctions = false;
    public boolean m_hideAnonFunctions = false;
    public boolean m_hideWatchFunctions = false;
    public boolean m_hideScope = true;
    public boolean m_sort = false;
    protected Object fInput;
    protected IDocumentProvider fDocumentProvider;
    protected ITextEditor fTextEditor;
    protected final Preferences.IPropertyChangeListener fPropertyChangeListener = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getProperty().equals("watchFxns") || propertyChangeEvent.getProperty().equals("showAnonFuns")) {
                SplusContentOutlinePage.this.update();
            }
        }
    };
    private static HashMap IMG_MAP = new HashMap();

    public ITextEditor getEditor() {
        return this.fTextEditor;
    }

    public IDocument getDocument() {
        return this.fDocumentProvider.getDocument(this.fInput);
    }

    public SplusContentOutlinePage(IDocumentProvider iDocumentProvider, ITextEditor iTextEditor) {
        this.fDocumentProvider = iDocumentProvider;
        this.fTextEditor = iTextEditor;
    }

    public void dispose() {
        SplusEditorPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.fPropertyChangeListener);
    }

    private static Image getImage(ImageDescriptor imageDescriptor) {
        Image image = (Image)IMG_MAP.get(imageDescriptor);
        if (image == null && (image = imageDescriptor.createImage()) != null) {
            IMG_MAP.put(imageDescriptor, image);
        }
        return image;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        SplusEditorPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.fPropertyChangeListener);
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.setContentProvider((IContentProvider)new SplusContentProvider(this));
        treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object object) {
                if (object instanceof Watch) {
                    return SplusContentOutlinePage.getImage(SplusPluginImages.DESC_WATCH_PUBLIC);
                }
                if (object instanceof Method) {
                    if (((Method)object).isAnon) {
                        return SplusContentOutlinePage.getImage(SplusPluginImages.DESC_MISC_PRIVATE);
                    }
                    return SplusContentOutlinePage.getImage(SplusPluginImages.DESC_MISC_PUBLIC);
                }
                if (object instanceof Member) {
                    return SplusContentOutlinePage.getImage(SplusPluginImages.DESC_FIELD_DEFAULT);
                }
                return null;
            }

            public String getText(Object object) {
                return object == null ? "" : object.toString();
            }
        });
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        treeViewer.setSorter((ViewerSorter)new OutlineSorter());
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        if (this.fInput != null) {
            treeViewer.setInput(this.fInput);
        }
    }

    private void makeActions() {
        this.m_hideVarAction = new ToggleAction("Hide Variables", SplusPluginImages.DESC_HIDE_FIELD_DEFAULT, "m_hideVariables");
        this.m_hideAllFunsAction = new ToggleAction("Hide Functions", SplusPluginImages.DESC_HIDE_MISC_PUBLIC, "m_hideFunctions");
        this.m_hideAnonFunsAction = new ToggleAction("Hide Anonymous Functions", SplusPluginImages.DESC_HIDE_MISC_PRIVATE, "m_hideAnonFunctions");
        this.m_hideWatchFunsAction = new ToggleAction("Hide Watch Functions", SplusPluginImages.DESC_HIDE_WATCH_PUBLIC, "m_hideWatchFunctions");
        this.m_hideScopeAction = new ToggleAction("Hide Scope", null, "m_hideScope");
        this.m_sortAction = new ToggleAction("Sort", SplusPluginImages.DESC_SORT, "m_sort");
        this.m_prefAction = new PreferenceAction();
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillToolBarMenu(iActionBars.getToolBarManager());
        this.fillContextMenu(iActionBars.getMenuManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        this.fillMenu(iMenuManager);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        this.fillMenu(iMenuManager);
    }

    private void fillToolBarMenu(IToolBarManager iToolBarManager) {
        this.addToContributionManager((IContributionManager)iToolBarManager, false);
    }

    private void fillMenu(IMenuManager iMenuManager) {
        this.addToContributionManager((IContributionManager)iMenuManager, true);
    }

    private void addToContributionManager(IContributionManager iContributionManager, boolean bl) {
        iContributionManager.add((IAction)this.m_hideAllFunsAction);
        iContributionManager.add((IAction)this.m_hideWatchFunsAction);
        iContributionManager.add((IAction)this.m_hideAnonFunsAction);
        iContributionManager.add((IAction)this.m_hideVarAction);
        iContributionManager.add((IContributionItem)new Separator());
        iContributionManager.add((IAction)this.m_sortAction);
        if (bl) {
            iContributionManager.add((IContributionItem)new Separator());
            iContributionManager.add((IAction)this.m_prefAction);
        }
        iContributionManager.add((IContributionItem)new Separator("additions"));
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                SplusContentOutlinePage.this.fillContextMenu(iMenuManager);
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        super.selectionChanged(selectionChangedEvent);
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection.isEmpty()) {
            this.fTextEditor.resetHighlightRange();
        } else {
            Member member = (Member)((IStructuredSelection)iSelection).getFirstElement();
            int n = member.position.getOffset();
            int n2 = member.length;
            try {
                this.fTextEditor.setHighlightRange(n, n2, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.fTextEditor.resetHighlightRange();
            }
        }
    }

    public void setInput(Object object) {
        this.fInput = object;
        this.update();
    }

    public void update() {
        Control control;
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && (control = treeViewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            treeViewer.setInput(this.fInput);
            control.setRedraw(true);
        }
    }

    public class PreferenceAction
    extends Action {
        public PreferenceAction() {
            super("Preferences...");
        }

        public void run() {
            String[] stringArray = new String[]{"com.insightful.splus.eclipse.editors.spluseditor.preferences.SplusOutlinePreferencePage"};
            Shell shell = SplusContentOutlinePage.this.getControl().getShell();
            PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)stringArray[0], (String[])stringArray, null).open();
        }
    }

    public class ToggleAction
    extends Action {
        private String m_boolVarName;

        public ToggleAction(String string, ImageDescriptor imageDescriptor, String string2) {
            super(string);
            this.setToolTipText(string);
            if (imageDescriptor != null) {
                this.setImageDescriptor(imageDescriptor);
            }
            this.m_boolVarName = string2;
        }

        public int getStyle() {
            return 2;
        }

        public void run() {
            try {
                SplusContentOutlinePage splusContentOutlinePage = SplusContentOutlinePage.this;
                Field field = ((Object)((Object)splusContentOutlinePage)).getClass().getDeclaredField(this.m_boolVarName);
                boolean bl = field.getBoolean((Object)splusContentOutlinePage);
                field.setBoolean((Object)splusContentOutlinePage, !bl);
                splusContentOutlinePage.getTreeViewer().refresh();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
        }
    }

    public class OutlineSorter
    extends ViewerSorter {
        public int compare(Viewer viewer, Object object, Object object2) {
            if (!SplusContentOutlinePage.this.m_sort) {
                return 0;
            }
            String string = object.toString();
            String string2 = object2.toString();
            try {
                if (string.startsWith("anonymousFunction") && string2.startsWith("anonymousFunction")) {
                    int n = "anonymousFunction".length();
                    int n2 = string.indexOf("(", n);
                    int n3 = string2.indexOf("(", n);
                    return Integer.parseInt(string.substring(n, n2)) - Integer.parseInt(string2.substring(n, n3));
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            return super.compare(viewer, (Object)string, (Object)string2);
        }
    }

    public static class Watch
    extends Member {
        public Watch(PObject pObject, PObject pObject2, Member member, IDocument iDocument) {
            super(pObject, pObject2, member, iDocument);
        }
    }

    public static class Scope
    extends Method {
        public Scope(PObject pObject, PObject pObject2, Member member, IDocument iDocument) {
            super(pObject, pObject2, member, iDocument);
        }

        public String toString() {
            return "";
        }

        public boolean hasChildren() {
            return this.hasChildren;
        }
    }

    public static class Method
    extends Member {
        public Vector args = new Vector();
        public boolean hasChildren;
        public boolean isAnon;

        public Method(PObject pObject, PObject pObject2, Member member, IDocument iDocument) {
            super(pObject, pObject2, member, iDocument);
            for (int i = 0; i < pObject.poGetLength() - 1; ++i) {
                this.args.add(pObject.poGetName(i));
            }
            boolean bl = this.isAnon = !SplusParseTreeBuilder.isAssignment(pObject2);
            if (this.isAnon) {
                this.name = member == null ? "anonymousFunction" + Integer.toString(Member.scopelessAnonymousCount++) : "anonymousFunction" + Integer.toString(member.anonymousCount++);
                this.name = "function";
            }
            this.length = this.name.length();
            this.setCodeLength(pObject, iDocument);
        }

        protected void setCodeLength(PObject pObject, IDocument iDocument) {
            try {
                int n = SplusParseTreeBuilder.getEndLine(pObject);
                int n2 = iDocument.getLineOffset(n) + SplusParseTreeBuilder.getEndColumn(pObject);
                this.codeLength = n2 - this.position.offset;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.name + "(");
            for (int i = 0; this.args != null && i < this.args.size(); ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.args.get(i).toString());
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public boolean hasChildren() {
            return this.hasChildren;
        }
    }

    public static class Member {
        public String name = "";
        public Position position;
        public Member parent;
        public int length;
        public int codeLength;
        protected int anonymousCount = 1;
        protected static int scopelessAnonymousCount = 1;

        public static void resetAnonymousCount() {
            scopelessAnonymousCount = 1;
        }

        public Member(PObject pObject, PObject pObject2, Member member, IDocument iDocument) {
            this.setName(pObject, pObject2);
            this.setPosition(pObject, iDocument);
            this.length = this.name.length();
            this.codeLength = this.name.length();
            this.parent = member;
        }

        protected void setName(PObject pObject, PObject pObject2) {
            if (pObject.poIsName()) {
                this.name = pObject.poGetName();
            } else if (pObject.poIsString()) {
                this.name = pObject.poGetStringElement(0);
            } else if (pObject.poGetMode().equals("call")) {
                this.name = pObject.poGetElement(0).toString();
            } else if (pObject.poGetMode().equals("function") && pObject2 != null && SplusParseTreeBuilder.isAssignment(pObject2)) {
                this.setName(pObject2.poGetElement(pObject2.poGetLength() - 2), null);
            }
        }

        protected void setPosition(PObject pObject, IDocument iDocument) {
            try {
                int n = SplusParseTreeBuilder.getStartLine(pObject);
                int n2 = iDocument.getLineOffset(n) + SplusParseTreeBuilder.getStartColumn(pObject);
                this.position = new Position(n2, this.name.length());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        public String toString() {
            return this.name;
        }

        public Member getParent() {
            return this.parent;
        }

        public boolean hasChildren() {
            return false;
        }
    }
}

