/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context.intellisense;

import java.util.LinkedList;

public class SplusIntelliSenseTrie {
    private SplusIntelliSenseTrieNode root = null;

    private SplusIntelliSenseTrieNode getRoot() {
        if (this.root == null) {
            this.root = new SplusIntelliSenseTrieNode(null);
        }
        return this.root;
    }

    public void reset() {
        this.root = null;
    }

    public void add(String string) {
        this.getRoot().add(string);
    }

    public LinkedList getValues(String string) {
        return this.getRoot().getSuffii(string);
    }

    private static class SplusIntelliSenseTrieNode {
        private static int NUM_ACCEPTABLE_CHILDREN = 255;
        private SplusIntelliSenseTrieNode[][] children = null;
        private SplusIntelliSenseTrieNode parent = null;
        private boolean validEnding = false;

        private SplusIntelliSenseTrieNode[][] getChildren(boolean bl) {
            if (bl && this.children == null) {
                this.children = new SplusIntelliSenseTrieNode[16][];
            }
            return this.children;
        }

        private SplusIntelliSenseTrieNode getChild(char c, boolean bl) {
            SplusIntelliSenseTrieNode[][] splusIntelliSenseTrieNodeArray = this.getChildren(bl);
            if (splusIntelliSenseTrieNodeArray == null) {
                return null;
            }
            char c2 = c;
            int n = c2 / 16;
            int n2 = c2 % 16;
            if (splusIntelliSenseTrieNodeArray[n] == null) {
                if (!bl) {
                    return null;
                }
                splusIntelliSenseTrieNodeArray[n] = new SplusIntelliSenseTrieNode[16];
            }
            if (splusIntelliSenseTrieNodeArray[n][n2] == null) {
                if (!bl) {
                    return null;
                }
                splusIntelliSenseTrieNodeArray[n][n2] = new SplusIntelliSenseTrieNode(this);
            }
            return splusIntelliSenseTrieNodeArray[n][n2];
        }

        public SplusIntelliSenseTrieNode(SplusIntelliSenseTrieNode splusIntelliSenseTrieNode) {
            this.parent = splusIntelliSenseTrieNode;
        }

        public synchronized void add(String string) {
            this.add(string.toCharArray(), 0);
        }

        private void add(char[] cArray, int n) {
            SplusIntelliSenseTrieNode splusIntelliSenseTrieNode = this;
            int n2 = n;
            while (n2 < cArray.length) {
                splusIntelliSenseTrieNode = splusIntelliSenseTrieNode.getChild(cArray[n2++], true);
            }
            splusIntelliSenseTrieNode.validEnding = true;
        }

        private synchronized LinkedList getSuffii(String string) {
            LinkedList linkedList = new LinkedList();
            SplusIntelliSenseTrieNode splusIntelliSenseTrieNode = this.getChild(string.charAt(0), false);
            for (int n = 1; splusIntelliSenseTrieNode != null && n < string.length(); splusIntelliSenseTrieNode = splusIntelliSenseTrieNode.getChild(string.charAt(n), false), ++n) {
            }
            if (splusIntelliSenseTrieNode != null) {
                splusIntelliSenseTrieNode.getSuffii(new StringBuffer(string), linkedList);
            }
            return linkedList;
        }

        private void getSuffii(StringBuffer stringBuffer, LinkedList linkedList) {
            if (this.validEnding) {
                linkedList.add(stringBuffer.toString());
                if (this.children == null) {
                    return;
                }
            }
            for (int i = 0; i < 16; ++i) {
                if (this.children[i] == null) continue;
                for (int j = 0; j < 16; ++j) {
                    if (this.children[i][j] == null) continue;
                    char c = (char)(i * 16 + j);
                    stringBuffer.append(c);
                    this.children[i][j].getSuffii(stringBuffer, linkedList);
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
            }
        }
    }
}

