/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.util;

import com.insightful.splus.eclipse.editors.spluseditor.SplusContentOutlinePage;
import com.insightful.splus.eclipse.editors.spluseditor.SplusEditor;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusContentProvider;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import com.insightful.splus.parser.PObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class DefaultSplusFoldingStructureProvider
implements IProjectionListener {
    private IDocument fCachedDocument;
    private ITextEditor fEditor;
    private ProjectionViewer fViewer;
    private boolean fAllowCollapsing = false;
    private boolean fCollapseJavadoc = false;
    private boolean fCollapseMethods = true;

    public void install(ITextEditor iTextEditor, ProjectionViewer projectionViewer) {
        if (iTextEditor instanceof SplusEditor) {
            this.fEditor = iTextEditor;
            this.fViewer = projectionViewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
        }
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer = null;
            this.fEditor = null;
        }
    }

    protected boolean isInstalled() {
        return this.fEditor != null;
    }

    public void projectionEnabled() {
        this.projectionDisabled();
        if (this.fEditor instanceof SplusEditor) {
            this.initialize();
        }
    }

    public void projectionDisabled() {
        this.fCachedDocument = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        try {
            IDocumentProvider iDocumentProvider = this.fEditor.getDocumentProvider();
            this.fCachedDocument = iDocumentProvider.getDocument((Object)this.fEditor.getEditorInput());
            this.fAllowCollapsing = true;
            ProjectionAnnotationModel projectionAnnotationModel = (ProjectionAnnotationModel)this.fEditor.getAdapter(ProjectionAnnotationModel.class);
            if (projectionAnnotationModel != null) {
                Map map = this.computeAdditions(this.fCachedDocument);
                projectionAnnotationModel.removeAllAnnotations();
                projectionAnnotationModel.replaceAnnotations(null, map);
            }
        }
        finally {
            this.fCachedDocument = null;
            this.fAllowCollapsing = false;
        }
    }

    public void update() {
        this.processDelta(null);
    }

    private Map computeAdditions(IDocument iDocument) {
        HashMap hashMap = new HashMap();
        String string = iDocument.get();
        PObject pObject = SplusParseTreeBuilder.getInstance().getParseTree(iDocument.get());
        SplusContentProvider splusContentProvider = new SplusContentProvider(pObject, iDocument);
        splusContentProvider.inputChanged(null, iDocument, iDocument);
        Object[] objectArray = splusContentProvider.getElements(null);
        this.computeAdditions(objectArray, hashMap, string);
        return hashMap;
    }

    private void computeAdditions(Object[] objectArray, Map map, String string) {
        for (int i = 0; i < objectArray.length; ++i) {
            SplusContentOutlinePage.Member member = (SplusContentOutlinePage.Member)objectArray[i];
            this.computeAdditions(member, map, string);
        }
    }

    private void computeAdditions(SplusContentOutlinePage.Member member, Map map, String string) {
        IRegion[] iRegionArray;
        boolean bl = false;
        boolean bl2 = false;
        if (member instanceof SplusContentOutlinePage.Method) {
            bl2 = this.fAllowCollapsing && this.fCollapseMethods;
            bl = true;
        }
        if (bl && (iRegionArray = this.computeProjectionRanges(member, string)) != null) {
            for (int i = 0; i < iRegionArray.length - 1; ++i) {
                Position position = this.createProjectionPosition(iRegionArray[i]);
                if (position == null) continue;
                map.put(new SplusProjectionAnnotation(member, this.fAllowCollapsing && this.fCollapseJavadoc, true), position);
            }
            Position position = this.createProjectionPosition(iRegionArray[iRegionArray.length - 1]);
            if (position != null) {
                map.put(new SplusProjectionAnnotation(member, bl2, false), position);
            }
        }
    }

    private IRegion[] computeProjectionRanges(SplusContentOutlinePage.Member member, String string) {
        if (member instanceof SplusContentOutlinePage.Method) {
            SplusContentOutlinePage.Method method = (SplusContentOutlinePage.Method)member;
            int n = method.position.offset;
            int n2 = method.codeLength;
            String string2 = string;
            if (string2 == null) {
                return null;
            }
            ArrayList<Region> arrayList = new ArrayList<Region>();
            arrayList.add(new Region(n, n2));
            if (arrayList.size() > 0) {
                IRegion[] iRegionArray = new IRegion[arrayList.size()];
                arrayList.toArray(iRegionArray);
                return iRegionArray;
            }
        }
        return null;
    }

    private Position createProjectionPosition(IRegion iRegion) {
        if (this.fCachedDocument == null) {
            return null;
        }
        try {
            int n = this.fCachedDocument.getLineOfOffset(iRegion.getOffset());
            int n2 = this.fCachedDocument.getLineOfOffset(iRegion.getOffset() + iRegion.getLength());
            if (n != n2) {
                int n3 = this.fCachedDocument.getLineOffset(n);
                int n4 = this.fCachedDocument.getLineOffset(n2 + 1);
                return new Position(n3, n4 - n3);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDelta(Object object) {
        if (!this.isInstalled()) {
            return;
        }
        ProjectionAnnotationModel projectionAnnotationModel = (ProjectionAnnotationModel)this.fEditor.getAdapter(ProjectionAnnotationModel.class);
        if (projectionAnnotationModel == null) {
            return;
        }
        try {
            Object object22;
            IDocumentProvider iDocumentProvider = this.fEditor.getDocumentProvider();
            this.fCachedDocument = iDocumentProvider.getDocument((Object)this.fEditor.getEditorInput());
            this.fAllowCollapsing = false;
            HashMap<Object, Position> hashMap = new HashMap<Object, Position>();
            ArrayList arrayList = new ArrayList();
            ArrayList<SplusProjectionAnnotation> arrayList2 = new ArrayList<SplusProjectionAnnotation>();
            Map map = this.computeAdditions(this.fCachedDocument);
            Map map2 = this.createAnnotationMap((IAnnotationModel)projectionAnnotationModel);
            for (Object object22 : map.keySet()) {
                SplusContentOutlinePage.Member member = (SplusContentOutlinePage.Member)((SplusProjectionAnnotation)((Object)object22)).getElement();
                Position position = (Position)map.get(object22);
                List list = (List)map2.get(member);
                if (list == null) {
                    hashMap.put(object22, position);
                    continue;
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    SplusProjectionAnnotation splusProjectionAnnotation = (SplusProjectionAnnotation)((Object)iterator.next());
                    if (((SplusProjectionAnnotation)((Object)object22)).isComment() != splusProjectionAnnotation.isComment()) continue;
                    Position position2 = projectionAnnotationModel.getPosition((Annotation)splusProjectionAnnotation);
                    if (position2 != null && !position.equals((Object)position2)) {
                        position2.setOffset(position.getOffset());
                        position2.setLength(position.getLength());
                        arrayList2.add(splusProjectionAnnotation);
                    }
                    iterator.remove();
                    break;
                }
                if (!list.isEmpty()) continue;
                map2.remove(member);
            }
            for (Object object22 : map2.values()) {
                int n = object22.size();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(object22.get(i));
                }
            }
            this.match(projectionAnnotationModel, arrayList, hashMap, arrayList2);
            object22 = new Annotation[arrayList.size()];
            arrayList.toArray((T[])object22);
            Annotation[] annotationArray = new Annotation[arrayList2.size()];
            arrayList2.toArray(annotationArray);
            projectionAnnotationModel.modifyAnnotations((Annotation[])object22, hashMap, annotationArray);
        }
        finally {
            this.fCachedDocument = null;
            this.fAllowCollapsing = true;
        }
    }

    private void match(ProjectionAnnotationModel projectionAnnotationModel, List list, Map map, List list2) {
        if (list.isEmpty() || map.isEmpty() && list2.isEmpty()) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<SplusProjectionAnnotation> arrayList2 = new ArrayList<SplusProjectionAnnotation>();
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            SplusProjectionAnnotation splusProjectionAnnotation;
            Object object;
            SplusProjectionAnnotation splusProjectionAnnotation2 = (SplusProjectionAnnotation)((Object)iterator.next());
            Position position = projectionAnnotationModel.getPosition((Annotation)splusProjectionAnnotation2);
            if (position == null) continue;
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                object = (SplusProjectionAnnotation)((Object)iterator2.next());
                if (splusProjectionAnnotation2.isComment() != ((SplusProjectionAnnotation)((Object)object)).isComment() || (splusProjectionAnnotation = projectionAnnotationModel.getPosition((Annotation)object)) == null || position.getOffset() != splusProjectionAnnotation.getOffset()) continue;
                position.setLength(splusProjectionAnnotation.getLength());
                splusProjectionAnnotation2.setElement(((SplusProjectionAnnotation)((Object)object)).getElement());
                iterator.remove();
                arrayList2.add(splusProjectionAnnotation2);
                iterator2.remove();
                arrayList.add(object);
                continue block0;
            }
            object = map.keySet().iterator();
            while (object.hasNext()) {
                splusProjectionAnnotation = (SplusProjectionAnnotation)((Object)object.next());
                if (splusProjectionAnnotation2.isComment() != splusProjectionAnnotation.isComment()) continue;
                Position position2 = (Position)map.get((Object)splusProjectionAnnotation);
                if (position.getOffset() != position2.getOffset()) continue;
                position.setLength(position2.getLength());
                splusProjectionAnnotation2.setElement(splusProjectionAnnotation.getElement());
                iterator.remove();
                arrayList2.add(splusProjectionAnnotation2);
                object.remove();
                continue block0;
            }
        }
        list.addAll(arrayList);
        list2.addAll(arrayList2);
    }

    private Map createAnnotationMap(IAnnotationModel iAnnotationModel) {
        HashMap<Object, ArrayList<SplusProjectionAnnotation>> hashMap = new HashMap<Object, ArrayList<SplusProjectionAnnotation>>();
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SplusProjectionAnnotation)) continue;
            SplusProjectionAnnotation splusProjectionAnnotation = (SplusProjectionAnnotation)((Object)e);
            ArrayList<SplusProjectionAnnotation> arrayList = (ArrayList<SplusProjectionAnnotation>)hashMap.get(splusProjectionAnnotation.getElement());
            if (arrayList == null) {
                arrayList = new ArrayList<SplusProjectionAnnotation>(2);
                hashMap.put(splusProjectionAnnotation.getElement(), arrayList);
            }
            arrayList.add(splusProjectionAnnotation);
        }
        return hashMap;
    }

    private static class SplusProjectionAnnotation
    extends ProjectionAnnotation {
        private Object fSplusElement;
        private boolean fIsComment;

        public SplusProjectionAnnotation(Object object, boolean bl, boolean bl2) {
            super(bl);
            this.fSplusElement = object;
            this.fIsComment = bl2;
        }

        public Object getElement() {
            return this.fSplusElement;
        }

        public void setElement(Object object) {
            this.fSplusElement = object;
        }

        public boolean isComment() {
            return this.fIsComment;
        }

        public void setIsComment(boolean bl) {
            this.fIsComment = bl;
        }
    }
}

