/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.util;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.editors.spluseditor.SplusEditor;
import com.insightful.splus.eclipse.editors.spluseditor.actions.FoldingActionGroup;
import com.insightful.splus.eclipse.editors.spluseditor.actions.GotoMatchingBracketAction;
import com.insightful.splus.eclipse.editors.spluseditor.actions.PresentationAction;
import com.insightful.splus.eclipse.editors.spluseditor.actions.SplusRunAction;
import com.insightful.splus.eclipse.editors.spluseditor.actions.ToggleCommentAction;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusFindReferences;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusFindSource;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusEditorMessages;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusFormatter;
import com.insightful.splus.eclipse.views.util.ConsoleHistoryDocument;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.osgi.framework.Bundle;

public class SplusActionContributor
extends TextEditorActionContributor {
    protected RetargetTextEditorAction fGotoMatchingBracket = new RetargetTextEditorAction(SplusEditorMessages.getResourceBundle(), "GotoMatchingBracket.");
    protected TextEditorAction fTogglePresentation;
    private static ResourceBundle fResourceBundle;

    private static ResourceBundle getResourceBundle() {
        if (fResourceBundle == null) {
            fResourceBundle = Platform.getResourceBundle((Bundle)SplusEditorPlugin.getDefault().getBundle());
        }
        return fResourceBundle;
    }

    public SplusActionContributor() {
        this.fGotoMatchingBracket.setActionDefinitionId("com.insightful.splus.eclipse.editors.spluseditor.goto.matching.bracket");
        this.fTogglePresentation = new PresentationAction();
    }

    public void init(IActionBars iActionBars) {
        super.init(iActionBars);
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        if (iToolBarManager != null) {
            iToolBarManager.add((IContributionItem)new Separator());
        }
    }

    private void doSetActiveEditor(IEditorPart iEditorPart) {
        super.setActiveEditor(iEditorPart);
        SplusEditor splusEditor = null;
        if (iEditorPart instanceof SplusEditor) {
            splusEditor = (SplusEditor)iEditorPart;
        }
        this.fGotoMatchingBracket.setAction(this.getAction((ITextEditor)splusEditor, "GotoMatchingBracket"));
        IActionBars iActionBars = this.getActionBars();
        this.updateBarsActionHandler(iActionBars, "com.insightful.splus.eclipse.splus.toggle.comment", "ToggleComment", splusEditor);
        this.updateBarsActionHandler(iActionBars, "org.eclipse.ui.edit.text.shiftLeft", "ShiftLeft", splusEditor);
        this.updateBarsActionHandler(iActionBars, "org.eclipse.ui.edit.text.shiftRight", "ShiftRight", splusEditor);
        this.updateBarsActionHandler(iActionBars, "com.insightful.splus.eclipse.splus.format", "Format", splusEditor);
        this.updateBarsActionHandler(iActionBars, "com.insightful.splus.eclipse.splus.help", "SplusHelp", splusEditor);
        this.updateBarsActionHandler(iActionBars, "com.insightful.splus.eclipse.splus.help.topic", "SplusHelpTopic", splusEditor);
        this.updateBarsActionHandler(iActionBars, "com.insightful.splus.eclipse.editors.spluseditor.folding", "DefineFoldingRegion", splusEditor);
        this.updateBarsActionHandler(iActionBars, "com.insightful.splus.eclipse.splus.runFile", "SourceCurrentFile", splusEditor);
        this.updateBarsActionHandler(iActionBars, "com.insightful.splus.eclipse.splus.runSelection", "Run", splusEditor);
        this.updateBarsActionHandler(iActionBars, "com.insightful.splus.eclipse.splus.runNextSelection", "RunNext", splusEditor);
        this.updateBarsActionHandler(iActionBars, "com.insightful.splus.eclipse.editors.spluseditor.findSel", "FindSelection", splusEditor);
        this.updateBarsActionHandler(iActionBars, "com.insightful.splus.eclipse.editors.spluseditor.find.method", "EditCurrentFunction", splusEditor);
        this.updateBarsActionHandler(iActionBars, "com.insightful.splus.eclipse.editors.spluseditor.find.references", "FindCurrentFunctionRefs", splusEditor);
        this.updateBarsActionHandler(iActionBars, "com.insightful.splus.eclipse.editors.spluseditor.copy2Console", "CopyToConsole", splusEditor);
        this.updateBarsActionHandler(iActionBars, "com.insightful.splus.eclipse.editors.spluseditor.goto.matching.bracket", "GotoMatchingBracket", splusEditor);
        this.fTogglePresentation.setEditor((ITextEditor)splusEditor);
        this.fTogglePresentation.update();
    }

    public void updateBarsActionHandler(IActionBars iActionBars, String string, String string2, SplusEditor splusEditor) {
        iActionBars.setGlobalActionHandler(string, this.getAction((ITextEditor)splusEditor, string2));
    }

    public static IAction getGotoMatchingBracketAction(SplusEditor splusEditor) {
        Object object = splusEditor.getAction("GotoMatchingBracket");
        if (object == null) {
            object = new GotoMatchingBracketAction(splusEditor);
            object.setActionDefinitionId("com.insightful.splus.eclipse.editors.spluseditor.goto.matching.bracket");
            splusEditor.setAction("GotoMatchingBracket", (IAction)object);
        }
        return object;
    }

    public static IAction getFormatAction(SplusEditor splusEditor) {
        Object object = splusEditor.getAction("com.insightful.splus.eclipse.splus.format");
        if (object == null) {
            object = new SplusFormatter(splusEditor);
            object.setText(SplusActionContributor.getResourceBundle().getString("FormatAction.label"));
            splusEditor.setAction("Format.CTXT", (IAction)object);
            object.setActionDefinitionId("com.insightful.splus.eclipse.editors.spluseditor.format");
            splusEditor.setAction("Format", (IAction)object);
        }
        return object;
    }

    public static IAction getToggleCommentAction(SplusEditor splusEditor) {
        Object object = splusEditor.getAction("ToggleComment");
        if (object == null) {
            object = new ToggleCommentAction(SplusEditorMessages.getResourceBundle(), "ToggleComment.", (ITextEditor)splusEditor);
            splusEditor.markAsStateDependentAction("ToggleComment", true);
            splusEditor.setAction("ToggleComment.CTXT", (IAction)object);
            object.setActionDefinitionId("com.insightful.splus.eclipse.editors.spluseditor.toggle.comment");
            splusEditor.setAction("ToggleComment", (IAction)object);
            splusEditor.configureToggleCommentAction("ToggleComment");
        }
        return object;
    }

    public static IAction getShiftLeftAction(SplusEditor splusEditor) {
        IAction iAction = splusEditor.getAction("org.eclipse.ui.edit.text.shiftLeft");
        return iAction;
    }

    public static IAction getShiftRightAction(SplusEditor splusEditor) {
        IAction iAction = splusEditor.getAction("org.eclipse.ui.edit.text.shiftRight");
        return iAction;
    }

    public static IAction getFoldingAction(SplusEditor splusEditor) {
        Object object = splusEditor.getAction("DefineFoldingRegion");
        if (object == null) {
            object = new DefineFoldingRegionAction(SplusEditorMessages.getResourceBundle(), "DefineFoldingRegion.", (ITextEditor)splusEditor);
            splusEditor.setAction("DefineFoldingRegion", (IAction)object);
            splusEditor.setAction("DefineFoldingRegion.CTXT", (IAction)object);
            object.setActionDefinitionId("com.insightful.splus.eclipse.editors.spluseditor.folding");
            new FoldingActionGroup((ITextEditor)splusEditor, (ITextViewer)splusEditor.getViewer());
        }
        return object;
    }

    public static IAction getRunFileAction(final SplusEditor splusEditor) {
        Object object = splusEditor.getAction("SourceCurrentFile");
        if (object == null) {
            SplusRunAction splusRunAction = new SplusRunAction();
            object = new Action(){

                public void run() {
                    IDocument iDocument = splusEditor.getDocumentProvider().getDocument((Object)splusEditor.getEditorInput());
                    ConsoleHistoryDocument.runText(iDocument.get(), true);
                }
            };
            object.setText(SplusActionContributor.getResourceBundle().getString("RunFileAction.label"));
            splusRunAction.setActiveEditor((IAction)object, (IEditorPart)splusEditor);
            object.setActionDefinitionId("com.insightful.splus.eclipse.splus.runFile");
            splusEditor.setAction("SourceCurrentFile", (IAction)object);
            splusEditor.setAction("SourceCurrentFile.CTXT", (IAction)object);
        }
        return object;
    }

    public static IAction getRunAction(SplusEditor splusEditor) {
        Object object = splusEditor.getAction("Run");
        if (object == null) {
            final SplusRunAction splusRunAction = new SplusRunAction();
            object = new Action(){

                public void run() {
                    splusRunAction.run((IAction)this);
                }
            };
            object.setText(SplusActionContributor.getResourceBundle().getString("RunAction.label"));
            splusRunAction.setActiveEditor((IAction)object, (IEditorPart)splusEditor);
            object.setActionDefinitionId("com.insightful.splus.eclipse.debug.runSplusAction.command");
            splusEditor.setAction("Run", (IAction)object);
            splusEditor.setAction("Run.CTXT", (IAction)object);
        }
        return object;
    }

    public static IAction getRunNextAction(SplusEditor splusEditor) {
        Object object = splusEditor.getAction("RunNext");
        if (object == null) {
            final SplusRunAction splusRunAction = new SplusRunAction();
            object = new Action(){

                public void run() {
                    splusRunAction.run((IAction)this);
                }
            };
            object.setText(SplusActionContributor.getResourceBundle().getString("RunNextAction.label"));
            splusRunAction.setActiveEditor((IAction)object, (IEditorPart)splusEditor);
            object.setActionDefinitionId("com.insightful.splus.eclipse.splus.runNextSelection");
            splusEditor.setAction("RunNext", (IAction)object);
            splusEditor.setAction("RunNext.CTXT", (IAction)object);
        }
        return object;
    }

    public static IAction getSearchAction(SplusEditor splusEditor) {
        Object object = splusEditor.getAction("FindSelection");
        if (object == null) {
            object = new TextEditorAction(SplusEditorMessages.getResourceBundle(), "Find.", (ITextEditor)splusEditor){

                public void setEnabled(boolean bl) {
                    super.setEnabled(true);
                }

                public void run() {
                    SplusEditor splusEditor = (SplusEditor)this.getTextEditor();
                    if (splusEditor != null) {
                        splusEditor.doFindSelection();
                    }
                }
            };
            splusEditor.setAction("FindSelection", (IAction)object);
            splusEditor.setAction("FindSelection.CTXT", (IAction)object);
            object.setActionDefinitionId("com.insightful.splus.eclipse.editors.spluseditor.findSel");
        }
        return object;
    }

    public static IAction getFindDefinitionAction(final SplusEditor splusEditor) {
        Object object = splusEditor.getAction("EditCurrentFunction");
        if (object == null) {
            object = new Action(){

                public void run() {
                    String string = splusEditor.getSelectedText(false);
                    if (string.length() != 0) {
                        SplusFindSource.findMethod(string, true);
                    }
                }
            };
            object.setText(SplusActionContributor.getResourceBundle().getString("FindDefinitionAction.label"));
            object.setActionDefinitionId("com.insightful.splus.eclipse.editors.spluseditor.find.method");
            splusEditor.setAction("EditCurrentFunction", (IAction)object);
            splusEditor.setAction("EditCurrentFunction.CTXT", (IAction)object);
        }
        return object;
    }

    public static IAction getFindReferencesAction(final SplusEditor splusEditor) {
        Object object = splusEditor.getAction("FindCurrentFunctionRefs");
        if (object == null) {
            final IWorkbenchWindow iWorkbenchWindow = SplusEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            object = new Action(){

                public void run() {
                    String string = splusEditor.getSelectedText(false);
                    if (string.length() != 0) {
                        SplusFindReferences.run(string, iWorkbenchWindow);
                    }
                }
            };
            object.setText(SplusActionContributor.getResourceBundle().getString("FindReferencesAction.label"));
            object.setActionDefinitionId("com.insightful.splus.eclipse.editors.spluseditor.find.references");
            splusEditor.setAction("FindCurrentFunctionRefs", (IAction)object);
            splusEditor.setAction("FindCurrentFunctionRefs.CTXT", (IAction)object);
        }
        return object;
    }

    public static IAction getCopy2ConsoleAction(SplusEditor splusEditor) {
        Object object = splusEditor.getAction("CopyToConsole");
        if (object == null) {
            object = new TextEditorAction(SplusEditorMessages.getResourceBundle(), "CopyToConsole.", (ITextEditor)splusEditor){

                public void run() {
                    ITextEditor iTextEditor = this.getTextEditor();
                    TextSelection textSelection = (TextSelection)iTextEditor.getSelectionProvider().getSelection();
                    String string = textSelection.getText();
                    if (string.length() > 0) {
                        ConsoleHistoryDocument.copyToConsole(string);
                    }
                }
            };
            splusEditor.setAction("CopyToConsole", (IAction)object);
            splusEditor.setAction("CopyToConsole.CTXT", (IAction)object);
            object.setActionDefinitionId("com.insightful.splus.eclipse.editors.spluseditor.copy2Console");
        }
        return object;
    }

    public static IAction getSplusHelpAction(SplusEditor splusEditor) {
        IAction iAction = splusEditor.getAction("SplusHelp");
        if (iAction == null) {
            TextEditorAction textEditorAction = new TextEditorAction(SplusEditorMessages.getResourceBundle(), "SplusHelp.", (ITextEditor)splusEditor){

                public void setEnabled(boolean bl) {
                    super.setEnabled(true);
                }

                public void run() {
                    SplusEditor splusEditor = (SplusEditor)this.getTextEditor();
                    if (splusEditor != null) {
                        splusEditor.doHelp();
                    }
                }
            };
            textEditorAction.setEditor((ITextEditor)splusEditor);
            textEditorAction.setActionDefinitionId("com.insightful.splus.eclipse.splus.help");
            splusEditor.setAction("SplusHelp", (IAction)textEditorAction);
            splusEditor.setAction("SplusHelp.CTXT", (IAction)textEditorAction);
        }
        return iAction;
    }

    public static IAction getSplusHelpTopicAction(SplusEditor splusEditor) {
        IAction iAction = splusEditor.getAction("SplusHelpTopic");
        if (iAction == null) {
            TextEditorAction textEditorAction = new TextEditorAction(SplusEditorMessages.getResourceBundle(), "SplusHelpTopic.", (ITextEditor)splusEditor){

                public void setEnabled(boolean bl) {
                    super.setEnabled(true);
                }

                public void run() {
                    SplusEditor splusEditor = (SplusEditor)this.getTextEditor();
                    if (splusEditor != null) {
                        splusEditor.doHelpForSelection();
                    }
                }
            };
            textEditorAction.setEditor((ITextEditor)splusEditor);
            textEditorAction.setActionDefinitionId("com.insightful.splus.eclipse.splus.help.topic");
            splusEditor.setAction("SplusHelpTopic", (IAction)textEditorAction);
            splusEditor.setAction("SplusHelpTopic.CTXT", (IAction)textEditorAction);
            splusEditor.setActionActivationCode("SplusHelpTopic", '\u0000', 0x100000A, 0);
        }
        return iAction;
    }

    public void setActiveEditor(IEditorPart iEditorPart) {
        super.setActiveEditor(iEditorPart);
        this.doSetActiveEditor(iEditorPart);
    }

    public void dispose() {
        this.doSetActiveEditor(null);
        super.dispose();
    }

    private static class DefineFoldingRegionAction
    extends TextEditorAction {
        public DefineFoldingRegionAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor) {
            super(resourceBundle, string, iTextEditor);
        }

        private IAnnotationModel getAnnotationModel(ITextEditor iTextEditor) {
            return (IAnnotationModel)iTextEditor.getAdapter(ProjectionAnnotationModel.class);
        }

        public void run() {
            IAnnotationModel iAnnotationModel;
            ITextSelection iTextSelection;
            ITextEditor iTextEditor = this.getTextEditor();
            ISelection iSelection = iTextEditor.getSelectionProvider().getSelection();
            if (iSelection instanceof ITextSelection && !(iTextSelection = (ITextSelection)iSelection).isEmpty() && (iAnnotationModel = this.getAnnotationModel(iTextEditor)) != null) {
                int n = iTextSelection.getStartLine();
                int n2 = iTextSelection.getEndLine();
                try {
                    IDocument iDocument = iTextEditor.getDocumentProvider().getDocument((Object)iTextEditor.getEditorInput());
                    int n3 = iDocument.getLineOffset(n);
                    int n4 = iDocument.getLineOffset(n2 + 1);
                    Position position = new Position(n3, n4 - n3);
                    iAnnotationModel.addAnnotation((Annotation)new ProjectionAnnotation(), position);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }
}

