/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.parser;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.preferences.SplusEditorPreferencePage;
import com.insightful.splus.eclipse.views.util.ConsoleHistoryDocument;
import com.insightful.splus.parser.PObject;
import com.insightful.splus.parser.PObjectFactory;
import com.insightful.splus.parser.PObjectFactoryImpl;
import com.insightful.splus.parser.Parser;
import com.insightful.splus.parser.ParserImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;

public class SplusParseTreeBuilder {
    private static final String EQUAL_MODE = "=";
    private static final String LEFT_ARROW_MODE = "<-";
    private static final String LEFT_DBL_ARROW_MODE = "<<-";
    private static final String IF_MODE = "if";
    private static final String FOR_MODE = "for";
    private static final String WHILE_MODE = "while";
    private static final String REPEAT_MODE = "repeat";
    private static final String NEXT_MODE = "next";
    private static final String BREAK_MODE = "break";
    private static final String RETURN_MODE = "return";
    private static final String INTERNAL_MODE = "internal";
    private static final String DOT_CALL_MODE = ".Call";
    private static final String DOT_C_MODE = ".C";
    private static final String DOT_JAVA_MODE = ".JavaMethod";
    private static final String OPEN_PAREN_MODE = "(";
    private static final String CLOSE_PAREN_MODE = ")";
    private static final String OPEN_BRACE_MODE = "{";
    private static final String CLOSE_BRACE_MODE = "}";
    private static final String COMMENT_MODE = "comment expression";
    private static final String DOLLAR_CALL = "$";
    private static final String COLON_CALL = ":";
    private static final String AT_CALL = "@";
    private static final String BRACE_CALL = "[";
    private static final String RIGHT_BRACE_CALL = "]";
    private static final String DBL_BRACE_CALL = "[[";
    private static final String RIGHT_DBL_BRACE_CALL = "]]";
    private static final String LT_CALL = "<";
    private static final String GT_CALL = ">";
    private static final String LTE_CALL = "<=";
    private static final String GTE_CALL = ">=";
    private static final String EQUAL_CALL = "==";
    private static final String NOT_EQUAL_CALL = "!=";
    private static final String PLUS_CALL = "+";
    private static final String MINUS_CALL = "-";
    private static final String TIMES_CALL = "*";
    private static final String DIV_CALL = "/";
    private static SplusParseTreeBuilder g_instance;
    private static int g_maxTrees;
    private PObjectFactory m_evaluator = new PObjectFactoryImpl();
    private Parser m_parser = new ParserImpl(this.m_evaluator);
    private HashMap m_sCodeToTreeMap;
    private LinkedList m_lastSCodeParsed;
    private static String NEWLINE;
    private static String SEMICOLON;
    private static String DEFAULT_TAB;
    private static String TAB;
    private int m_column = 0;
    private int m_numTabs = 0;
    private int m_callDepth = 0;
    private int m_addedNewlines = 0;
    private boolean m_isLastComment;
    private StringBuffer m_prettyPrint;
    private int m_maxColumn = 60;
    private boolean m_useSpaces = false;
    private int m_numSpaces = 2;
    private boolean m_everyBraceOnNewline = true;
    private boolean m_allScopeEncapsulated = false;

    public static SplusParseTreeBuilder getInstance() {
        if (g_instance == null) {
            g_instance = new SplusParseTreeBuilder();
        }
        return g_instance;
    }

    protected SplusParseTreeBuilder() {
        this.m_parser.setCaptureMultipleErrors(true);
        this.m_parser.setAddLimits(true);
        this.m_sCodeToTreeMap = new HashMap();
        this.m_lastSCodeParsed = new LinkedList();
    }

    public PObject getParseTreeResult(String string) {
        PObject pObject = this.getParseTree(string);
        return pObject.poGetElement("result");
    }

    public PObject getParseTree(String string) {
        Object object = this.m_sCodeToTreeMap.get(string);
        if (object == null) {
            if (this.m_lastSCodeParsed.size() == g_maxTrees) {
                String string2 = (String)this.m_lastSCodeParsed.getLast();
                this.m_sCodeToTreeMap.remove(string2);
                this.m_lastSCodeParsed.removeLast();
            }
            object = this.m_parser.parse(string, true);
            this.m_sCodeToTreeMap.put(string, object);
            this.m_lastSCodeParsed.addFirst(string);
        }
        return (PObject)object;
    }

    public boolean isComplete(File file) {
        return this.isComplete(SplusParseTreeBuilder.toString(file));
    }

    public boolean isComplete(String string) {
        return this.isComplete(this.getParseTree(string));
    }

    public boolean isComplete(PObject pObject) {
        return !pObject.poGetElement("incomplete").poGetLogicalElement(0);
    }

    public boolean isCompleteString(File file) {
        return this.isCompleteString(SplusParseTreeBuilder.toString(file));
    }

    public boolean isCompleteString(String string) {
        return this.isCompleteString(this.getParseTree(string));
    }

    public boolean isCompleteString(PObject pObject) {
        return !pObject.poGetElement("unfinishedString").poGetLogicalElement(0);
    }

    public String[] getSyntaxErrors(File file) {
        return this.getSyntaxErrors(SplusParseTreeBuilder.toString(file));
    }

    public String[] getSyntaxErrors(String string) {
        if (string.length() == 0) {
            return null;
        }
        return this.getSyntaxErrors(this.getParseTree(string));
    }

    public String[] getSyntaxErrors(PObject pObject) {
        PObject pObject2 = pObject;
        PObject pObject3 = pObject2.poGetElement("allErrors");
        if (!pObject3.poIsNull() && pObject3.poGetLength() != 0) {
            int n = pObject3.poGetLength();
            String[] stringArray = new String[n];
            for (int i = 0; i < stringArray.length; ++i) {
                PObject pObject4 = pObject3.poGetElement(i).poGetElement("error");
                stringArray[i] = pObject4.poGetStringElement(0);
            }
            return stringArray;
        }
        return null;
    }

    public double[] getSyntaxErrorLines(PObject pObject) {
        PObject pObject2 = pObject;
        PObject pObject3 = pObject2.poGetElement("allErrors");
        if (!pObject3.poIsNull() && pObject3.poGetLength() != 0) {
            int n = pObject3.poGetLength();
            double[] dArray = new double[n];
            for (int i = 0; i < dArray.length; ++i) {
                PObject pObject4 = pObject3.poGetElement(i).poGetElement("errorLine");
                dArray[i] = pObject4.poGetDoubleElement(0);
            }
            return dArray;
        }
        return null;
    }

    public double getSyntaxErrorColumn(PObject pObject) {
        PObject pObject2 = pObject;
        PObject pObject3 = pObject2.poGetElement("errorColumn");
        if (!pObject3.poIsNull()) {
            return pObject3.poGetDoubleElement(0);
        }
        return 0.0;
    }

    public static String toString(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            boolean bl = false;
            while (true) {
                String string;
                if (bl) {
                    stringBuffer.append("\n");
                }
                if ((string = bufferedReader.readLine()) == null) break;
                stringBuffer.append(string);
                bl = true;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static int getStartLine(PObject pObject) {
        return SplusParseTreeBuilder.getIntAttribute(pObject, "start.line", -1);
    }

    public static int getStartColumn(PObject pObject) {
        return SplusParseTreeBuilder.getIntAttribute(pObject, "start.column", -1);
    }

    public static int getEndLine(PObject pObject) {
        return SplusParseTreeBuilder.getIntAttribute(pObject, "end.line", -1);
    }

    public static int getEndColumn(PObject pObject) {
        return SplusParseTreeBuilder.getIntAttribute(pObject, "end.column", -1);
    }

    private static int getIntAttribute(PObject pObject, String string, int n) {
        try {
            return (int)pObject.poGetAttribute(string).poGetDoubleElement(0);
        }
        catch (Exception exception) {
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPrettyPrint(String string, int n, boolean bl, int n2, boolean bl2, boolean bl3) {
        SplusParseTreeBuilder splusParseTreeBuilder;
        SplusParseTreeBuilder splusParseTreeBuilder2 = splusParseTreeBuilder = SplusParseTreeBuilder.getInstance();
        synchronized (splusParseTreeBuilder2) {
            PObject pObject = splusParseTreeBuilder.getParseTree(string);
            if (splusParseTreeBuilder.isComplete(pObject) && splusParseTreeBuilder.isCompleteString(pObject) && splusParseTreeBuilder.getSyntaxErrors(pObject) == null) {
                PObject pObject2 = pObject;
                pObject = pObject2.poGetElement("result");
                splusParseTreeBuilder.initPrettyPrint(n, bl, n2, bl2, bl3);
                splusParseTreeBuilder.toString(pObject, false, false);
                return splusParseTreeBuilder.getPrettyPrint().toString();
            }
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPrettyPrint(String string) {
        SplusParseTreeBuilder splusParseTreeBuilder;
        SplusParseTreeBuilder splusParseTreeBuilder2 = splusParseTreeBuilder = SplusParseTreeBuilder.getInstance();
        synchronized (splusParseTreeBuilder2) {
            PObject pObject = splusParseTreeBuilder.getParseTree("{\n" + string + "\n}\n");
            if (splusParseTreeBuilder.isComplete(pObject) && splusParseTreeBuilder.isCompleteString(pObject) && splusParseTreeBuilder.getSyntaxErrors(pObject) == null) {
                splusParseTreeBuilder.toString(pObject, true, false);
                return splusParseTreeBuilder.getPrettyPrint().toString();
            }
            return "";
        }
    }

    private void resetTabs() {
        this.m_numTabs = 0;
    }

    private void incrementTabs() {
        ++this.m_numTabs;
        this.m_addedNewlines = 0;
    }

    private void decrementTabs() {
        if (this.m_numTabs > 0) {
            --this.m_numTabs;
        }
        if (this.m_addedNewlines == 2) {
            int n = this.getPrettyPrint().length() - TAB.length();
            this.getPrettyPrint().setLength(n);
        }
    }

    private void initPrettyPrint() {
        this.initPrettyPrint(SplusEditorPreferencePage.getFormatMargin(), SplusEditorPreferencePage.getFormatUseSpaces(), SplusEditorPreferencePage.getFormatNumSpaces(), SplusEditorPreferencePage.getFormatNewlinePerCurlyBrace(), SplusEditorPreferencePage.getFormatScopeEncapsulated());
    }

    private void initPrettyPrint(int n, boolean bl, int n2, boolean bl2, boolean bl3) {
        this.m_prettyPrint = new StringBuffer();
        this.m_isLastComment = false;
        this.m_addedNewlines = 0;
        this.m_column = 0;
        this.m_maxColumn = n;
        this.m_useSpaces = bl;
        this.m_numSpaces = n2;
        this.m_everyBraceOnNewline = bl2;
        this.m_allScopeEncapsulated = bl3;
        TAB = this.getTabString();
        this.resetTabs();
    }

    private StringBuffer getPrettyPrint() {
        return this.m_prettyPrint;
    }

    private String getTabString() {
        if (this.m_useSpaces) {
            StringBuffer stringBuffer = new StringBuffer(this.m_numSpaces);
            for (int i = 0; i < this.m_numSpaces; ++i) {
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
        return DEFAULT_TAB;
    }

    private void addNewline(boolean bl) {
        boolean bl2 = false;
        if (bl) {
            this.getPrettyPrint().append(SEMICOLON);
            this.m_column += SEMICOLON.length();
        } else if (this.m_addedNewlines < 2) {
            StringBuffer stringBuffer = this.getPrettyPrint();
            int n = stringBuffer.length() - 1;
            stringBuffer.insert(++n, NEWLINE);
            n += NEWLINE.length();
            for (int i = 0; i < this.m_numTabs; ++i) {
                stringBuffer.insert(n + i, TAB);
            }
            ++this.m_addedNewlines;
            this.m_column = this.m_numTabs * TAB.length();
        }
    }

    private void addNewlineAtNaturalBreak(boolean bl) {
        boolean bl2 = false;
        if (bl) {
            this.getPrettyPrint().append(SEMICOLON);
            this.m_column += SEMICOLON.length();
        } else if (this.m_addedNewlines < 2) {
            StringBuffer stringBuffer = this.getPrettyPrint();
            int n = stringBuffer.length() - 1;
            int n2 = stringBuffer.lastIndexOf(",");
            int n3 = stringBuffer.lastIndexOf(NEWLINE);
            int n4 = this.m_callDepth > 0 && n2 > n3 ? n2 : n;
            int n5 = n - n4;
            stringBuffer.replace(++n4, n4 + 1, NEWLINE);
            n4 += NEWLINE.length();
            for (int i = 0; i < this.m_numTabs; ++i) {
                stringBuffer.insert(n4 + i, TAB);
            }
            ++this.m_addedNewlines;
            this.m_column = n5 + this.m_numTabs * TAB.length();
        }
    }

    private void addText(String string) {
        this.doAddText(string, true, false);
    }

    private void addTextOnSameLine(String string) {
        this.doAddText(string, false, false);
    }

    private void addStringOnSameLine(String string) {
        this.doAddText(string, true, true);
    }

    private void addNameWithPotentialSpecialChars(String string, boolean bl) {
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((i != 0 || Character.isLetter(c)) && (Character.isLetterOrDigit(c) || c == '.')) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            this.addStringOnSameLine("\"" + string + "\"");
        } else {
            this.addStringOnSameLine(string);
        }
    }

    private void addCommentOnSameLine(String string) {
        this.doAddText(string, false, false);
    }

    private void doAddText(String string, boolean bl, boolean bl2) {
        int n = string.length();
        if (!bl || this.m_column + n < this.m_maxColumn || this.m_maxColumn < n) {
            this.m_addedNewlines = 0;
        } else {
            this.incrementTabs();
            this.incrementTabs();
            this.addNewlineAtNaturalBreak(false);
            this.decrementTabs();
            this.decrementTabs();
        }
        if (bl2 && string.startsWith("\"") && string.endsWith("\"")) {
            String string2 = this.handleStringSpecialCharacters(string.substring(1, n - 1));
            this.getPrettyPrint().append("\"");
            this.getPrettyPrint().append(string2);
            this.getPrettyPrint().append("\"");
        } else {
            this.getPrettyPrint().append(string);
        }
        this.m_column += string.length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void toString(PObject pObject, boolean bl, boolean bl2) {
        String string;
        PObject pObject2 = pObject;
        if (bl) {
            PObject pObject3 = pObject;
            pObject2 = pObject3.poGetElement("result");
            this.initPrettyPrint();
        }
        boolean bl3 = false;
        for (int i = 0; i < pObject2.poGetLength(); ++i) {
            if (pObject2.poGetName(i).equals("")) continue;
            bl3 = true;
            break;
        }
        if ((string = pObject2.poGetMode()).equals("call with ...")) {
            pObject2 = pObject2.poGetElement(0);
            string = pObject2.poGetMode();
        }
        if (!string.equals(COMMENT_MODE)) {
            this.m_isLastComment = false;
        }
        if (bl && string.equals(OPEN_BRACE_MODE)) {
            this.m_isLastComment = true;
            PObject pObject4 = pObject2;
            this.recursivePObjectToString(pObject4, 0, pObject4.poGetLength(), NEWLINE, false, false);
            return;
        } else if (pObject2.poIsNull()) {
            this.addText("NULL");
            return;
        } else if (pObject2.poGetMode().equals("call")) {
            char c;
            PObject pObject5 = pObject2;
            int n = pObject5.poGetLength();
            PObject pObject6 = pObject5.poGetElement(0);
            String string2 = pObject6.poIsName() ? pObject6.poGetName() : null;
            char c2 = c = string2 != null ? (char)string2.charAt(0) : (char)'a';
            if (!Character.isLetter(c) && c != '.') {
                if (n == 2) {
                    this.addText(string2);
                    this.toString(pObject5.poGetElement(1), false, false);
                    return;
                } else {
                    this.toString(pObject5.poGetElement(1), false, false);
                    if (string2.equals(AT_CALL) || string2.equals(DOLLAR_CALL) || string2.equals(BRACE_CALL) || string2.equals(DBL_BRACE_CALL) || string2.equals(COLON_CALL)) {
                        this.addTextOnSameLine(string2);
                    } else {
                        this.addTextOnSameLine(" " + string2);
                        this.addText(" ");
                    }
                    this.recursivePObjectToString(pObject5, 2, n, ", ", false, false);
                    if (string2.equals(BRACE_CALL)) {
                        this.addTextOnSameLine(RIGHT_BRACE_CALL);
                        return;
                    } else {
                        if (!string2.equals(DBL_BRACE_CALL)) return;
                        this.addTextOnSameLine(RIGHT_DBL_BRACE_CALL);
                    }
                }
                return;
            } else {
                boolean bl4 = "switch".equals(string2);
                this.toString(pObject5.poGetElement(0), false, false);
                this.addTextOnSameLine(OPEN_PAREN_MODE);
                ++this.m_callDepth;
                this.recursivePObjectToString(pObject5, 1, n, ", ", bl4, true);
                --this.m_callDepth;
                this.addTextOnSameLine(CLOSE_PAREN_MODE);
            }
            return;
        } else if (pObject2.poIsName()) {
            this.addNameWithPotentialSpecialChars(pObject2.poGetName(), true);
            return;
        } else if (pObject2.poIsString()) {
            this.addStringOnSameLine(pObject2.toString());
            return;
        } else if (pObject2.poGetMode().equals("function")) {
            this.m_isLastComment = true;
            PObject pObject7 = pObject2;
            int n = pObject7.poGetLength();
            this.addText(string);
            this.addTextOnSameLine(OPEN_PAREN_MODE);
            this.recursivePObjectToString(pObject7, 0, n - 1, ", ", false, false);
            this.addTextOnSameLine(CLOSE_PAREN_MODE);
            PObject pObject8 = pObject7.poGetElement(n - 1);
            String string3 = pObject8.poGetMode();
            boolean bl5 = string3.equals(OPEN_BRACE_MODE);
            if (bl2) {
                if (!bl5) {
                    this.addTextOnSameLine(" ");
                    this.toString(pObject8, false, bl2);
                    return;
                } else {
                    this.incrementTabs();
                    this.addNewline(false);
                    this.toString(pObject8, false, false);
                    this.decrementTabs();
                }
                return;
            } else {
                this.handleStartOfScopeBlock(!bl5, bl2);
                this.toString(pObject8, false, false);
                this.handleEndOfScopeBlock(!bl5, bl2);
            }
            return;
        } else if (pObject2.poIsRecursive()) {
            PObject pObject9 = pObject2;
            int n = pObject9.poGetLength();
            if (string.equals(LEFT_ARROW_MODE) || string.equals(EQUAL_MODE) || string.equals(LEFT_DBL_ARROW_MODE)) {
                PObject pObject10 = pObject9.poGetElement(0);
                PObject pObject11 = pObject9.poGetElement(1);
                this.toString(pObject10, false, false);
                this.addTextOnSameLine(" " + string);
                this.addText(" ");
                this.toString(pObject11, false, false);
                return;
            } else if (string.equals(OPEN_BRACE_MODE)) {
                this.m_isLastComment = true;
                this.addText(OPEN_BRACE_MODE);
                if (n != 0) {
                    this.incrementTabs();
                    if (!bl2) {
                        this.addNewline(bl2);
                    }
                    this.recursivePObjectToString(pObject9, 0, n, NEWLINE, false, false);
                    this.decrementTabs();
                    this.addNewline(bl2);
                }
                this.addText(CLOSE_BRACE_MODE);
                if (bl2) return;
                this.addNewline(bl2);
                return;
            } else if (string.equals(OPEN_PAREN_MODE)) {
                this.addTextOnSameLine(OPEN_PAREN_MODE);
                this.recursivePObjectToString(pObject9, 0, n, ", ", false, false);
                this.addTextOnSameLine(CLOSE_PAREN_MODE);
                return;
            } else if (string.equals(FOR_MODE) && n == 3) {
                this.addText(FOR_MODE);
                this.addTextOnSameLine(" (");
                this.addText(pObject9.poGetName(0));
                this.addText(" in ");
                this.toString(pObject9.poGetElement(1), false, false);
                this.addTextOnSameLine(CLOSE_PAREN_MODE);
                this.m_isLastComment = true;
                PObject pObject12 = pObject9.poGetElement(2);
                String string4 = pObject12.poGetMode();
                boolean bl6 = string4.equals(OPEN_BRACE_MODE);
                this.handleStartOfScopeBlock(!bl6, bl2);
                this.toString(pObject12, false, bl2);
                this.handleEndOfScopeBlock(!bl6, bl2);
                return;
            } else if (string.equals(WHILE_MODE)) {
                this.addText(WHILE_MODE);
                this.addTextOnSameLine(" (");
                this.toString(pObject9.poGetElement(0), false, false);
                this.addTextOnSameLine(CLOSE_PAREN_MODE);
                this.m_isLastComment = true;
                PObject pObject13 = pObject9.poGetElement(1);
                String string5 = pObject13.poGetMode();
                boolean bl7 = string5.equals(OPEN_BRACE_MODE);
                this.handleStartOfScopeBlock(!bl7, bl2);
                this.toString(pObject13, false, bl2);
                this.handleEndOfScopeBlock(!bl7, bl2);
                return;
            } else if (string.equals(IF_MODE)) {
                int n2 = 0;
                this.addText(IF_MODE);
                this.addTextOnSameLine(" (");
                this.toString(pObject9.poGetElement(n2++), false, false);
                this.addTextOnSameLine(CLOSE_PAREN_MODE);
                this.m_isLastComment = true;
                PObject pObject14 = pObject9.poGetElement(n2++);
                String string6 = pObject14.poGetMode();
                boolean bl8 = string6.equals(OPEN_BRACE_MODE);
                this.handleStartOfScopeBlock(!bl8, bl2);
                this.toString(pObject14, false, false);
                this.handleEndOfScopeBlock(!bl8, bl2, n2 < n && !bl8);
                while (n2 < n) {
                    this.addText("else");
                    pObject14 = pObject9.poGetElement(n2++);
                    string6 = pObject14.poGetMode();
                    boolean bl9 = string6.equals(IF_MODE);
                    bl8 = string6.equals(OPEN_BRACE_MODE);
                    boolean bl10 = !bl9 && !bl8;
                    this.handleStartOfScopeBlock(bl10, bl2, bl9);
                    this.toString(pObject14, false, false);
                    this.handleEndOfScopeBlock(bl10, bl2, false);
                }
                if (bl2) return;
                this.handleEndOfScopeBlock(false, bl2, true);
                return;
            } else if (string.equals(COMMENT_MODE)) {
                if (!this.m_isLastComment) {
                    this.addNewline(bl2);
                }
                this.m_isLastComment = true;
                this.recursivePObjectToString(pObject9, 0, n, NEWLINE, false, false);
                return;
            } else if (string.equals(RETURN_MODE) || string.equals(NEXT_MODE) || string.equals(BREAK_MODE)) {
                this.addText(string);
                this.addTextOnSameLine(OPEN_PAREN_MODE);
                if (pObject9.poGetLength() != 0) {
                    this.toString(pObject9.poGetElement(0), false, false);
                }
                this.addTextOnSameLine(CLOSE_PAREN_MODE);
                return;
            } else if (string.equals(INTERNAL_MODE)) {
                this.addText(".Internal");
                this.addTextOnSameLine(OPEN_PAREN_MODE);
                this.recursivePObjectToString(pObject9, 0, n, ", ", true, false);
                this.addTextOnSameLine(CLOSE_PAREN_MODE);
                return;
            } else {
                if (!string.equals(DOT_CALL_MODE) && !string.equals(DOT_C_MODE) && !string.equals(DOT_JAVA_MODE)) throw new RuntimeException("Unknown Pretty Print Object: " + pObject2.toString());
                this.addText(string);
                this.addTextOnSameLine(OPEN_PAREN_MODE);
                int n3 = string.equals(DOT_CALL_MODE) || string.equals(DOT_C_MODE) ? 1 : 0;
                this.recursivePObjectToString(pObject9, 0, n3, ", ", true, true);
                if (n3 == 1 && n > 1) {
                    this.addText(", ");
                }
                this.recursivePObjectToString(pObject9, n3, n, ", ", false, true);
                this.addTextOnSameLine(CLOSE_PAREN_MODE);
            }
            return;
        } else if (pObject2.poIsDouble()) {
            PObject pObject15 = pObject2;
            long l = pObject15.poGetLength();
            if (l == 1L) {
                double d = pObject15.poGetDoubleElement(0);
                if (d == Math.floor(d)) {
                    this.addText(Integer.toString((int)d));
                    return;
                } else {
                    this.addText(Double.toString(d));
                }
                return;
            } else {
                this.addText(string);
                this.addTextOnSameLine(OPEN_PAREN_MODE);
                int n = 0;
                while ((long)n < l) {
                    if (n != 0) {
                        this.addTextOnSameLine(", ");
                    }
                    this.addText(Double.toString(pObject15.poGetDoubleElement(n)));
                    ++n;
                }
                this.addTextOnSameLine(CLOSE_PAREN_MODE);
            }
            return;
        } else if (pObject2.poIsLogical()) {
            PObject pObject16 = pObject2;
            long l = pObject16.poGetLength();
            if (l == 1L) {
                this.addText(pObject16.poGetLogicalElement(0) ? "T" : "F");
                return;
            } else {
                this.addText(string);
                this.addTextOnSameLine(OPEN_PAREN_MODE);
                int n = 0;
                while ((long)n < l) {
                    if (n != 0) {
                        this.addTextOnSameLine(", ");
                    }
                    this.addText(pObject16.poGetLogicalElement(n) ? "T" : "F");
                    ++n;
                }
                this.addTextOnSameLine(CLOSE_PAREN_MODE);
            }
            return;
        } else {
            if (pObject2.poIsMissing()) return;
            throw new RuntimeException("Unknown Pretty Print Object: " + pObject2.toString());
        }
    }

    private void handleStartOfScopeBlock(boolean bl, boolean bl2) {
        this.handleStartOfScopeBlock(bl, bl2, false);
    }

    private void handleStartOfScopeBlock(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            if (bl2) {
                this.addTextOnSameLine(" ");
            } else if (this.m_allScopeEncapsulated) {
                if (this.m_everyBraceOnNewline && !bl2) {
                    this.addNewline(false);
                } else {
                    this.addTextOnSameLine(" ");
                }
                this.addTextOnSameLine(OPEN_BRACE_MODE);
                this.incrementTabs();
                if (!bl2) {
                    this.addNewline(false);
                } else {
                    this.addTextOnSameLine(" ");
                }
            } else if (this.m_everyBraceOnNewline) {
                this.incrementTabs();
                this.addNewline(bl2);
            } else {
                this.addTextOnSameLine(" ");
            }
        } else if (this.m_everyBraceOnNewline && !bl3) {
            this.addNewline(bl2);
        } else {
            this.addTextOnSameLine(" ");
        }
    }

    private void handleEndOfScopeBlock(boolean bl, boolean bl2) {
        this.handleEndOfScopeBlock(bl, bl2, false);
    }

    private void handleEndOfScopeBlock(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            if (bl2) {
                this.addTextOnSameLine(" ");
            } else if (this.m_allScopeEncapsulated) {
                this.decrementTabs();
                this.addNewline(bl2);
                this.addTextOnSameLine(CLOSE_BRACE_MODE);
                this.addNewline(bl2);
            } else if (this.m_everyBraceOnNewline) {
                this.decrementTabs();
                this.addNewline(bl2);
            } else if (bl3) {
                this.addNewline(bl2);
            }
        } else if (bl3) {
            this.addNewline(bl2);
        }
    }

    private void recursivePObjectToString(PObject pObject, int n, int n2, String string, boolean bl, boolean bl2) {
        if (n == n2) {
            return;
        }
        String string2 = pObject.poGetElement(0).toString();
        String string3 = pObject.poGetMode();
        boolean bl3 = COMMENT_MODE.equals(string3);
        boolean bl4 = DOLLAR_CALL.equals(string2);
        for (int i = n; i < n2; ++i) {
            PObject pObject2;
            if (i != n) {
                if (string == NEWLINE) {
                    this.addNewline(bl2);
                } else {
                    this.addTextOnSameLine(string);
                }
            } else if (bl3) {
                pObject2 = pObject.poGetElement(i);
                this.commentToString(pObject2);
                continue;
            }
            pObject2 = pObject.poGetElement(i);
            boolean bl5 = pObject2.poIsMissing();
            String string4 = pObject.poGetName(i);
            boolean bl6 = false;
            for (int j = 0; j < string4.length(); ++j) {
                char c = string4.charAt(j);
                if ((j != 0 || Character.isLetter(c)) && (Character.isLetterOrDigit(c) || c == '.')) continue;
                bl6 = true;
                break;
            }
            if (string4 != null && string4.length() != 0) {
                if (bl) {
                    this.addText("\"" + string4 + "\"");
                } else {
                    this.addNameWithPotentialSpecialChars(string4, true);
                }
                if (!bl5) {
                    this.addTextOnSameLine(EQUAL_MODE);
                }
            }
            if (bl4 && pObject2.poIsString()) {
                String string5 = pObject2.poGetStringElement(0);
                this.addNameWithPotentialSpecialChars(string5, true);
                continue;
            }
            this.toString(pObject2, false, bl2);
        }
    }

    private void commentToString(PObject pObject) {
        int n = pObject.poGetLength();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                this.addNewline(false);
            }
            this.addCommentOnSameLine(pObject.poGetStringElement(i));
        }
    }

    private String handleStringSpecialCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block8;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block8;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static PObject getFunctionDefinition(PObject pObject, String string) {
        PObject pObject2;
        if (SplusParseTreeBuilder.isAssignment(pObject) && pObject.poGetElement(1).poGetMode().equals("function") && ((pObject2 = pObject.poGetElement(0)).poIsName() ? pObject2.poGetName().equals(string) : pObject2.poIsString() && pObject2.poGetStringElement(0).equals(string))) {
            return pObject.poGetElement(1);
        }
        for (int i = 0; pObject.poIsRecursive() && i < pObject.poGetLength(); ++i) {
            PObject pObject3 = SplusParseTreeBuilder.getFunctionDefinition(pObject.poGetElement(i), string);
            if (pObject3 == null) continue;
            return pObject3;
        }
        return null;
    }

    public static boolean hasFunctionDefinition(PObject pObject, String string) {
        return SplusParseTreeBuilder.getFunctionDefinition(pObject, string) != null;
    }

    public static void getFunctionsDefined(PObject pObject, HashMap hashMap) {
        if (SplusParseTreeBuilder.isAssignment(pObject) && pObject.poGetElement(1).poGetMode().equals("function")) {
            String string;
            PObject pObject2 = pObject.poGetElement(0);
            if (pObject2.poIsName()) {
                string = pObject2.poGetName();
                hashMap.put(string, string);
            } else if (pObject2.poIsString()) {
                string = pObject2.poGetStringElement(0);
                hashMap.put(string, string);
            }
        }
        for (int i = 0; pObject.poIsRecursive() && i < pObject.poGetLength(); ++i) {
            SplusParseTreeBuilder.getFunctionsDefined(pObject.poGetElement(i), hashMap);
        }
    }

    public static void findNamePObjects(PObject pObject, String string, Vector vector) {
        if (pObject.poIsName() && pObject.poGetName().equals(string)) {
            vector.add(pObject);
            return;
        }
        for (int i = 0; pObject.poIsRecursive() && i < pObject.poGetLength(); ++i) {
            SplusParseTreeBuilder.findNamePObjects(pObject.poGetElement(i), string, vector);
        }
    }

    private static boolean isPObjectPresent(PObject pObject, int n, int n2, boolean bl) {
        boolean bl2 = bl;
        int n3 = SplusParseTreeBuilder.getStartColumn(pObject);
        int n4 = SplusParseTreeBuilder.getStartLine(pObject);
        int n5 = SplusParseTreeBuilder.getEndColumn(pObject);
        int n6 = SplusParseTreeBuilder.getEndLine(pObject);
        boolean bl3 = false;
        if (n == n4) {
            bl3 = n == n6 ? (n2 < n3 ? bl2 : n2 <= n5) : n2 >= n3 || bl2;
        } else if (n == n6) {
            bl3 = n2 <= n5;
        } else if (n > n4 && n < n6) {
            bl3 = true;
        } else if (n < n4) {
            bl3 = bl2;
        }
        return bl3;
    }

    public static PObject findFirstPObject(PObject pObject, int n, int n2, boolean bl) {
        PObject pObject2 = pObject;
        PObject pObject3 = pObject2.poGetElement("result");
        if (!SplusParseTreeBuilder.isAssignment(pObject3) && pObject3.poIsRecursive()) {
            int n3 = -1;
            for (int i = 0; pObject3.poIsRecursive() && i < pObject3.poGetLength(); ++i) {
                PObject pObject4 = pObject3.poGetElement(i);
                if (!SplusParseTreeBuilder.isPObjectPresent(pObject4, n, n2, true)) continue;
                n3 = i;
                break;
            }
            if (bl) {
                ++n3;
            }
            if (n3 != -1 && pObject3.poGetLength() > n3) {
                return pObject3.poGetElement(n3);
            }
            return pObject3.poGetElement(0);
        }
        return pObject3;
    }

    public static PObject findNamePObject(PObject pObject, int n, int n2) {
        PObject pObject2 = null;
        boolean bl = SplusParseTreeBuilder.isPObjectPresent(pObject, n, n2, false);
        if (bl && pObject.poIsName()) {
            pObject2 = pObject;
        }
        for (int i = 0; pObject2 == null && pObject.poIsRecursive() && i < pObject.poGetLength(); ++i) {
            pObject2 = SplusParseTreeBuilder.findNamePObject(pObject.poGetElement(i), n, n2);
        }
        return pObject2;
    }

    public static boolean isIf(PObject pObject) {
        if (pObject == null) {
            return false;
        }
        String string = pObject.poGetMode();
        return string.equals(IF_MODE);
    }

    public static boolean isFor(PObject pObject) {
        if (pObject == null) {
            return false;
        }
        String string = pObject.poGetMode();
        return string.equals(FOR_MODE);
    }

    public static boolean isWhile(PObject pObject) {
        if (pObject == null) {
            return false;
        }
        String string = pObject.poGetMode();
        return string.equals(WHILE_MODE);
    }

    public static boolean isRepeat(PObject pObject) {
        if (pObject == null) {
            return false;
        }
        String string = pObject.poGetMode();
        return string.equals(REPEAT_MODE);
    }

    public static boolean isAssignment(PObject pObject) {
        if (pObject == null) {
            return false;
        }
        String string = pObject.poGetMode();
        return string.equals(LEFT_ARROW_MODE) || string.equals(EQUAL_MODE);
    }

    public static int getOffsetForLine(String string, int n, boolean bl) {
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < n && n4 < n2) {
            ++n5;
            if (string.charAt(n4++) != '\n') continue;
            if (!bl && SplusEditorPlugin.g_isWindowsOS) {
                ++n5;
            }
            ++n3;
        }
        return n5;
    }

    private static int addExpression(PObject pObject, String string, int n, Vector vector) {
        int n2 = SplusParseTreeBuilder.getStartColumn(pObject);
        int n3 = SplusParseTreeBuilder.getEndColumn(pObject);
        int n4 = SplusParseTreeBuilder.getStartLine(pObject);
        int n5 = SplusParseTreeBuilder.getEndLine(pObject);
        int n6 = SplusParseTreeBuilder.getOffsetForLine(string, n4, true);
        int n7 = SplusParseTreeBuilder.getOffsetForLine(string, n5, true);
        int n8 = n6 + n2;
        String string2 = string.substring(n, n8);
        int n9 = n7 + n3 + 1;
        String string3 = "";
        if (string2.trim().length() != 0) {
            PObject pObject2 = SplusParseTreeBuilder.getInstance().getParseTree(string2);
            if (pObject2.poGetElement("allErrors").poGetLength() == 0 || !pObject2.poGetElement("incomplete").poGetLogicalElement(0)) {
                vector.add(string2);
                string3 = string.substring(n8, n9).trim();
            } else {
                string3 = string2 + string.substring(n8, n9).trim();
            }
        } else {
            string3 = string.substring(n8, n9);
        }
        vector.add(string3);
        return n9;
    }

    public static String[] separateTopLevelExpressions(String string) {
        String string2;
        PObject pObject = SplusParseTreeBuilder.getInstance().getParseTree(string);
        PObject pObject2 = pObject.poGetElement("incomplete");
        PObject pObject3 = pObject.poGetElement("allErrors");
        PObject pObject4 = pObject.poGetElement("result");
        if (pObject2.poGetLogicalElement(0)) {
            return new String[]{string.trim()};
        }
        int n = pObject3.poGetLength();
        if (n != 0 && string.indexOf(10) == -1) {
            return new String[]{string.trim()};
        }
        boolean bl = SplusParseTreeBuilder.getStartColumn(pObject4) == -1 && SplusParseTreeBuilder.getEndColumn(pObject4) == -1;
        int n2 = bl ? pObject4.poGetLength() : 1;
        int n3 = 0;
        Vector<String> vector = new Vector<String>();
        if (n2 == 0 && n == 0) {
            return new String[0];
        }
        if (n2 == 1 && n == 0) {
            SplusParseTreeBuilder.addExpression(pObject4, string, n3, vector);
        } else {
            for (int i = 0; i < n2; ++i) {
                PObject pObject5 = i != 0 || pObject4.poIsRecursive() ? pObject4.poGetElement(i + 1 - 1) : pObject4;
                n3 = SplusParseTreeBuilder.addExpression(pObject5, string, n3, vector);
            }
        }
        if (n > 0 && (string2 = string.substring(n3).trim()).length() != 0) {
            vector.add(string2);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static void DO_TEST(String string) {
        SplusParseTreeBuilder splusParseTreeBuilder = new SplusParseTreeBuilder();
        String[] stringArray = null;
        String string2 = "";
        string2 = SplusParseTreeBuilder.doPrettyPrint(string);
        stringArray = splusParseTreeBuilder.getSyntaxErrors(splusParseTreeBuilder.getParseTree(string2));
        if (stringArray.length != 0) {
            throw new RuntimeException(stringArray[0]);
        }
    }

    private static void TEXT() {
        SplusParseTreeBuilder.DO_TEST("foo <- \" \"");
        SplusParseTreeBuilder.DO_TEST("foo <- function() {}");
        SplusParseTreeBuilder.DO_TEST("foo <- function() \n#comment\n {}");
        SplusParseTreeBuilder.DO_TEST("foo <- function() print(1)");
        SplusParseTreeBuilder.DO_TEST("foo = function() {}");
        SplusParseTreeBuilder.DO_TEST("a <- 1");
        SplusParseTreeBuilder.DO_TEST("c(a=1)");
        SplusParseTreeBuilder.DO_TEST("c(\"43\"=1)");
        SplusParseTreeBuilder.DO_TEST("c(\"(%)\"=1)");
        SplusParseTreeBuilder.DO_TEST("a <- \"asdf[]{}();;;\\\"\"");
        SplusParseTreeBuilder.DO_TEST("c(if(1==2) 3, if (1==1) 3))");
        SplusParseTreeBuilder.DO_TEST("c(if(1==2) 3 else 5)");
        SplusParseTreeBuilder.DO_TEST("if(1==2) 3 else 5");
        SplusParseTreeBuilder.DO_TEST("if(1==2) \n3\n else \n5");
        SplusParseTreeBuilder.DO_TEST("if(1==2) \n3\n else 5");
        SplusParseTreeBuilder.DO_TEST("if(1==2) 3\n else \n5");
        SplusParseTreeBuilder.DO_TEST("if(1==2) {3} else 5");
        SplusParseTreeBuilder.DO_TEST("split.function.args <- function(x=0, y\n=1) {\nx + y\n}");
        SplusParseTreeBuilder.DO_TEST("x$\"f()\" <- 12");
        SplusParseTreeBuilder.DO_TEST("\"[.foo\" <- function(x, ...) {}");
        SplusParseTreeBuilder.DO_TEST("cat(file = rtfFile , rtfInit(bLandscape = F , colortable = c(\"\\\\red0\\\\green0\\\\blue0\" , \"\\\\red255\\\\green0\\\\blue0\") , vert.marg = 1 , side.marg = 1.25) , append = F)");
        SplusParseTreeBuilder.DO_TEST("lapply(1:10, FUN=function(x){cat(x,\"\n\");})");
    }

    static {
        g_maxTrees = 5;
        NEWLINE = ConsoleHistoryDocument.g_lineDelimiter;
        SEMICOLON = "; ";
        TAB = DEFAULT_TAB = "\t";
    }
}

