/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.preferences.util;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class SplusSourceViewer
extends ProjectionViewer
implements IPropertyChangeListener {
    public static final int SHOW_OUTLINE = 51;
    public static final int OPEN_STRUCTURE = 52;
    public static final int SHOW_HIERARCHY = 53;
    private IInformationPresenter fOutlinePresenter;
    private IInformationPresenter fStructurePresenter;
    private IInformationPresenter fHierarchyPresenter;
    private Color fForegroundColor;
    private Color fBackgroundColor;
    private IPreferenceStore fPreferenceStore;
    private boolean fIsConfigured;

    public SplusSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, IOverviewRuler iOverviewRuler, boolean bl, int n, IPreferenceStore iPreferenceStore) {
        super(composite, iVerticalRuler, iOverviewRuler, bl, n);
        this.setPreferenceStore(iPreferenceStore);
    }

    public void doOperation(int n) {
        if (this.getTextWidget() == null) {
            return;
        }
        switch (n) {
            case 51: {
                this.fOutlinePresenter.showInformation();
                return;
            }
            case 52: {
                this.fStructurePresenter.showInformation();
                return;
            }
            case 53: {
                this.fHierarchyPresenter.showInformation();
                return;
            }
        }
        super.doOperation(n);
    }

    public boolean canDoOperation(int n) {
        if (n == 51) {
            return this.fOutlinePresenter != null;
        }
        if (n == 52) {
            return this.fStructurePresenter != null;
        }
        if (n == 53) {
            return this.fHierarchyPresenter != null;
        }
        return super.canDoOperation(n);
    }

    public void configure(SourceViewerConfiguration sourceViewerConfiguration) {
        super.configure(sourceViewerConfiguration);
        IHyperlinkDetector[] iHyperlinkDetectorArray = sourceViewerConfiguration.getHyperlinkDetectors((ISourceViewer)this);
        int n = sourceViewerConfiguration.getHyperlinkStateMask((ISourceViewer)this);
        this.setHyperlinkDetectors(iHyperlinkDetectorArray, n);
        this.fIsConfigured = true;
    }

    public void unconfigure() {
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.uninstall();
            this.fOutlinePresenter = null;
        }
        if (this.fStructurePresenter != null) {
            this.fStructurePresenter.uninstall();
            this.fStructurePresenter = null;
        }
        if (this.fHierarchyPresenter != null) {
            this.fHierarchyPresenter.uninstall();
            this.fHierarchyPresenter = null;
        }
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
            this.fForegroundColor = null;
        }
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        super.unconfigure();
        this.fIsConfigured = false;
    }

    public Point rememberSelection() {
        return super.rememberSelection();
    }

    public void restoreSelection() {
        super.restoreSelection();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void setPreferenceStore(IPreferenceStore iPreferenceStore) {
        if (this.fIsConfigured && this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.fPreferenceStore = iPreferenceStore;
        if (this.fIsConfigured && this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    protected void createControl(Composite composite, int n) {
        super.createControl(composite, n);
    }

    public void prependTextPresentationListener(ITextPresentationListener iTextPresentationListener) {
        Assert.isNotNull((Object)iTextPresentationListener);
        if (this.fTextPresentationListeners == null) {
            this.fTextPresentationListeners = new ArrayList();
        }
        this.fTextPresentationListeners.remove(iTextPresentationListener);
        this.fTextPresentationListeners.add(0, iTextPresentationListener);
    }

    void setReconciler(IReconciler iReconciler) {
        this.fReconciler = iReconciler;
    }

    Object getReconciler() {
        return this.fReconciler;
    }
}

