/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.preferences.util;

import com.insightful.splus.SplusBadDataException;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import com.insightful.splus.eclipse.preferences.SplusOutlinePreferencePage;
import com.insightful.splus.eclipse.preferences.util.MultiSelectListEditor;
import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SplusStringListEditor
extends MultiSelectListEditor {
    protected FieldEditorPreferencePage m_page;
    protected Composite m_parent;

    public SplusStringListEditor(String string, String string2, Composite composite, FieldEditorPreferencePage fieldEditorPreferencePage) {
        super(string, string2, composite, ALLOW_ADD | ALLOW_REMOVE, true);
        this.m_parent = composite;
        this.m_page = fieldEditorPreferencePage;
    }

    protected void doFillIntoGrid(Composite composite, int n) {
        super.doFillIntoGrid(composite, n);
        List list = this.getListControl(composite);
        list.setLayoutData((Object)new GridData(1808));
    }

    protected String getNewTitle() {
        return "Add New Function(s) to Watch";
    }

    protected String getNewMessage() {
        return "Function(s) to Watch";
    }

    protected String createList(String[] stringArray) {
        return SplusOutlinePreferencePage.convertToCommaSepList(stringArray);
    }

    protected String getNewInputObject() {
        try {
            NewWatchFunctionDialog newWatchFunctionDialog = new NewWatchFunctionDialog(this.m_page.getShell(), this.getNewTitle(), this.getNewMessage());
            newWatchFunctionDialog.open();
            if (newWatchFunctionDialog.getReturnCode() == 1) {
                return null;
            }
            String[] stringArray = newWatchFunctionDialog.getString();
            int[] nArray = new int[stringArray.length];
            if (stringArray.length != 0) {
                List list = this.getListControl(this.m_parent);
                int n = Math.max(0, list.getSelectionIndex() + 1);
                for (int i = 0; i < stringArray.length; ++i) {
                    list.add(stringArray[i], n + i);
                    nArray[i] = n + i;
                }
                list.setSelection(nArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected String[] parseString(String string) {
        return SplusOutlinePreferencePage.convertFromCommaSepList(string);
    }

    class NewWatchFunctionDialog
    extends Dialog {
        private String m_title;
        private String m_message;
        private String m_str;
        private boolean m_text;
        private boolean m_file;
        private boolean m_splus;

        public NewWatchFunctionDialog(Shell shell, String string, String string2) {
            super(shell);
            this.m_title = "";
            this.m_message = "";
            this.m_str = "";
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
            this.m_title = string;
            this.m_message = string2;
        }

        public String[] getString() {
            String[] stringArray;
            block7: {
                SplusDataResult splusDataResult;
                block8: {
                    block6: {
                        String string = null;
                        stringArray = null;
                        if (this.m_text) {
                            string = this.m_str;
                        } else if (this.m_file) {
                            string = SplusParseTreeBuilder.toString(new File(this.m_str));
                        }
                        if (string == null) break block6;
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                        stringArray = new String[stringTokenizer.countTokens()];
                        int n = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            String string2 = stringTokenizer.nextToken();
                            stringArray[n++] = string2;
                        }
                        break block7;
                    }
                    NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
                    if (noConnection.isEngineBusy() || !(noConnection instanceof DefaultConnection)) break block7;
                    DefaultConnection defaultConnection = (DefaultConnection)noConnection;
                    splusDataResult = defaultConnection.processDataQuery(this.m_str);
                    if (splusDataResult.getError() == null || splusDataResult.getError().length() == 0) break block8;
                    MessageBox messageBox = new MessageBox(this.getParentShell(), 0);
                    messageBox.setMessage(splusDataResult.getError());
                    messageBox.setText("Error in S-PLUS Command");
                    messageBox.open();
                    stringArray = new String[]{};
                    break block7;
                }
                if (splusDataResult.getData() == null) break block7;
                try {
                    stringArray = splusDataResult.getStringData();
                }
                catch (SplusBadDataException splusBadDataException) {
                    splusBadDataException.printStackTrace();
                }
            }
            return stringArray;
        }

        protected Control createDialogArea(Composite composite) {
            final Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new GridLayout(3, false));
            composite2.setLayoutData((Object)new GridData(768));
            Composite composite3 = new Composite(composite2, 0);
            composite3.setLayout((Layout)new GridLayout(3, false));
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            composite3.setLayoutData((Object)gridData);
            Button button = new Button(composite3, 16);
            Button button2 = new Button(composite3, 16);
            Button button3 = new Button(composite3, 16);
            button.setText("Comma Separated Text");
            button2.setText("Comma Separated File");
            button3.setText("S-PLUS Command");
            Label label = new Label(composite2, 0);
            label.setText(this.m_message);
            final Text text = new Text(composite2, 2048);
            text.setLayoutData((Object)new GridData(768));
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    NewWatchFunctionDialog.this.m_str = text.getText();
                }
            });
            text.setText("");
            final Button button4 = new Button(composite2, 0);
            button4.setText("Browse...");
            button4.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FileDialog fileDialog = new FileDialog(composite2.getShell());
                    String string = fileDialog.open();
                    if (string != null) {
                        text.setText(string);
                    }
                }
            });
            button.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    boolean bl = ((Button)event.widget).getSelection();
                    NewWatchFunctionDialog.this.m_text = bl;
                }
            });
            button2.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    boolean bl = ((Button)event.widget).getSelection();
                    button4.setEnabled(bl);
                    NewWatchFunctionDialog.this.m_file = bl;
                }
            });
            button3.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    boolean bl = ((Button)event.widget).getSelection();
                    NewWatchFunctionDialog.this.m_splus = bl;
                }
            });
            button.setSelection(true);
            button4.setEnabled(false);
            this.m_text = true;
            this.m_splus = false;
            this.m_file = false;
            return composite2;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this.m_title);
        }
    }
}

