/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.util.ArrayList;
import org.eclipse.compare.internal.patch.DiffProject;
import org.eclipse.compare.internal.patch.FileDiff;
import org.eclipse.compare.internal.patch.Hunk;
import org.eclipse.compare.internal.patch.HunkDiffNode;
import org.eclipse.compare.internal.patch.PatchDiffNode;
import org.eclipse.compare.internal.patch.PatchFileDiffNode;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.PatchProjectDiffNode;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

class RetargetPatchElementDialog
extends Dialog {
    private final PatchDiffNode fSelectedNode;
    private final WorkspacePatcher fPatcher;
    private TreeViewer fViewer;
    private IResource fSelectedResource;

    public RetargetPatchElementDialog(Shell shell, WorkspacePatcher patcher, PatchDiffNode node) {
        super(shell);
        Assert.isNotNull((Object)patcher);
        Assert.isNotNull((Object)node);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fPatcher = patcher;
        this.fSelectedNode = node;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        Button okButton = this.getButton(0);
        okButton.setEnabled(false);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parent);
        this.getShell().setText(PatchMessages.PreviewPatchPage_RetargetPatch);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 16448);
        label.setText(this.getTreeLabel());
        GridData data2 = new GridData(4, 1, true, false);
        label.setLayoutData((Object)data2);
        this.fViewer = new TreeViewer(composite, 2048);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.fViewer.getTree().setLayoutData((Object)gd);
        this.fViewer.setContentProvider((IContentProvider)new RetargetPatchContentProvider(this.fSelectedNode));
        this.fViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fViewer.setComparator((ViewerComparator)new ResourceComparator(1));
        this.fViewer.setInput((Object)this.getViewerInput());
        IResource resource = this.getInitialSelection();
        if (resource != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)resource));
            this.fViewer.expandToLevel((Object)resource, 0);
        }
        this.setupListeners();
        Dialog.applyDialogFont((Control)composite);
        return parent;
    }

    private IResource getViewerInput() {
        if (this.fPatcher.isWorkspacePatch()) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        return this.fPatcher.getTarget();
    }

    private IResource getInitialSelection() {
        if (this.fSelectedNode instanceof PatchFileDiffNode) {
            PatchFileDiffNode node = (PatchFileDiffNode)this.fSelectedNode;
            return this.fPatcher.getTargetFile(node.getDiffResult().getDiff());
        }
        if (this.fSelectedNode instanceof HunkDiffNode) {
            HunkDiffNode node = (HunkDiffNode)this.fSelectedNode;
            return this.fPatcher.getTargetFile(node.getHunkResult().getDiffResult().getDiff());
        }
        if (this.fSelectedNode instanceof PatchProjectDiffNode) {
            PatchProjectDiffNode node = (PatchProjectDiffNode)this.fSelectedNode;
            DiffProject diffProject = node.getDiffProject();
            return diffProject.getProject();
        }
        return null;
    }

    private String getTreeLabel() {
        if (this.fSelectedNode instanceof PatchProjectDiffNode) {
            PatchProjectDiffNode node = (PatchProjectDiffNode)this.fSelectedNode;
            DiffProject project = node.getDiffProject();
            return NLS.bind((String)PatchMessages.PreviewPatchPage_SelectProject, (Object)project.getName());
        }
        if (this.fSelectedNode instanceof PatchFileDiffNode) {
            PatchFileDiffNode node = (PatchFileDiffNode)this.fSelectedNode;
            FileDiff diff = node.getDiffResult().getDiff();
            return NLS.bind((String)PatchMessages.RetargetPatchElementDialog_0, (Object)this.fPatcher.getPath(diff));
        }
        if (this.fSelectedNode instanceof HunkDiffNode) {
            HunkDiffNode node = (HunkDiffNode)this.fSelectedNode;
            Hunk hunk = node.getHunkResult().getHunk();
            return NLS.bind((String)PatchMessages.RetargetPatchElementDialog_1, (Object)this.fPatcher.getPath(hunk.getParent()));
        }
        return "";
    }

    protected void okPressed() {
        if (this.fSelectedResource != null) {
            if (this.fSelectedNode instanceof PatchProjectDiffNode && this.fSelectedResource instanceof IProject) {
                PatchProjectDiffNode node = (PatchProjectDiffNode)this.fSelectedNode;
                DiffProject project = node.getDiffProject();
                this.fPatcher.retargetProject(project, (IProject)this.fSelectedResource);
            } else if (this.fSelectedNode instanceof PatchFileDiffNode && this.fSelectedResource instanceof IFile) {
                PatchFileDiffNode node = (PatchFileDiffNode)this.fSelectedNode;
                FileDiff diff = node.getDiffResult().getDiff();
                this.fPatcher.retargetDiff(diff, (IFile)this.fSelectedResource);
            } else if (this.fSelectedNode instanceof HunkDiffNode && this.fSelectedResource instanceof IFile) {
                HunkDiffNode node = (HunkDiffNode)this.fSelectedNode;
                this.fPatcher.retargetHunk(node.getHunkResult().getHunk(), (IFile)this.fSelectedResource);
            }
        }
        super.okPressed();
    }

    void setupListeners() {
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                Object obj = s.getFirstElement();
                if (obj instanceof IResource) {
                    RetargetPatchElementDialog.this.fSelectedResource = (IResource)obj;
                    if (RetargetPatchElementDialog.this.fSelectedNode instanceof PatchProjectDiffNode) {
                        if (RetargetPatchElementDialog.this.fSelectedResource instanceof IProject) {
                            Button okButton = RetargetPatchElementDialog.this.getButton(0);
                            okButton.setEnabled(true);
                        }
                    } else if ((RetargetPatchElementDialog.this.fSelectedNode instanceof PatchFileDiffNode || RetargetPatchElementDialog.this.fSelectedNode instanceof HunkDiffNode) && RetargetPatchElementDialog.this.fSelectedResource instanceof IFile) {
                        Button okButton = RetargetPatchElementDialog.this.getButton(0);
                        okButton.setEnabled(true);
                    }
                }
            }
        });
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection s = event.getSelection();
                if (s instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)s).getFirstElement();
                    if (RetargetPatchElementDialog.this.fViewer.getExpandedState(item)) {
                        RetargetPatchElementDialog.this.fViewer.collapseToLevel(item, 1);
                    } else {
                        RetargetPatchElementDialog.this.fViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.x = this.convertWidthInCharsToPixels(75);
        size.y += this.convertHeightInCharsToPixels(20);
        return size;
    }

    private static class RetargetPatchContentProvider
    extends BaseWorkbenchContentProvider {
        private final PatchDiffNode node;

        public RetargetPatchContentProvider(PatchDiffNode node) {
            this.node = node;
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IWorkspaceRoot) {
                IProject[] allProjects = ((IWorkspaceRoot)element).getProjects();
                ArrayList<IProject> accessibleProjects = new ArrayList<IProject>();
                int i = 0;
                while (i < allProjects.length) {
                    if (allProjects[i].isOpen()) {
                        accessibleProjects.add(allProjects[i]);
                    }
                    ++i;
                }
                return accessibleProjects.toArray();
            }
            if (element instanceof IProject && this.node instanceof PatchProjectDiffNode) {
                return new Object[0];
            }
            return super.getChildren(element);
        }
    }
}

