/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.unix;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.dispatch.DispatchTask;
import org.apache.tools.ant.dispatch.DispatchUtils;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class Symlink
extends DispatchTask {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private String resource;
    private String link;
    private Vector fileSets = new Vector();
    private String linkFileName;
    private boolean overwrite;
    private boolean failonerror;
    private boolean executing = false;

    public void init() throws BuildException {
        super.init();
        this.setDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute() throws BuildException {
        if (this.executing) {
            throw new BuildException("Infinite recursion detected in Symlink.execute()");
        }
        try {
            this.executing = true;
            DispatchUtils.execute((Object)((Object)this));
        }
        finally {
            this.executing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void single() throws BuildException {
        try {
            if (this.resource == null) {
                this.handleError("Must define the resource to symlink to!");
                return;
            }
            if (this.link == null) {
                this.handleError("Must define the link name for symlink!");
                return;
            }
            this.doLink(this.resource, this.link);
        }
        finally {
            this.setDefaults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws BuildException {
        try {
            if (this.link == null) {
                this.handleError("Must define the link name for symlink!");
                return;
            }
            this.log("Removing symlink: " + this.link);
            Symlink.deleteSymlink(this.link);
        }
        catch (FileNotFoundException fnfe) {
            this.handleError(fnfe.toString());
        }
        catch (IOException ioe) {
            this.handleError(ioe.toString());
        }
        finally {
            this.setDefaults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recreate() throws BuildException {
        try {
            if (this.fileSets.isEmpty()) {
                this.handleError("File set identifying link file(s) required for action recreate");
                return;
            }
            Properties links = this.loadLinks(this.fileSets);
            Iterator<Object> kitr = links.keySet().iterator();
            while (kitr.hasNext()) {
                String lnk = (String)kitr.next();
                String res = links.getProperty(lnk);
                try {
                    File test = new File(lnk);
                    if (!FILE_UTILS.isSymbolicLink(null, lnk)) {
                        this.doLink(res, lnk);
                        continue;
                    }
                    if (test.getCanonicalPath().equals(new File(res).getCanonicalPath())) continue;
                    Symlink.deleteSymlink(lnk);
                    this.doLink(res, lnk);
                }
                catch (IOException ioe) {
                    this.handleError("IO exception while creating link");
                }
            }
        }
        finally {
            this.setDefaults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record() throws BuildException {
        try {
            if (this.fileSets.isEmpty()) {
                this.handleError("Fileset identifying links to record required");
                return;
            }
            if (this.linkFileName == null) {
                this.handleError("Name of file to record links in required");
                return;
            }
            Hashtable<File, Vector<File>> byDir = new Hashtable<File, Vector<File>>();
            Iterator litr = this.findLinks(this.fileSets).iterator();
            while (litr.hasNext()) {
                File thisLink = (File)litr.next();
                File parent = thisLink.getParentFile();
                Vector<File> v = (Vector<File>)byDir.get(parent);
                if (v == null) {
                    v = new Vector<File>();
                    byDir.put(parent, v);
                }
                v.addElement(thisLink);
            }
            Iterator dirs = byDir.keySet().iterator();
            while (dirs.hasNext()) {
                File dir = (File)dirs.next();
                Vector linksInDir = (Vector)byDir.get(dir);
                Properties linksToStore = new Properties();
                Iterator dlnk = linksInDir.iterator();
                while (dlnk.hasNext()) {
                    File lnk = (File)dlnk.next();
                    try {
                        linksToStore.put(lnk.getName(), lnk.getCanonicalPath());
                    }
                    catch (IOException ioe) {
                        this.handleError("Couldn't get canonical name of parent link");
                    }
                }
                this.writePropertyFile(linksToStore, dir);
            }
        }
        finally {
            this.setDefaults();
        }
    }

    private void setDefaults() {
        this.resource = null;
        this.link = null;
        this.linkFileName = null;
        this.failonerror = true;
        this.overwrite = false;
        this.setAction("single");
        this.fileSets.clear();
    }

    public void setOverwrite(boolean owrite) {
        this.overwrite = owrite;
    }

    public void setFailOnError(boolean foe) {
        this.failonerror = foe;
    }

    public void setAction(String action) {
        super.setAction(action);
    }

    public void setLink(String lnk) {
        this.link = lnk;
    }

    public void setResource(String src) {
        this.resource = src;
    }

    public void setLinkfilename(String lf) {
        this.linkFileName = lf;
    }

    public void addFileset(FileSet set) {
        this.fileSets.addElement(set);
    }

    public static void deleteSymlink(String path) throws IOException, FileNotFoundException {
        Symlink.deleteSymlink(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSymlink(File linkfil) throws IOException, FileNotFoundException {
        if (!linkfil.exists()) {
            throw new FileNotFoundException("No such symlink: " + linkfil);
        }
        File canfil = linkfil.getCanonicalFile();
        File temp = FILE_UTILS.createTempFile("symlink", ".tmp", canfil.getParentFile());
        try {
            try {
                FILE_UTILS.rename(canfil, temp);
            }
            catch (IOException e) {
                throw new IOException("Couldn't rename resource when attempting to delete " + linkfil);
            }
            if (!linkfil.delete()) {
                throw new IOException("Couldn't delete symlink: " + linkfil + " (was it a real file? is this not a UNIX system?)");
            }
        }
        finally {
            try {
                FILE_UTILS.rename(temp, canfil);
            }
            catch (IOException e) {
                throw new IOException("Couldn't return resource " + temp + " to its original name: " + canfil.getAbsolutePath() + "\n THE RESOURCE'S NAME ON DISK HAS " + "BEEN CHANGED BY THIS ERROR!\n");
            }
        }
    }

    private void writePropertyFile(Properties properties, File dir) throws BuildException {
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(new File(dir, this.linkFileName)));
            properties.store(bos, "Symlinks from " + dir);
        }
        catch (IOException ioe) {
            try {
                throw new BuildException((Throwable)ioe, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(bos);
                throw throwable;
            }
        }
        FileUtils.close((OutputStream)bos);
    }

    private void handleError(String msg) {
        if (this.failonerror) {
            throw new BuildException(msg);
        }
        this.log(msg);
    }

    private void doLink(String res, String lnk) throws BuildException {
        File linkfil = new File(lnk);
        if (this.overwrite && linkfil.exists()) {
            try {
                Symlink.deleteSymlink(linkfil);
            }
            catch (FileNotFoundException fnfe) {
                this.handleError("Symlink disappeared before it was deleted: " + lnk);
            }
            catch (IOException ioe) {
                this.handleError("Unable to overwrite preexisting link: " + lnk);
            }
        }
        String[] cmd = new String[]{"ln", "-s", res, lnk};
        this.log(Commandline.toString((String[])cmd));
        Execute.runCommand((Task)this, (String[])cmd);
    }

    private HashSet findLinks(Vector v) {
        HashSet<File> result = new HashSet<File>();
        for (int i = 0; i < v.size(); ++i) {
            FileSet fs = (FileSet)v.get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[][] fnd = new String[][]{ds.getIncludedFiles(), ds.getIncludedDirectories()};
            File dir = fs.getDir(this.getProject());
            for (int j = 0; j < fnd.length; ++j) {
                for (int k = 0; k < fnd[j].length; ++k) {
                    try {
                        File f = new File(dir, fnd[j][k]);
                        File pf = f.getParentFile();
                        String name = f.getName();
                        if (!FILE_UTILS.isSymbolicLink(pf, name)) continue;
                        result.add(new File(pf.getCanonicalFile(), name));
                        continue;
                    }
                    catch (IOException e) {
                        this.handleError("IOException: " + fnd[j][k] + " omitted");
                    }
                }
            }
        }
        return result;
    }

    private Properties loadLinks(Vector v) {
        Properties finalList = new Properties();
        for (int i = 0; i < v.size(); ++i) {
            FileSet fs = (FileSet)v.elementAt(i);
            DirectoryScanner ds = new DirectoryScanner();
            fs.setupDirectoryScanner((FileScanner)ds, this.getProject());
            ds.setFollowSymlinks(false);
            ds.scan();
            String[] incs = ds.getIncludedFiles();
            File dir = fs.getDir(this.getProject());
            for (int j = 0; j < incs.length; ++j) {
                File inc = new File(dir, incs[j]);
                File pf = inc.getParentFile();
                Properties lnks = new Properties();
                try {
                    lnks.load(new BufferedInputStream(new FileInputStream(inc)));
                    pf = pf.getCanonicalFile();
                }
                catch (FileNotFoundException fnfe) {
                    this.handleError("Unable to find " + incs[j] + "; skipping it.");
                    continue;
                }
                catch (IOException ioe) {
                    this.handleError("Unable to open " + incs[j] + " or its parent dir; skipping it.");
                    continue;
                }
                lnks.list(new PrintStream((OutputStream)new LogOutputStream((Task)this, 2)));
                Iterator<Object> kitr = lnks.keySet().iterator();
                while (kitr.hasNext()) {
                    String key = (String)kitr.next();
                    finalList.put(new File(pf, key).getAbsolutePath(), lnks.getProperty(key));
                }
            }
        }
        return finalList;
    }
}

