/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl.util;

import com.sun.media.jai.codecimpl.util.ComponentSampleModelJAI;
import com.sun.media.jai.codecimpl.util.JaiI18N;
import com.sun.media.jai.codecimpl.util.RasterFactory;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class FloatDoubleColorModel
extends ComponentColorModel {
    ColorSpace colorSpace;
    int colorSpaceType;
    int numColorComponents;
    int numComponents;
    int transparency;
    boolean hasAlpha;
    boolean isAlphaPremultiplied;

    public FloatDoubleColorModel(ColorSpace colorSpace, boolean bl, boolean bl2, int n, int n2) {
        super(colorSpace, FloatDoubleColorModel.bitsHelper(n2, colorSpace, bl), bl, bl2, n, n2);
        if (n2 != 4 && n2 != 5) {
            throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel0"));
        }
        this.colorSpace = colorSpace;
        this.colorSpaceType = colorSpace.getType();
        this.numComponents = this.numColorComponents = colorSpace.getNumComponents();
        if (bl) {
            ++this.numComponents;
        }
        this.transparency = n;
        this.hasAlpha = bl;
        this.isAlphaPremultiplied = bl2;
    }

    private static int[] bitsHelper(int n, ColorSpace colorSpace, boolean bl) {
        int n2 = n == 4 ? 32 : 64;
        int n3 = colorSpace.getNumComponents();
        if (bl) {
            ++n3;
        }
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = n2;
            ++n4;
        }
        return nArray;
    }

    private int clamp(double d) {
        return d >= 0.0 ? (d > 255.0 ? 255 : (int)d) : 0;
    }

    private int clamp(float f) {
        return f >= 0.0f ? (f > 255.0f ? 255 : (int)f) : 0;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public ColorModel coerceData(WritableRaster var1_1, boolean var2_2) {
        if (this.hasAlpha == false) return this;
        if (this.isAlphaPremultiplied == var2_2) {
            return this;
        }
        var3_3 = var1_1.getWidth();
        var4_4 = var1_1.getHeight();
        var5_5 = var1_1.getNumBands() - 1;
        var6_6 = var1_1.getMinX();
        var7_7 = var1_1.getMinY();
        if (var1_1.getTransferType() != this.transferType) {
            throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel6"));
        }
        if (var2_2) {
            switch (this.transferType) {
                case 4: {
                    var9_8 = null;
                    var10_12 = 0;
                    block8: while (true) {
                        if (var10_12 >= var4_4) {
                            return new FloatDoubleColorModel(this.colorSpace, this.hasAlpha, var2_2, this.transparency, this.transferType);
                        }
                        var8_16 = var6_6;
                        var11_20 = 0;
                        while (true) {
                            if (var11_20 >= var3_3) {
                                ++var10_12;
                                ++var7_7;
                                continue block8;
                            }
                            var12_24 = (var9_8 = (float[])var1_1.getDataElements(var8_16, var7_7, var9_8))[var5_5];
                            if (var12_24 != 0.0f) {
                                var13_28 = 0;
                                while (true) {
                                    if (var13_28 >= var5_5) {
                                        var1_1.setDataElements(var8_16, var7_7, var9_8);
                                        break;
                                    }
                                    v0 = var13_28++;
                                    var9_8[v0] = var9_8[v0] * var12_24;
                                }
                            }
                            ++var11_20;
                            ++var8_16;
                        }
                        break;
                    }
                }
                case 5: {
                    var9_9 = null;
                    var10_13 = 0;
                    block11: while (true) {
                        if (var10_13 >= var4_4) {
                            return new FloatDoubleColorModel(this.colorSpace, this.hasAlpha, var2_2, this.transparency, this.transferType);
                        }
                        var8_17 = var6_6;
                        var11_21 = 0;
                        while (true) {
                            if (var11_21 >= var3_3) {
                                ++var10_13;
                                ++var7_7;
                                continue block11;
                            }
                            var12_25 = (var9_9 = (double[])var1_1.getDataElements(var8_17, var7_7, var9_9))[var5_5];
                            if (var12_25 != 0.0) {
                                var14_30 = 0;
                                while (true) {
                                    if (var14_30 >= var5_5) {
                                        var1_1.setDataElements(var8_17, var7_7, var9_9);
                                        break;
                                    }
                                    v1 = var14_30++;
                                    var9_9[v1] = var9_9[v1] * var12_25;
                                }
                            }
                            ++var11_21;
                            ++var8_17;
                        }
                        break;
                    }
                }
                default: {
                    return new FloatDoubleColorModel(this.colorSpace, this.hasAlpha, var2_2, this.transparency, this.transferType);
                }
            }
        } else {
            switch (this.transferType) {
                case 4: {
                    var9_10 = 0;
                    block14: while (var9_10 < var4_4) {
                        var8_18 = var6_6;
                        var10_14 = 0;
                        while (true) {
                            if (var10_14 >= var3_3) {
                                ++var9_10;
                                ++var7_7;
                                continue block14;
                            }
                            var11_22 = null;
                            var12_26 = (var11_22 = (float[])var1_1.getDataElements(var8_18, var7_7, var11_22))[var5_5];
                            if (var12_26 != 0.0f) {
                                var13_29 = 1.0f / var12_26;
                                var14_31 = 0;
                                while (var14_31 < var5_5) {
                                    v2 = var14_31++;
                                    var11_22[v2] = var11_22[v2] * var13_29;
                                }
                            }
                            var1_1.setDataElements(var8_18, var7_7, var11_22);
                            ++var10_14;
                            ++var8_18;
                        }
                    }
                    break;
                }
                case 5: {
                    var9_11 = 0;
                    ** while (var9_11 < var4_4)
                }
lbl-1000:
                // 1 sources

                {
                    var8_19 = var6_6;
                    var10_15 = 0;
                    while (var10_15 < var3_3) {
                        var11_23 = null;
                        var12_27 = (var11_23 = (double[])var1_1.getDataElements(var8_19, var7_7, var11_23))[var5_5];
                        if (var12_27 != 0.0) {
                            var14_32 = 1.0 / var12_27;
                            var16_33 = 0;
                            while (var16_33 < var5_5) {
                                v3 = var16_33++;
                                var11_23[v3] = var11_23[v3] * var14_32;
                            }
                        }
                        var1_1.setDataElements(var8_19, var7_7, var11_23);
                        ++var10_15;
                        ++var8_19;
                    }
                    ++var9_11;
                    ++var7_7;
                    continue;
                }
            }
        }
lbl114:
        // 3 sources

        return new FloatDoubleColorModel(this.colorSpace, this.hasAlpha, var2_2, this.transparency, this.transferType);
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int[] nArray = new int[this.numComponents];
        int n3 = 0;
        while (n3 < this.numComponents) {
            nArray[n3] = n3;
            ++n3;
        }
        return new ComponentSampleModelJAI(this.transferType, n, n2, this.numComponents, n * this.numComponents, nArray);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        SampleModel sampleModel = this.createCompatibleSampleModel(n, n2);
        return RasterFactory.createWritableRaster(sampleModel, new Point(0, 0));
    }

    public int getAlpha(int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel4"));
    }

    public int getAlpha(Object object) {
        if (!this.hasAlpha) {
            return 255;
        }
        if (this.transferType == 4) {
            float[] fArray = (float[])object;
            return (int)(fArray[this.numColorComponents] * 255.0f);
        }
        double[] dArray = (double[])object;
        return (int)(dArray[this.numColorComponents] * 255.0);
    }

    public int getBlue(int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel3"));
    }

    public int getBlue(Object object) {
        return this.getSample(object, 2);
    }

    public int[] getComponents(int n, int[] nArray, int n2) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel9"));
    }

    public int[] getComponents(Object object, int[] nArray, int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel9"));
    }

    public int getDataElement(int[] nArray, int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel9"));
    }

    public Object getDataElements(int n, Object object) {
        double[] dArray;
        if (this.transferType == 4) {
            float[] fArray;
            if (object == null) {
                fArray = new float[this.numComponents];
            } else {
                if (!(object instanceof float[])) {
                    throw new ClassCastException(JaiI18N.getString("FloatDoubleColorModel7"));
                }
                fArray = (float[])object;
                if (fArray.length < this.numComponents) {
                    throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("FloatDoubleColorModel8"));
                }
            }
            float f = 0.003921569f;
            if (this.colorSpace.isCS_sRGB()) {
                int n2 = n >> 24 & 0xFF;
                int n3 = n >> 16 & 0xFF;
                int n4 = n >> 8 & 0xFF;
                int n5 = n & 0xFF;
                float f2 = f;
                if (this.isAlphaPremultiplied) {
                    f2 *= (float)n2;
                }
                fArray[0] = (float)n3 * f2;
                fArray[1] = (float)n4 * f2;
                fArray[2] = (float)n5 * f2;
                if (this.hasAlpha) {
                    fArray[3] = (float)n2 * f;
                }
            } else if (this.colorSpaceType == 6) {
                float f3;
                fArray[0] = f3 = (float)(n >> 16 & 0xFF) * (0.299f * f) + (float)(n >> 8 & 0xFF) * (0.587f * f) + (float)(n & 0xFF) * (0.114f * f);
                if (this.hasAlpha) {
                    int n6 = n >> 24 & 0xFF;
                    fArray[1] = (float)n6 * f;
                }
            } else {
                float[] fArray2 = new float[]{(float)(n >> 16 & 0xFF) * f, (float)(n >> 8 & 0xFF) * f, (float)(n & 0xFF) * f};
                fArray2 = this.colorSpace.fromRGB(fArray2);
                int n7 = 0;
                while (n7 < this.numColorComponents) {
                    fArray[n7] = fArray2[n7];
                    ++n7;
                }
                if (this.hasAlpha) {
                    int n8 = n >> 24 & 0xFF;
                    fArray[this.numColorComponents] = (float)n8 * f;
                }
            }
            return fArray;
        }
        if (object == null) {
            dArray = new double[this.numComponents];
        } else {
            if (!(object instanceof double[])) {
                throw new ClassCastException(JaiI18N.getString("FloatDoubleColorModel7"));
            }
            dArray = (double[])object;
            if (dArray.length < this.numComponents) {
                throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("FloatDoubleColorModel8"));
            }
        }
        double d = 0.00392156862745098;
        if (this.colorSpace.isCS_sRGB()) {
            int n9 = n >> 24 & 0xFF;
            int n10 = n >> 16 & 0xFF;
            int n11 = n >> 8 & 0xFF;
            int n12 = n & 0xFF;
            double d2 = d;
            if (this.isAlphaPremultiplied) {
                d2 *= (double)n9;
            }
            dArray[0] = (double)n10 * d2;
            dArray[1] = (double)n11 * d2;
            dArray[2] = (double)n12 * d2;
            if (this.hasAlpha) {
                dArray[3] = (double)n9 * d;
            }
        } else if (this.colorSpaceType == 6) {
            double d3;
            dArray[0] = d3 = (double)(n >> 16 & 0xFF) * (0.299 * d) + (double)(n >> 8 & 0xFF) * (0.587 * d) + (double)(n & 0xFF) * (0.114 * d);
            if (this.hasAlpha) {
                int n13 = n >> 24 & 0xFF;
                dArray[1] = (double)n13 * d;
            }
        } else {
            float f = 0.003921569f;
            float[] fArray = new float[]{(float)(n >> 16 & 0xFF) * f, (float)(n >> 8 & 0xFF) * f, (float)(n & 0xFF) * f};
            fArray = this.colorSpace.fromRGB(fArray);
            int n14 = 0;
            while (n14 < this.numColorComponents) {
                dArray[n14] = fArray[n14];
                ++n14;
            }
            if (this.hasAlpha) {
                int n15 = n >> 24 & 0xFF;
                dArray[this.numColorComponents] = (double)n15 * d;
            }
        }
        return dArray;
    }

    public Object getDataElements(int[] nArray, int n, Object object) {
        if (nArray.length - n < this.numComponents) {
            throw new IllegalArgumentException(String.valueOf(this.numComponents) + " " + JaiI18N.getString("FloatDoubleColorModel10"));
        }
        if (this.transferType == 4) {
            float[] fArray = object == null ? new float[nArray.length] : (float[])object;
            int n2 = 0;
            while (n2 < this.numComponents) {
                fArray[n2] = nArray[n + n2];
                ++n2;
            }
            return fArray;
        }
        double[] dArray = object == null ? new double[nArray.length] : (double[])object;
        int n3 = 0;
        while (n3 < this.numComponents) {
            dArray[n3] = nArray[n + n3];
            ++n3;
        }
        return dArray;
    }

    public int getGreen(int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel2"));
    }

    public int getGreen(Object object) {
        return this.getSample(object, 1);
    }

    public int getRGB(int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel5"));
    }

    public int getRGB(Object object) {
        int n;
        int n2;
        int n3;
        boolean bl = this.hasAlpha && this.isAlphaPremultiplied;
        int n4 = 255;
        if (this.colorSpace.isCS_sRGB()) {
            if (this.transferType == 4) {
                float[] fArray = (float[])object;
                float f = fArray[0];
                float f2 = fArray[1];
                float f3 = fArray[2];
                float f4 = 255.0f;
                if (bl) {
                    float f5 = fArray[3];
                    f4 /= f5;
                    n4 = this.clamp(255.0f * f5);
                }
                n3 = this.clamp(f * f4);
                n2 = this.clamp(f2 * f4);
                n = this.clamp(f3 * f4);
            } else {
                double[] dArray = (double[])object;
                double d = dArray[0];
                double d2 = dArray[1];
                double d3 = dArray[2];
                double d4 = 255.0;
                if (bl) {
                    double d5 = dArray[3];
                    d4 /= d5;
                    n4 = this.clamp(255.0 * d5);
                }
                n3 = this.clamp(d * d4);
                n2 = this.clamp(d2 * d4);
                n = this.clamp(d3 * d4);
            }
        } else if (this.colorSpaceType == 6) {
            if (this.transferType == 4) {
                float[] fArray = (float[])object;
                float f = fArray[0];
                if (bl) {
                    float f6 = fArray[1];
                    n2 = n = this.clamp(f * 255.0f / f6);
                    n3 = n;
                    n4 = this.clamp(255.0f * f6);
                } else {
                    n2 = n = this.clamp(f * 255.0f);
                    n3 = n;
                }
            } else {
                double[] dArray = (double[])object;
                double d = dArray[0];
                if (bl) {
                    double d6 = dArray[1];
                    n2 = n = this.clamp(d * 255.0 / d6);
                    n3 = n;
                    n4 = this.clamp(255.0 * d6);
                } else {
                    n2 = n = this.clamp(d * 255.0);
                    n3 = n;
                }
            }
        } else {
            float[] fArray;
            if (this.transferType == 4) {
                float[] fArray2 = (float[])object;
                if (bl) {
                    float f = fArray2[this.numColorComponents];
                    float f7 = 1.0f / f;
                    fArray = new float[this.numColorComponents];
                    int n5 = 0;
                    while (n5 < this.numColorComponents) {
                        fArray[n5] = fArray2[n5] * f7;
                        ++n5;
                    }
                    n4 = this.clamp(255.0f * f);
                } else {
                    fArray = fArray2;
                }
            } else {
                double[] dArray = (double[])object;
                fArray = new float[this.numColorComponents];
                if (bl) {
                    double d = dArray[this.numColorComponents];
                    double d7 = 1.0 / d;
                    int n6 = 0;
                    while (n6 < this.numColorComponents) {
                        fArray[n6] = (float)(dArray[n6] * d7);
                        ++n6;
                    }
                    n4 = this.clamp(255.0 * d);
                } else {
                    int n7 = 0;
                    while (n7 < this.numColorComponents) {
                        fArray[n7] = (float)dArray[n7];
                        ++n7;
                    }
                }
            }
            float[] fArray3 = this.colorSpace.toRGB(fArray);
            n3 = this.clamp(fArray3[0] * 255.0f);
            n2 = this.clamp(fArray3[1] * 255.0f);
            n = this.clamp(fArray3[2] * 255.0f);
        }
        return n4 << 24 | n3 << 16 | n2 << 8 | n;
    }

    public int getRed(int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel1"));
    }

    public int getRed(Object object) {
        return this.getSample(object, 0);
    }

    private int getSample(Object object, int n) {
        boolean bl = this.hasAlpha && this.isAlphaPremultiplied;
        int n2 = this.colorSpaceType;
        boolean bl2 = this.colorSpace.isCS_sRGB();
        if (n2 == 6) {
            n = 0;
            bl2 = true;
        }
        if (bl2) {
            if (this.transferType == 4) {
                float[] fArray = (float[])object;
                float f = fArray[n] * 255.0f;
                if (bl) {
                    float f2 = fArray[this.numColorComponents];
                    return this.clamp(f / f2);
                }
                return this.clamp(f);
            }
            double[] dArray = (double[])object;
            double d = dArray[n] * 255.0;
            if (bl) {
                double d2 = dArray[this.numColorComponents];
                return this.clamp(d / d2);
            }
            return this.clamp(d);
        }
        if (this.transferType == 4) {
            float[] fArray = (float[])object;
            if (bl) {
                float f = fArray[this.numColorComponents];
                float[] fArray2 = new float[this.numColorComponents];
                int n3 = 0;
                while (n3 < this.numColorComponents) {
                    fArray2[n3] = fArray[n3] / f;
                    ++n3;
                }
                float[] fArray3 = this.colorSpace.toRGB(fArray2);
                return (int)(fArray3[n] * f * 255.0f);
            }
            float[] fArray4 = this.colorSpace.toRGB(fArray);
            return (int)(fArray4[n] * 255.0f);
        }
        double[] dArray = (double[])object;
        float[] fArray = new float[this.numColorComponents];
        if (bl) {
            double d = dArray[this.numColorComponents];
            int n4 = 0;
            while (n4 < this.numColorComponents) {
                fArray[n4] = (float)(dArray[n4] / d);
                ++n4;
            }
            float[] fArray5 = this.colorSpace.toRGB(fArray);
            return (int)((double)fArray5[n] * d * 255.0);
        }
        int n5 = 0;
        while (n5 < this.numColorComponents) {
            fArray[n5] = (float)dArray[n5];
            ++n5;
        }
        float[] fArray6 = this.colorSpace.toRGB(fArray);
        return (int)(fArray6[n] * 255.0f);
    }

    public boolean isCompatibleRaster(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        return this.isCompatibleSampleModel(sampleModel);
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        if (sampleModel instanceof ComponentSampleModel) {
            if (sampleModel.getNumBands() != this.getNumComponents()) {
                return false;
            }
            return sampleModel.getDataType() == this.transferType;
        }
        return false;
    }

    public String toString() {
        return "FloatDoubleColorModel: " + super.toString();
    }
}

