/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.debug.connection;

import com.insightful.splus.SplusDebugHandlerInterface;
import com.insightful.splus.SplusDebugListener;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.debug.core.SplusDebugPlugin;
import com.insightful.splus.eclipse.debug.core.launching.SplusDebugLaunchDelegate;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugManager;
import com.insightful.splus.eclipse.views.util.ConsoleHistoryDocument;
import java.rmi.RemoteException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.swt.widgets.Display;

public class DebugConnection
extends DefaultConnection {
    private boolean m_debugEngineBusy;

    public SplusDebugManager getSplusDebugManager() {
        return new SplusDebugManager(this.m_splusSession);
    }

    public DebugConnection(ConsoleHistoryDocument consoleHistoryDocument) throws Exception {
        super(consoleHistoryDocument);
        SplusDebugPlugin.getDefault().setDebugManager(this.m_splusSession);
        this.m_debugEngineBusy = false;
    }

    private boolean hijackEvaluation(final String string) {
        String string2 = string.trim();
        if (string2.length() != 0 && SplusDebugPlugin.getDefault().getDebugMode()) {
            this.setDebugEngineBusy(true);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    DebugUIPlugin.launchInBackground((ILaunchConfiguration)SplusDebugLaunchDelegate.getDefaultConfiguration(string), (String)"debug");
                }
            });
            return true;
        }
        return false;
    }

    public void setDebugEngineBusy(boolean bl) {
        this.m_debugEngineBusy = bl;
    }

    public boolean isEngineBusy() {
        boolean bl = super.isEngineBusy();
        if (SplusDebugPlugin.getDefault().getDebugMode()) {
            return this.m_debugEngineBusy || bl;
        }
        return bl;
    }

    public void writeEngineInput(String string) {
        this.writeEngineInput(string, false);
    }

    public void writeEngineInput(String string, boolean bl) {
        if (!bl && this.hijackEvaluation(string)) {
            return;
        }
        super.writeEngineInput(string);
    }

    public void sendCmd(String string) {
        if (this.hijackEvaluation(string)) {
            return;
        }
        super.sendCmd(string);
    }

    public void openEditor(String string) {
        if (this.isEngineBusy()) {
            try {
                this.m_splusSession.start();
                this.m_splusSession.doInvisibleEvaluate(0L, "Edit(\"" + string + "\")");
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        } else {
            super.openEditor(string);
        }
    }

    public void setEscaped() {
        if (SplusDebugPlugin.getDefault().getDebugMode()) {
            try {
                this.m_splusSession.start();
                this.m_splusSession.doStop(0L);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        } else {
            super.setEscaped();
        }
    }

    public String getHoverText(String string) {
        if (SplusDebugPlugin.getDefault().getDebugMode() && this.isEngineBusy() && !this.wantsInput()) {
            return new HoverEvaluator(string).getResult();
        }
        return super.getHoverText(string);
    }

    class HoverEvaluator
    implements SplusDebugListener {
        private String m_request;
        private String m_result;
        private boolean m_done = false;

        public HoverEvaluator(String string) {
            this.m_request = string;
            this.m_done = false;
            try {
                DebugConnection.this.m_splusSession.addSplusDebugListener((SplusDebugListener)this);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }

        public String getResult() {
            try {
                DebugConnection.this.m_splusSession.doEvaluate(0L, this.m_request);
                while (!this.m_done) {
                    try {
                        Thread.sleep(100L);
                        Thread.yield();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            return this.m_result;
        }

        public void evalInfoRetrieved(String string, SplusDebugHandlerInterface splusDebugHandlerInterface) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                int n = splusDebugHandlerInterface.getNumEvals(string);
                for (int i = 0; i < n; ++i) {
                    if (i != 0) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(splusDebugHandlerInterface.getEval(string, i));
                }
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            try {
                DebugConnection.this.m_splusSession.removeSplusDebugListener((SplusDebugListener)this);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            this.m_result = stringBuffer.toString();
            this.m_done = true;
        }

        public void breakpointHit(SplusDebugHandlerInterface splusDebugHandlerInterface) {
        }

        public void callStackRetrieved(SplusDebugHandlerInterface splusDebugHandlerInterface) {
        }

        public void objectsRetrieved(SplusDebugHandlerInterface splusDebugHandlerInterface) {
        }
    }
}

