/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.debug.core.model;

import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusDebugHandlerInterface;
import com.insightful.splus.SplusDebugListener;
import com.insightful.splus.SplusEngineBusyException;
import com.insightful.splus.SplusIncompleteExpressionException;
import com.insightful.splus.SplusWinSessionEvent;
import com.insightful.splus.SplusWinSessionListener;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.debug.connection.DebugConnection;
import com.insightful.splus.eclipse.debug.core.SplusDebugPlugin;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugElement;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugEvent;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugLineBreakpoint;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugManager;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugThread;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugValue;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugVariable;
import com.insightful.splus.eclipse.debug.core.model.SplusEclipseDebugListener;
import com.insightful.splus.eclipse.views.util.ConsoleHistoryDocument;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;

public class SplusDebugTarget
extends SplusDebugElement
implements IDebugTarget,
SplusDebugListener {
    private static final String DEBUG_CALL_START = "Debug(";
    private static final String DEBUG_END = ")";
    private static final String DEBUG_CALL = "x=";
    private static final String DEBUG_VECTOR_START = "c(";
    private static final String DEBUG_TYPES_START = ", types=c(";
    private static final String DEBUG_BREAKS_START = ", breakpoints=list(";
    private static final String DEBUG_BREAKS_FILE = ", \"f\"";
    private static final String DEBUG_ENTRY_STOP = ", entryStop=";
    private long fExprID;
    private String fExpr;
    private boolean fEntryStop;
    private ILaunch fLaunch;
    private String fName;
    private boolean fSuspended = false;
    private boolean fTerminated = false;
    private boolean fStarted = true;
    private SplusDebugThread fThread;
    private IThread[] fThreads;
    private EventDispatchJob fEventDispatch;
    private SplusDebugEvent fEvent;
    private boolean m_objects = false;
    private boolean m_dataRequested = false;
    private SplusDebugValue[] m_valuesRetrieved = new SplusDebugValue[0];
    private SplusDebugVariable[] m_variablesRetrieved = new SplusDebugVariable[0];
    private HashMap m_variablesToValues = new HashMap();

    void doSleep(int n) {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private IStatus doConsolePaneRun(String string, Display display) {
        this.started();
        PaneRun paneRun = new PaneRun(string, display);
        paneRun.start();
        while (!paneRun.isDone()) {
            this.doSleep(100);
        }
        this.terminated();
        return Status.OK_STATUS;
    }

    private IStatus doOutputPaneRun(String string, Display display) {
        SplusDebugPlugin.getDefault().getDebugManager().doSetCommandLine(false);
        this.started();
        new OutputPaneRun(string, display).start();
        while (!this.isStarted() || !this.isTerminated()) {
            this.doSleep(100);
            if (this.fEvent == null || this.fEvent.getType() != 6) continue;
            this.terminated();
            break;
        }
        SplusDebugPlugin.getDefault().getDebugManager().doSetCommandLine(true);
        return Status.OK_STATUS;
    }

    public SplusDebugTarget(ILaunch iLaunch, String string, boolean bl) throws CoreException {
        super(null);
        SplusDebugPlugin.getDefault().getDebugManager().addSplusDebugListener(this);
        this.fLaunch = iLaunch;
        this.fTarget = this;
        this.fExpr = string;
        this.fEntryStop = bl;
        this.fThread = new SplusDebugThread(this);
        this.fThreads = new IThread[]{this.fThread};
        this.fEventDispatch = new EventDispatchJob();
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        this.fThread.addDebugListener(this.fEventDispatch);
        this.fEventDispatch.schedule();
    }

    public String createBreakpointList() {
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("com.insightful.splus.eclipse.debug");
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        HashMap<String, StringBuffer> hashMap = new HashMap<String, StringBuffer>();
        if (iBreakpointArray.length != 0) {
            Object object;
            for (int i = 0; i < iBreakpointArray.length; ++i) {
                try {
                    object = (SplusDebugLineBreakpoint)iBreakpointArray[i];
                    String string = object.getMarker().getResource().getLocation().toString();
                    int n = object.getLineNumber();
                    if (!object.isEnabled()) continue;
                    StringBuffer stringBuffer3 = null;
                    if (hashMap.get(string) != null) {
                        stringBuffer3 = (StringBuffer)hashMap.get(string);
                    } else {
                        stringBuffer3 = new StringBuffer();
                        stringBuffer3.append(", \"" + string + "\"=" + DEBUG_VECTOR_START);
                        hashMap.put(string, stringBuffer3);
                    }
                    stringBuffer3.append("," + Integer.toString(n));
                    continue;
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
            stringBuffer.append(DEBUG_BREAKS_START);
            stringBuffer2.append(DEBUG_TYPES_START);
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                object = (StringBuffer)hashMap.get(iterator.next());
                stringBuffer2.append(DEBUG_BREAKS_FILE);
                stringBuffer.append((StringBuffer)object);
                stringBuffer.append(DEBUG_END);
            }
            stringBuffer.append(DEBUG_END);
            stringBuffer2.append(DEBUG_END);
        }
        return stringBuffer.toString() + stringBuffer2.toString();
    }

    public String createSplusDebugCall(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(this.fExpr);
        } else {
            stringBuffer.append(DEBUG_CALL_START);
            stringBuffer.append(DEBUG_CALL + this.fExpr);
            stringBuffer.append(this.createBreakpointList());
            stringBuffer.append(DEBUG_ENTRY_STOP + (this.fEntryStop ? "T" : "F"));
            stringBuffer.append(DEBUG_END);
        }
        return stringBuffer.toString();
    }

    public long getExpressionID() {
        return this.fExprID;
    }

    public IProcess getProcess() {
        return null;
    }

    public IThread[] getThreads() throws DebugException {
        return this.fThreads;
    }

    public boolean hasThreads() throws DebugException {
        return this.fThreads != null && this.fThreads.length != 0;
    }

    public String getName() throws DebugException {
        if (this.fName == null) {
            this.fName = "S-PLUS Call";
        }
        return this.fName;
    }

    public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
        IMarker iMarker;
        String string;
        if (iBreakpoint.getModelIdentifier().equals("com.insightful.splus.eclipse.debug") && (string = "") != null && (iMarker = iBreakpoint.getMarker()) != null) {
            Path path = new Path(string);
            return iMarker.getResource().getFullPath().equals(path);
        }
        return false;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public boolean canTerminate() {
        return this.isStarted() && !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        SplusDebugPlugin.getDefault().getDebugManager().doStop(this.getExpressionID());
    }

    public boolean canResume() {
        return this.isStarted() && !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return this.isStarted() && !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public void resume() throws DebugException {
        this.fThread.resume();
    }

    private void resumed(int n) {
        this.fSuspended = false;
        this.fThread.fireResumeEvent(n);
    }

    private synchronized void suspended(int n) {
        DebugConnection debugConnection = (DebugConnection)SplusEditorPlugin.getDefault().getConnection();
        debugConnection.flushOutputHandler();
        SplusDebugManager splusDebugManager = SplusDebugPlugin.getDefault().getDebugManager();
        if (!this.m_dataRequested) {
            this.m_dataRequested = true;
            splusDebugManager.doCallStack(this.getExpressionID());
            splusDebugManager.doObjects(this.getExpressionID());
        }
        this.fSuspended = true;
        this.fThread.fireSuspendEvent(n);
    }

    public void suspend() throws DebugException {
        this.fThread.suspend();
    }

    public boolean isStarted() {
        return this.fStarted;
    }

    private void started() {
        this.fStarted = true;
        this.fireCreationEvent();
        this.installDeferredBreakpoints();
    }

    public void start() {
        SplusDebugPlugin.getDefault().getDebugManager().doStart(this.createSplusDebugCall(false));
    }

    private void terminated() {
        this.fTerminated = true;
        this.fSuspended = false;
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        this.fireTerminateEvent();
    }

    public void breakpointAdded(IBreakpoint iBreakpoint) {
    }

    public void breakpointRemoved(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
    }

    public void breakpointChanged(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long l, long l2) throws DebugException {
        return null;
    }

    private void installDeferredBreakpoints() {
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("com.insightful.splus.eclipse.debug");
        for (int i = 0; i < iBreakpointArray.length; ++i) {
            this.breakpointAdded(iBreakpointArray[i]);
        }
    }

    protected IStackFrame[] getStackFrames() throws DebugException {
        return this.fThread.getStackFrames();
    }

    protected IValue getVariableValue(SplusDebugVariable splusDebugVariable) throws DebugException {
        IValue iValue = (IValue)this.m_variablesToValues.get((Object)splusDebugVariable);
        if (iValue == null) {
            return new SplusDebugValue(this, splusDebugVariable.getName(), new String[0]){

                public String getReferenceTypeName() throws DebugException {
                    return "";
                }

                public String getValueString() throws DebugException {
                    return "";
                }
            };
        }
        return iValue;
    }

    public IValue[] getDataStack() throws DebugException {
        if (this.m_objects) {
            return this.m_valuesRetrieved;
        }
        SplusDebugPlugin.getDefault().getDebugManager().doObjects(this.getExpressionID());
        return new IValue[0];
    }

    public SplusDebugVariable[] getVariables() throws DebugException {
        if (this.m_objects) {
            return this.m_variablesRetrieved;
        }
        return new SplusDebugVariable[0];
    }

    public synchronized void reset() {
        SplusDebugPlugin.getDefault().getDebugManager().start();
        this.m_objects = false;
        this.m_dataRequested = false;
        this.fEventDispatch.resetFrame();
    }

    public void objectsRetrieved(SplusDebugHandlerInterface splusDebugHandlerInterface) {
        SplusDebugManager splusDebugManager = SplusDebugPlugin.getDefault().getDebugManager();
        this.m_objects = true;
        this.m_variablesToValues.clear();
        int n = splusDebugManager.getNumObjects();
        SplusDebugVariable[] splusDebugVariableArray = this.m_variablesRetrieved;
        this.m_valuesRetrieved = new SplusDebugValue[n];
        this.m_variablesRetrieved = new SplusDebugVariable[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.m_valuesRetrieved[i] = new SplusDebugValue(this, splusDebugManager.getObjectName(i), splusDebugHandlerInterface.getObjectData(i));
                SplusDebugVariable splusDebugVariable = new SplusDebugVariable(this, splusDebugManager.getObjectName(i));
                for (int j = 0; j < splusDebugVariableArray.length; ++j) {
                    try {
                        if (!splusDebugVariableArray[j].getName().equals(splusDebugManager.getObjectName(i))) continue;
                        splusDebugVariable = splusDebugVariableArray[j];
                        break;
                    }
                    catch (DebugException debugException) {
                        debugException.printStackTrace();
                    }
                }
                this.m_variablesRetrieved[i] = splusDebugVariable;
                this.m_variablesToValues.put(this.m_variablesRetrieved[i], this.m_valuesRetrieved[i]);
                continue;
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
        this.fEventDispatch.debugEventOccurred(new SplusDebugEvent(8));
        this.suspended(16);
    }

    public synchronized void breakpointHit(SplusDebugHandlerInterface splusDebugHandlerInterface) {
        this.fThread.setBreakpoint();
    }

    public synchronized void callStackRetrieved(SplusDebugHandlerInterface splusDebugHandlerInterface) {
        this.fThread.setCallStack();
    }

    public void evalInfoRetrieved(String string, SplusDebugHandlerInterface splusDebugHandlerInterface) {
    }

    private class OutputPaneRun
    extends PaneRun {
        public OutputPaneRun(String string, Display display) {
            super(string, display);
        }

        public void run() {
            DebugConnection debugConnection = (DebugConnection)SplusEditorPlugin.getDefault().getConnection();
            StringBuffer stringBuffer = new StringBuffer();
            try {
                SplusDataResult splusDataResult = debugConnection.doDataQueryWithOutput(this.m_sCode);
                if (splusDataResult.hasOutput()) {
                    stringBuffer.append(splusDataResult.getOutput());
                } else if (splusDataResult.hasError()) {
                    stringBuffer.append(splusDataResult.getError());
                } else if (splusDataResult.hasExpression()) {
                    stringBuffer.append(splusDataResult.getExpression());
                }
                if (splusDataResult.hasWarning()) {
                    String[] stringArray = splusDataResult.getWarning();
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuffer.append(stringArray[i] + "\n");
                    }
                }
            }
            catch (RemoteException remoteException) {
                stringBuffer.append(remoteException.getMessage());
            }
            catch (SplusIncompleteExpressionException splusIncompleteExpressionException) {
                stringBuffer.append(splusIncompleteExpressionException.getMessage());
            }
            catch (SplusEngineBusyException splusEngineBusyException) {
                SplusEditorPlugin.displayWarning((String)"Engine Busy", (String)"Cannot debug.  The engine is currently busy.");
            }
            this.doOutput(debugConnection, stringBuffer.toString());
            SplusDebugTarget.this.terminated();
            debugConnection.setDebugEngineBusy(false);
        }

        public void doOutput(DebugConnection debugConnection, final String string) {
            if (string.length() != 0) {
                this.m_display.syncExec(new Runnable(){

                    public void run() {
                        String string2 = "> " + SplusDebugTarget.this.fExpr + "\n" + string;
                        SplusEditorPlugin.getDefault().getOutputDocument().set(string2);
                    }
                });
            }
        }
    }

    private class PaneRun
    extends Thread
    implements SplusWinSessionListener {
        protected Display m_display;
        protected String m_sCode;
        protected boolean m_notDone;

        public PaneRun(String string, Display display) {
            super("Debug Run");
            this.m_sCode = string;
            this.m_notDone = true;
            this.m_display = display;
        }

        public void run() {
            final ConsoleHistoryDocument consoleHistoryDocument = SplusEditorPlugin.getDefault().getConsoleDocument();
            final DebugConnection debugConnection = (DebugConnection)SplusEditorPlugin.getDefault().getConnection();
            debugConnection.addSplusWinSessionListener(this);
            Thread thread = new Thread(){

                public void run() {
                    while (PaneRun.this.m_display != null && !PaneRun.this.m_display.isDisposed()) {
                        PaneRun.this.m_display.syncExec(new Runnable(){

                            public void run() {
                                consoleHistoryDocument.getAndDisplayOutput();
                            }
                        });
                        if (!PaneRun.this.m_notDone) {
                            if (consoleHistoryDocument.sendToOutput()) {
                                consoleHistoryDocument.setSendToOutput(false);
                                debugConnection.flushOutputHandler();
                            } else {
                                consoleHistoryDocument.addPrompt(0);
                                consoleHistoryDocument.refreshPrompts();
                            }
                            debugConnection.setDebugEngineBusy(false);
                            SplusEditorPlugin.getDefault().setSplusBusy(false);
                            return;
                        }
                        SplusDebugTarget.this.doSleep(100);
                    }
                }
            };
            thread.setName("Get Debug Output");
            thread.start();
            SplusEditorPlugin.getDefault().setSplusBusy(true);
            if (!debugConnection.wantsInput()) {
                debugConnection.writeEngineInput(this.m_sCode, true);
            } else {
                debugConnection.writeEngineInput(this.m_sCode + "\n", true);
            }
        }

        public boolean isDone() {
            return !this.m_notDone;
        }

        public void eventOccurred(SplusWinSessionEvent splusWinSessionEvent) {
            int n = splusWinSessionEvent == null ? -1 : splusWinSessionEvent.getType();
            switch (n) {
                case 32: {
                    final IWorkbench iWorkbench = SplusEditorPlugin.getDefault().getWorkbench();
                    iWorkbench.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            iWorkbench.close();
                        }
                    });
                    break;
                }
                case 2: 
                case 21: 
                case 999: 
                case 1000: 
                case 1001: 
                case 1003: {
                    DebugConnection debugConnection = (DebugConnection)SplusEditorPlugin.getDefault().getConnection();
                    SplusEditorPlugin.getDefault().setSplusBusy(false);
                    debugConnection.removeSplusWinSessionListener(this);
                    debugConnection.flushOutputHandler();
                    this.m_notDone = false;
                }
            }
        }
    }

    class EventDispatchJob
    extends Job
    implements SplusEclipseDebugListener,
    SplusWinSessionListener {
        private IStackFrame m_topFrame;

        public EventDispatchJob() {
            super("S-PLUS Debug Event Dispatch");
            this.m_topFrame = null;
            this.setSystem(true);
            SplusDebugTarget.this.fEvent = null;
        }

        public void resetFrame() {
            this.m_topFrame = null;
        }

        public void debugEventOccurred(SplusDebugEvent splusDebugEvent) {
            SplusDebugTarget.this.fEvent = splusDebugEvent;
            SplusDebugTarget.this.fThread.setStepping(false);
            switch (splusDebugEvent.getType()) {
                case 0: {
                    SplusDebugTarget.this.started();
                    break;
                }
                case 6: {
                    SplusDebugTarget.this.terminated();
                    break;
                }
                case 5: {
                    SplusDebugTarget.this.resumed(4);
                    break;
                }
                case 2: {
                    SplusDebugTarget.this.suspended(2);
                    break;
                }
                case 3: {
                    SplusDebugTarget.this.suspended(1);
                    break;
                }
                case 4: {
                    SplusDebugTarget.this.suspended(4);
                    break;
                }
                case 1: {
                    try {
                        if (this.m_topFrame == null || !this.m_topFrame.equals(SplusDebugTarget.this.fThread.getTopStackFrame())) {
                            SplusDebugTarget.this.suspended(16);
                        }
                        this.m_topFrame = SplusDebugTarget.this.fThread.getTopStackFrame();
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                    break;
                }
            }
        }

        public void eventOccurred(SplusWinSessionEvent splusWinSessionEvent) {
            if (splusWinSessionEvent.getType() == 2) {
                SplusEditorPlugin.getDefault().setSplusBusy(false);
                SplusDebugTarget.this.terminated();
            }
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            SplusDebugPlugin.getDefault().getDebugManager().start();
            SplusDebugLineBreakpoint.updateResources();
            Display display = Display.getDefault();
            if (SplusDebugPlugin.getDefault().getDebugMode()) {
                return SplusDebugTarget.this.doConsolePaneRun(SplusDebugTarget.this.createSplusDebugCall(true), display);
            }
            return SplusDebugTarget.this.doOutputPaneRun(SplusDebugTarget.this.createSplusDebugCall(false), display);
        }
    }
}

