/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.debug.ui.model;

import com.insightful.splus.eclipse.debug.core.model.SplusDebugLineBreakpoint;
import com.insightful.splus.eclipse.editors.spluseditor.SplusEditor;
import com.insightful.splus.parser.PObject;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class SplusDebugLineBreakpointAdapter
implements IToggleBreakpointsTarget {
    private Vector m_address = new Vector();

    private void clearAddress() {
        this.m_address.removeAllElements();
    }

    private boolean findFirstLineNumber(PObject pObject, int n) {
        int n2 = (int)pObject.poGetAttribute("start.line").poGetDoubleElement(0);
        try {
            if (n2 == n) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (pObject.poIsRecursive()) {
            for (int i = 0; i < pObject.poGetLength(); ++i) {
                PObject pObject2 = pObject.poGetElement(i);
                this.m_address.add(new Integer(i + 1));
                if (this.findFirstLineNumber(pObject2, n)) {
                    return true;
                }
                this.m_address.remove(this.m_address.size() - 1);
            }
        }
        return false;
    }

    public void toggleLineBreakpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) throws CoreException {
        ITextEditor iTextEditor = this.getEditor(iWorkbenchPart);
        if (iTextEditor != null && iTextEditor instanceof SplusEditor) {
            IBreakpoint iBreakpoint;
            IResource iResource = (IResource)iTextEditor.getEditorInput().getAdapter(IResource.class);
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            int n = iTextSelection.getStartLine();
            IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("com.insightful.splus.eclipse.debug");
            for (int i = 0; i < iBreakpointArray.length; ++i) {
                iBreakpoint = iBreakpointArray[i];
                if (!iResource.equals(iBreakpoint.getMarker().getResource()) || ((ILineBreakpoint)iBreakpoint).getLineNumber() != n + 1) continue;
                iBreakpoint.delete();
                return;
            }
            PObject pObject = ((SplusEditor)iTextEditor).getParseTree();
            this.clearAddress();
            if (this.findFirstLineNumber(pObject, n)) {
                iBreakpoint = pObject;
                PObject pObject2 = pObject;
                String string = "";
                String string2 = "";
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                for (n2 = 0; n2 < this.m_address.size(); ++n2) {
                    if (pObject.poGetMode().equals("function") && n4 != -1) {
                        PObject pObject3 = iBreakpoint.poGetElement(n4 - 1);
                        string = pObject3.poIsName() ? pObject3.poGetName() : pObject3.poGetStringElement(0);
                        if (string2.length() == 0) {
                            string2 = string;
                            n3 = n2;
                        }
                        pObject2 = iBreakpoint;
                        n5 = n4;
                    }
                    int n6 = (Integer)this.m_address.get(n2) - 1;
                    if (string2.length() == 0) {
                        // empty if block
                    }
                    iBreakpoint = pObject;
                    n4 = n6;
                    pObject = iBreakpoint.poGetElement(n4);
                }
                if (string.length() == 0) {
                    return;
                }
                if (string2.equals(string)) {
                    string2 = "";
                }
                long[] lArray = new long[this.m_address.size() - n3];
                int n7 = n3;
                int n8 = 0;
                while (n7 < this.m_address.size()) {
                    lArray[n8] = ((Integer)this.m_address.get(n7)).intValue();
                    ++n7;
                    ++n8;
                }
                while (string.startsWith("\"")) {
                    string = string.substring(1, string.length());
                }
                while (string.endsWith("\"")) {
                    string = string.substring(0, string.length() - 1);
                }
                new SplusDebugLineBreakpoint(iResource, n + 1, string, string2, lArray);
            } else {
                return;
            }
        }
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        return this.getEditor(iWorkbenchPart) != null && iSelection instanceof ITextSelection;
    }

    private ITextEditor getEditor(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof ITextEditor) {
            ITextEditor iTextEditor = (ITextEditor)iWorkbenchPart;
            return iTextEditor;
        }
        return null;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        return false;
    }
}

