/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.debug.ui.views;

import com.insightful.splus.SplusProfileHandler;
import com.insightful.splus.SplusWinSessionEvent;
import com.insightful.splus.SplusWinSessionListener;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.debug.connection.DebugConnection;
import com.insightful.splus.eclipse.debug.preferences.SplusProfilePreferencePage;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class FunctionCallView
extends ViewPart
implements IPropertyChangeListener {
    public static String ID = "com.insightful.splus.eclipse.debug.ui.FunctionCallView";
    private RefreshTimer m_refreshThread;
    private TreeViewer m_treeViewer;
    private TableViewer m_tableViewer;
    private Action m_refreshAction;
    private Action m_resetAction;
    private Action m_treeAction;
    private boolean m_showTree = true;
    private StackLayout m_layout;
    private Composite m_parent;
    private boolean m_alive = true;
    private final String NAME_COLUMN = "Function";
    private final String COUNT_COLUMN = "Call Count";
    private final String DURATION_COLUMN = "Duration (ms)";
    private String[] columnNames = new String[]{"Function", "Call Count", "Duration (ms)"};
    private int[] columnWidths = new int[]{125, 110, 125};
    private int m_sortColumn = -1;
    private int m_reverseSort = 1;

    public FunctionCallView() {
        this.m_refreshThread = new RefreshTimer();
        this.m_refreshThread.start();
        SplusEditorPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DebugConnection) {
            ((DebugConnection)noConnection).addSplusWinSessionListener(new SplusWinSessionListener(){

                public void eventOccurred(SplusWinSessionEvent splusWinSessionEvent) {
                    if (splusWinSessionEvent.getType() == 2) {
                        SplusProfileHandler.endAllFunctionCalls();
                    }
                }
            });
        }
    }

    public void dispose() {
        this.m_alive = false;
    }

    public void createPartControl(Composite composite) {
        this.m_parent = composite;
        this.m_layout = new StackLayout();
        composite.setLayout((Layout)this.m_layout);
        this.createTreeViewer(composite);
        this.createTableViewer(composite);
        this.setTreeVisible(true);
        this.createActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void setTreeVisible(boolean bl) {
        this.m_showTree = bl;
        this.m_layout.topControl = this.m_showTree ? this.m_treeViewer.getControl() : this.m_tableViewer.getControl();
        this.m_parent.layout();
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                if (FunctionCallView.this.m_treeAction != null) {
                    FunctionCallView.this.m_treeAction.setChecked(FunctionCallView.this.m_showTree);
                }
                FunctionCallView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.m_tableViewer.getControl());
        this.m_tableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.m_tableViewer);
        menu = menuManager.createContextMenu(this.m_treeViewer.getControl());
        this.m_treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.m_treeViewer);
    }

    private void createActions() {
        this.m_refreshAction = new Action(){

            public void run() {
                FunctionCallView.this.updateView();
            }
        };
        this.m_refreshAction.setToolTipText("Refresh Function Calls");
        this.m_refreshAction.setDescription("Refresh Function Calls");
        this.m_refreshAction.setText("Refresh Function Calls");
        this.m_resetAction = new Action(){

            public void run() {
                FunctionCallView.this.m_treeViewer.setInput(null);
                FunctionCallView.this.m_tableViewer.setInput(null);
                SplusProfileHandler.resetFunctionCalls();
                FunctionCallView.this.m_tableViewer.setInput((Object)FunctionCallView.this);
                FunctionCallView.this.m_treeViewer.setInput((Object)FunctionCallView.this);
                FunctionCallView.this.updateView();
            }
        };
        this.m_resetAction.setToolTipText("Reset Function Calls");
        this.m_resetAction.setDescription("Reset Function Calls");
        this.m_resetAction.setText("Reset Function Calls");
        this.m_treeAction = new Action(){

            public void run() {
                FunctionCallView.this.setTreeVisible(!FunctionCallView.this.m_showTree);
            }

            public int getStyle() {
                return 2;
            }
        };
        this.m_treeAction.setToolTipText("Show Function Tree");
        this.m_treeAction.setDescription("Show Function Tree");
        this.m_treeAction.setText("Show Function Tree");
        this.m_treeAction.setChecked(true);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IAction)this.m_treeAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.m_refreshAction);
        iMenuManager.add((IAction)this.m_resetAction);
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                iMenuManager.removeAll();
                FunctionCallView.this.fillContextMenu(iMenuManager);
            }
        });
        this.fillContextMenu(iMenuManager);
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
    }

    private void createTreeViewer(Composite composite) {
        this.m_treeViewer = new TreeViewer(composite);
        this.m_treeViewer.setContentProvider((IContentProvider)new FunctionCallTreeProvider());
        this.m_treeViewer.setInput((Object)this);
    }

    private void createTableViewer(Composite composite) {
        this.m_tableViewer = new TableViewer(composite);
        final Table table = this.m_tableViewer.getTable();
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setFont(SplusEditorPlugin.getDefaultFont((Display)composite.getDisplay()));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = table.indexOf((TableColumn)selectionEvent.widget);
                if (FunctionCallView.this.m_sortColumn == n) {
                    FunctionCallView.this.m_reverseSort = FunctionCallView.this.m_reverseSort * -1;
                } else {
                    FunctionCallView.this.m_sortColumn = n;
                    FunctionCallView.this.m_reverseSort = 1;
                }
                FunctionCallView.this.m_tableViewer.refresh();
            }
        };
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.createTableColumn(table, (SelectionListener)selectionAdapter, i);
        }
        this.m_tableViewer.setUseHashlookup(true);
        this.m_tableViewer.setColumnProperties(this.columnNames);
        this.m_tableViewer.setSorter((ViewerSorter)new SplusObjectSorter());
        this.m_tableViewer.setContentProvider((IContentProvider)new FunctionCallTableProvider());
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)new FunctionCallTableLabelProvider());
        this.m_tableViewer.setInput((Object)this);
    }

    private TableColumn createTableColumn(Table table, SelectionListener selectionListener, int n) {
        TableColumn tableColumn = new TableColumn(table, 0, n);
        tableColumn.setText(this.columnNames[n]);
        tableColumn.setWidth(this.columnWidths[n]);
        tableColumn.addSelectionListener(selectionListener);
        return tableColumn;
    }

    public void setFocus() {
        if (this.m_showTree) {
            this.m_treeViewer.getControl().setFocus();
        } else {
            this.m_tableViewer.getControl().setFocus();
        }
    }

    public boolean updateView() {
        if (this.m_alive && this.getSite() != null && this.getSite().getShell() != null) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    FunctionCallView.this.m_treeViewer.refresh(true);
                    FunctionCallView.this.m_tableViewer.refresh(true);
                }
            });
        }
        return this.m_alive;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (string.equals(SplusProfilePreferencePage.REFRESH_RATE)) {
            this.m_refreshThread.setTimerIncrement(SplusProfilePreferencePage.getRefreshRate());
        }
    }

    private class RefreshTimer
    extends Thread {
        private int m_increment = 5;

        public void setTimerIncrement(int n) {
            this.m_increment = n;
        }

        public void run() {
            do {
                try {
                    Thread.sleep(this.m_increment * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (FunctionCallView.this.updateView());
        }
    }

    public class SplusObjectSorter
    extends ViewerSorter {
        public int compare(Viewer viewer, Object object, Object object2) {
            if (FunctionCallView.this.m_sortColumn != -1 && object instanceof Vector && object2 instanceof Vector) {
                String string = (String)((Vector)object).get(FunctionCallView.this.m_sortColumn);
                String string2 = (String)((Vector)object2).get(FunctionCallView.this.m_sortColumn);
                try {
                    double d = Double.parseDouble(string);
                    double d2 = Double.parseDouble(string2);
                    if (d == d2) {
                        return 0;
                    }
                    if (d > d2) {
                        return 1 * FunctionCallView.this.m_reverseSort;
                    }
                    return -1 * FunctionCallView.this.m_reverseSort;
                }
                catch (NumberFormatException numberFormatException) {
                    return string.compareTo(string2) * FunctionCallView.this.m_reverseSort;
                }
            }
            return super.compare(viewer, object, object2);
        }
    }

    public class FunctionCallTableLabelProvider
    implements ITableLabelProvider {
        private Vector m_listeners = new Vector();

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof Vector && ((Vector)object).size() > n) {
                return (String)((Vector)object).get(n);
            }
            return "";
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return true;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
            this.m_listeners.add(iLabelProviderListener);
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
            this.m_listeners.remove(iLabelProviderListener);
        }
    }

    public class FunctionCallTableProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object object) {
            Set set = SplusProfileHandler.getFunctionCallSet();
            Object[] objectArray = set.toArray();
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                String string = (String)objectArray[i];
                Vector<String> vector = new Vector<String>();
                vector.add(string);
                vector.add(Integer.toString(SplusProfileHandler.getFunctionCallCount((Object)string)));
                vector.add(Integer.toString(SplusProfileHandler.getFunctionCallTime((Object)string)));
                objectArray2[i] = vector;
            }
            return objectArray2;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            if (object2 != null) {
                viewer.refresh();
            }
        }

        public void dispose() {
        }
    }

    private class FunctionCallTreeProvider
    implements ITreeContentProvider {
        private FunctionCallTreeProvider() {
        }

        public Object[] getElements(Object object) {
            TreeModel treeModel = SplusProfileHandler.getFunctionTreeModel();
            return this.getChildren(treeModel.getRoot());
        }

        public Object[] getChildren(Object object) {
            TreeModel treeModel = SplusProfileHandler.getFunctionTreeModel();
            Vector<Object> vector = new Vector<Object>();
            for (int i = 0; i < treeModel.getChildCount(object); ++i) {
                Object object2 = treeModel.getChild(object, i);
                String string = SplusProfileHandler.getTreeNodeName((DefaultMutableTreeNode)((DefaultMutableTreeNode)object2));
                if (string.length() == 0) {
                    Object[] objectArray = this.getChildren(object2);
                    for (int j = 0; j < objectArray.length; ++j) {
                        vector.add(objectArray[j]);
                    }
                    continue;
                }
                vector.add(object2);
            }
            Object[] objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        public Object getParent(Object object) {
            if (object instanceof TreeNode) {
                return ((TreeNode)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            return this.getChildren(object).length != 0;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            if (object2 != null) {
                viewer.refresh();
            }
        }
    }
}

