/*
 * Decompiled with CFR 0.152.
 */
import com.insightful.splus.SplusDataResult;
import ejbsplus.SplusEngine;
import ejbsplus.SplusEngineClient;
import ejbsplus.SplusEngineHome;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class QueryTester
extends JFrame {
    String ejbHost = null;
    QueryTesterProxy proxy = null;
    SplusEngine engine = null;
    JFrame m_helpFrame = null;
    JTextArea m_splusInput = new JTextArea();
    JTextArea m_splusOutput = new JTextArea();
    String m_helpText = "Type an S-PLUS expression in the \"S-PLUS input\" field, and click the \"send to S-PLUS\" button to evaluate the expression, showing the output in the \"S-PLUS output\" window.\n\n";
    static String usage = "Usage: $JAVA_HOME/bin/java QueryTester hostname:port\n\nwhere:\n  hostname = the host running the EJB container (jboss)\n  port = RMI port that the EJB container is running on\n\nexample:  /usr/bin/java QueryTester apple:1099";

    public QueryTester(String string) {
        super("Query Tester Example");
        this.ejbHost = string;
        try {
            this.proxy = new QueryTesterProxy(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        JScrollPane jScrollPane = new JScrollPane(this.m_splusInput, 22, 32);
        JScrollPane jScrollPane2 = new JScrollPane(this.m_splusOutput, 22, 32);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("S-PLUS input"));
        jScrollPane2.setBorder(BorderFactory.createTitledBorder("S-PLUS output"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jScrollPane);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(jScrollPane2);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(this.newButton("send to S-PLUS", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QueryTester.this.m_splusOutput.setText("sending command to splus...");
                Thread thread = new Thread(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        1.access$000(this.this$1).doSplusExpression();
                    }
                };
                thread.start();
            }

            static /* synthetic */ QueryTester access$000(1 var0) {
                return var0.QueryTester.this;
            }
        }));
        jPanel2.add(this.newButton("clear input", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QueryTester.this.m_splusInput.setText("");
            }
        }));
        jPanel2.add(this.newButton("help", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (QueryTester.this.m_helpFrame != null) {
                    QueryTester.this.m_helpFrame.dispose();
                    QueryTester.this.m_helpFrame = null;
                }
                QueryTester.this.m_helpFrame = new JFrame("Help");
                QueryTester.this.m_helpFrame.getContentPane().setLayout(new BorderLayout());
                JTextArea jTextArea = new JTextArea(QueryTester.this.m_helpText);
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                JScrollPane jScrollPane = new JScrollPane(jTextArea, 22, 31);
                QueryTester.this.m_helpFrame.getContentPane().add((Component)jScrollPane, "Center");
                ((Component)QueryTester.this.m_helpFrame).setSize(300, 200);
                ((Component)QueryTester.this.m_helpFrame).setVisible(true);
                jScrollPane.getViewport().setViewPosition(new Point(0, 0));
            }
        }));
        jPanel2.add(this.newButton("quit", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        }));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(5, 5));
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        ((Component)this).setSize(600, 400);
        this.show();
    }

    public JButton newButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public void doSplusExpression() {
        String string = "";
        String string2 = string + this.m_splusInput.getText();
        try {
            SplusDataResult splusDataResult = this.getSession().eval(string2, (SplusEngineClient)this.proxy);
            if (splusDataResult != null) {
                if (splusDataResult.hasOutput()) {
                    string = string + splusDataResult.getOutput() + "\n\n";
                }
                if (splusDataResult.hasError()) {
                    string = string + splusDataResult.getError();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string.length() < 1) {
            string = string + "no output";
        }
        this.m_splusOutput.setText(string);
    }

    public SplusEngine getSession() {
        if (this.engine == null) {
            try {
                Properties properties = new Properties();
                properties.setProperty("java.naming.provider.url", this.ejbHost);
                properties.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                properties.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming");
                InitialContext initialContext = new InitialContext(properties);
                SplusEngineHome splusEngineHome = (SplusEngineHome)initialContext.lookup("SplusEngine");
                this.engine = splusEngineHome.create();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.engine;
    }

    public String[] getLoginData() {
        final String[] stringArray = new String[]{"", "", ""};
        final JDialog jDialog = new JDialog();
        jDialog.setTitle("Login");
        jDialog.setModal(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 2, 10, 10));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(new JLabel("S-PLUS Host:"));
        final JTextField jTextField = new JTextField();
        jPanel.add(jTextField);
        jPanel.add(new JLabel("User Name:"));
        final JTextField jTextField2 = new JTextField();
        jPanel.add(jTextField2);
        jPanel.add(new JLabel("Password:"));
        final JPasswordField jPasswordField = new JPasswordField();
        jPanel.add(jPasswordField);
        final JButton jButton = new JButton("Login");
        final JButton jButton2 = new JButton("Cancel");
        JPanel jPanel2 = new JPanel();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton3 = (JButton)actionEvent.getSource();
                if (jButton3 == jButton) {
                    stringArray[0] = jTextField.getText();
                    stringArray[1] = jTextField2.getText();
                    char[] cArray = jPasswordField.getPassword();
                    if (cArray != null && cArray.length > 0) {
                        stringArray[2] = new String(cArray);
                    }
                    int n = 1;
                    while (n < cArray.length) {
                        cArray[n] = '\u0000';
                        ++n;
                    }
                    if (stringArray[0] == null || stringArray[0].length() == 0 || stringArray[1] == null || stringArray[1].length() == 0 || stringArray[2] == null || stringArray[2].length() == 0) {
                        JOptionPane.showMessageDialog(jDialog, "All entries are required.", "Required Field Error", 2);
                        return;
                    }
                    jDialog.dispose();
                } else if (jButton3 == jButton2) {
                    jDialog.dispose();
                }
            }
        };
        jButton.addActionListener(actionListener);
        jPanel2.add(jButton);
        jButton2.addActionListener(actionListener);
        jPanel2.add(jButton2);
        jDialog.getContentPane().add((Component)jPanel, "Center");
        jDialog.getContentPane().add((Component)jPanel2, "South");
        jDialog.pack();
        Dimension dimension = jDialog.getSize();
        Dimension dimension2 = jDialog.getToolkit().getScreenSize();
        ((Component)jDialog).setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        jDialog.setResizable(false);
        jDialog.show();
        while (jDialog.isShowing()) {
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Argument is required:\n\n");
            System.out.println(usage);
            System.exit(0);
        }
        new QueryTester(stringArray[0]);
    }
}

