/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class JGo3DNoteRect
extends JGoRectangle {
    public static final int ChangedShadowSize = 401;
    public static final int ChangedFlapSize = 402;
    private int myShadowSize = 4;
    private int myFlapSize = 8;

    public JGo3DNoteRect() {
    }

    public JGo3DNoteRect(Rectangle rectangle) {
        super(rectangle);
    }

    public JGo3DNoteRect(Point point, Dimension dimension) {
        super(point, dimension);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        JGo3DNoteRect jGo3DNoteRect = (JGo3DNoteRect)super.copyObject(jGoCopyEnvironment);
        if (jGo3DNoteRect != null) {
            jGo3DNoteRect.myShadowSize = this.myShadowSize;
            jGo3DNoteRect.myFlapSize = this.myFlapSize;
        }
        return jGo3DNoteRect;
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        Rectangle rectangle = this.getBoundingRect();
        int n = this.getShadowSize();
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width - n;
        int n5 = rectangle.height - n;
        this.drawRect(graphics2D, n2, n3, n4, n5);
        int[] nArray = jGoView.\u00cc();
        int[] nArray2 = jGoView.\u00cd();
        nArray[0] = n2 + n4;
        nArray2[0] = n3;
        nArray[1] = rectangle.x + rectangle.width;
        nArray2[1] = rectangle.y + n;
        nArray[2] = rectangle.x + rectangle.width;
        nArray2[2] = rectangle.y + rectangle.height;
        nArray[3] = rectangle.x + n;
        nArray2[3] = rectangle.y + rectangle.height;
        nArray[4] = n2;
        nArray2[4] = n3 + n5;
        nArray[5] = n2 + n4;
        nArray2[5] = n3 + n5;
        graphics2D.setColor(Color.lightGray);
        graphics2D.fillPolygon(nArray, nArray2, 6);
        int n6 = this.getFlapSize();
        nArray[0] = n2 + n4 - n6;
        nArray2[0] = n3 + n5;
        nArray[1] = n2 + n4 - n6 * 7 / 8;
        nArray2[1] = n3 + n5 - n6 * 7 / 8;
        nArray[2] = n2 + n4;
        nArray2[2] = n3 + n5 - n6;
        int n7 = Color.gray.getRed();
        int n8 = Color.gray.getGreen();
        int n9 = Color.gray.getBlue();
        graphics2D.setColor(new Color(n7, n8, n9, 192));
        graphics2D.fillPolygon(nArray, nArray2, 3);
    }

    public int getShadowSize() {
        return this.myShadowSize;
    }

    public void setShadowSize(int n) {
        int n2 = this.getShadowSize();
        if (n2 != n) {
            this.myShadowSize = Math.max(n, 0);
            this.update(401, n2, null);
        }
    }

    public int getFlapSize() {
        return this.myFlapSize;
    }

    public void setFlapSize(int n) {
        int n2 = this.getFlapSize();
        if (n2 != n) {
            this.myFlapSize = Math.max(n, 0);
            this.update(402, n2, null);
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 401: {
                jGoDocumentChangedEdit.setNewValueInt(this.getShadowSize());
                return;
            }
            case 402: {
                jGoDocumentChangedEdit.setNewValueInt(this.getFlapSize());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 401: {
                this.setShadowSize(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
            case 402: {
                this.setFlapSize(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }
}

