/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoView;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class JGoGridView
extends JGoView {
    public static final int GridInvisible = 0;
    public static final int GridDot = 1;
    public static final int GridCross = 2;
    public static final int GridLine = 3;
    public static final int NoSnap = 0;
    public static final int SnapJump = 1;
    public static final int SnapAfter = 2;
    public static final int ChangedDimensions = 0;
    public static final int ChangedStyle = 1;
    public static final int ChangedSpot = 2;
    public static final int ChangedSnapMove = 3;
    public static final int ChangedSnapResize = 4;
    public static final int ChangedPen = 5;
    public static final int ChangedOrigin = 6;
    private int \u0161 = 50;
    private int \u0162 = 50;
    private int \u0163 = 0;
    private int \u0164 = 1;
    private Point \u0165 = new Point();
    private JGoPen \u0166 = JGoPen.lightGray;
    private int \u0167 = 0;
    private int \u0168 = 0;

    public JGoGridView() {
    }

    public JGoGridView(JGoDocument jGoDocument) {
        super(jGoDocument);
    }

    public void setGridWidth(int n) {
        if (n != this.\u0161) {
            this.\u0161 = n;
            if (this.getHorizontalScrollBar() != null) {
                this.getHorizontalScrollBar().setUnitIncrement(this.getGridWidth());
            }
            this.onGridChange(0);
        }
    }

    public int getGridWidth() {
        return this.\u0161;
    }

    public void setGridHeight(int n) {
        if (n != this.\u0162) {
            this.\u0162 = n;
            if (this.getVerticalScrollBar() != null) {
                this.getVerticalScrollBar().setUnitIncrement(this.getGridHeight());
            }
            this.onGridChange(0);
        }
    }

    public int getGridHeight() {
        return this.\u0162;
    }

    public void setGridStyle(int n) {
        if (n != this.\u0163) {
            this.\u0163 = n;
            this.onGridChange(1);
        }
    }

    public int getGridStyle() {
        return this.\u0163;
    }

    public void setGridOrigin(Point point) {
        if (!point.equals(this.\u0165)) {
            this.\u0165.x = point.x;
            this.\u0165.y = point.y;
            this.onGridChange(6);
        }
    }

    public Point getGridOrigin() {
        return this.\u0165;
    }

    public void setGridSpot(int n) {
        if (n != this.\u0164) {
            this.\u0164 = n;
            this.onGridChange(2);
        }
    }

    public int getGridSpot() {
        return this.\u0164;
    }

    public void setGridPen(JGoPen jGoPen) {
        if (this.\u0166 != jGoPen) {
            this.\u0166 = jGoPen;
            this.onGridChange(5);
        }
    }

    public JGoPen getGridPen() {
        return this.\u0166;
    }

    public int getSnapMove() {
        return this.\u0167;
    }

    public void setSnapMove(int n) {
        if (this.\u0167 != n) {
            this.\u0167 = n;
            this.onGridChange(3);
        }
    }

    public int getSnapResize() {
        return this.\u0168;
    }

    public void setSnapResize(int n) {
        if (this.\u0168 != n) {
            this.\u0168 = n;
            this.onGridChange(4);
        }
    }

    public void onGridChange(int n) {
        this.fireUpdate(100, n, null);
    }

    protected void paintBackgroundDecoration(Graphics2D graphics2D, Rectangle rectangle) {
        switch (this.getGridStyle()) {
            case 0: {
                break;
            }
            case 3: {
                this.drawGridLines(graphics2D, rectangle);
                break;
            }
            case 1: {
                this.drawGridCrosses(graphics2D, 1, 1, rectangle);
                break;
            }
            case 2: {
                this.drawGridCrosses(graphics2D, 6, 6, rectangle);
            }
        }
    }

    protected void drawGridLines(Graphics2D graphics2D, Rectangle rectangle) {
        int n = this.getGridWidth();
        int n2 = this.getGridHeight();
        JGoPen jGoPen = this.getGridPen();
        int n3 = rectangle.x - n;
        int n4 = rectangle.y - n2;
        int n5 = rectangle.x + rectangle.width + n;
        int n6 = rectangle.y + rectangle.height + n2;
        Point point = this.findNearestGridPoint(n3, n4, null);
        Point point2 = this.findNearestGridPoint(n5, n6, null);
        int n7 = point.x;
        while (n7 < point2.x) {
            JGoDrawable.drawLine(graphics2D, jGoPen, n7, rectangle.y, n7, rectangle.y + rectangle.height);
            n7 += n;
        }
        int n8 = point.y;
        while (n8 < point2.y) {
            JGoDrawable.drawLine(graphics2D, jGoPen, rectangle.x, n8, rectangle.x + rectangle.width, n8);
            n8 += n2;
        }
    }

    protected void drawGridCrosses(Graphics2D graphics2D, int n, int n2, Rectangle rectangle) {
        int n3 = this.getGridWidth();
        int n4 = this.getGridHeight();
        JGoPen jGoPen = this.getGridPen();
        int n5 = rectangle.x - n3;
        int n6 = rectangle.y - n4;
        int n7 = rectangle.x + rectangle.width + n3;
        int n8 = rectangle.y + rectangle.height + n4;
        Point point = this.findNearestGridPoint(n5, n6, null);
        Point point2 = this.findNearestGridPoint(n7, n8, null);
        if (n < 2 && n2 < 2) {
            int n9 = 0;
            if (this.getScale() > 1.0) {
                n9 = 1;
            }
            int n10 = point.x;
            while (n10 < point2.x) {
                int n11 = point.y;
                while (n11 < point2.y) {
                    JGoDrawable.drawEllipse(graphics2D, jGoPen, null, n10, n11, n9, n9);
                    n11 += n4;
                }
                n10 += n3;
            }
        } else {
            int n12 = point.x;
            while (n12 < point2.x) {
                int n13 = point.y;
                while (n13 < point2.y) {
                    JGoDrawable.drawLine(graphics2D, jGoPen, n12, n13 - n / 2, n12, n13 + n / 2);
                    JGoDrawable.drawLine(graphics2D, jGoPen, n12 - n2 / 2, n13, n12 + n2 / 2, n13);
                    n13 += n4;
                }
                n12 += n3;
            }
        }
    }

    public void doLayout() {
        if (this.getHorizontalScrollBar() != null) {
            this.getHorizontalScrollBar().setUnitIncrement(this.getGridWidth());
        }
        if (this.getVerticalScrollBar() != null) {
            this.getVerticalScrollBar().setUnitIncrement(this.getGridHeight());
        }
        super.doLayout();
    }

    public void moveSelection(JGoSelection jGoSelection, int n, int n2, int n3, int n4) {
        int n5 = this.getSnapMove();
        if (n5 == 1 || n5 == 2 && n4 == 3) {
            Vector<JGoObject> vector = null;
            JGoListPosition jGoListPosition = jGoSelection.getFirstObjectPos();
            Point point = new Point();
            int n6 = this.getGridSpot();
            while (jGoListPosition != null) {
                JGoObject jGoObject = jGoSelection.getObjectAtPos(jGoListPosition);
                jGoListPosition = jGoSelection.getNextObjectPos(jGoListPosition);
                if (!jGoObject.isDraggable()) continue;
                JGoObject jGoObject2 = jGoObject.getTopLevelObject();
                if (jGoObject2 != jGoObject) {
                    if (jGoSelection.isSelected(jGoObject2) || vector != null && vector.contains(jGoObject2)) continue;
                    if (vector == null) {
                        vector = new Vector<JGoObject>();
                    }
                    vector.add(jGoObject2);
                }
                Point point2 = jGoObject2.getSpotLocation(n6, point);
                int n7 = point2.x + n2;
                int n8 = point2.y + n3;
                this.findNearestGridPoint(n7, n8, point);
                jGoObject2.setSpotLocation(n6, point);
            }
        } else {
            super.moveSelection(jGoSelection, n, n2, n3, n4);
        }
    }

    public void handleResizing(Graphics2D graphics2D, Point point, Point point2, int n) {
        Point point3;
        Point point4;
        int n2 = this.getSnapResize();
        if (n2 == 1 || n2 == 2 && n == 3) {
            point4 = this.findNearestGridPoint(point2.x, point2.y, null);
            point3 = this.docToViewCoords(point4);
        } else {
            point4 = point2;
            point3 = point;
        }
        super.handleResizing(graphics2D, point3, point4, n);
    }

    public void snapObject(JGoObject jGoObject) {
        this.snapObject(jGoObject, this.getGridSpot());
    }

    public void snapObject(JGoObject jGoObject, int n) {
        Point point = jGoObject.getSpotLocation(n);
        Point point2 = this.findNearestGridPoint(point.x, point.y, point);
        jGoObject.setSpotLocation(n, point2);
    }

    public void snapAllObjects() {
        this.snapAllObjects(this.getGridSpot());
    }

    public void snapAllObjects(int n) {
        JGoDocument jGoDocument = this.getDocument();
        JGoListPosition jGoListPosition = jGoDocument.getFirstObjectPos();
        while (jGoListPosition != null) {
            JGoObject jGoObject = jGoDocument.getObjectAtPos(jGoListPosition);
            jGoListPosition = jGoDocument.getNextObjectPosAtTop(jGoListPosition);
            this.snapObject(jGoObject, n);
        }
    }

    public Point findNearestGridPoint(int n, int n2, Point point) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Point point2 = this.getGridOrigin();
        int n9 = point2.x;
        int n10 = point2.y;
        int n11 = this.getGridWidth();
        int n12 = this.getGridHeight();
        int n13 = n - n9;
        if (n13 < 0) {
            n13 -= n11;
        }
        n13 = n13 / n11 * n11 + n9;
        int n14 = n2 - n10;
        if (n14 < 0) {
            n14 -= n12;
        }
        n14 = n14 / n12 * n12 + n10;
        int n15 = (n - n13) * (n - n13) + (n2 - n14) * (n2 - n14);
        int n16 = n13;
        int n17 = n14;
        int n18 = n13 + n11;
        int n19 = n14;
        int n20 = (n - n18) * (n - n18) + (n2 - n19) * (n2 - n19);
        if (n20 < n15) {
            n15 = n20;
            n16 = n18;
            n17 = n19;
        }
        if ((n8 = (n - (n7 = n13)) * (n - n7) + (n2 - (n6 = n14 + n12)) * (n2 - n6)) < n15) {
            n15 = n8;
            n16 = n7;
            n17 = n6;
        }
        if ((n5 = (n - (n4 = n18)) * (n - n4) + (n2 - (n3 = n6)) * (n2 - n3)) < n15) {
            n16 = n4;
            n17 = n3;
        }
        if (point == null) {
            return new Point(n16, n17);
        }
        point.x = n16;
        point.y = n17;
        return point;
    }
}

