/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoHandle;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObjList;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectSimpleCollection;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class JGoSelection
implements JGoObjectSimpleCollection,
Transferable,
Serializable {
    private JGoObjList mySelectedObjects = new JGoObjList();
    private HashMap myHandles = new HashMap();
    private transient JGoView myView = null;
    private JGoPen myBoundingHandlePen = null;
    private JGoPen myResizeHandlePen = JGoPen.black;
    private JGoBrush myResizeHandleBrush = null;
    private boolean myResizeHandleSizeInViewCoords = false;

    public JGoSelection() {
        this.myView = null;
    }

    public JGoSelection(JGoView jGoView) {
        this.myView = jGoView;
    }

    public final JGoView getView() {
        return this.myView;
    }

    public int getNumObjects() {
        return this.mySelectedObjects.getNumObjects();
    }

    public boolean isEmpty() {
        return this.mySelectedObjects.isEmpty();
    }

    public JGoListPosition getFirstObjectPos() {
        return this.mySelectedObjects.getFirstObjectPos();
    }

    public JGoObject getObjectAtPos(JGoListPosition jGoListPosition) {
        return this.mySelectedObjects.getObjectAtPos(jGoListPosition);
    }

    public JGoListPosition getNextObjectPos(JGoListPosition jGoListPosition) {
        return this.mySelectedObjects.getNextObjectPos(jGoListPosition);
    }

    public JGoListPosition getNextObjectPosAtTop(JGoListPosition jGoListPosition) {
        return this.mySelectedObjects.getNextObjectPos(jGoListPosition);
    }

    public JGoObject getPrimarySelection() {
        JGoListPosition jGoListPosition = this.mySelectedObjects.getFirstObjectPos();
        if (jGoListPosition == null) {
            return null;
        }
        return this.mySelectedObjects.getObjectAtPos(jGoListPosition);
    }

    public JGoObject selectObject(JGoObject jGoObject) {
        if (jGoObject == null) {
            return null;
        }
        if (this.getPrimarySelection() == jGoObject && this.getNumObjects() == 1) {
            return jGoObject;
        }
        this.clearSelection();
        return this.extendSelection(jGoObject);
    }

    public JGoObject extendSelection(JGoObject jGoObject) {
        if (jGoObject == null) {
            return null;
        }
        if ((jGoObject = jGoObject.redirectSelection()) == null) {
            return null;
        }
        if (!this.isSelected(jGoObject)) {
            this.\u0128(jGoObject);
        }
        return jGoObject;
    }

    public JGoObject toggleSelection(JGoObject jGoObject) {
        if (jGoObject == null) {
            return null;
        }
        if ((jGoObject = jGoObject.redirectSelection()) == null) {
            return null;
        }
        if (this.isSelected(jGoObject)) {
            this.\u0129(jGoObject);
        } else {
            this.\u0128(jGoObject);
        }
        return jGoObject;
    }

    public void clearSelection(JGoObject jGoObject) {
        if (jGoObject == null) {
            this.clearSelection();
            return;
        }
        if ((jGoObject = jGoObject.redirectSelection()) == null) {
            return;
        }
        if (this.isSelected(jGoObject)) {
            this.\u0129(jGoObject);
        }
    }

    public void clearSelection() {
        JGoView jGoView = this.getView();
        JGoListPosition jGoListPosition = this.mySelectedObjects.getFirstObjectPos();
        while (jGoListPosition != null) {
            JGoObject jGoObject = this.mySelectedObjects.getObjectAtPos(jGoListPosition);
            this.mySelectedObjects.removeObjectAtPos(jGoListPosition);
            jGoObject.lostSelection(this);
            if (jGoView != null) {
                jGoView.fireUpdate(6, 0, jGoObject);
            }
            this.myHandles.remove(jGoObject);
            jGoListPosition = this.mySelectedObjects.getFirstObjectPos();
        }
    }

    public boolean isInSelection(JGoObject jGoObject) {
        if (jGoObject == null) {
            return false;
        }
        if ((jGoObject = jGoObject.redirectSelection()) == null) {
            return false;
        }
        return this.isSelected(jGoObject);
    }

    public boolean isSelected(JGoObject jGoObject) {
        return this.myHandles.containsKey(jGoObject);
    }

    private void \u0128(JGoObject jGoObject) {
        this.mySelectedObjects.addObjectAtTail(jGoObject);
        this.myHandles.put(jGoObject, null);
        JGoView jGoView = this.getView();
        jGoObject.gainedSelection(this);
        if (jGoView != null) {
            jGoView.fireUpdate(5, 0, jGoObject);
        }
    }

    private void \u0129(JGoObject jGoObject) {
        JGoObject jGoObject2 = this.getPrimarySelection();
        this.mySelectedObjects.removeObject(jGoObject);
        JGoView jGoView = this.getView();
        jGoObject.lostSelection(this);
        if (jGoView != null) {
            jGoView.fireUpdate(6, 0, jGoObject);
        }
        this.myHandles.remove(jGoObject);
        if (jGoObject2 == jGoObject && (jGoObject2 = this.getPrimarySelection()) != null) {
            jGoObject2.lostSelection(this);
            if (jGoView != null) {
                jGoView.fireUpdate(6, 0, jGoObject2);
            }
            jGoObject2.gainedSelection(this);
            if (jGoView != null) {
                jGoView.fireUpdate(5, 0, jGoObject2);
            }
        }
    }

    public void clearSelectionHandles(JGoObject jGoObject) {
        if (jGoObject != null) {
            jGoObject.hideSelectionHandles(this);
        } else {
            JGoListPosition jGoListPosition = this.mySelectedObjects.getFirstObjectPos();
            while (jGoListPosition != null) {
                jGoObject = this.mySelectedObjects.getObjectAtPos(jGoListPosition);
                jGoListPosition = this.mySelectedObjects.getNextObjectPos(jGoListPosition);
                jGoObject.hideSelectionHandles(this);
            }
        }
    }

    public void restoreSelectionHandles(JGoObject jGoObject) {
        if (jGoObject != null) {
            if (this.isSelected(jGoObject) && jGoObject.isVisible()) {
                jGoObject.showSelectionHandles(this);
            }
        } else {
            JGoListPosition jGoListPosition = this.mySelectedObjects.getFirstObjectPos();
            while (jGoListPosition != null) {
                jGoObject = this.mySelectedObjects.getObjectAtPos(jGoListPosition);
                jGoListPosition = this.mySelectedObjects.getNextObjectPos(jGoListPosition);
                if (!jGoObject.isVisible()) continue;
                jGoObject.showSelectionHandles(this);
            }
        }
    }

    public void showHandles(JGoObject jGoObject) {
        Object v = this.myHandles.get(jGoObject);
        if (v == null) {
            return;
        }
        JGoView jGoView = this.getView();
        if (jGoView != null) {
            if (v instanceof Vector) {
                Vector vector = (Vector)v;
                int n = 0;
                while (n < vector.size()) {
                    JGoHandle jGoHandle = (JGoHandle)vector.elementAt(n);
                    jGoHandle.setVisible(true);
                    ++n;
                }
            } else {
                JGoHandle jGoHandle = (JGoHandle)v;
                jGoHandle.setVisible(true);
            }
        }
    }

    public void hideHandles(JGoObject jGoObject) {
        Object v = this.myHandles.get(jGoObject);
        if (v == null) {
            return;
        }
        JGoView jGoView = this.getView();
        if (jGoView != null) {
            if (v instanceof Vector) {
                Vector vector = (Vector)v;
                int n = 0;
                while (n < vector.size()) {
                    JGoHandle jGoHandle = (JGoHandle)vector.elementAt(n);
                    jGoHandle.setVisible(false);
                    ++n;
                }
            } else {
                JGoHandle jGoHandle = (JGoHandle)v;
                jGoHandle.setVisible(false);
            }
        }
    }

    public JGoHandle createBoundingHandle(JGoObject jGoObject) {
        JGoView jGoView = this.getView();
        Rectangle rectangle = jGoView != null ? jGoView.\u00cf() : new Rectangle();
        rectangle.setBounds(jGoObject.getBoundingRect());
        rectangle.grow(1, 1);
        JGoHandle jGoHandle = new JGoHandle(rectangle, 0);
        jGoHandle.setHandleType(-1);
        jGoHandle.setSelectable(false);
        Color color = jGoView != null ? (this.getPrimarySelection() == jGoObject ? jGoView.getPrimarySelectionColor() : jGoView.getSecondarySelectionColor()) : Color.black;
        if (this.myBoundingHandlePen == null || !this.myBoundingHandlePen.getColor().equals(color)) {
            this.myBoundingHandlePen = JGoPen.make(65535, 2, color);
        }
        jGoHandle.setPen(this.myBoundingHandlePen);
        jGoHandle.setBrush(null);
        this.addHandle(jGoObject, jGoHandle);
        return jGoHandle;
    }

    public boolean isResizeHandleSizeInViewCoords() {
        return this.myResizeHandleSizeInViewCoords;
    }

    public void setResizeHandleSizeInViewCoords(boolean bl) {
        this.myResizeHandleSizeInViewCoords = bl;
    }

    public JGoHandle allocateResizeHandle(JGoObject jGoObject, int n, int n2, int n3) {
        Serializable serializable;
        JGoView jGoView = this.getView();
        Rectangle rectangle = jGoView != null ? jGoView.\u00cf() : new Rectangle();
        rectangle.width = JGoHandle.getDefaultHandleWidth();
        rectangle.height = JGoHandle.getDefaultHandleHeight();
        if (this.isResizeHandleSizeInViewCoords() && jGoView != null && jGoView.getScale() != 1.0) {
            serializable = jGoView.\u00ce();
            serializable.setSize(rectangle.width, rectangle.height);
            jGoView.convertViewToDoc((Dimension)serializable);
            rectangle.width = serializable.width;
            if (rectangle.width < 2) {
                rectangle.width = 2;
            }
            rectangle.height = serializable.height;
            if (rectangle.height < 2) {
                rectangle.height = 2;
            }
        }
        rectangle.x = n - rectangle.width / 2;
        rectangle.y = n2 - rectangle.height / 2;
        serializable = new JGoHandle(rectangle, 0);
        return serializable;
    }

    public JGoHandle createResizeHandle(JGoObject jGoObject, int n, int n2, int n3, boolean bl) {
        JGoView jGoView = this.getView();
        JGoHandle jGoHandle = this.allocateResizeHandle(jGoObject, n, n2, n3);
        jGoHandle.setHandleType(n3);
        if (n3 == -1) {
            jGoHandle.setSelectable(false);
        } else {
            jGoHandle.setSelectable(true);
        }
        jGoHandle.setPen(this.myResizeHandlePen);
        if (bl) {
            Color color = jGoView != null ? (this.getPrimarySelection() == jGoObject ? jGoView.getPrimarySelectionColor() : jGoView.getSecondarySelectionColor()) : Color.black;
            if (this.myResizeHandleBrush == null || !this.myResizeHandleBrush.getColor().equals(color)) {
                this.myResizeHandleBrush = JGoBrush.make(65535, color);
            }
            jGoHandle.setBrush(this.myResizeHandleBrush);
        } else {
            jGoHandle.setBrush(null);
        }
        this.addHandle(jGoObject, jGoHandle);
        return jGoHandle;
    }

    public void addHandle(JGoObject jGoObject, JGoHandle jGoHandle) {
        jGoHandle.setHandleFor(jGoObject);
        Object v = this.myHandles.get(jGoObject);
        if (v == null) {
            this.myHandles.put(jGoObject, jGoHandle);
        } else if (v instanceof Vector) {
            Vector vector = (Vector)v;
            vector.addElement(jGoHandle);
        } else {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(v);
            vector.addElement(jGoHandle);
            this.myHandles.put(jGoObject, vector);
        }
        if (this.getView() != null) {
            this.getView().addObjectAtHead(jGoHandle);
        }
    }

    public void deleteHandles(JGoObject jGoObject) {
        Object v = this.myHandles.get(jGoObject);
        if (v == null) {
            return;
        }
        JGoView jGoView = this.getView();
        if (jGoView != null) {
            if (v instanceof Vector) {
                Vector vector = (Vector)v;
                int n = 0;
                while (n < vector.size()) {
                    JGoHandle jGoHandle = (JGoHandle)vector.elementAt(n);
                    jGoView.removeObject(jGoHandle);
                    ++n;
                }
            } else {
                JGoHandle jGoHandle = (JGoHandle)v;
                jGoView.removeObject(jGoHandle);
            }
        }
        this.myHandles.put(jGoObject, null);
    }

    public int getNumHandles(JGoObject jGoObject) {
        Object v = this.myHandles.get(jGoObject);
        if (v == null) {
            return 0;
        }
        if (v instanceof Vector) {
            Vector vector = (Vector)v;
            return vector.size();
        }
        return 1;
    }

    public DataFlavor[] getTransferDataFlavors() {
        JGoDocument jGoDocument = this.getDocument();
        if (jGoDocument != null) {
            return jGoDocument.getTransferDataFlavors();
        }
        return new DataFlavor[0];
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        JGoDocument jGoDocument = this.getDocument();
        if (jGoDocument != null) {
            return jGoDocument.isDataFlavorSupported(dataFlavor);
        }
        return false;
    }

    public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(dataFlavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    private JGoDocument getDocument() {
        JGoDocument jGoDocument = null;
        if (this.getView() != null) {
            jGoDocument = this.getView().getDocument();
        } else {
            JGoListPosition jGoListPosition = this.mySelectedObjects.getFirstObjectPos();
            while (jGoListPosition != null) {
                JGoObject jGoObject = this.mySelectedObjects.getObjectAtPos(jGoListPosition);
                jGoListPosition = this.mySelectedObjects.getNextObjectPos(jGoListPosition);
                jGoDocument = jGoObject.getDocument();
                if (jGoDocument != null) break;
                JGoView jGoView = jGoObject.getView();
                if (jGoView != null) {
                    jGoDocument = jGoView.getDocument();
                }
                if (jGoDocument != null) break;
            }
        }
        return jGoDocument;
    }
}

