/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;

public class RootBeanDefinition
extends AbstractBeanDefinition {
    public RootBeanDefinition() {
    }

    public RootBeanDefinition(Class beanClass) {
        this.setBeanClass(beanClass);
    }

    public RootBeanDefinition(Class beanClass, boolean singleton) {
        this.setBeanClass(beanClass);
        this.setSingleton(singleton);
    }

    public RootBeanDefinition(Class beanClass, int autowireMode) {
        this.setBeanClass(beanClass);
        this.setAutowireMode(autowireMode);
    }

    public RootBeanDefinition(Class beanClass, int autowireMode, boolean dependencyCheck) {
        this.setBeanClass(beanClass);
        this.setAutowireMode(autowireMode);
        if (dependencyCheck && this.getResolvedAutowireMode() != 3) {
            this.setDependencyCheck(1);
        }
    }

    public RootBeanDefinition(Class beanClass, MutablePropertyValues pvs) {
        super(null, pvs);
        this.setBeanClass(beanClass);
    }

    public RootBeanDefinition(Class beanClass, MutablePropertyValues pvs, boolean singleton) {
        super(null, pvs);
        this.setBeanClass(beanClass);
        this.setSingleton(singleton);
    }

    public RootBeanDefinition(Class beanClass, ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        super(cargs, pvs);
        this.setBeanClass(beanClass);
    }

    public RootBeanDefinition(String beanClassName, ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        super(cargs, pvs);
        this.setBeanClassName(beanClassName);
    }

    public RootBeanDefinition(RootBeanDefinition original) {
        super(original);
    }

    public boolean equals(Object other) {
        return other instanceof RootBeanDefinition && super.equals(other);
    }

    public String toString() {
        return "Root bean: " + super.toString();
    }
}

