/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.CategoryAxis;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public abstract class CategoryPlot
extends Plot {
    protected static final double DEFAULT_INTRO_GAP_PERCENT = 0.05;
    protected static final double DEFAULT_TRAIL_GAP_PERCENT = 0.05;
    protected static final double DEFAULT_CATEGORY_GAPS_PERCENT = 0.2;
    protected static final double DEFAULT_ITEM_GAPS_PERCENT = 0.15;
    protected static final double MAX_INTRO_GAP_PERCENT = 0.2;
    protected static final double MAX_TRAIL_GAP_PERCENT = 0.2;
    protected static final double MAX_CATEGORY_GAPS_PERCENT = 0.3;
    protected static final double MAX_ITEM_GAPS_PERCENT = 0.3;
    protected CategoryItemRenderer renderer;
    protected double introGapPercent;
    protected double trailGapPercent;
    protected double categoryGapsPercent;
    protected double itemGapsPercent;
    protected CategoryToolTipGenerator toolTipGenerator;

    protected CategoryPlot(Axis axis, Axis axis2, CategoryItemRenderer categoryItemRenderer) {
        this(axis, axis2, categoryItemRenderer, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, 0.05, 0.05, 0.2, 0.15, null);
    }

    protected CategoryPlot(Axis axis, Axis axis2, CategoryItemRenderer categoryItemRenderer, Insets insets, Paint paint, Image image, float f, Stroke stroke, Paint paint2, float f2, double d, double d2, double d3, double d4, CategoryToolTipGenerator categoryToolTipGenerator) {
        super(axis, axis2, insets, paint, image, f, stroke, paint2, f2);
        this.renderer = categoryItemRenderer;
        this.insets = insets;
        this.introGapPercent = d;
        this.trailGapPercent = d2;
        this.categoryGapsPercent = d3;
        this.itemGapsPercent = d4;
        this.toolTipGenerator = categoryToolTipGenerator;
    }

    public CategoryItemRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(CategoryItemRenderer categoryItemRenderer) {
        this.renderer = categoryItemRenderer;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getIntroGapPercent() {
        return this.introGapPercent;
    }

    public void setIntroGapPercent(double d) {
        if (d < 0.0 || d > 0.2) {
            throw new IllegalArgumentException("BarPlot.setIntroGapPercent(double): argument outside valid range.");
        }
        if (this.introGapPercent != d) {
            this.introGapPercent = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getTrailGapPercent() {
        return this.trailGapPercent;
    }

    public void setTrailGapPercent(double d) {
        if (d < 0.0 || d > 0.2) {
            throw new IllegalArgumentException("BarPlot.setTrailGapPercent(double): argument outside valid range.");
        }
        if (this.trailGapPercent != d) {
            this.trailGapPercent = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getCategoryGapsPercent() {
        return this.categoryGapsPercent;
    }

    public void setCategoryGapsPercent(double d) {
        if (d < 0.0 || d > 0.3) {
            throw new IllegalArgumentException("BarPlot.setCategoryGapsPercent(double): argument outside valid range.");
        }
        if (this.categoryGapsPercent != d) {
            this.categoryGapsPercent = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getItemGapsPercent() {
        return this.itemGapsPercent;
    }

    public void setItemGapsPercent(double d) {
        if (d < 0.0 || d > 0.3) {
            throw new IllegalArgumentException("BarPlot.setItemGapsPercent(double): argument outside valid range.");
        }
        if (d != this.itemGapsPercent) {
            this.itemGapsPercent = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public CategoryToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(CategoryToolTipGenerator categoryToolTipGenerator) {
        this.toolTipGenerator = categoryToolTipGenerator;
    }

    public CategoryDataset getDataset() {
        return (CategoryDataset)this.chart.getDataset();
    }

    public abstract CategoryAxis getDomainAxis();

    public abstract ValueAxis getRangeAxis();

    public abstract double getCategoryCoordinate(int var1, Rectangle2D var2);

    public void zoom(double d) {
        ValueAxis valueAxis = this.getRangeAxis();
        if (d > 0.0) {
            double d2 = valueAxis.getMaximumAxisValue() - valueAxis.getMinimumAxisValue();
            double d3 = d2 * d;
            valueAxis.setAnchoredRange(d3);
        } else {
            valueAxis.setAutoRange(true);
        }
    }
}

