/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.BarRenderer;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.data.CategoryDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class HorizontalBarRenderer
extends BarRenderer
implements CategoryItemRenderer {
    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryDataset categoryDataset) {
        this.calculateCategoryAndItemSpans(graphics2D, rectangle2D, categoryPlot, categoryDataset, rectangle2D.getHeight());
    }

    public Shape drawCategoryItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, Object object, int n2, Object object2) {
        Rectangle2D.Double double_ = null;
        Number number = categoryDataset.getValue(n, object);
        if (number != null) {
            double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
            double d2 = Math.min(this.zeroInJava2D, d);
            double d3 = rectangle2D.getY() + rectangle2D.getHeight() * categoryPlot.getIntroGapPercent();
            int n3 = categoryDataset.getCategoryCount();
            int n4 = categoryDataset.getSeriesCount();
            if (n3 > 1) {
                d3 = d3 + (double)n2 * this.categorySpan / (double)n3 + (double)n2 * this.categoryGapSpan / (double)(n3 - 1) + (double)n * this.itemSpan / (double)(n3 * n4);
                if (n4 > 1) {
                    d3 += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
                }
            } else {
                d3 += (double)n * this.itemSpan / (double)(n3 * n4);
                if (n4 > 1) {
                    d3 += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
                }
            }
            double d4 = Math.abs(d - this.zeroInJava2D);
            double d5 = this.itemWidth;
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d2, d3, d4, d5);
            Paint paint = categoryPlot.getSeriesPaint(n);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_2);
            if (this.itemWidth > 3.0) {
                graphics2D.setStroke(categoryPlot.getSeriesStroke(n));
                graphics2D.setPaint(categoryPlot.getSeriesOutlinePaint(n));
                graphics2D.draw(double_2);
            }
            double_ = double_2;
        }
        return double_;
    }

    public boolean hasItemGaps() {
        return true;
    }

    public int barWidthsPerCategory(CategoryDataset categoryDataset) {
        return categoryDataset.getSeriesCount();
    }
}

