/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.ChartUtilities;
import com.jrefinery.chart.DrawInfo;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.event.ChartChangeEvent;
import com.jrefinery.chart.event.ChartChangeListener;
import com.jrefinery.chart.tooltips.StandardToolTipsCollection;
import com.jrefinery.chart.tooltips.ToolTipsCollection;
import com.jrefinery.chart.ui.ChartPropertyEditPanel;
import com.jrefinery.ui.ExtensionFileFilter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;

public class JFreeChartPanel
extends JPanel
implements ActionListener,
MouseListener,
Printable,
ChartChangeListener {
    public static final boolean DEFAULT_BUFFER_USED = true;
    public static final int DEFAULT_WIDTH = 680;
    public static final int DEFAULT_HEIGHT = 420;
    public static final double WIDTH_SCALING_THRESHOLD = 300.0;
    public static final double HEIGHT_SCALING_THRESHOLD = 200.0;
    public static final String PROPERTIES_ACTION_COMMAND = "PROPERTIES";
    public static final String SAVE_ACTION_COMMAND = "SAVE";
    public static final String PRINT_ACTION_COMMAND = "PRINT";
    public static final String ZOOM_IN_ACTION_COMMAND = "ZOOM_IN";
    public static final String ZOOM_OUT_ACTION_COMMAND = "ZOOM_OUT";
    public static final String ZOOM_AUTO_ACTION_COMMAND = "ZOOM_RESET";
    protected JFreeChart chart;
    protected boolean useBuffer;
    protected boolean refreshBuffer;
    protected Image chartBuffer;
    protected int chartBufferHeight;
    protected int chartBufferWidth;
    protected Rectangle2D minimumDrawArea;
    protected JPopupMenu popup;
    protected DrawInfo info;
    protected double scaleX;
    protected double scaleY;
    protected JMenuItem zoomInMenuItem;
    protected JMenuItem zoomOutMenuItem;
    protected int zoomLevel = 0;
    protected static final int MAX_ZOOM_LEVEL = 4;
    private Rectangle2D available = new Rectangle2D.Double();
    private Rectangle2D chartArea = new Rectangle2D.Double();

    public JFreeChartPanel(JFreeChart jFreeChart) {
        this(jFreeChart, 680, 420, 300.0, 200.0, true, true, true, true, true, true);
    }

    public JFreeChartPanel(JFreeChart jFreeChart, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this(jFreeChart, 680, 420, 300.0, 200.0, true, bl, bl2, bl3, bl4, bl5);
    }

    public JFreeChartPanel(JFreeChart jFreeChart, int n, int n2, double d, double d2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.chart = jFreeChart;
        this.info = new DrawInfo();
        this.setPreferredSize(new Dimension(n, n2));
        this.useBuffer = bl;
        this.refreshBuffer = false;
        this.chart.addChangeListener(this);
        this.minimumDrawArea = new Rectangle2D.Double(0.0, 0.0, d, d2);
        this.popup = null;
        if (bl2 || bl3 || bl4 || bl5) {
            this.popup = this.createPopupMenu(bl2, bl3, bl4, bl5);
        }
        this.enableEvents(16L);
        if (bl6) {
            this.info.setToolTipsCollection(new StandardToolTipsCollection());
            this.enableEvents(32L);
            this.setToolTipText("ON");
        }
        this.addMouseListener(this);
        this.setOpaque(true);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart jFreeChart) {
        if (this.chart != null) {
            this.chart.removeChangeListener(this);
        }
        this.chart = jFreeChart;
        this.chart.addChangeListener(this);
        if (this.useBuffer) {
            this.refreshBuffer = true;
        }
        this.repaint();
    }

    public void setToolTipGeneration(boolean bl) {
        if (bl) {
            this.info.setToolTipsCollection(new StandardToolTipsCollection());
        } else {
            this.info.setToolTipsCollection(null);
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        ToolTipsCollection toolTipsCollection = this.info.getToolTipsCollection();
        if (toolTipsCollection != null) {
            Insets insets = this.getInsets();
            string = toolTipsCollection.getToolTipText((int)((double)(mouseEvent.getX() - insets.left) / this.scaleX), (int)((double)(mouseEvent.getY() - insets.top) / this.scaleY));
        }
        return string;
    }

    public Rectangle2D getMinimumDrawArea() {
        return this.minimumDrawArea;
    }

    public void setMinimumDrawArea(Rectangle2D rectangle2D) {
        this.minimumDrawArea = rectangle2D;
        if (this.useBuffer) {
            this.refreshBuffer = true;
        }
        this.repaint();
    }

    public void setRefreshBuffer(boolean bl) {
        this.refreshBuffer = bl;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        this.available.setRect(insets.left, insets.top, dimension.getWidth() - (double)insets.left - (double)insets.right, dimension.getHeight() - (double)insets.top - (double)insets.bottom);
        boolean bl = false;
        double d = this.available.getWidth();
        double d2 = this.available.getHeight();
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        if (this.minimumDrawArea != null) {
            double d3;
            double d4 = this.minimumDrawArea.getWidth();
            if (d < d4) {
                this.scaleX = d / d4;
                d = d4;
                bl = true;
            }
            if (d2 < (d3 = this.minimumDrawArea.getHeight())) {
                this.scaleY = d2 / d3;
                d2 = d3;
                bl = true;
            }
        }
        this.chartArea.setRect(0.0, 0.0, d, d2);
        if (this.useBuffer) {
            if (this.chartBuffer == null || (double)this.chartBufferWidth != this.available.getWidth() || (double)this.chartBufferHeight != this.available.getHeight()) {
                this.chartBufferWidth = (int)this.available.getWidth();
                this.chartBufferHeight = (int)this.available.getHeight();
                this.chartBuffer = this.createImage(this.chartBufferWidth, this.chartBufferHeight);
                this.refreshBuffer = true;
            }
            if (this.refreshBuffer) {
                Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.chartBufferWidth, this.chartBufferHeight);
                Graphics2D graphics2D2 = (Graphics2D)this.chartBuffer.getGraphics();
                if (bl) {
                    AffineTransform affineTransform = graphics2D2.getTransform();
                    graphics2D2.transform(AffineTransform.getScaleInstance(this.scaleX, this.scaleY));
                    this.chart.draw(graphics2D2, this.chartArea, this.info);
                    graphics2D2.setTransform(affineTransform);
                } else {
                    this.chart.draw(graphics2D2, double_, this.info);
                }
                this.refreshBuffer = false;
            }
            graphics.drawImage(this.chartBuffer, insets.left, insets.right, this);
        } else {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(insets.left, insets.right);
            if (bl) {
                graphics2D.transform(AffineTransform.getScaleInstance(this.scaleX, this.scaleY));
            }
            this.chart.draw(graphics2D, this.chartArea, this.info);
            graphics2D.setTransform(affineTransform);
        }
    }

    public void chartChanged(ChartChangeEvent chartChangeEvent) {
        this.refreshBuffer = true;
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(PROPERTIES_ACTION_COMMAND)) {
            this.attemptEditChartProperties();
        } else if (string.equals(SAVE_ACTION_COMMAND)) {
            try {
                this.doSaveAs();
            }
            catch (IOException iOException) {
                System.err.println("JFreeChartPanel.doSaveAs: i/o exception = " + iOException.getMessage());
            }
        } else if (string.equals(PRINT_ACTION_COMMAND)) {
            this.createChartPrintJob();
        } else if (string.equals(ZOOM_IN_ACTION_COMMAND)) {
            this.zoomIn();
        } else if (string.equals(ZOOM_OUT_ACTION_COMMAND)) {
            this.zoomOut();
        } else if (string.equals(ZOOM_AUTO_ACTION_COMMAND)) {
            this.zoomAuto();
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Insets insets = this.getInsets();
        this.chart.handleClick((int)((double)(mouseEvent.getX() - insets.left) / this.scaleX), (int)((double)(mouseEvent.getY() - insets.top) / this.scaleY), this.info);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.popup != null) {
            this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void attemptEditChartProperties() {
        ChartPropertyEditPanel chartPropertyEditPanel = new ChartPropertyEditPanel(this.chart);
        int n = JOptionPane.showConfirmDialog(this, chartPropertyEditPanel, "Chart Properties", 2, -1);
        if (n == 0) {
            chartPropertyEditPanel.updateChartProperties(this.chart);
        }
    }

    public void doSaveAs() throws IOException {
        JFileChooser jFileChooser = new JFileChooser();
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("PNG Image Files", ".png");
        jFileChooser.addChoosableFileFilter((FileFilter)extensionFileFilter);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            ChartUtilities.saveChartAsPNG(jFileChooser.getSelectedFile(), this.chart, this.getWidth(), this.getHeight());
        }
    }

    protected JPopupMenu createPopupMenu(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        JMenuItem jMenuItem;
        JPopupMenu jPopupMenu = new JPopupMenu("Chart:");
        boolean bl5 = false;
        if (bl) {
            jMenuItem = new JMenuItem("Properties...");
            jMenuItem.setActionCommand(PROPERTIES_ACTION_COMMAND);
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            bl5 = true;
        }
        if (bl2) {
            if (bl5) {
                jPopupMenu.addSeparator();
                bl5 = false;
            }
            jMenuItem = new JMenuItem("Save as...");
            jMenuItem.setActionCommand(SAVE_ACTION_COMMAND);
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            bl5 = true;
        }
        if (bl3) {
            if (bl5) {
                jPopupMenu.addSeparator();
                bl5 = false;
            }
            jMenuItem = new JMenuItem("Print...");
            jMenuItem.setActionCommand(PRINT_ACTION_COMMAND);
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            bl5 = true;
        }
        if (bl4) {
            if (bl5) {
                jPopupMenu.addSeparator();
                bl5 = false;
            }
            jMenuItem = new JMenu("Zoom");
            this.zoomInMenuItem = new JMenuItem("In");
            this.zoomInMenuItem.setActionCommand(ZOOM_IN_ACTION_COMMAND);
            this.zoomInMenuItem.addActionListener(this);
            ((JMenu)jMenuItem).add(this.zoomInMenuItem);
            this.zoomOutMenuItem = new JMenuItem("Out");
            this.zoomOutMenuItem.setActionCommand(ZOOM_OUT_ACTION_COMMAND);
            this.zoomOutMenuItem.addActionListener(this);
            ((JMenu)jMenuItem).add(this.zoomOutMenuItem);
            ((JMenu)jMenuItem).addSeparator();
            JMenuItem jMenuItem2 = new JMenuItem("Reset");
            jMenuItem2.setActionCommand(ZOOM_AUTO_ACTION_COMMAND);
            jMenuItem2.addActionListener(this);
            ((JMenu)jMenuItem).add(jMenuItem2);
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    public void createChartPrintJob() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                JOptionPane.showMessageDialog(this, printerException);
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n != 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        this.chart.draw(graphics2D, new Rectangle2D.Double(d, d2, d3, d4), null);
        return 0;
    }

    public void zoomIn() {
        if (this.zoomLevel < 4) {
            ++this.zoomLevel;
            this.chart.getPlot().zoom(0.5);
            if (!this.zoomOutMenuItem.isEnabled()) {
                this.zoomOutMenuItem.setEnabled(true);
            }
        }
        if (this.zoomLevel >= 4 && this.zoomInMenuItem.isEnabled()) {
            this.zoomInMenuItem.setEnabled(false);
        }
    }

    public void zoomOut() {
        if (this.zoomLevel > -4) {
            --this.zoomLevel;
            this.chart.getPlot().zoom(2.0);
            if (!this.zoomInMenuItem.isEnabled()) {
                this.zoomInMenuItem.setEnabled(true);
            }
        }
        if (this.zoomLevel <= -4 && this.zoomOutMenuItem.isEnabled()) {
            this.zoomOutMenuItem.setEnabled(false);
        }
    }

    public void zoomAuto() {
        this.zoomLevel = 0;
        this.chart.getPlot().zoom(0.0);
        if (!this.zoomInMenuItem.isEnabled()) {
            this.zoomInMenuItem.setEnabled(true);
        }
        if (!this.zoomOutMenuItem.isEnabled()) {
            this.zoomOutMenuItem.setEnabled(true);
        }
    }
}

