/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.DrawInfo;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.TickUnits;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.chart.tooltips.ToolTipsCollection;
import com.jrefinery.data.MeterDataset;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;

public class MeterPlot
extends Plot {
    public static final int NORMAL_DATA = 0;
    public static final int WARNING_DATA = 1;
    public static final int CRITICAL_DATA = 2;
    public static final int FULL_DATA = 3;
    public static final String CRITICAL_TEXT = "Critical";
    public static final String WARNING_TEXT = "Warning";
    public static final String NORMAL_TEXT = "Normal";
    static final Color DEFAULT_NORMAL_COLOR = Color.green;
    static final Color DEFAULT_WARNING_COLOR = Color.yellow;
    static final Color DEFAULT_CRITICAL_COLOR = Color.red;
    public static final int DEFAULT_METER_ANGLE = 180;
    public static final float DEFAULT_BORDER_SIZE = 3.0f;
    public static final float DEFAULT_CIRCLE_SIZE = 10.0f;
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.green;
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 10);
    public static final int NO_LABELS = 0;
    public static final int VALUE_LABELS = 1;
    protected int labelType;
    protected Font labelFont;
    protected int meterCalcAngle = -1;
    protected double meterRange = -1.0;
    protected int meterAngle = 180;
    protected double minMeterValue = 0.0;
    protected TickUnits tickUnits = null;
    protected NumberTickUnit tickUnit = null;
    Color colorNormal;
    Color colorCritical;
    Color colorWarning;
    int borderType;

    public MeterPlot() {
        this(Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, 1, DEFAULT_LABEL_FONT, DEFAULT_NORMAL_COLOR, DEFAULT_WARNING_COLOR, DEFAULT_CRITICAL_COLOR);
    }

    public MeterPlot(Insets insets, Paint paint, Image image, float f, Stroke stroke, Paint paint2, float f2, int n, Font font, Color color, Color color2, Color color3) {
        super(null, null, insets, paint, image, f, stroke, paint2, f2);
        this.labelType = n;
        this.labelFont = font;
        this.setInsets(insets);
        this.colorNormal = color;
        this.colorCritical = color3;
        this.colorWarning = color2;
    }

    public Color getNormalColor() {
        return this.colorNormal;
    }

    public Color getWarningColor() {
        return this.colorWarning;
    }

    public Color getCriticalColor() {
        return this.colorCritical;
    }

    public int getBorderType() {
        return this.borderType;
    }

    public void setBorderType(int n) {
        this.borderType = n;
    }

    public int getMeterAngle() {
        return this.meterAngle;
    }

    public void setMeterAngle(int n) {
        this.meterAngle = n;
    }

    public int getLabelType() {
        return this.labelType;
    }

    public void setLabelType(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("MeterPlot.setLabelType(int): unrecognised type.");
        }
        if (this.labelType != n) {
            this.labelType = n;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("MeterPlot.setLabelFont(...): null font not allowed.");
        }
        if (!this.labelFont.equals(font)) {
            this.labelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public MeterDataset getDataset() {
        return (MeterDataset)this.chart.getDataset();
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, DrawInfo drawInfo) {
        ToolTipsCollection toolTipsCollection = null;
        if (drawInfo != null) {
            drawInfo.setPlotArea(rectangle2D);
            toolTipsCollection = drawInfo.getToolTipsCollection();
        }
        if (this.insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)this.insets.left, rectangle2D.getY() + (double)this.insets.top, rectangle2D.getWidth() - (double)this.insets.left - (double)this.insets.right, rectangle2D.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        this.drawOutlineAndBackground(graphics2D, rectangle2D);
        double d = 6.0;
        double d2 = 6.0;
        double d3 = rectangle2D.getX() + d / 2.0;
        double d4 = rectangle2D.getY() + d2 / 2.0;
        double d5 = rectangle2D.getWidth() - d;
        double d6 = rectangle2D.getHeight() - d2 + (this.meterAngle <= 180 ? rectangle2D.getHeight() / 1.25 : 0.0);
        double d7 = Math.min(d5, d6) / 2.0;
        d3 = (d3 + d3 + d5) / 2.0 - d7;
        d4 = (d4 + d4 + d6) / 2.0 - d7;
        d5 = 2.0 * d7;
        d6 = 2.0 * d7;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, d5, d6);
        double d8 = double_.getCenterX();
        double d9 = double_.getCenterY();
        MeterDataset meterDataset = (MeterDataset)this.chart.getDataset();
        if (meterDataset != null) {
            double d10 = meterDataset.getMinimumValue().doubleValue();
            double d11 = meterDataset.getMaximumValue().doubleValue();
            this.minMeterValue = d10;
            double d12 = meterDataset.getValue().doubleValue();
            this.meterCalcAngle = 180 + (this.meterAngle - 180) / 2;
            this.meterRange = d11 - d10;
            Shape shape = graphics2D.getClip();
            graphics2D.clip(rectangle2D);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.foregroundAlpha));
            this.drawArc(graphics2D, double_, d10, d11, Color.black, 1);
            this.drawTicks(graphics2D, double_, d10, d11);
            this.drawArcFor(graphics2D, double_, meterDataset, 3);
            this.drawArcFor(graphics2D, double_, meterDataset, 0);
            this.drawArcFor(graphics2D, double_, meterDataset, 1);
            this.drawArcFor(graphics2D, double_, meterDataset, 2);
            this.drawTick(graphics2D, double_, d12, true, Color.green, true);
            graphics2D.setColor(Color.green);
            graphics2D.setStroke(new BasicStroke(2.0f));
            double d13 = ((RectangularShape)double_).getWidth() / 2.0 + 3.0 + 15.0;
            double d14 = this.calculateAngle(d12);
            double d15 = d8 + d13 * Math.cos(Math.PI * (d14 / 180.0));
            double d16 = d9 - d13 * Math.sin(Math.PI * (d14 / 180.0));
            Polygon polygon = new Polygon();
            if (d14 > 135.0 && d14 < 225.0 || d14 < 45.0 && d14 > -45.0) {
                double d17 = d9 - 2.5;
                double d18 = d9 + 2.5;
                polygon.addPoint((int)d8, (int)d17);
                polygon.addPoint((int)d8, (int)d18);
            } else {
                polygon.addPoint((int)(d8 - 2.5), (int)d9);
                polygon.addPoint((int)(d8 + 2.5), (int)d9);
            }
            polygon.addPoint((int)d15, (int)d16);
            Ellipse2D.Double double_2 = new Ellipse2D.Double(d8 - 5.0, d9 - 5.0, 10.0, 10.0);
            graphics2D.fill(polygon);
            graphics2D.fill(double_2);
            graphics2D.clip(shape);
            graphics2D.setComposite(composite);
        }
    }

    void drawArcFor(Graphics2D graphics2D, Rectangle2D rectangle2D, MeterDataset meterDataset, int n) {
        Number number = null;
        Number number2 = null;
        Color color = null;
        switch (n) {
            case 2: {
                number = meterDataset.getMinimumCriticalValue();
                number2 = meterDataset.getMaximumCriticalValue();
                color = this.getCriticalColor();
                break;
            }
            case 1: {
                number = meterDataset.getMinimumWarningValue();
                number2 = meterDataset.getMaximumWarningValue();
                color = this.getWarningColor();
                break;
            }
            case 0: {
                number = meterDataset.getMinimumNormalValue();
                number2 = meterDataset.getMaximumNormalValue();
                color = this.getNormalColor();
                break;
            }
            case 3: {
                number = meterDataset.getMinimumValue();
                number2 = meterDataset.getMaximumValue();
                color = DEFAULT_BACKGROUND_COLOR;
                break;
            }
            default: {
                return;
            }
        }
        if (number != null && number2 != null) {
            double d = meterDataset.getMinimumValue().doubleValue();
            if (this.getBorderType() == n) {
                this.drawArc(graphics2D, rectangle2D, number.doubleValue(), meterDataset.getMinimumValue().doubleValue(), color);
                this.drawArc(graphics2D, rectangle2D, meterDataset.getMaximumValue().doubleValue(), number2.doubleValue(), color);
            } else {
                this.drawArc(graphics2D, rectangle2D, number.doubleValue(), number2.doubleValue(), color);
            }
            this.drawTick(graphics2D, rectangle2D, number.doubleValue(), true, color);
            this.drawTick(graphics2D, rectangle2D, number2.doubleValue(), true, color);
        }
    }

    void drawArc(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, double d2, Color color) {
        this.drawArc(graphics2D, rectangle2D, d, d2, color, 0);
    }

    void drawArc(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, double d2, Color color, int n) {
        double d3 = this.calculateAngle(d2);
        double d4 = this.calculateAngle(d);
        double d5 = d4 - d3;
        double d6 = rectangle2D.getX();
        double d7 = rectangle2D.getY();
        double d8 = rectangle2D.getWidth();
        double d9 = rectangle2D.getHeight();
        graphics2D.setColor(color);
        if (n > 0) {
            graphics2D.setStroke(new BasicStroke(10.0f));
        } else {
            graphics2D.setStroke(new BasicStroke(3.0f));
        }
        Arc2D.Double double_ = new Arc2D.Double(d6, d7, d8, d9, d3, d5, n > 0 ? 2 : 0);
        if (n > 0) {
            graphics2D.fill(double_);
        } else {
            graphics2D.draw(double_);
        }
    }

    double calculateAngle(double d) {
        double d2 = (double)this.meterCalcAngle - (d -= this.minMeterValue) / this.meterRange * (double)this.meterAngle;
        return d2;
    }

    void drawTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, double d2) {
        int n = 20;
        double d3 = (d2 - d) / (double)n;
        double d4 = d;
        while (d4 <= d2) {
            this.drawTick(graphics2D, rectangle2D, d4);
            d4 += d3;
        }
    }

    void drawTick(Graphics2D graphics2D, Rectangle2D rectangle2D, double d) {
        this.drawTick(graphics2D, rectangle2D, d, false, null, false);
    }

    void drawTick(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, boolean bl, Color color) {
        this.drawTick(graphics2D, rectangle2D, d, bl, color, false);
    }

    void drawTick(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, boolean bl, Color color, boolean bl2) {
        double d2 = this.calculateAngle(d);
        double d3 = rectangle2D.getCenterX();
        double d4 = rectangle2D.getCenterY();
        if (color == null) {
            color = Color.white;
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(2.0f));
        double d5 = 0.0;
        double d6 = 0.0;
        if (!bl2) {
            double d7 = rectangle2D.getWidth() / 2.0 + 3.0;
            double d8 = d7 - 15.0;
            double d9 = d3 + d7 * Math.cos(Math.PI * (d2 / 180.0));
            double d10 = d4 - d7 * Math.sin(Math.PI * (d2 / 180.0));
            d5 = d3 + d8 * Math.cos(Math.PI * (d2 / 180.0));
            d6 = d4 - d8 * Math.sin(Math.PI * (d2 / 180.0));
            Line2D.Double double_ = new Line2D.Double(d9, d10, d5, d6);
            graphics2D.draw(double_);
        } else {
            d5 = d3;
            d6 = d4;
            d2 = 90.0;
        }
        if (this.labelType == 1 && bl) {
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###,##0.00");
            String string = decimalFormat.format(d);
            Rectangle2D rectangle2D2 = graphics2D.getFont().getStringBounds(string, graphics2D.getFontRenderContext());
            double d11 = d5;
            double d12 = d6;
            if (bl2) {
                d12 += 10.0;
            }
            if (d2 == 90.0 || d2 == 270.0) {
                d11 -= rectangle2D2.getWidth() / 2.0;
            } else if (d2 < 90.0 || d2 > 270.0) {
                d11 -= rectangle2D2.getWidth();
            }
            d12 = d2 > 135.0 && d2 < 225.0 || d2 > 315.0 || d2 < 45.0 ? (d12 -= rectangle2D2.getHeight() / 2.0) : (d12 += rectangle2D2.getHeight() / 2.0);
            if (this.labelFont != null) {
                graphics2D.setFont(this.labelFont);
            }
            graphics2D.drawString(string, (float)d11, (float)d12);
        }
    }

    public String getPlotType() {
        return "Meter Plot";
    }

    public void zoom(double d) {
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        return axis == null;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis == null;
    }
}

