/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractTitle;
import com.jrefinery.chart.Spacer;
import com.jrefinery.chart.event.TitleChangeEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;

public class TextTitle
extends AbstractTitle {
    public static final Font DEFAULT_FONT = new Font("Dialog", 1, 12);
    public static final Paint DEFAULT_TEXT_PAINT = Color.black;
    protected String text;
    protected Font font;
    protected Paint paint;

    public TextTitle(String string) {
        this(string, DEFAULT_FONT, DEFAULT_TEXT_PAINT, 0, 4, 4, AbstractTitle.DEFAULT_SPACER);
    }

    public TextTitle(String string, Font font) {
        this(string, font, DEFAULT_TEXT_PAINT, 0, 4, 4, AbstractTitle.DEFAULT_SPACER);
    }

    public TextTitle(String string, Font font, Paint paint) {
        this(string, font, paint, 0, 4, 4, AbstractTitle.DEFAULT_SPACER);
    }

    public TextTitle(String string, Font font, int n) {
        this(string, font, DEFAULT_TEXT_PAINT, 0, n, 4, AbstractTitle.DEFAULT_SPACER);
    }

    public TextTitle(String string, Font font, Paint paint, int n, int n2, int n3, Spacer spacer) {
        super(n, n2, n3, spacer);
        this.text = string;
        this.font = font;
        this.paint = paint;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (!this.font.equals(font)) {
            this.font = font;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        if (!this.paint.equals(paint)) {
            this.paint = paint;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        if (!this.text.equals(string)) {
            this.text = string;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public boolean isValidPosition(int n) {
        return n == 0 || n == 1;
    }

    public double getPreferredWidth(Graphics2D graphics2D) {
        graphics2D.setFont(this.font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D = this.font.getStringBounds(this.text, fontRenderContext);
        double d = rectangle2D.getWidth();
        if (this.spacer != null) {
            d = this.spacer.getAdjustedWidth(d);
        }
        return d;
    }

    public double getPreferredHeight(Graphics2D graphics2D) {
        graphics2D.setFont(this.font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineMetrics lineMetrics = this.font.getLineMetrics(this.text, fontRenderContext);
        double d = lineMetrics.getHeight();
        if (this.spacer != null) {
            d = this.spacer.getAdjustedHeight(d);
        }
        return d;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.position != 0 && this.position != 1) {
            throw new RuntimeException("TextTitle.draw(...) - invalid title position.");
        }
        this.drawHorizontal(graphics2D, rectangle2D);
    }

    protected void drawHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D2 = this.font.getStringBounds(this.text, fontRenderContext);
        LineMetrics lineMetrics = this.font.getLineMetrics(this.text, fontRenderContext);
        double d2 = rectangle2D2.getWidth();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = lineMetrics.getHeight();
        double d6 = 0.0;
        double d7 = 0.0;
        if (this.spacer != null) {
            d3 = this.spacer.getLeftSpace(d2);
            d4 = this.spacer.getRightSpace(d2);
            d6 = this.spacer.getTopSpace(d5);
            d7 = this.spacer.getBottomSpace(d5);
        }
        double d8 = rectangle2D.getY() + d6;
        if (this.verticalAlignment == 0) {
            d8 = d8 + d5 - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent();
        } else if (this.verticalAlignment == 4) {
            d = rectangle2D.getHeight() - d6 - d7 - d5;
            d8 = d8 + d / 2.0 + d5 - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent();
        } else if (this.verticalAlignment == 1) {
            d8 = rectangle2D.getMaxY() - d7 - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent();
        }
        d = rectangle2D.getX() + d3;
        if (this.horizontalAlignment == 4) {
            d = d + (rectangle2D.getWidth() - d3 - d4) / 2.0 - d2 / 2.0;
        } else if (this.horizontalAlignment == 3) {
            d = rectangle2D.getX() + d3;
        } else if (this.horizontalAlignment == 2) {
            d = rectangle2D.getMaxX() - d4 - d2;
        }
        graphics2D.setFont(this.font);
        graphics2D.setPaint(this.paint);
        graphics2D.drawString(this.text, (float)d, (float)d8);
    }
}

