/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.fop.apps.CommandLineOptions;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FOTreeBuilder;
import org.xml.sax.helpers.DefaultHandler;

public class Fop
implements Constants {
    private int renderType = 0;
    private OutputStream stream = null;
    private FOUserAgent foUserAgent = null;
    private FOTreeBuilder foTreeBuilder = null;
    static /* synthetic */ Class array$Ljava$lang$String;

    public Fop(int renderType, FOUserAgent ua) {
        if (renderType < 1 || renderType > 12) {
            throw new IllegalArgumentException("Invalid render type #" + renderType);
        }
        this.renderType = renderType;
        this.foUserAgent = ua;
        if (this.foUserAgent == null) {
            this.foUserAgent = new FOUserAgent();
        }
    }

    public Fop(int renderType) {
        this(renderType, new FOUserAgent());
    }

    public FOUserAgent getUserAgent() {
        return this.foUserAgent;
    }

    public void setOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    public DefaultHandler getDefaultHandler() throws FOPException {
        if (this.foTreeBuilder == null) {
            this.foTreeBuilder = new FOTreeBuilder(this.renderType, this.foUserAgent, this.stream);
        }
        return this.foTreeBuilder;
    }

    public FormattingResults getResults() {
        if (this.foTreeBuilder == null) {
            throw new IllegalStateException("Results are only available after calling getDefaultHandler().");
        }
        return this.foTreeBuilder.getResults();
    }

    public static URL[] getJARList() throws MalformedURLException {
        String optionalLib;
        File[] files;
        File buildDir;
        File baseDir = new File(".").getAbsoluteFile().getParentFile();
        if ("build".equals(baseDir.getName())) {
            buildDir = baseDir;
            baseDir = baseDir.getParentFile();
        } else {
            buildDir = new File(baseDir, "build");
        }
        File fopJar = new File(buildDir, "fop.jar");
        if (!fopJar.exists()) {
            fopJar = new File(baseDir, "fop.jar");
        }
        if (!fopJar.exists()) {
            throw new RuntimeException("fop.jar not found in directory: " + baseDir.getAbsolutePath() + " (or below)");
        }
        ArrayList<URL> jars = new ArrayList<URL>();
        jars.add(fopJar.toURL());
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        };
        File libDir = new File(baseDir, "lib");
        if (!libDir.exists()) {
            libDir = baseDir;
        }
        if ((files = libDir.listFiles(filter)) != null) {
            int size = files.length;
            for (int i = 0; i < size; ++i) {
                jars.add(files[i].toURL());
            }
        }
        if ((optionalLib = System.getProperty("fop.optional.lib")) != null && (files = new File(optionalLib).listFiles(filter)) != null) {
            int size = files.length;
            for (int i = 0; i < size; ++i) {
                jars.add(files[i].toURL());
            }
        }
        URL[] urls = jars.toArray(new URL[jars.size()]);
        return urls;
    }

    public static boolean checkDependencies() {
        try {
            Class<?> clazz = Class.forName("org.apache.batik.Version");
            if (clazz != null) {
                clazz = Class.forName("org.apache.avalon.framework.configuration.Configuration");
            }
            return clazz != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void startFOPWithDynamicClasspath(String[] args) {
        try {
            URL[] urls = Fop.getJARList();
            URLClassLoader loader = new URLClassLoader(urls, null);
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> clazz = Class.forName("org.apache.fop.apps.Fop", true, loader);
            Method mainMethod = clazz.getMethod("startFOP", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Fop.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            System.err.println("Unable to start FOP:");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startFOP(String[] args) {
        CommandLineOptions options = null;
        FOUserAgent foUserAgent = null;
        FilterOutputStream bos = null;
        try {
            options = new CommandLineOptions();
            options.parse(args);
            foUserAgent = options.getFOUserAgent();
            Fop fop = new Fop(options.getRenderer(), foUserAgent);
            try {
                if (options.getOutputFile() != null) {
                    bos = new BufferedOutputStream(new FileOutputStream(options.getOutputFile()));
                    fop.setOutputStream(bos);
                    foUserAgent.setOutputFile(options.getOutputFile());
                }
                foUserAgent.getInputHandler().render(fop);
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
            }
            if (options.getOutputMode() != 2) {
                System.exit(0);
            }
        }
        catch (Exception e) {
            if (options != null) {
                options.getLogger().error("Exception", e);
            }
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        if (Fop.checkDependencies()) {
            Fop.startFOP(args);
        } else {
            Fop.startFOPWithDynamicClasspath(args);
        }
    }

    public static String getVersion() {
        return "1.0dev";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

