/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.LengthPairProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Locator;

public class TableCell
extends FObj {
    private CommonAccessibility commonAccessibility;
    private CommonAural commonAural;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonRelativePosition commonRelativePosition;
    private LengthRangeProperty blockProgressionDimension;
    private int borderCollapse;
    private LengthPairProperty borderSeparation;
    private Numeric columnNumber;
    private int displayAlign;
    private int relativeAlign;
    private int emptyCells;
    private int endsRow;
    private Length height;
    private String id;
    private LengthRangeProperty inlineProgressionDimension;
    private Numeric numberColumnsSpanned;
    private Numeric numberRowsSpanned;
    private int startsRow;
    private Length width;
    private boolean blockItemFound = false;
    protected int startOffset;
    protected int beforeOffset = 0;
    protected int startAdjust = 0;
    protected int widthAdjust = 0;
    protected int borderHeight = 0;
    protected int top;
    private boolean bDone = false;

    public TableCell(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonAccessibility = pList.getAccessibilityProps();
        this.commonAural = pList.getAuralProps();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.blockProgressionDimension = pList.get(17).getLengthRange();
        this.borderCollapse = pList.get(31).getEnum();
        this.borderSeparation = pList.get(45).getLengthPair();
        this.columnNumber = pList.get(70).getNumeric();
        this.displayAlign = pList.get(81).getEnum();
        this.relativeAlign = pList.get(182).getEnum();
        this.emptyCells = pList.get(84).getEnum();
        this.endsRow = pList.get(86).getEnum();
        this.height = pList.get(106).getLength();
        this.id = pList.get(113).getString();
        this.inlineProgressionDimension = pList.get(116).getLengthRange();
        this.numberColumnsSpanned = pList.get(149).getNumeric();
        this.numberRowsSpanned = pList.get(150).getNumeric();
        this.startsRow = pList.get(213).getEnum();
        this.width = pList.get(241).getLength();
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.id);
        this.getFOEventHandler().startCell(this);
    }

    protected void endOfNode() throws FOPException {
        if (!this.blockItemFound) {
            this.missingChildElementError("marker* (%block;)+");
        }
        this.getFOEventHandler().endCell(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if (FO_URI.equals(nsURI) && localName.equals("marker")) {
            if (this.blockItemFound) {
                this.nodesOutOfOrderError(loc, "fo:marker", "(%block;)");
            }
        } else if (!this.isBlockItem(nsURI, localName)) {
            this.invalidChildError(loc, nsURI, localName);
        } else {
            this.blockItemFound = true;
        }
    }

    public void setStartOffset(int offset) {
        this.startOffset = offset;
    }

    private void calcBorders(CommonBorderPaddingBackground bp) {
        if (this.borderCollapse == 129) {
            int iSep = this.borderSeparation.getIPD().getLength().getValue();
            this.startAdjust = iSep / 2 + bp.getBorderStartWidth(false) + bp.getPaddingStart(false);
            this.widthAdjust = this.startAdjust + iSep - iSep / 2 + bp.getBorderEndWidth(false) + bp.getPaddingEnd(false);
            int bSep = this.borderSeparation.getBPD().getLength().getValue();
            this.beforeOffset = bSep / 2 + bp.getBorderBeforeWidth(false) + bp.getPaddingBefore(false);
        } else {
            int borderStart = bp.getBorderStartWidth(false);
            int borderEnd = bp.getBorderEndWidth(false);
            int borderBefore = bp.getBorderBeforeWidth(false);
            int borderAfter = bp.getBorderAfterWidth(false);
            this.startAdjust = borderStart / 2 + bp.getPaddingStart(false);
            this.widthAdjust = this.startAdjust + borderEnd / 2 + bp.getPaddingEnd(false);
            this.beforeOffset = borderBefore / 2 + bp.getPaddingBefore(false);
            this.borderHeight = (borderBefore + borderAfter) / 2;
        }
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public boolean hasColumnNumber() {
        return this.columnNumber.getValue() >= 1;
    }

    public int getColumnNumber() {
        return Math.max(this.columnNumber.getValue(), 0);
    }

    public boolean showEmptyCells() {
        return this.emptyCells == 130;
    }

    public int getBorderCollapse() {
        return this.borderCollapse;
    }

    public boolean isSeparateBorderModel() {
        return this.getBorderCollapse() == 129;
    }

    public LengthPairProperty getBorderSeparation() {
        return this.borderSeparation;
    }

    public String getId() {
        return this.id;
    }

    public int getNumberColumnsSpanned() {
        return Math.max(this.numberColumnsSpanned.getValue(), 1);
    }

    public int getNumberRowsSpanned() {
        return Math.max(this.numberRowsSpanned.getValue(), 1);
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public int getDisplayAlign() {
        return this.displayAlign;
    }

    public boolean startsRow() {
        return this.startsRow == 149;
    }

    public boolean endsRow() {
        return this.endsRow == 149;
    }

    public String getName() {
        return "fo:table-cell";
    }

    public int getNameId() {
        return 50;
    }
}

