/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.fo.pagination.Title;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.traits.MinOptMax;

public class ContentLayoutManager
implements InlineLevelLayoutManager {
    private FOUserAgent userAgent;
    private Area holder;
    private int stackSize;
    private LayoutManager parentLM;
    private InlineLevelLayoutManager childLM = null;
    protected static Log log = LogFactory.getLog(class$org$apache$fop$layoutmgr$LayoutManager == null ? (class$org$apache$fop$layoutmgr$LayoutManager = ContentLayoutManager.class$("org.apache.fop.layoutmgr.LayoutManager")) : class$org$apache$fop$layoutmgr$LayoutManager);
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$LayoutManager;

    public ContentLayoutManager(Area area, LayoutManager parentLM) {
        this.holder = area;
        this.parentLM = parentLM;
    }

    public ContentLayoutManager(Title foTitle, PageSequenceLayoutManager pslm) {
        this.parentLM = pslm;
        this.holder = new LineArea();
        this.setUserAgent(foTitle.getUserAgent());
        InlineLayoutManager lm = new InlineLayoutManager(foTitle);
        this.addChildLM(lm);
        this.fillArea(lm);
    }

    public void fillArea(LayoutManager curLM) {
        int maxtb;
        int ipd = 1000000;
        LayoutContext childLC = new LayoutContext(2);
        childLC.setLeadingSpace(new SpaceSpecifier(false));
        childLC.setTrailingSpace(new SpaceSpecifier(false));
        childLC.setStackLimit(new MinOptMax(ipd));
        childLC.setRefIPD(ipd);
        int lineHeight = 14000;
        int lead = 12000;
        int follow = 2000;
        int halfLeading = (lineHeight - lead - follow) / 2;
        int lineLead = lead + halfLeading;
        int middlefollow = maxtb = follow + halfLeading;
        this.stackSize = 0;
        LinkedList contentList = this.getNextKnuthElements(childLC, 135);
        ListIterator contentIter = contentList.listIterator();
        while (contentIter.hasNext()) {
            KnuthElement element = (KnuthElement)contentIter.next();
            if (!element.isBox()) continue;
            KnuthInlineBox box = (KnuthInlineBox)element;
            if (box.getLead() > lineLead) {
                lineLead = box.getLead();
            }
            if (box.getTotal() > maxtb) {
                maxtb = box.getTotal();
            }
            if (box.getMiddle() <= middlefollow) continue;
            middlefollow = box.getMiddle();
        }
        if (maxtb - lineLead > middlefollow) {
            middlefollow = maxtb - lineLead;
        }
        LayoutContext lc = new LayoutContext(0);
        lc.setBaseline(lineLead);
        lc.setLineHeight(lineHeight);
        lc.setFlags(256, true);
        lc.setLeadingSpace(new SpaceSpecifier(false));
        lc.setTrailingSpace(new SpaceSpecifier(false));
        KnuthPossPosIter contentPosIter = new KnuthPossPosIter(contentList, 0, contentList.size());
        curLM.addAreas(contentPosIter, lc);
    }

    public void addAreas(PositionIterator posIter, LayoutContext context) {
        int savedIPD = ((InlineArea)this.holder).getIPD();
        LayoutContext childContext = new LayoutContext(context);
        childContext.setIPDAdjust(0.0);
        this.childLM.addAreas(posIter, childContext);
        ((InlineArea)this.holder).setIPD(savedIPD);
    }

    public int getStackingSize() {
        return this.stackSize;
    }

    public Area getParentArea(Area childArea) {
        return this.holder;
    }

    public void addChildArea(Area childArea) {
        this.holder.addChildArea(childArea);
    }

    public void setUserAgent(FOUserAgent ua) {
        this.userAgent = ua;
    }

    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setParent(LayoutManager lm) {
        this.parentLM = lm;
    }

    public LayoutManager getParent() {
        return this.parentLM;
    }

    public boolean isFinished() {
        return false;
    }

    public void setFinished(boolean isFinished) {
    }

    public void resetPosition(Position position) {
    }

    public boolean createNextChildLMs(int pos) {
        return false;
    }

    public List getChildLMs() {
        ArrayList<InlineLevelLayoutManager> childLMs = new ArrayList<InlineLevelLayoutManager>(1);
        childLMs.add(this.childLM);
        return childLMs;
    }

    public void addChildLM(LayoutManager lm) {
        if (lm == null) {
            return;
        }
        lm.setParent(this);
        this.childLM = (InlineLevelLayoutManager)lm;
        log.trace(this.getClass().getName() + ": Adding child LM " + lm.getClass().getName());
    }

    public void addChildLMs(List newLMs) {
        if (newLMs == null || newLMs.size() == 0) {
            return;
        }
        ListIterator iter = newLMs.listIterator();
        while (iter.hasNext()) {
            LayoutManager lm = (LayoutManager)iter.next();
            this.addChildLM(lm);
        }
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        LinkedList<KnuthElement> contentList = new LinkedList<KnuthElement>();
        while (!this.childLM.isFinished()) {
            LinkedList returnedList = this.childLM.getNextKnuthElements(context, alignment);
            if (returnedList == null) continue;
            while (returnedList.size() > 0) {
                KnuthElement contentElement = (KnuthElement)returnedList.removeFirst();
                this.stackSize += contentElement.getW();
                contentList.add(contentElement);
            }
        }
        this.setFinished(true);
        return contentList;
    }

    public List addALetterSpaceTo(List oldList) {
        return oldList;
    }

    public void getWordChars(StringBuffer sbChars, Position pos) {
    }

    public void hyphenate(Position pos, HyphContext hc) {
    }

    public boolean applyChanges(List oldList) {
        return false;
    }

    public LinkedList getChangedKnuthElements(List oldList, int alignment) {
        return null;
    }

    public PageSequenceLayoutManager getPSLM() {
        return this.parentLM.getPSLM();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

