/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class SplusCodeReader
extends Reader {
    public static final int EOF = -1;
    private boolean fSkipComments = false;
    private boolean fSkipStrings = false;
    private boolean fForward = false;
    private IDocument fDocument;
    private int fOffset;
    private int fEnd = -1;
    private int fCachedLineNumber = -1;
    private int fCachedLineOffset = -1;

    public int getOffset() {
        return this.fForward ? this.fOffset - 1 : this.fOffset;
    }

    public void configureForwardReader(IDocument iDocument, int n, int n2, boolean bl, boolean bl2) throws IOException {
        this.fDocument = iDocument;
        this.fOffset = n;
        this.fSkipComments = bl;
        this.fSkipStrings = bl2;
        this.fForward = true;
        this.fEnd = Math.min(this.fDocument.getLength(), this.fOffset + n2);
    }

    public void configureBackwardReader(IDocument iDocument, int n, boolean bl, boolean bl2) throws IOException {
        this.fDocument = iDocument;
        this.fOffset = n;
        this.fSkipComments = bl;
        this.fSkipStrings = bl2;
        this.fForward = false;
        try {
            this.fCachedLineNumber = this.fDocument.getLineOfOffset(this.fOffset);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public void close() throws IOException {
        this.fDocument = null;
    }

    public int read() throws IOException {
        try {
            return this.fForward ? this.readForwards() : this.readBackwards();
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    private void gotoStringEnd(char c) throws BadLocationException {
        while (this.fOffset < this.fEnd) {
            char c2;
            if ((c2 = this.fDocument.getChar(this.fOffset++)) == '\\') {
                ++this.fOffset;
                continue;
            }
            if (c2 != c) continue;
            return;
        }
    }

    private void gotoLineEnd() throws BadLocationException {
        int n = this.fDocument.getLineOfOffset(this.fOffset);
        this.fOffset = this.fDocument.getLineOffset(n + 1);
    }

    private int readForwards() throws BadLocationException {
        block4: while (this.fOffset < this.fEnd) {
            char c = this.fDocument.getChar(this.fOffset++);
            switch (c) {
                case '#': {
                    this.gotoLineEnd();
                    return c;
                }
                case '\"': 
                case '\'': {
                    if (this.fSkipStrings) {
                        this.gotoStringEnd(c);
                        continue block4;
                    }
                    return c;
                }
            }
            return c;
        }
        return -1;
    }

    private void handleSingleLineComment() throws BadLocationException {
        int n = this.fDocument.getLineOfOffset(this.fOffset);
        if (n < this.fCachedLineNumber) {
            this.fCachedLineNumber = n;
            this.fCachedLineOffset = this.fDocument.getLineOffset(n);
            int n2 = this.fOffset;
            while (this.fCachedLineOffset < n2) {
                char c;
                if ((c = this.fDocument.getChar(n2--)) != '#' || this.fCachedLineOffset > n2) continue;
                this.fOffset = n2;
                return;
            }
        }
    }

    private void gotoStringStart(char c) throws BadLocationException {
        while (0 < this.fOffset) {
            char c2 = this.fDocument.getChar(this.fOffset);
            if (c2 == c && (0 > this.fOffset || this.fDocument.getChar(this.fOffset - 1) != '\\')) {
                return;
            }
            --this.fOffset;
        }
    }

    private int readBackwards() throws BadLocationException {
        block4: while (0 < this.fOffset) {
            --this.fOffset;
            this.handleSingleLineComment();
            char c = this.fDocument.getChar(this.fOffset);
            switch (c) {
                case '#': {
                    return c;
                }
                case '\"': 
                case '\'': {
                    if (this.fSkipStrings) {
                        --this.fOffset;
                        this.gotoStringStart(c);
                        continue block4;
                    }
                    return c;
                }
            }
            return c;
        }
        return -1;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            int n4 = this.read();
            if (n4 == -1) {
                if (i == n) {
                    return -1;
                }
                return i - n;
            }
            cArray[i] = (char)n4;
        }
        return n2;
    }

    public boolean ready() throws IOException {
        return true;
    }

    public String getString() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.read()) != -1) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }
}

