/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusWordDetector;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyledText;

public class SplusCompletionProcessor
implements IContentAssistProcessor {
    protected static final String[] fgProposals = new String[]{"break", "character", "complex", "else", "F", "for", "function", "if", "in", "logical", "NA", "next", "NULL", "numeric", "repeat", "T", "while"};
    protected IContextInformationValidator fValidator = new Validator();
    private ContentAssistant fAssistant;
    private int fRepetition = -1;
    private int fNumberOfComputedResults = 0;
    private String fErrorMessage;
    private static char[] g_validChars = null;

    public SplusCompletionProcessor(ContentAssistant contentAssistant) {
        this.fAssistant = contentAssistant;
        this.fAssistant.addCompletionListener(new ICompletionListener(){

            public void assistSessionStarted(ContentAssistEvent contentAssistEvent) {
                if (contentAssistEvent.processor != SplusCompletionProcessor.this) {
                    return;
                }
                SplusCompletionProcessor.this.fRepetition = 0;
                if (contentAssistEvent.assistant instanceof IContentAssistantExtension2) {
                    IContentAssistantExtension2 iContentAssistantExtension2 = (IContentAssistantExtension2)contentAssistEvent.assistant;
                    iContentAssistantExtension2.setRepeatedInvocationMode(false);
                    iContentAssistantExtension2.setShowEmptyList(false);
                }
            }

            public void assistSessionEnded(ContentAssistEvent contentAssistEvent) {
                if (contentAssistEvent.processor != SplusCompletionProcessor.this) {
                    return;
                }
                SplusCompletionProcessor.this.fRepetition = -1;
                if (contentAssistEvent.assistant instanceof IContentAssistantExtension2) {
                    IContentAssistantExtension2 iContentAssistantExtension2 = (IContentAssistantExtension2)contentAssistEvent.assistant;
                    iContentAssistantExtension2.setShowEmptyList(false);
                    iContentAssistantExtension2.setRepeatedInvocationMode(false);
                    iContentAssistantExtension2.setStatusLineVisible(false);
                    if (iContentAssistantExtension2 instanceof IContentAssistantExtension3) {
                        IContentAssistantExtension3 iContentAssistantExtension3 = (IContentAssistantExtension3)iContentAssistantExtension2;
                        ((ContentAssistant)iContentAssistantExtension3).setRepeatedInvocationTrigger(KeySequence.getInstance());
                    }
                }
            }

            public void selectionChanged(ICompletionProposal iCompletionProposal, boolean bl) {
            }
        });
    }

    public String getWordSoFar(ITextViewer iTextViewer, int n, int n2) {
        int n3;
        StyledText styledText = iTextViewer.getTextWidget();
        int n4 = styledText.getLineAtOffset(n);
        int n5 = styledText.getOffsetAtLine(n4);
        int n6 = n2;
        SplusWordDetector splusWordDetector = new SplusWordDetector();
        for (n3 = n - n6; n5 <= n3 && splusWordDetector.isWordPart(styledText.getText(n3, n3).charAt(0)); --n3) {
        }
        String string = null;
        if (++n3 <= n - n6) {
            string = styledText.getText(n3, n - n6);
        }
        return string;
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        String string = this.getWordSoFar(iTextViewer, n, 2);
        if (string == null || string.length() == 0) {
            return new IContextInformation[0];
        }
        String string2 = SplusEditorPlugin.getDefault().getSplusIntelliSenseHelper(null).getFunctionArgList(string);
        IContextInformation[] iContextInformationArray = new IContextInformation[]{new ContextInformation(string2, string2)};
        return iContextInformationArray;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        String string = this.getWordSoFar(iTextViewer, n, 1);
        if (string == null || string.length() == 0) {
            return new ICompletionProposal[0];
        }
        LinkedList linkedList = SplusEditorPlugin.getDefault().getSplusIntelliSenseHelper(null).getFunctionList(string);
        if (linkedList.isEmpty()) {
            return new ICompletionProposal[0];
        }
        String string2 = (String)linkedList.getFirst();
        boolean bl = string.equals(string2);
        int n2 = bl ? 0 : 1;
        ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[linkedList.size() + n2];
        int n3 = n - string.length();
        int n4 = string.length();
        if (!bl) {
            iCompletionProposalArray[0] = new CompletionProposal(string, n3, n4, string.length());
        }
        Iterator iterator = linkedList.iterator();
        int n5 = n2;
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            iCompletionProposalArray[n5] = new CompletionProposal(string3, n3, n4, string3.length());
            ++n5;
        }
        return iCompletionProposalArray;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        if (g_validChars == null) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            g_validChars = new char[63];
            n3 = 0;
            n = 97;
            while (n3 < 26) {
                SplusCompletionProcessor.g_validChars[n2] = n;
                ++n3;
                ++n2;
                n = (char)(n + 1);
            }
            n3 = 0;
            n = 65;
            while (n3 < 26) {
                SplusCompletionProcessor.g_validChars[n2] = n;
                ++n3;
                ++n2;
                n = (char)(n + 1);
            }
            n3 = 0;
            n = 48;
            while (n3 < 10) {
                SplusCompletionProcessor.g_validChars[n2] = n;
                ++n3;
                ++n2;
                n = (char)(n + 1);
            }
            SplusCompletionProcessor.g_validChars[n2] = 46;
        }
        return g_validChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{'('};
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public String getErrorMessage() {
        return null;
    }

    public static void configure(ContentAssistant contentAssistant, IPreferenceStore iPreferenceStore) {
        contentAssistant.enableAutoActivation(true);
        contentAssistant.setAutoActivationDelay(5);
        contentAssistant.enableAutoInsert(false);
        contentAssistant.enablePrefixCompletion(true);
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected ITextViewer fViewer;
        protected int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int n) {
            int n2;
            if (n == this.fInstallOffset) {
                return true;
            }
            if (n - 1 < this.fInstallOffset) {
                return false;
            }
            String string = this.fViewer.getTextWidget().getText(this.fInstallOffset, n - 1);
            int n3 = 0;
            block4: for (n2 = 0; n2 < string.length(); n2 += 1) {
                switch (string.charAt(n2)) {
                    case '(': {
                        ++n3;
                        continue block4;
                    }
                    case ')': {
                        --n3;
                    }
                }
            }
            n2 = n3 >= 0 ? 1 : 0;
            return n2 != 0;
        }

        public void install(IContextInformation iContextInformation, ITextViewer iTextViewer, int n) {
            this.fInstallOffset = n;
            this.fViewer = iTextViewer;
        }

        public boolean updatePresentation(int n, TextPresentation textPresentation) {
            return false;
        }
    }
}

