/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusIncrementalBuilder;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusReferencesResult;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import com.insightful.splus.parser.PObject;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class SplusFindReferences
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow m_window;
    private ISelection m_selection;
    private IViewPart m_view;

    public String getSelectionAsText() {
        if (this.m_selection != null && this.m_selection instanceof TextSelection) {
            return ((TextSelection)this.m_selection).getText();
        }
        return "";
    }

    public void init(IViewPart iViewPart) {
        this.m_view = iViewPart;
    }

    private ISearchQuery getSearchQuery() {
        return SplusFindReferences.getSearchQuery(this.getSelectionAsText(), this.m_window);
    }

    private static ISearchQuery getSearchQuery(String string, IWorkbenchWindow iWorkbenchWindow) {
        return new SplusMethodQuery(string, iWorkbenchWindow);
    }

    public void run(IAction iAction) {
        NewSearchUI.runQueryInBackground((ISearchQuery)this.getSearchQuery());
    }

    public static void run(String string, IWorkbenchWindow iWorkbenchWindow) {
        NewSearchUI.runQueryInBackground((ISearchQuery)SplusFindReferences.getSearchQuery(string, iWorkbenchWindow));
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.m_selection = iSelection;
        iAction.setEnabled(true);
        if (this.m_selection.isEmpty()) {
            iAction.setEnabled(false);
        } else if (this.m_selection instanceof TextSelection) {
            if (((TextSelection)this.m_selection).getLength() == 0) {
                iAction.setEnabled(false);
            }
        } else {
            iAction.setEnabled(false);
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.m_window = iWorkbenchWindow;
    }

    private static class SplusMethodQuery
    implements ISearchQuery {
        private ISearchResult m_searchResult;
        private IWorkbenchWindow m_window;
        private String m_queryString;

        public SplusMethodQuery(String string, IWorkbenchWindow iWorkbenchWindow) {
            this.m_queryString = string;
            this.m_window = iWorkbenchWindow;
        }

        public String getQueryString() {
            return this.m_queryString;
        }

        public boolean canRerun() {
            return true;
        }

        public boolean canRunInBackground() {
            return true;
        }

        public String getLabel() {
            return "S-PLUS Search";
        }

        public ISearchResult getSearchResult() {
            if (this.m_searchResult == null) {
                this.m_searchResult = new SplusReferencesResult(this, this.getQueryString());
            }
            return this.m_searchResult;
        }

        public IStatus run(final IProgressMonitor iProgressMonitor) throws OperationCanceledException {
            this.m_window.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    boolean bl = SplusMethodQuery.this.m_window.getWorkbench().saveAllEditors(true);
                    if (bl) {
                        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1000);
                        SplusIncrementalBuilder.getBuildableExtensions();
                        SplusMethodQuery.this.getResourceNamedReferences((IProgressMonitor)subProgressMonitor);
                    }
                }
            });
            String string = "Search complete.";
            return new Status(0, SplusEditorPlugin.getPluginId(), 0, string, null);
        }

        private void getResourceNamedReferences(IProgressMonitor iProgressMonitor) {
            try {
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                for (int i = 0; i < iProjectArray.length; ++i) {
                    if (!iProjectArray[i].isAccessible()) continue;
                    iProjectArray[i].accept((IResourceVisitor)new NamedReferenceVisitor(this, iProgressMonitor));
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }

        private class NamedReferenceVisitor
        implements IResourceVisitor {
            private IProgressMonitor m_monitor;
            private SplusMethodQuery m_query;

            public NamedReferenceVisitor(SplusMethodQuery splusMethodQuery2, IProgressMonitor iProgressMonitor) {
                this.m_monitor = iProgressMonitor;
                this.m_query = splusMethodQuery2;
            }

            private void doVisit(IResource iResource) {
                if (this.m_monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (iResource.exists()) {
                    String string = SplusParseTreeBuilder.toString(iResource.getLocation().toFile());
                    Vector vector = new Vector();
                    try {
                        int n;
                        int n2;
                        int n3;
                        int n4;
                        SplusReferencesResult splusReferencesResult = (SplusReferencesResult)this.m_query.getSearchResult();
                        PObject pObject = SplusParseTreeBuilder.getInstance().getParseTree(string);
                        SplusParseTreeBuilder.findNamePObjects(pObject, this.m_query.getQueryString(), vector);
                        Match[] matchArray = new Match[vector.size()];
                        int[] nArray = null;
                        if (matchArray.length > 0) {
                            n4 = 0;
                            n3 = 0;
                            n2 = 0;
                            for (n = 0; n < string.length(); ++n) {
                                if (string.charAt(n) != '\n') continue;
                                ++n4;
                            }
                            nArray = new int[n4];
                            for (n = 0; n < string.length(); ++n) {
                                ++n3;
                                if (string.charAt(n) != '\n') continue;
                                if (SplusEditorPlugin.g_isWindowsOS) {
                                    // empty if block
                                }
                                nArray[n2++] = ++n3;
                            }
                        }
                        n4 = 0;
                        n3 = 0;
                        n2 = 0;
                        n = 0;
                        for (int i = 0; i < matchArray.length; ++i) {
                            PObject pObject2 = (PObject)vector.get(i);
                            n = 0;
                            n2 = 0;
                            n3 = 0;
                            n4 = 0;
                            n4 = SplusParseTreeBuilder.getStartLine(pObject2);
                            n2 = SplusParseTreeBuilder.getStartColumn(pObject2);
                            int n5 = n = n4 == SplusParseTreeBuilder.getEndLine(pObject2) ? 1 + SplusParseTreeBuilder.getEndColumn(pObject2) - n2 : 0;
                            if (n4 > 0) {
                                n3 = nArray[n4 - 1];
                            }
                            matchArray[i] = new Match((Object)iResource, 2, n3 + n2, n);
                        }
                        splusReferencesResult.addMatches(matchArray);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }

            public boolean visit(IResource iResource) throws CoreException {
                if (iResource.getType() == 1 && SplusIncrementalBuilder.isBuildable(iResource.getFullPath().getFileExtension())) {
                    this.doVisit(iResource);
                }
                return !SplusIncrementalBuilder.ignoreChildren(iResource);
            }
        }
    }
}

