/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.util;

import com.insightful.splus.eclipse.editors.spluseditor.util.IColorManager;
import com.insightful.splus.eclipse.preferences.SplusEditorPreferencePage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public class SplusColorProvider
implements IColorManager {
    public RGB SINGLE_LINE_COMMENT = SplusEditorPreferencePage.getRGB("splus_single_line_comment");
    public RGB TYPE = SplusEditorPreferencePage.getRGB("splus_type");
    public RGB CONSTANT = SplusEditorPreferencePage.getRGB("splus_constant");
    public RGB KEYWORD = SplusEditorPreferencePage.getRGB("splus_keyword");
    public RGB USER = SplusEditorPreferencePage.getRGB("user_defined");
    public RGB QUOTE_STRING = SplusEditorPreferencePage.getRGB("splus_quote_string");
    public RGB DBL_QUOTE_STRING = SplusEditorPreferencePage.getRGB("splus_dbl_quote_string");
    public RGB DEFAULT = SplusEditorPreferencePage.getRGB("splus_default");
    public RGB TASK = SplusEditorPreferencePage.getRGB("splus_comment_task_tag");
    protected Map fColorTable = new HashMap(10);

    public void dispose() {
        Iterator iterator = this.fColorTable.values().iterator();
        while (iterator.hasNext()) {
            ((Color)iterator.next()).dispose();
        }
    }

    public Color getColor(RGB rGB) {
        Color color = (Color)this.fColorTable.get(rGB);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rGB);
            this.fColorTable.put(rGB, color);
        }
        return color;
    }

    public void unbindColor(String string) {
        this.fColorTable.remove(string);
    }

    public void bindColor(String string, RGB rGB) {
        this.fColorTable.put(string, this.getColor(rGB));
    }

    public Color getColor(String string) {
        Color color = (Color)this.fColorTable.get(string);
        if (color == null) {
            String string2 = EditorsPlugin.getDefault().getPluginPreferences().getString(string).replaceAll(" ", "");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            color = new Color((Device)Display.getCurrent(), new RGB(n, n2, n3));
            this.fColorTable.put(string, color);
        }
        return color;
    }
}

