/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.preferences;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SplusConnectionPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private static String USE_EXTERNAL_PROCESS = "external.process";
    private static String LOCAL = "local.process";
    private static String SHOME = "splus.shome";
    private static String SPROJ = "splus.sproj";
    private static String SERVER = "server";
    private static String LOCAL_PORT = "local.rmi.port";
    private static String REMOTE_PORT = "remote.rmi.port";
    private static String OPTIONS = "startup.options";
    private static String ALL_CHANGES_IN = "changed";
    private static String FORCED_RESET = "forced.reset";
    private static boolean m_defaultsCreated = false;
    private Button m_sameProcess;
    private Button m_externalProcess;
    private Button m_localExternalProcess;
    private Button m_remoteExternalProcess;
    private Text m_sprojText;
    private Text m_serverText;
    private Text m_localPortText;
    private Text m_remotePortText;
    private Text m_optionsText;
    private Text m_externalSprojText;

    public SplusConnectionPreferencePage() {
        super(1);
        this.setPreferenceStore(SplusEditorPlugin.getDefault().getPreferenceStore());
        this.setDescription("S-PLUS Connection options");
        this.initializeDefaults();
    }

    public static boolean isRelevantProperty(String string) {
        return string.equals(ALL_CHANGES_IN) || string.equals(FORCED_RESET);
    }

    public static boolean isResetForced() {
        IPreferenceStore iPreferenceStore = SplusEditorPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean(FORCED_RESET);
    }

    public static void setResetForced(boolean bl) {
        IPreferenceStore iPreferenceStore = SplusEditorPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(FORCED_RESET, bl);
    }

    public static boolean useExternal() {
        if (!m_defaultsCreated) {
            new SplusConnectionPreferencePage();
        }
        return SplusEditorPlugin.getDefault().getPluginPreferences().getBoolean(USE_EXTERNAL_PROCESS);
    }

    public static boolean useLocal() {
        if (!m_defaultsCreated) {
            new SplusConnectionPreferencePage();
        }
        return SplusEditorPlugin.getDefault().getPluginPreferences().getBoolean(LOCAL);
    }

    public static String getSproj() {
        if (!m_defaultsCreated) {
            new SplusConnectionPreferencePage();
        }
        return SplusEditorPlugin.getDefault().getPluginPreferences().getString(SPROJ);
    }

    public static String getServer() {
        if (!m_defaultsCreated) {
            new SplusConnectionPreferencePage();
        }
        return SplusEditorPlugin.getDefault().getPluginPreferences().getString(SERVER);
    }

    public static String getOptions() {
        if (!m_defaultsCreated) {
            new SplusConnectionPreferencePage();
        }
        return SplusEditorPlugin.getDefault().getPluginPreferences().getString(OPTIONS);
    }

    public static int getLocalRmiPort() {
        if (!m_defaultsCreated) {
            new SplusConnectionPreferencePage();
        }
        return SplusEditorPlugin.getDefault().getPluginPreferences().getInt(LOCAL_PORT);
    }

    public static int getRemoteRmiPort() {
        if (!m_defaultsCreated) {
            new SplusConnectionPreferencePage();
        }
        return SplusEditorPlugin.getDefault().getPluginPreferences().getInt(REMOTE_PORT);
    }

    protected void initializeDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setDefault(USE_EXTERNAL_PROCESS, false);
        iPreferenceStore.setDefault(LOCAL, true);
        iPreferenceStore.setDefault(SHOME, DefaultConnection.getShome());
        iPreferenceStore.setDefault(SPROJ, DefaultConnection.getSproj());
        iPreferenceStore.setDefault(SERVER, "");
        iPreferenceStore.setDefault(LOCAL_PORT, 1099);
        iPreferenceStore.setDefault(REMOTE_PORT, 1099);
        iPreferenceStore.setDefault(OPTIONS, "");
        iPreferenceStore.setDefault(ALL_CHANGES_IN, false);
        m_defaultsCreated = true;
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        GridData gridData2 = new GridData(1808);
        gridData2.horizontalSpan = 2;
        gridData2.horizontalIndent = 25;
        GridData gridData3 = new GridData(768);
        gridData3.horizontalIndent = 25;
        this.m_sameProcess = new Button(composite, 16);
        this.m_sameProcess.setLayoutData((Object)gridData);
        Composite composite2 = new Composite(composite, 0);
        StringFieldEditor stringFieldEditor = new StringFieldEditor(SPROJ, "S-PLUS Project startup location", composite2);
        this.m_sprojText = stringFieldEditor.getTextControl(composite2);
        this.addField((FieldEditor)stringFieldEditor);
        composite2.setLayoutData((Object)gridData3);
        this.m_externalProcess = new Button(composite, 16);
        this.m_externalProcess.setLayoutData((Object)gridData);
        Composite composite3 = this.createExternalProcessComposite(composite);
        composite3.setLayoutData((Object)gridData2);
        this.m_sameProcess.setText("Start S-PLUS Connection in the Workbench process");
        this.m_externalProcess.setText("Start S-PLUS Connection in an external process");
        this.m_sameProcess.addListener(13, (Listener)this);
        this.m_externalProcess.addListener(13, (Listener)this);
        this.restoreConnectionInfo();
        this.handleEvent(null);
    }

    private Composite createExternalProcessComposite(Composite composite) {
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 25;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        this.m_localExternalProcess = new Button(composite2, 16);
        Composite composite3 = this.createLocalExternalProcessComposite(composite2);
        this.m_remoteExternalProcess = new Button(composite2, 16);
        Composite composite4 = this.createRemoteExternalProcessComposite(composite2);
        this.m_localExternalProcess.setText("Local Connection");
        this.m_remoteExternalProcess.setText("Remote Connection");
        composite3.setLayoutData((Object)gridData);
        composite4.setLayoutData((Object)gridData);
        this.m_localExternalProcess.addListener(13, (Listener)this);
        this.m_remoteExternalProcess.addListener(13, (Listener)this);
        return composite2;
    }

    private Composite createLocalExternalProcessComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        StringFieldEditor stringFieldEditor = new StringFieldEditor(SPROJ, "S-PLUS Project startup location", composite2);
        this.m_externalSprojText = stringFieldEditor.getTextControl(composite2);
        this.addField((FieldEditor)stringFieldEditor);
        stringFieldEditor = new IntegerFieldEditor(LOCAL_PORT, "RMI Port", composite2);
        this.m_localPortText = stringFieldEditor.getTextControl(composite2);
        this.addField((FieldEditor)stringFieldEditor);
        stringFieldEditor = new StringFieldEditor(OPTIONS, "S-PLUS Startup Options", composite2);
        this.m_optionsText = stringFieldEditor.getTextControl(composite2);
        this.addField((FieldEditor)stringFieldEditor);
        return composite2;
    }

    private Composite createRemoteExternalProcessComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        StringFieldEditor stringFieldEditor = new StringFieldEditor(SERVER, "Server", composite2);
        this.m_serverText = stringFieldEditor.getTextControl(composite2);
        this.addField((FieldEditor)stringFieldEditor);
        stringFieldEditor = new IntegerFieldEditor(REMOTE_PORT, "RMI Port", composite2);
        this.m_remotePortText = stringFieldEditor.getTextControl(composite2);
        this.addField((FieldEditor)stringFieldEditor);
        return composite2;
    }

    public void handleEvent(Event event) {
        boolean bl = this.m_externalProcess.getSelection();
        boolean bl2 = this.m_remoteExternalProcess.getSelection();
        this.m_sprojText.setEnabled(!bl);
        this.m_serverText.setEnabled(bl && bl2);
        this.m_remotePortText.setEnabled(bl && bl2);
        this.m_externalSprojText.setEnabled(bl && !bl2);
        this.m_localPortText.setEnabled(bl && !bl2);
        this.m_optionsText.setEnabled(bl && !bl2);
    }

    public static boolean checkForRestartNeeded(Shell shell) {
        if (DefaultConnection.localSameProcessConnectionRestart()) {
            String string = "A previous connection to the S-PLUS engine has been established within\nthe Workbench's process.  To create a another connection within this\nprocess requires a restart of the Workbench.\n\nClick Yes to restart the Workbench in this configuration.\nClick No to go back to the S-PLUS Connection Preference Page.";
            return MessageDialog.openQuestion((Shell)shell, (String)"Restart Required", (String)string);
        }
        return true;
    }

    private boolean saveConnectionInfo() {
        boolean bl;
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        boolean bl2 = SplusConnectionPreferencePage.useExternal();
        boolean bl3 = this.m_externalProcess.getSelection();
        String string = this.m_sprojText.getText().replace('\\', '/').toLowerCase();
        String string2 = SplusConnectionPreferencePage.getSproj().replace('\\', '/').toLowerCase();
        boolean bl4 = bl = !bl3 && (bl2 || !string.equals(string2));
        if (bl && !SplusConnectionPreferencePage.checkForRestartNeeded(this.getShell())) {
            return false;
        }
        iPreferenceStore.setValue(USE_EXTERNAL_PROCESS, bl3);
        iPreferenceStore.setValue(LOCAL, this.m_localExternalProcess.getSelection());
        return true;
    }

    private void restoreConnectionInfo(boolean bl, boolean bl2) {
        this.m_externalProcess.setSelection(bl);
        this.m_sameProcess.setSelection(!bl);
        this.m_localExternalProcess.setSelection(bl2);
        this.m_remoteExternalProcess.setSelection(!bl2);
    }

    private void restoreConnectionInfo() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.restoreConnectionInfo(iPreferenceStore.getBoolean(USE_EXTERNAL_PROCESS), iPreferenceStore.getBoolean(LOCAL));
    }

    private void restoreDefaultConnectionInfo() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.restoreConnectionInfo(iPreferenceStore.getDefaultBoolean(USE_EXTERNAL_PROCESS), iPreferenceStore.getDefaultBoolean(LOCAL));
    }

    public boolean performOk() {
        boolean bl;
        boolean bl2 = bl = this.saveConnectionInfo() && super.performOk();
        if (bl) {
            IPreferenceStore iPreferenceStore;
            iPreferenceStore.setValue(ALL_CHANGES_IN, !(iPreferenceStore = this.getPreferenceStore()).getBoolean(ALL_CHANGES_IN));
        }
        return bl;
    }

    public void performApply() {
        this.saveConnectionInfo();
        super.performApply();
    }

    public void performDefaults() {
        this.restoreDefaultConnectionInfo();
        super.performDefaults();
    }

    public void init(IWorkbench iWorkbench) {
    }
}

