/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.preferences.util;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class MultiSelectListEditor
extends FieldEditor {
    public static int ALLOW_ADD = 1;
    public static int ALLOW_REMOVE = 2;
    public static int ALLOW_UP = 4;
    public static int ALLOW_DOWN = 8;
    public static int ALLOW_ALL = ALLOW_ADD | ALLOW_REMOVE | ALLOW_UP | ALLOW_DOWN;
    private int allowButtons = ALLOW_ALL;
    private boolean multipleSelections;
    private List list;
    private Composite buttonBox;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private SelectionListener selectionListener;

    protected MultiSelectListEditor() {
    }

    protected MultiSelectListEditor(String string, String string2, Composite composite, int n, boolean bl) {
        this.allowButtons = n;
        this.multipleSelections = bl;
        this.init(string, string2);
        this.createControl(composite);
    }

    protected MultiSelectListEditor(String string, String string2, Composite composite) {
        this(string, string2, composite, ALLOW_ALL, true);
    }

    private void addPressed() {
        this.setPresentsDefaultValue(false);
        String string = this.getNewInputObject();
        if (string != null) {
            int n = this.list.getSelectionIndex();
            if (n >= 0) {
                this.list.add(string, n + 1);
            } else {
                this.list.add(string, 0);
            }
            this.selectionChanged();
        }
    }

    protected void adjustForNumColumns(int n) {
        Label label = this.getLabelControl();
        ((GridData)label.getLayoutData()).horizontalSpan = n;
        ((GridData)this.list.getLayoutData()).horizontalSpan = n - 1;
    }

    private void createButtons(Composite composite) {
        if ((this.allowButtons & ALLOW_ADD) == ALLOW_ADD) {
            this.addButton = this.createPushButton(composite, "ListEditor.add");
        }
        if ((this.allowButtons & ALLOW_REMOVE) == ALLOW_REMOVE) {
            this.removeButton = this.createPushButton(composite, "ListEditor.remove");
        }
        if ((this.allowButtons & ALLOW_UP) == ALLOW_UP) {
            this.upButton = this.createPushButton(composite, "ListEditor.up");
        }
        if ((this.allowButtons & ALLOW_DOWN) == ALLOW_DOWN) {
            this.downButton = this.createPushButton(composite, "ListEditor.down");
        }
    }

    protected abstract String createList(String[] var1);

    private Button createPushButton(Composite composite, String string) {
        Button button = new Button(composite, 8);
        button.setText(JFaceResources.getString((String)string));
        button.setFont(composite.getFont());
        GridData gridData = new GridData(768);
        int n = this.convertHorizontalDLUsToPixels((Control)button, 61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Widget widget = selectionEvent.widget;
                if (widget == MultiSelectListEditor.this.addButton) {
                    MultiSelectListEditor.this.addPressed();
                } else if (widget == MultiSelectListEditor.this.removeButton) {
                    MultiSelectListEditor.this.removePressed();
                } else if (widget == MultiSelectListEditor.this.upButton) {
                    MultiSelectListEditor.this.upPressed();
                } else if (widget == MultiSelectListEditor.this.downButton) {
                    MultiSelectListEditor.this.downPressed();
                } else if (widget == MultiSelectListEditor.this.list) {
                    MultiSelectListEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void doFillIntoGrid(Composite composite, int n) {
        Label label = this.getLabelControl(composite);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
        this.list = this.getListControl(composite);
        gridData = new GridData(768);
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = n - 1;
        gridData.grabExcessHorizontalSpace = true;
        this.list.setLayoutData((Object)gridData);
        this.buttonBox = this.getButtonBoxControl(composite);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gridData);
    }

    protected void doLoad() {
        if (this.list != null) {
            String string = this.getPreferenceStore().getString(this.getPreferenceName());
            String[] stringArray = this.parseString(string);
            for (int i = 0; i < stringArray.length; ++i) {
                this.list.add(stringArray[i]);
            }
        }
    }

    protected void doLoadDefault() {
        if (this.list != null) {
            this.list.removeAll();
            String string = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            String[] stringArray = this.parseString(string);
            for (int i = 0; i < stringArray.length; ++i) {
                this.list.add(stringArray[i]);
            }
        }
    }

    protected void doStore() {
        String string = this.createList(this.list.getItems());
        if (string != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), string);
        }
    }

    private void downPressed() {
        this.swap(false);
    }

    public Composite getButtonBoxControl(Composite composite) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)gridLayout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    MultiSelectListEditor.this.addButton = null;
                    MultiSelectListEditor.this.removeButton = null;
                    MultiSelectListEditor.this.upButton = null;
                    MultiSelectListEditor.this.downButton = null;
                    MultiSelectListEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, composite);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public List getListControl(Composite composite) {
        if (this.list == null) {
            int n = 2818;
            n = this.multipleSelections ? (n |= 2) : (n |= 4);
            this.list = new List(composite, n);
            this.list.setFont(composite.getFont());
            this.list.addSelectionListener(this.getSelectionListener());
            this.list.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    MultiSelectListEditor.this.list = null;
                }
            });
        } else {
            this.checkParent((Control)this.list, composite);
        }
        return this.list;
    }

    protected abstract String getNewInputObject();

    public int getNumberOfControls() {
        return 2;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton != null) {
            return this.addButton.getShell();
        }
        if (this.removeButton != null) {
            return this.removeButton.getShell();
        }
        if (this.upButton != null) {
            return this.upButton.getShell();
        }
        if (this.downButton != null) {
            return this.downButton.getShell();
        }
        if (this.list != null) {
            return this.list.getShell();
        }
        return null;
    }

    protected abstract String[] parseString(String var1);

    private void removePressed() {
        this.setPresentsDefaultValue(false);
        int[] nArray = this.list.getSelectionIndices();
        if (nArray != null && nArray.length != 0) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.list.remove(nArray[i]);
            }
            this.selectionChanged();
        }
    }

    private void selectionChanged() {
        int n;
        int[] nArray = this.list.getSelectionIndices();
        int n2 = this.list.getItemCount();
        boolean bl = nArray != null && nArray.length != 0;
        int n3 = bl ? nArray[0] : -1;
        int n4 = n = bl ? nArray[nArray.length - 1] : -1;
        if (this.removeButton != null) {
            this.removeButton.setEnabled(bl);
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(bl && n2 > 1 && n3 > 0);
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(bl && n2 > 1 && n < n2 - 1);
        }
    }

    public void setFocus() {
        if (this.list != null) {
            this.list.setFocus();
        }
    }

    private void swap(boolean bl) {
        int n;
        this.setPresentsDefaultValue(false);
        int[] nArray = this.list.getSelectionIndices();
        int n2 = n = bl ? -1 : 1;
        if (nArray != null && nArray.length != 0) {
            int n3 = bl ? 0 : nArray.length - 1;
            while (true) {
                String string = this.list.getItem(nArray[n3]);
                String string2 = this.list.getItem(nArray[n3] + n);
                this.list.setItem(nArray[n3] + n, string);
                this.list.setItem(nArray[n3], string2);
                int n4 = n3;
                nArray[n4] = nArray[n4] + n;
                if (bl && n3 == nArray.length - 1 || !bl && n3 == 0) break;
                n3 -= n;
            }
            this.list.setSelection(nArray);
        }
        this.selectionChanged();
    }

    private void upPressed() {
        this.swap(true);
    }

    public void setEnabled(boolean bl, Composite composite) {
        super.setEnabled(bl, composite);
        this.getListControl(composite).setEnabled(bl);
        if (this.addButton != null) {
            this.addButton.setEnabled(bl);
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(bl);
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(bl);
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(bl);
        }
    }
}

