/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.ISurrogateProfileHandler;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class SurrogateProfileHandler
implements ISurrogateProfileHandler {
    private static final String NATIVE_TOUCHPOINT_TYPE = "org.eclipse.equinox.p2.native";
    private static final String PROP_TYPE_ROOT = "org.eclipse.equinox.p2.type.root";
    private static final String P2_ENGINE_DIR = "p2/org.eclipse.equinox.p2.engine/";
    private static final String OSGI_INSTALL_AREA = "osgi.install.area";
    private static final String ECLIPSE_INI_IGNORED = "eclipse.ini.ignored";
    private static final String IU_LOCKED = Integer.toString(3);
    private static final String PROP_SURROGATE = "org.eclipse.equinox.p2.surrogate";
    private static final String PROP_SHARED_TIMESTAMP = "org.eclipse.equinox.p2.shared.timestamp";
    private static final String PROP_BASE = "org.eclipse.equinox.p2.base";
    private static final String PROP_RESOLVE = "org.eclipse.equinox.p2.resolve";
    private static final String OPTIONAL = "OPTIONAL";
    private static final String PROP_INCLUSION_RULES = "org.eclipse.equinox.p2.internal.inclusion.rules";
    private SimpleProfileRegistry profileRegistry;
    static /* synthetic */ Class class$0;

    private static void addSharedProfileBaseIUs(final IProfile sharedProfile, Profile userProfile) {
        Query rootIUQuery = new Query(){

            public boolean isMatch(Object candidate) {
                if (candidate instanceof IInstallableUnit) {
                    IInstallableUnit iu = (IInstallableUnit)candidate;
                    if (Boolean.valueOf(sharedProfile.getInstallableUnitProperty(iu, SurrogateProfileHandler.PROP_TYPE_ROOT)).booleanValue()) {
                        return true;
                    }
                    if (iu.getTouchpointType().getId().equals(SurrogateProfileHandler.NATIVE_TOUCHPOINT_TYPE)) {
                        return true;
                    }
                }
                return false;
            }
        };
        Collector rootIUs = sharedProfile.query(rootIUQuery, new Collector(), null);
        Iterator iterator = rootIUs.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            userProfile.addInstallableUnit(iu);
            userProfile.addInstallableUnitProperties(iu, sharedProfile.getInstallableUnitProperties(iu));
            userProfile.setInstallableUnitProperty(iu, "org.eclipse.equinox.p2.type.lock", IU_LOCKED);
            userProfile.setInstallableUnitProperty(iu, PROP_BASE, Boolean.TRUE.toString());
        }
    }

    private static void removeUserProfileBaseIUs(final Profile userProfile) {
        Query rootIUQuery = new Query(){

            public boolean isMatch(Object candidate) {
                IInstallableUnit iu;
                return candidate instanceof IInstallableUnit && Boolean.valueOf(userProfile.getInstallableUnitProperty(iu = (IInstallableUnit)candidate, SurrogateProfileHandler.PROP_BASE)) != false;
            }
        };
        Collector rootIUs = userProfile.query(rootIUQuery, new Collector(), null);
        Iterator iterator = rootIUs.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            userProfile.removeInstallableUnit(iu);
        }
    }

    private static void markRootsOptional(final Profile userProfile) {
        Query rootIUQuery = new Query(){

            public boolean isMatch(Object candidate) {
                IInstallableUnit iu;
                return candidate instanceof IInstallableUnit && Boolean.valueOf(userProfile.getInstallableUnitProperty(iu = (IInstallableUnit)candidate, SurrogateProfileHandler.PROP_TYPE_ROOT)) != false;
            }
        };
        Collector rootIUs = userProfile.query(rootIUQuery, new Collector(), null);
        Iterator iterator = rootIUs.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            userProfile.setInstallableUnitProperty(iu, PROP_INCLUSION_RULES, OPTIONAL);
        }
    }

    private static void updateProperties(IProfile sharedProfile, Profile userProfile) {
        userProfile.setProperty(PROP_SHARED_TIMESTAMP, Long.toString(sharedProfile.getTimestamp()));
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Location installLocation = (Location)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName(), (String)Location.INSTALL_FILTER);
        File installFolder = new File(installLocation.getURL().getPath());
        if (Boolean.valueOf(sharedProfile.getProperty("org.eclipse.equinox.p2.roaming")).booleanValue()) {
            userProfile.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.getAbsolutePath());
            userProfile.setProperty("org.eclipse.equinox.p2.cache.shared", installFolder.getAbsolutePath());
            userProfile.setProperty("org.eclipse.equinox.p2.roaming", Boolean.FALSE.toString());
        } else {
            String cache = sharedProfile.getProperty("org.eclipse.equinox.p2.cache");
            if (cache != null) {
                userProfile.setProperty("org.eclipse.equinox.p2.cache.shared", cache);
            }
        }
        BundleContext bundleContext2 = EngineActivator.getContext();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Location configurationLocation = (Location)ServiceHelper.getService((BundleContext)bundleContext2, (String)clazz2.getName(), (String)Location.CONFIGURATION_FILTER);
        File configurationFolder = new File(configurationLocation.getURL().getPath());
        userProfile.setProperty("org.eclipse.equinox.p2.cache", configurationFolder.getParentFile().getAbsolutePath());
        userProfile.setProperty("org.eclipse.equinox.p2.configurationFolder", configurationFolder.getAbsolutePath());
        File launcherConfigFile = new File(configurationFolder, ECLIPSE_INI_IGNORED);
        userProfile.setProperty("org.eclipse.equinox.p2.launcherConfiguration", launcherConfigFile.getAbsolutePath());
    }

    private synchronized SimpleProfileRegistry getProfileRegistry() {
        if (this.profileRegistry == null) {
            String installArea = EngineActivator.getContext().getProperty(OSGI_INSTALL_AREA);
            try {
                URL registryURL = new URL(String.valueOf(installArea) + P2_ENGINE_DIR + "profileRegistry");
                File sharedRegistryDirectory = new File(registryURL.getPath());
                this.profileRegistry = new SimpleProfileRegistry(sharedRegistryDirectory, null, false);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return this.profileRegistry;
    }

    public Profile createProfile(String id) {
        IProfile sharedProfile = this.getProfileRegistry().getProfile(id);
        if (sharedProfile == null) {
            return null;
        }
        Profile userProfile = new Profile(id, null, sharedProfile.getProperties());
        userProfile.setProperty(PROP_SURROGATE, Boolean.TRUE.toString());
        userProfile.setSurrogateProfileHandler(this);
        SurrogateProfileHandler.updateProperties(sharedProfile, userProfile);
        SurrogateProfileHandler.addSharedProfileBaseIUs(sharedProfile, userProfile);
        return userProfile;
    }

    public boolean isSurrogate(IProfile profile) {
        return Boolean.valueOf(profile.getProperty(PROP_SURROGATE));
    }

    public Collector queryProfile(IProfile profile, Query query, Collector collector, IProgressMonitor monitor) {
        IProfile sharedProfile = this.getProfileRegistry().getProfile(profile.getProfileId());
        if (sharedProfile != null) {
            sharedProfile.query(query, collector, monitor);
        }
        return profile.query(query, collector, monitor);
    }

    public boolean updateProfile(Profile userProfile) {
        IProfile sharedProfile = this.getProfileRegistry().getProfile(userProfile.getProfileId());
        if (sharedProfile == null) {
            throw new IllegalStateException(NLS.bind((String)Messages.shared_profile_not_found, (Object)userProfile.getProfileId()));
        }
        String sharedTimeStamp = Long.toString(sharedProfile.getTimestamp());
        String userSharedTimeStamp = userProfile.getProperty(PROP_SHARED_TIMESTAMP);
        if (userSharedTimeStamp != null && userSharedTimeStamp.equals(sharedTimeStamp)) {
            return false;
        }
        SurrogateProfileHandler.updateProperties(sharedProfile, userProfile);
        SurrogateProfileHandler.removeUserProfileBaseIUs(userProfile);
        if (!userProfile.query((Query)InstallableUnitQuery.ANY, new Collector(), null).isEmpty()) {
            userProfile.setProperty(PROP_RESOLVE, Boolean.TRUE.toString());
            SurrogateProfileHandler.markRootsOptional(userProfile);
        }
        SurrogateProfileHandler.addSharedProfileBaseIUs(sharedProfile, userProfile);
        return true;
    }
}

