/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.provisional.p2.engine.EngineSession;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.Messages;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;

public abstract class Phase {
    protected static final String PARM_OPERAND = "operand";
    protected static final String PARM_PHASE_ID = "phaseId";
    protected static final String PARM_PROFILE = "profile";
    protected static final String PARM_CONTEXT = "context";
    protected final String phaseId;
    protected final int weight;
    protected int prePerformWork = 1000;
    protected int mainPerformWork = 10000;
    protected int postPerformWork = 1000;
    private Map phaseParameters;

    protected Phase(String phaseId, int weight) {
        if (phaseId == null || phaseId.length() == 0) {
            throw new IllegalArgumentException(Messages.phaseid_not_set);
        }
        if (weight <= 0) {
            throw new IllegalArgumentException(Messages.phaseid_not_positive);
        }
        this.weight = weight;
        this.phaseId = phaseId;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " - " + this.weight;
    }

    public final MultiStatus perform(EngineSession session, IProfile profile, Operand[] operands, ProvisioningContext context, IProgressMonitor monitor) {
        MultiStatus result;
        MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        try {
            this.perform(status, session, profile, operands, context, monitor);
        }
        catch (OperationCanceledException e) {
            status.add((IStatus)new Status(8, "org.eclipse.equinox.p2.engine", e.getMessage(), (Throwable)e));
        }
        catch (RuntimeException e) {
            status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", e.getMessage(), (Throwable)e));
        }
        catch (LinkageError e) {
            status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", e.getMessage(), (Throwable)e));
        }
        if (status.matches(8)) {
            result = new MultiStatus("org.eclipse.equinox.p2.engine", 8, Messages.Engine_Operation_Canceled_By_User, null);
            result.merge((IStatus)status);
            return result;
        }
        if (status.matches(4)) {
            result = new MultiStatus("org.eclipse.equinox.p2.engine", 4, this.getProblemMessage(), null);
            result.merge((IStatus)status);
            return result;
        }
        return status;
    }

    void perform(MultiStatus status, EngineSession session, IProfile profile, Operand[] operands, ProvisioningContext context, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.prePerformWork + this.mainPerformWork + this.postPerformWork));
        this.prePerform(status, profile, context, (IProgressMonitor)subMonitor.newChild(this.prePerformWork));
        if (status.matches(12)) {
            return;
        }
        session.recordPhaseStart(this);
        subMonitor.setWorkRemaining(this.mainPerformWork + this.postPerformWork);
        this.mainPerform(status, session, profile, operands, context, subMonitor.newChild(this.mainPerformWork));
        if (status.matches(12)) {
            return;
        }
        session.recordPhaseEnd(this);
        subMonitor.setWorkRemaining(this.postPerformWork);
        this.postPerform(status, profile, context, (IProgressMonitor)subMonitor.newChild(this.postPerformWork));
        if (status.matches(12)) {
            return;
        }
        subMonitor.done();
    }

    void prePerform(MultiStatus status, IProfile profile, ProvisioningContext context, IProgressMonitor monitor) {
        this.phaseParameters = new HashMap();
        this.phaseParameters.put(PARM_PROFILE, profile);
        this.phaseParameters.put(PARM_CONTEXT, context);
        this.phaseParameters.put(PARM_PHASE_ID, this.phaseId);
        Phase.mergeStatus(status, this.initializePhase(monitor, profile, this.phaseParameters));
    }

    private void mainPerform(MultiStatus status, EngineSession session, IProfile profile, Operand[] operands, ProvisioningContext context, SubMonitor subMonitor) {
        subMonitor.beginTask("", operands.length);
        int i = 0;
        while (i < operands.length) {
            subMonitor.setWorkRemaining(operands.length - i);
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            Operand operand = operands[i];
            if (this.isApplicable(operand)) {
                ProvisioningAction[] actions = this.getActions(operand);
                Map<String, Operand> parameters = new HashMap<String, Operand>(this.phaseParameters);
                parameters.put(PARM_OPERAND, operand);
                Phase.mergeStatus(status, this.initializeOperand(profile, operand, parameters, (IProgressMonitor)subMonitor));
                if (status.matches(12)) {
                    return;
                }
                parameters = Collections.unmodifiableMap(parameters);
                if (actions != null) {
                    int j = 0;
                    while (j < actions.length) {
                        ProvisioningAction action = actions[j];
                        session.recordAction(action, operand);
                        Phase.mergeStatus(status, action.execute(parameters));
                        if (status.matches(12)) {
                            return;
                        }
                        ++j;
                    }
                }
                Phase.mergeStatus(status, this.completeOperand(profile, operand, parameters, (IProgressMonitor)subMonitor));
                if (status.matches(12)) {
                    return;
                }
                subMonitor.worked(1);
            }
            ++i;
        }
    }

    protected static void mergeStatus(MultiStatus multi, IStatus status) {
        if (status != null && !status.isOK()) {
            multi.merge(status);
        }
    }

    void postPerform(MultiStatus status, IProfile profile, ProvisioningContext context, IProgressMonitor monitor) {
        Phase.mergeStatus(status, this.completePhase(monitor, profile, this.phaseParameters));
        this.phaseParameters = null;
    }

    void undo(MultiStatus status, EngineSession session, IProfile profile, Operand operand, ProvisioningAction[] actions, ProvisioningContext context) {
        Map<String, Operand> parameters = new HashMap<String, Operand>(this.phaseParameters);
        parameters.put(PARM_OPERAND, operand);
        Phase.mergeStatus(status, this.initializeOperand(profile, operand, parameters, (IProgressMonitor)new NullProgressMonitor()));
        parameters = Collections.unmodifiableMap(parameters);
        int j = 0;
        while (j < actions.length) {
            ProvisioningAction action = actions[j];
            Phase.mergeStatus(status, action.undo(parameters));
            ++j;
        }
        Phase.mergeStatus(status, this.completeOperand(profile, operand, parameters, (IProgressMonitor)new NullProgressMonitor()));
    }

    protected boolean isApplicable(Operand operand) {
        return true;
    }

    protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        return Status.OK_STATUS;
    }

    protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        return Status.OK_STATUS;
    }

    protected IStatus completeOperand(IProfile profile, Operand operand, Map parameters, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    protected IStatus initializeOperand(IProfile profile, Operand operand, Map parameters, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    protected abstract ProvisioningAction[] getActions(Operand var1);

    protected String getProblemMessage() {
        return Messages.phase_error;
    }
}

