/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class BDLIndexRetrievalEngineNode
extends EngineNode {
    public static String INDEX_TYPE_ATTRIBUTE_TAG = "iType";
    public static String POS_ATTRIBUTE_TAG = "+";
    public static String NEG_ATTRIBUTE_TAG = "-";
    public static String LOG_ATTRIBUTE_TAG = "T";
    protected static final int POSITIVE = 0;
    protected static final int NEGATIVE = 1;
    protected static final int LOGICAL = 2;
    private boolean m_positiveIndex = false;
    private boolean m_negativeIndex = false;
    private boolean m_logicalIndex = false;

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    protected void initVars(XTProps props) throws Exception {
        String type = props.getValue(INDEX_TYPE_ATTRIBUTE_TAG, POS_ATTRIBUTE_TAG);
        this.m_positiveIndex = type.equals(POS_ATTRIBUTE_TAG);
        this.m_negativeIndex = type.equals(NEG_ATTRIBUTE_TAG);
        this.m_logicalIndex = type.equals(LOG_ATTRIBUTE_TAG);
        if (!this.m_logicalIndex && !this.m_negativeIndex) {
            this.m_positiveIndex = true;
        }
    }

    public boolean executeDataCacheProc() throws Exception {
        XTProps props = this.getNodeProperties();
        this.initVars(props);
        return this.indexing();
    }

    protected boolean indexing() throws Exception {
        XTMetaData dataMD = this.getInputMetaData(0);
        XTMetaData indexMD = this.getInputMetaData(1);
        XTMetaData outputMD = this.getOutputMD();
        long nr = dataMD.getNumRows();
        long ni = indexMD.getNumRows();
        DataCacheRowBuf buf = new DataCacheRowBuf(dataMD);
        RandomAccessFile blobFile = null;
        if (buf.containsBlobs()) {
            blobFile = new RandomAccessFile(this.getInputDataBlobFile(), "r");
            buf.setReadBlobFile(blobFile);
        }
        FileInputStream indStream = new FileInputStream(this.getIndexFile());
        BufferedInputStream indBuffer = new BufferedInputStream(indStream);
        DataInputStream indInputStream = new DataInputStream(indBuffer);
        DataCacheRowBuf indBuf = new DataCacheRowBuf(indexMD);
        DataCacheRowBuf outputBuf = new DataCacheRowBuf(outputMD);
        boolean ok = false;
        if (this.m_positiveIndex) {
            ok = this.positiveIndexing(buf, indBuf, outputBuf, indInputStream, outputMD, ni, nr);
        } else if (this.m_negativeIndex) {
            ok = this.negativeIndexing(buf, indBuf, outputBuf, indInputStream, outputMD, ni, nr);
        } else if (this.m_logicalIndex) {
            ok = this.logicalIndexing(buf, indBuf, outputBuf, indInputStream, outputMD, ni, nr);
        }
        indInputStream.close();
        if (blobFile != null) {
            blobFile.close();
        }
        return ok;
    }

    protected boolean positiveIndexing(DataCacheRowBuf buf, DataCacheRowBuf indBuf, DataCacheRowBuf outputBuf, DataInputStream indInputStream, XTMetaData outputMD, long ni, long nr) throws Exception {
        RandomAccessFile fileStream = new RandomAccessFile(this.getInputDataFile(), "r");
        DataOutputStream outputStream = this.setupOutputStream();
        OutputStream outBlobFile = this.setupOutputBlobStream(outputBuf);
        int bytesPerRow = buf.getBytesPerRow();
        byte[] rowData = new byte[bytesPerRow];
        int nc = outputBuf.getNumColumns();
        long outputRows = 0L;
        for (long i = 0L; i < ni; ++i) {
            indBuf.readRow(indInputStream);
            double rowNum = Math.floor(indBuf.getDouble(0)) - 1.0;
            if (rowNum < 0.0) continue;
            if (rowNum >= (double)nr) {
                for (int c = 0; c < nc; ++c) {
                    outputBuf.setNA(c);
                }
                outputBuf.writeRow(outputStream);
                ++outputRows;
                continue;
            }
            long seekTo = (long)(rowNum * (double)bytesPerRow);
            fileStream.seek(seekTo);
            fileStream.read(rowData);
            buf.readRow(rowData, 0);
            outputBuf.copyAllColumns(buf);
            outputBuf.writeRow(outputStream);
            ++outputRows;
        }
        outputMD.setNumRows(outputRows);
        this.setOutputMetaData(0, outputMD);
        fileStream.close();
        this.flushAndClose(outputStream);
        this.flushAndClose(outBlobFile);
        return true;
    }

    protected boolean negativeIndexing(DataCacheRowBuf buf, DataCacheRowBuf indBuf, DataCacheRowBuf outputBuf, DataInputStream indInputStream, XTMetaData outputMD, long ni, long nr) throws Exception {
        if (ni == 0L) {
            this.getNetworkManager().copyFile(this.getInputDataFile(), this.getOutputDataCacheFileName(0));
            this.setOutputMetaData(0, outputMD);
            return true;
        }
        DataOutputStream outputStream = this.setupOutputStream();
        OutputStream outBlobFile = this.setupOutputBlobStream(outputBuf);
        FileInputStream stream = new FileInputStream(this.getInputDataFile());
        BufferedInputStream buffer = new BufferedInputStream(stream);
        DataInputStream inputStream = new DataInputStream(buffer);
        long outputRows = 0L;
        double nextExclRow = -1.0;
        long i = 0L;
        for (long r = 0L; r < nr; ++r) {
            if (r == 0L) {
                indBuf.readRow(indInputStream);
                nextExclRow = Math.floor(Math.abs(indBuf.getDouble(0))) - 1.0;
                ++i;
            }
            buf.readRow(inputStream);
            if ((double)r != nextExclRow) {
                outputBuf.copyAllColumns(buf);
                outputBuf.writeRow(outputStream);
                ++outputRows;
                continue;
            }
            if (!((double)r >= nextExclRow) || i >= ni) continue;
            indBuf.readRow(indInputStream);
            nextExclRow = Math.floor(Math.abs(indBuf.getDouble(0))) - 1.0;
            ++i;
        }
        outputMD.setNumRows(outputRows);
        this.setOutputMetaData(0, outputMD);
        inputStream.close();
        this.flushAndClose(outputStream);
        this.flushAndClose(outBlobFile);
        return true;
    }

    protected boolean logicalIndexing(DataCacheRowBuf buf, DataCacheRowBuf indBuf, DataCacheRowBuf outputBuf, DataInputStream indInputStream, XTMetaData outputMD, long ni, long nr) throws Exception {
        boolean getrow;
        long r;
        long processedRows;
        RandomAccessFile fileStream = new RandomAccessFile(this.getInputDataFile(), "r");
        long bytesPerRow = buf.getBytesPerRow();
        long seek = 0L;
        byte[] dataRow = new byte[(int)bytesPerRow];
        RandomAccessFile indStream = new RandomAccessFile(this.getIndexFile(), "r");
        long indBytesPerRow = indBuf.getBytesPerRow();
        long indSeek = 0L;
        byte[] indRow = new byte[(int)indBytesPerRow];
        DataOutputStream outputStream = this.setupOutputStream();
        OutputStream outBlobFile = this.setupOutputBlobStream(outputBuf);
        long outputRows = 0L;
        long i = processedRows = 0L;
        for (r = 0L; r < nr && i < ni; ++r, ++i) {
            indStream.seek(indSeek);
            indStream.read(indRow);
            indBuf.readRow(indRow, 0);
            fileStream.seek(seek);
            fileStream.read(dataRow);
            buf.readRow(dataRow, 0);
            ++processedRows;
            boolean bl = getrow = Math.floor(indBuf.getDouble(0)) == 1.0;
            if (getrow) {
                outputBuf.copyAllColumns(buf);
                outputBuf.writeRow(outputStream);
                ++outputRows;
            }
            indSeek += indBytesPerRow;
            seek += bytesPerRow;
        }
        if (processedRows < ni) {
            for (int i2 = 0; i2 < outputBuf.getNumColumns(); ++i2) {
                outputBuf.setNA(i2);
            }
            for (long i3 = processedRows; i3 < ni; ++i3) {
                boolean getrow2;
                indStream.seek(indSeek);
                indStream.read(indRow);
                indBuf.readRow(indRow, 0);
                boolean bl = getrow2 = Math.floor(indBuf.getDouble(0)) == 1.0;
                if (getrow2) {
                    outputBuf.writeRow(outputStream);
                    ++outputRows;
                }
                indSeek += indBytesPerRow;
            }
        } else if (processedRows < nr) {
            i = 0L;
            r = processedRows;
            while (r < nr) {
                if (i == 0L || i % ni == 0L) {
                    indSeek = 0L;
                }
                indStream.seek(indSeek);
                indStream.read(indRow);
                indBuf.readRow(indRow, 0);
                fileStream.seek(seek);
                fileStream.read(dataRow);
                buf.readRow(dataRow, 0);
                ++processedRows;
                boolean bl = getrow = Math.floor(indBuf.getDouble(0)) == 1.0;
                if (getrow) {
                    outputBuf.copyAllColumns(buf);
                    outputBuf.writeRow(outputStream);
                    ++outputRows;
                }
                indSeek += indBytesPerRow;
                seek += bytesPerRow;
                ++r;
                ++i;
            }
        }
        outputMD.setNumRows(outputRows);
        this.setOutputMetaData(0, outputMD);
        fileStream.close();
        indStream.close();
        this.flushAndClose(outputStream);
        this.flushAndClose(outBlobFile);
        return true;
    }

    protected String getInputDataFile() {
        return this.getInputDataCacheFileName(0);
    }

    protected String getInputDataBlobFile() {
        return this.getNetworkManager().getInputDataBlobFileName(this.getNodeID(), 0);
    }

    protected String getSetDataFile() {
        return this.getInputDataFile();
    }

    protected String getSetDataBlobFile() {
        return this.getInputDataBlobFile();
    }

    protected String getIndexFile() {
        return this.getInputDataCacheFileName(1);
    }

    protected XTMetaData getOutputMD() throws Exception {
        return (XTMetaData)this.getInputMetaData(0).clone();
    }

    protected DataOutputStream setupOutputStream() throws Exception {
        FileOutputStream oStream = new FileOutputStream(this.getOutputDataCacheFileName(0));
        BufferedOutputStream oBuffer = new BufferedOutputStream(oStream);
        return new DataOutputStream(oBuffer);
    }

    protected OutputStream setupOutputBlobStream(DataCacheRowBuf outputBuf) throws Exception {
        BufferedOutputStream outBlobFile = null;
        if (outputBuf.containsBlobs()) {
            String bf = this.getNetworkManager().getOutputDataBlobFileName(this.getNodeID(), 0);
            outBlobFile = new BufferedOutputStream(new FileOutputStream(bf, false));
            outputBuf.setWriteBlobFile(outBlobFile);
        }
        return outBlobFile;
    }

    protected void flushAndClose(OutputStream stream) throws Exception {
        if (stream != null) {
            stream.flush();
            stream.close();
        }
    }
}

